/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea;

import com.intellij.codeInsight.folding.JavaCodeFoldingSettings;
import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.lang.folding.CustomFoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.idea.KotlinFoldingBuilder;
import org.jetbrains.kotlin.idea.editor.fixers.FixersUtilKt;
import org.jetbrains.kotlin.idea.references.ReferenceUtilKt;
import org.jetbrains.kotlin.kdoc.lexer.KDocTokens;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtImportList;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.calls.components.ArgumentsUtilsKt;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J&\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J.\u0010\u0010\u001a\u00020\b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\u0010\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0006H\u0002J\u0010\u0010\u0017\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u0018\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u001aH\u0014J\u0010\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u001c\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u001d\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\nH\u0014J\u0010\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020\u0012H\u0002J\u0010\u0010 \u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\nH\u0014J\u0018\u0010!\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\f\u0010\"\u001a\u00020\u0006*\u00020\u0006H\u0002J\u0014\u0010#\u001a\u00020\u0014*\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/idea/KotlinFoldingBuilder;", "Lcom/intellij/lang/folding/CustomFoldingBuilder;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "collectionFactoryFunctionsNames", "", "", "appendDescriptors", "", "node", "Lcom/intellij/lang/ASTNode;", "document", "Lcom/intellij/openapi/editor/Document;", "descriptors", "", "Lcom/intellij/lang/folding/FoldingDescriptor;", "buildLanguageFoldRegions", "root", "Lcom/intellij/psi/PsiElement;", "quick", "", "getCommentContents", "line", "getFirstLineOfComment", "getLanguagePlaceholderText", "range", "Lcom/intellij/openapi/util/TextRange;", "getRangeToFold", "getTrimmedFirstLineOfString", "isCustomFoldingRoot", "isFirstElementInFile", "element", "isRegionCollapsedByDefault", "needFolding", "addSpaceIfNeeded", "shouldFoldCollection", "idea"})
public final class KotlinFoldingBuilder
extends CustomFoldingBuilder
implements DumbAware {
    private final Set<String> collectionFactoryFunctionsNames = SetsKt.setOf((Object[])new String[]{"arrayOf", "booleanArrayOf", "byteArrayOf", "charArrayOf", "doubleArrayOf", "floatArrayOf", "intArrayOf", "longArrayOf", "shortArrayOf", "arrayListOf", "hashMapOf", "hashSetOf", "linkedMapOf", "linkedSetOf", "linkedStringMapOf", "linkedStringSetOf", "listOf", "listOfNotNull", "mapOf", "mutableListOf", "mutableMapOf", "mutableSetOf", "setOf", "sortedMapOf", "sortedSetOf", "stringMapOf", "stringSetOf"});

    protected void buildLanguageFoldRegions(@NotNull List<FoldingDescriptor> descriptors2, @NotNull PsiElement root, @NotNull Document document, boolean quick) {
        Intrinsics.checkParameterIsNotNull(descriptors2, (String)"descriptors");
        Intrinsics.checkParameterIsNotNull((Object)root, (String)"root");
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        if (!(root instanceof KtFile)) {
            return;
        }
        List<KtImportDirective> imports = ((KtFile)root).getImportDirectives();
        if (imports.size() > 1) {
            PsiElement importKeyword;
            PsiElement psiElement2 = importKeyword = imports.get(0).getFirstChild();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"importKeyword");
            int startOffset = PsiUtilsKt.getEndOffset(psiElement2) + 1;
            KtImportList importList = ((KtFile)root).getImportList();
            if (importList != null) {
                int endOffset = PsiUtilsKt.getEndOffset((PsiElement)importList);
                TextRange range = new TextRange(startOffset, endOffset);
                FoldingDescriptor foldingDescriptor = new FoldingDescriptor((PsiElement)importList, range);
                List<FoldingDescriptor> list2 = descriptors2;
                FoldingDescriptor $receiver = foldingDescriptor;
                $receiver.setCanBeRemovedWhenCollapsed(true);
                FoldingDescriptor foldingDescriptor2 = foldingDescriptor;
                list2.add(foldingDescriptor2);
            }
        }
        FileASTNode fileASTNode = ((KtFile)root).getNode();
        Intrinsics.checkExpressionValueIsNotNull((Object)fileASTNode, (String)"root.node");
        this.appendDescriptors((ASTNode)fileASTNode, document, descriptors2);
    }

    private final void appendDescriptors(ASTNode node, Document document, List<FoldingDescriptor> descriptors2) {
        if (this.needFolding(node, document)) {
            TextRange textRange = this.getRangeToFold(node);
            TextRange textRange2 = node.getTextRange();
            Intrinsics.checkExpressionValueIsNotNull((Object)textRange2, (String)"node.textRange");
            TextRange relativeRange = textRange.shiftRight(-textRange2.getStartOffset());
            CharSequence charSequence = node.getChars();
            TextRange textRange3 = relativeRange;
            Intrinsics.checkExpressionValueIsNotNull((Object)textRange3, (String)"relativeRange");
            CharSequence foldRegionText = charSequence.subSequence(textRange3.getStartOffset(), relativeRange.getEndOffset());
            if (StringUtil.countNewLines((CharSequence)foldRegionText) > 0) {
                descriptors2.add(new FoldingDescriptor(node, textRange));
            }
        }
        for (ASTNode child = node.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            this.appendDescriptors(child, document, descriptors2);
        }
    }

    private final boolean needFolding(ASTNode node, Document document) {
        IElementType type2 = node.getElementType();
        ASTNode aSTNode = node.getTreeParent();
        IElementType parentType = aSTNode != null ? aSTNode.getElementType() : null;
        return Intrinsics.areEqual((Object)type2, (Object)((Object)KtNodeTypes.FUNCTION_LITERAL)) || Intrinsics.areEqual((Object)type2, (Object)((Object)KtNodeTypes.BLOCK)) && Intrinsics.areEqual((Object)parentType, (Object)((Object)KtNodeTypes.FUNCTION_LITERAL)) ^ true || Intrinsics.areEqual((Object)type2, (Object)KtNodeTypes.CLASS_BODY) || Intrinsics.areEqual((Object)type2, (Object)((Object)KtTokens.BLOCK_COMMENT)) || Intrinsics.areEqual((Object)type2, (Object)KDocTokens.KDOC) || Intrinsics.areEqual((Object)type2, (Object)((Object)KtNodeTypes.STRING_TEMPLATE)) || Intrinsics.areEqual((Object)type2, (Object)KtNodeTypes.PRIMARY_CONSTRUCTOR) || this.shouldFoldCollection(node, document);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean shouldFoldCollection(@NotNull ASTNode $receiver, Document document) {
        boolean bl;
        PsiElement psiElement2 = $receiver.getPsi();
        if (!(psiElement2 instanceof KtCallExpression)) {
            psiElement2 = null;
        }
        KtCallExpression ktCallExpression = (KtCallExpression)psiElement2;
        if (ktCallExpression == null) return false;
        KtCallExpression call2 = ktCallExpression;
        if (DumbService.isDumb((Project)call2.getProject())) {
            return false;
        }
        if (call2.getValueArguments().size() < 2) {
            return false;
        }
        if (FixersUtilKt.startLine((PsiElement)call2, document) == FixersUtilKt.endLine((PsiElement)call2, document)) {
            return false;
        }
        KtReferenceExpression ktReferenceExpression = KtPsiUtilKt.referenceExpression(call2);
        if (ktReferenceExpression == null) return false;
        KtReferenceExpression reference2 = ktReferenceExpression;
        Iterable $receiver$iv = ReferenceUtilKt.getMainReference(reference2).getResolvesByNames();
        if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
            bl = false;
        } else {
            for (Object element$iv : $receiver$iv) {
                Name name2 = (Name)element$iv;
                if (name2.isSpecial()) return false;
                if (!this.collectionFactoryFunctionsNames.contains(name2.getIdentifier())) {
                    return false;
                }
                boolean bl2 = false;
                if (!bl2) continue;
                return false;
            }
            bl = false;
        }
        if (bl) {
            return false;
        }
        Object object = CollectionsKt.singleOrNull((Iterable)ReferenceUtilKt.resolveMainReferenceToDescriptors(reference2));
        if (!(object instanceof FunctionDescriptor)) {
            object = null;
        }
        FunctionDescriptor functionDescriptor2 = (FunctionDescriptor)object;
        if (functionDescriptor2 == null) return false;
        FunctionDescriptor functionDescriptor3 = functionDescriptor2;
        if (functionDescriptor3.getValueParameters().size() != 1) return false;
        List<ValueParameterDescriptor> list2 = functionDescriptor3.getValueParameters();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"functionDescriptor.valueParameters");
        Object object2 = CollectionsKt.first(list2);
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"functionDescriptor.valueParameters.first()");
        if (!ArgumentsUtilsKt.isVararg((ValueParameterDescriptor)object2)) return false;
        return true;
    }

    private final TextRange getRangeToFold(ASTNode node) {
        if (Intrinsics.areEqual((Object)node.getElementType(), (Object)((Object)KtNodeTypes.FUNCTION_LITERAL))) {
            PsiElement rbrace;
            KtFunctionLiteral psi;
            PsiElement psiElement2 = node.getPsi();
            if (!(psiElement2 instanceof KtFunctionLiteral)) {
                psiElement2 = null;
            }
            KtFunctionLiteral ktFunctionLiteral = psi = (KtFunctionLiteral)psiElement2;
            PsiElement lbrace = ktFunctionLiteral != null ? ktFunctionLiteral.getLBrace() : null;
            KtFunctionLiteral ktFunctionLiteral2 = psi;
            Object object = rbrace = ktFunctionLiteral2 != null ? ktFunctionLiteral2.getRBrace() : null;
            if (lbrace != null && rbrace != null) {
                return new TextRange(PsiUtilsKt.getStartOffset(lbrace), PsiUtilsKt.getEndOffset(rbrace));
            }
        }
        if (Intrinsics.areEqual((Object)node.getElementType(), (Object)((Object)KtNodeTypes.CALL_EXPRESSION))) {
            PsiElement rightParenthesis;
            KtValueArgumentList valueArgumentList;
            PsiElement psiElement3 = node.getPsi();
            if (!(psiElement3 instanceof KtCallExpression)) {
                psiElement3 = null;
            }
            KtCallExpression ktCallExpression = (KtCallExpression)psiElement3;
            KtValueArgumentList ktValueArgumentList = valueArgumentList = ktCallExpression != null ? ktCallExpression.getValueArgumentList() : null;
            PsiElement leftParenthesis = ktValueArgumentList != null ? ktValueArgumentList.getLeftParenthesis() : null;
            KtValueArgumentList ktValueArgumentList2 = valueArgumentList;
            Object object = rightParenthesis = ktValueArgumentList2 != null ? ktValueArgumentList2.getRightParenthesis() : null;
            if (leftParenthesis != null && rightParenthesis != null) {
                return new TextRange(PsiUtilsKt.getStartOffset(leftParenthesis), PsiUtilsKt.getEndOffset(rightParenthesis));
            }
        }
        TextRange textRange = node.getTextRange();
        Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"node.textRange");
        return textRange;
    }

    @NotNull
    protected String getLanguagePlaceholderText(@NotNull ASTNode node, @NotNull TextRange range) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)range, (String)"range");
        return Intrinsics.areEqual((Object)node.getElementType(), (Object)((Object)KtTokens.BLOCK_COMMENT)) ? '/' + this.getFirstLineOfComment(node) + ".../" : (Intrinsics.areEqual((Object)node.getElementType(), (Object)KDocTokens.KDOC) ? "/**" + this.getFirstLineOfComment(node) + "...*/" : (Intrinsics.areEqual((Object)node.getElementType(), (Object)((Object)KtNodeTypes.STRING_TEMPLATE)) ? "\"\"\"" + this.addSpaceIfNeeded(this.getTrimmedFirstLineOfString(node)) + "...\"\"\"" : (Intrinsics.areEqual((Object)node.getElementType(), (Object)KtNodeTypes.PRIMARY_CONSTRUCTOR) || Intrinsics.areEqual((Object)node.getElementType(), (Object)((Object)KtNodeTypes.CALL_EXPRESSION)) ? "(...)" : (node.getPsi() instanceof KtImportList ? "..." : "{...}"))));
    }

    private final String getTrimmedFirstLineOfString(ASTNode node) {
        String firstLine2;
        String string;
        Object v1;
        block2: {
            String string2 = node.getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"node.text");
            List lines = StringsKt.split$default((CharSequence)string2, (String[])new String[]{"\n"}, (boolean)false, (int)0, (int)6, null);
            Sequence $receiver$iv = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)lines), (Function1)getTrimmedFirstLineOfString.firstLine.1.INSTANCE);
            for (Object element$iv : $receiver$iv) {
                String p1 = (String)element$iv;
                CharSequence charSequence = p1;
                if (!(charSequence.length() > 0)) continue;
                v1 = element$iv;
                break block2;
            }
            v1 = null;
        }
        if ((string = (firstLine2 = (String)v1)) == null) {
            string = "";
        }
        return string;
    }

    private final String addSpaceIfNeeded(@NotNull String $receiver) {
        CharSequence charSequence = $receiver;
        if (charSequence.length() == 0 || StringsKt.endsWith$default((String)$receiver, (String)" ", (boolean)false, (int)2, null)) {
            return $receiver;
        }
        return $receiver + " ";
    }

    private final String getFirstLineOfComment(ASTNode node) {
        Object v1;
        block2: {
            String string = node.getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"node.text");
            Iterable $receiver$iv = StringsKt.split$default((CharSequence)string, (String[])new String[]{"\n"}, (boolean)false, (int)0, (int)6, null);
            for (Object element$iv : $receiver$iv) {
                String it = (String)element$iv;
                CharSequence charSequence = this.getCommentContents(it);
                if (!(charSequence.length() > 0)) continue;
                v1 = element$iv;
                break block2;
            }
            v1 = null;
        }
        String string = v1;
        if (string == null) {
            return "";
        }
        String targetCommentLine = string;
        return ' ' + this.getCommentContents(targetCommentLine) + ' ';
    }

    private final String getCommentContents(String line) {
        String string;
        String string2 = string = line;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String string3 = string = StringsKt.removePrefix((String)StringsKt.removePrefix((String)StringsKt.removePrefix((String)StringsKt.removePrefix((String)((Object)StringsKt.trim((CharSequence)string2)).toString(), (CharSequence)"/**"), (CharSequence)"/*"), (CharSequence)"*/"), (CharSequence)"*");
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        return ((Object)StringsKt.trim((CharSequence)string3)).toString();
    }

    protected boolean isRegionCollapsedByDefault(@NotNull ASTNode node) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        JavaCodeFoldingSettings settings2 = JavaCodeFoldingSettings.getInstance();
        if (node.getPsi() instanceof KtImportList) {
            JavaCodeFoldingSettings javaCodeFoldingSettings = settings2;
            Intrinsics.checkExpressionValueIsNotNull((Object)javaCodeFoldingSettings, (String)"settings");
            return javaCodeFoldingSettings.isCollapseImports();
        }
        IElementType type2 = node.getElementType();
        if (Intrinsics.areEqual((Object)type2, (Object)((Object)KtTokens.BLOCK_COMMENT)) || Intrinsics.areEqual((Object)type2, (Object)KDocTokens.KDOC)) {
            PsiElement psiElement2 = node.getPsi();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"node.psi");
            if (this.isFirstElementInFile(psiElement2)) {
                JavaCodeFoldingSettings javaCodeFoldingSettings = settings2;
                Intrinsics.checkExpressionValueIsNotNull((Object)javaCodeFoldingSettings, (String)"settings");
                return javaCodeFoldingSettings.isCollapseFileHeader();
            }
        }
        return false;
    }

    protected boolean isCustomFoldingRoot(@NotNull ASTNode node) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        return Intrinsics.areEqual((Object)node.getElementType(), (Object)((Object)KtNodeTypes.BLOCK)) || Intrinsics.areEqual((Object)node.getElementType(), (Object)KtNodeTypes.CLASS_BODY);
    }

    private final boolean isFirstElementInFile(PsiElement element3) {
        PsiElement parent2 = element3.getParent();
        if (parent2 instanceof KtFile) {
            Object v0;
            block2: {
                Sequence $receiver$iv = PsiUtilsKt.getAllChildren(parent2);
                for (Object element$iv : $receiver$iv) {
                    PsiElement it = (PsiElement)element$iv;
                    if (!(it.getTextLength() != 0 && !(it instanceof PsiWhiteSpace))) continue;
                    v0 = element$iv;
                    break block2;
                }
                v0 = null;
            }
            PsiElement firstNonWhiteSpace = v0;
            return Intrinsics.areEqual((Object)element3, (Object)firstNonWhiteSpace);
        }
        return false;
    }
}

