/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea;

import com.intellij.codeInsight.hint.DeclarationRangeUtil;
import com.intellij.lang.BracePair;
import com.intellij.lang.PairedBraceMatcher;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtClassBody;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bH\u0016J\u0013\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0016\u00a2\u0006\u0002\u0010\rJ\u001a\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0011H\u0016R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/KotlinPairMatcher;", "Lcom/intellij/lang/PairedBraceMatcher;", "()V", "pairs", "", "Lcom/intellij/lang/BracePair;", "[Lcom/intellij/lang/BracePair;", "getCodeConstructStart", "", "file", "Lcom/intellij/psi/PsiFile;", "openingBraceOffset", "getPairs", "()[Lcom/intellij/lang/BracePair;", "isPairedBracesAllowedBeforeType", "", "lbraceType", "Lcom/intellij/psi/tree/IElementType;", "contextType", "idea"})
public final class KotlinPairMatcher
implements PairedBraceMatcher {
    private final BracePair[] pairs = new BracePair[]{new BracePair((IElementType)KtTokens.LPAR, (IElementType)KtTokens.RPAR, false), new BracePair((IElementType)KtTokens.LONG_TEMPLATE_ENTRY_START, (IElementType)KtTokens.LONG_TEMPLATE_ENTRY_END, false), new BracePair((IElementType)KtTokens.LBRACE, (IElementType)KtTokens.RBRACE, true), new BracePair((IElementType)KtTokens.LBRACKET, (IElementType)KtTokens.RBRACKET, false)};

    @NotNull
    public BracePair[] getPairs() {
        return this.pairs;
    }

    public boolean isPairedBracesAllowedBeforeType(@NotNull IElementType lbraceType, @Nullable IElementType contextType) {
        Intrinsics.checkParameterIsNotNull((Object)lbraceType, (String)"lbraceType");
        return Intrinsics.areEqual((Object)lbraceType, (Object)((Object)KtTokens.LONG_TEMPLATE_ENTRY_START)) ? false : KtTokens.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(contextType) || contextType == KtTokens.SEMICOLON || contextType == KtTokens.COMMA || contextType == KtTokens.RPAR || contextType == KtTokens.RBRACKET || contextType == KtTokens.RBRACE || contextType == KtTokens.LBRACE || contextType == KtTokens.LONG_TEMPLATE_ENTRY_END;
    }

    public int getCodeConstructStart(@NotNull PsiFile file, int openingBraceOffset) {
        int n;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        PsiElement element3 = file.findElementAt(openingBraceOffset);
        if (element3 == null || element3 instanceof PsiFile) {
            return openingBraceOffset;
        }
        PsiElement parent2 = element3.getParent();
        PsiElement psiElement2 = parent2;
        if (psiElement2 instanceof KtClassBody || psiElement2 instanceof KtBlockExpression) {
            TextRange textRange = DeclarationRangeUtil.getPossibleDeclarationAtRange((PsiElement)parent2.getParent());
            n = textRange != null ? textRange.getStartOffset() : openingBraceOffset;
        } else {
            n = openingBraceOffset;
        }
        return n;
    }
}

