/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.caches;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.DataInputOutputUtil;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.caches.CachedAttributeData;
import org.jetbrains.kotlin.idea.caches.FileAttributeService;
import org.jetbrains.kotlin.idea.caches.FileAttributeServiceImpl;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J3\u0010\t\u001a\u0002H\n\"\u000e\b\u0000\u0010\n*\b\u0012\u0004\u0012\u0002H\n0\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\n0\u000fH\u0002\u00a2\u0006\u0002\u0010\u0010J:\u0010\u0011\u001a\n\u0012\u0004\u0012\u0002H\n\u0018\u00010\u0012\"\u0004\b\u0000\u0010\n2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00052\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u0002H\n0\u0017H\u0016J \u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u00122\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J>\u0010\u001b\u001a\n\u0012\u0004\u0012\u0002H\n\u0018\u00010\u0012\"\u000e\b\u0000\u0010\n*\b\u0012\u0004\u0012\u0002H\n0\u000b2\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\n0\u000fH\u0016J \u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020\u001aH\u0016JK\u0010 \u001a\b\u0012\u0004\u0012\u0002H\n0\u0012\"\u0004\b\u0000\u0010\n2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010!\u001a\u0002H\n2\u0018\u0010\"\u001a\u0014\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u0002H\n\u0012\u0004\u0012\u00020\u001d0#H\u0016\u00a2\u0006\u0002\u0010%J&\u0010&\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00122\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010!\u001a\u00020\u001aH\u0016J;\u0010'\u001a\b\u0012\u0004\u0012\u0002H\n0\u0012\"\u000e\b\u0000\u0010\n*\b\u0012\u0004\u0012\u0002H\n0\u000b2\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010!\u001a\u0002H\nH\u0016\u00a2\u0006\u0002\u0010(R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/idea/caches/FileAttributeServiceImpl;", "Lorg/jetbrains/kotlin/idea/caches/FileAttributeService;", "()V", "attributes", "", "", "Lcom/intellij/openapi/vfs/newvfs/FileAttribute;", "getAttributes", "()Ljava/util/Map;", "deserializeEnumValue", "T", "", "i", "", "klass", "Ljava/lang/Class;", "(ILjava/lang/Class;)Ljava/lang/Enum;", "read", "Lorg/jetbrains/kotlin/idea/caches/CachedAttributeData;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "id", "readValueFun", "Lkotlin/Function1;", "Ljava/io/DataInput;", "readBooleanAttribute", "", "readEnumAttribute", "register", "", "version", "fixedSize", "write", "value", "writeValueFun", "Lkotlin/Function2;", "Ljava/io/DataOutput;", "(Lcom/intellij/openapi/vfs/VirtualFile;Ljava/lang/String;Ljava/lang/Object;Lkotlin/jvm/functions/Function2;)Lorg/jetbrains/kotlin/idea/caches/CachedAttributeData;", "writeBooleanAttribute", "writeEnumAttribute", "(Ljava/lang/String;Lcom/intellij/openapi/vfs/VirtualFile;Ljava/lang/Enum;)Lorg/jetbrains/kotlin/idea/caches/CachedAttributeData;", "idea"})
public final class FileAttributeServiceImpl
implements FileAttributeService {
    @NotNull
    private final Map<String, FileAttribute> attributes;

    @NotNull
    public final Map<String, FileAttribute> getAttributes() {
        return this.attributes;
    }

    @Override
    public void register(@NotNull String id, int version, boolean fixedSize) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        Map<String, FileAttribute> map2 = this.attributes;
        FileAttribute fileAttribute2 = new FileAttribute(id, version, fixedSize);
        map2.put(id, fileAttribute2);
    }

    @Override
    @NotNull
    public <T extends Enum<T>> CachedAttributeData<T> writeEnumAttribute(@NotNull String id, @NotNull VirtualFile file, @NotNull T value) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull(value, (String)"value");
        return this.write(file, id, value, writeEnumAttribute.1.INSTANCE);
    }

    @Override
    @Nullable
    public <T extends Enum<T>> CachedAttributeData<T> readEnumAttribute(@NotNull String id, @NotNull VirtualFile file, @NotNull Class<T> klass2) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull(klass2, (String)"klass");
        return this.read(file, id, (Function1)new Function1<DataInput, T>(this, klass2){
            final /* synthetic */ FileAttributeServiceImpl this$0;
            final /* synthetic */ Class $klass;

            @NotNull
            public final T invoke(@NotNull DataInput input) {
                Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
                return (T)FileAttributeServiceImpl.access$deserializeEnumValue(this.this$0, DataInputOutputUtil.readINT((DataInput)input), this.$klass);
            }
            {
                this.this$0 = fileAttributeServiceImpl;
                this.$klass = clazz;
                super(1);
            }
        });
    }

    @Override
    @NotNull
    public CachedAttributeData<Boolean> writeBooleanAttribute(@NotNull String id, @NotNull VirtualFile file, boolean value) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return this.write(file, id, value, writeBooleanAttribute.1.INSTANCE);
    }

    @Override
    @Nullable
    public CachedAttributeData<Boolean> readBooleanAttribute(@NotNull String id, @NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return this.read(file, id, readBooleanAttribute.1.INSTANCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public <T> CachedAttributeData<T> write(@NotNull VirtualFile file, @NotNull String id, T value, @NotNull Function2<? super DataOutput, ? super T, Unit> writeValueFun) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        Intrinsics.checkParameterIsNotNull(writeValueFun, (String)"writeValueFun");
        FileAttribute fileAttribute2 = this.attributes.get(id);
        if (fileAttribute2 == null) {
            throw (Throwable)new IllegalArgumentException("Attribute with " + id + " wasn't registered");
        }
        FileAttribute attribute = fileAttribute2;
        CachedAttributeData<T> data = new CachedAttributeData<T>(value, file.getTimeStamp());
        Closeable closeable = attribute.writeAttribute(file);
        Throwable throwable = null;
        try {
            DataOutputStream it = (DataOutputStream)closeable;
            DataInputOutputUtil.writeTIME((DataOutput)it, (long)data.getTimeStamp());
            DataOutputStream dataOutputStream = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)dataOutputStream, (String)"it");
            writeValueFun.invoke((Object)dataOutputStream, value);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public <T> CachedAttributeData<T> read(@NotNull VirtualFile file, @NotNull String id, @NotNull Function1<? super DataInput, ? extends T> readValueFun) {
        CachedAttributeData<Object> cachedAttributeData;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        Intrinsics.checkParameterIsNotNull(readValueFun, (String)"readValueFun");
        FileAttribute fileAttribute2 = this.attributes.get(id);
        if (fileAttribute2 == null) {
            throw (Throwable)new IllegalArgumentException("Attribute with " + id + " wasn't registered");
        }
        FileAttribute attribute = fileAttribute2;
        if (!(file instanceof VirtualFileWithId)) {
            return null;
        }
        DataInputStream dataInputStream = attribute.readAttribute(file);
        if (dataInputStream == null) {
            return null;
        }
        DataInputStream stream2 = dataInputStream;
        Closeable closeable = stream2;
        Throwable throwable = null;
        try {
            DataInputStream it = (DataInputStream)closeable;
            long timeStamp = DataInputOutputUtil.readTIME((DataInput)it);
            DataInputStream dataInputStream2 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)dataInputStream2, (String)"it");
            Object value = readValueFun.invoke((Object)dataInputStream2);
            cachedAttributeData = file.getTimeStamp() == timeStamp ? new CachedAttributeData<Object>(value, timeStamp) : null;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return cachedAttributeData;
    }

    private final <T extends Enum<T>> T deserializeEnumValue(int i, Class<T> klass2) {
        Method method = klass2.getMethod("values", new Class[0]);
        Object object = method.invoke(null, new Object[0]);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        Enum[] values = (Enum[])object;
        return (T)values[i];
    }

    public FileAttributeServiceImpl() {
        ConcurrentMap concurrentMap = ContainerUtil.newConcurrentMap();
        Intrinsics.checkExpressionValueIsNotNull((Object)concurrentMap, (String)"ContainerUtil.newConcurrentMap()");
        this.attributes = concurrentMap;
    }

    @NotNull
    public static final /* synthetic */ Enum access$deserializeEnumValue(FileAttributeServiceImpl $this, int i, @NotNull Class klass2) {
        return $this.deserializeEnumValue(i, klass2);
    }
}

