/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.caches;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.caches.ImplicitPackagePrefixCache;
import org.jetbrains.kotlin.idea.caches.project.GetModuleInfoKt;
import org.jetbrains.kotlin.idea.caches.project.IdeaModuleInfo;
import org.jetbrains.kotlin.idea.caches.project.ModuleSourceInfo;
import org.jetbrains.kotlin.idea.stubindex.PackageIndexUtil;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u001f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 ,2\u00020\u0001:\u0001,B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\u000e\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u0019J\u0010\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\tH\u0002J\u0015\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b\u001eJ\u0015\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b\u001eJ\r\u0010\u001f\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b J\u0016\u0010!\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\n2\u0006\u0010#\u001a\u00020\tJ\u0014\u0010$\u001a\u00020\u000b*\u00020\u00192\u0006\u0010%\u001a\u00020&H\u0002J/\u0010'\u001a\u00020\u0016\"\u0004\b\u0000\u0010(*\b\u0012\u0004\u0012\u0002H(0)2\u0014\b\u0004\u0010*\u001a\u000e\u0012\u0004\u0012\u0002H(\u0012\u0004\u0012\u00020\u00160+H\u0082\bR2\u0010\u0005\u001a&\u0012\u0004\u0012\u00020\u0007\u0012\u001c\u0012\u001a\u0012\u0004\u0012\u00020\t\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\b0\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lorg/jetbrains/kotlin/idea/caches/PerModulePackageCacheService;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "cache", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/openapi/module/Module;", "Ljava/util/concurrent/ConcurrentMap;", "Lorg/jetbrains/kotlin/idea/caches/project/ModuleSourceInfo;", "Lorg/jetbrains/kotlin/name/FqName;", "", "implicitPackagePrefixCache", "Lorg/jetbrains/kotlin/idea/caches/ImplicitPackagePrefixCache;", "pendingKtFileChanges", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "pendingVFileChanges", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "projectScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "checkPendingChanges", "", "getImplicitPackagePrefix", "sourceRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "invalidateCacheForModuleSourceInfo", "moduleSourceInfo", "notifyPackageChange", "file", "notifyPackageChange$idea_core", "onTooComplexChange", "onTooComplexChange$idea_core", "packageExists", "packageFqName", "moduleInfo", "containedInOrContains", "root", "", "processPending", "T", "", "body", "Lkotlin/Function1;", "Companion", "idea-core"})
public final class PerModulePackageCacheService {
    private final ConcurrentHashMap<Module, ConcurrentMap<ModuleSourceInfo, ConcurrentMap<FqName, Boolean>>> cache;
    private final ImplicitPackagePrefixCache implicitPackagePrefixCache;
    private final Set<VFileEvent> pendingVFileChanges;
    private final Set<KtFile> pendingKtFileChanges;
    private final GlobalSearchScope projectScope;
    private final Project project;
    public static final int FULL_DROP_THRESHOLD = 1000;
    private static final Logger LOG;
    public static final Companion Companion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onTooComplexChange$idea_core() {
        PerModulePackageCacheService perModulePackageCacheService = this;
        synchronized (perModulePackageCacheService) {
            this.pendingVFileChanges.clear();
            this.pendingKtFileChanges.clear();
            this.cache.clear();
            this.implicitPackagePrefixCache.clear$idea_core();
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void notifyPackageChange$idea_core(@NotNull VFileEvent file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        PerModulePackageCacheService perModulePackageCacheService = this;
        synchronized (perModulePackageCacheService) {
            Collection collection = this.pendingVFileChanges;
            VFileEvent vFileEvent = file;
            collection.add(vFileEvent);
            vFileEvent = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void notifyPackageChange$idea_core(@NotNull KtFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        PerModulePackageCacheService perModulePackageCacheService = this;
        synchronized (perModulePackageCacheService) {
            Collection collection = this.pendingKtFileChanges;
            KtFile ktFile = file;
            collection.add(ktFile);
            ktFile = Unit.INSTANCE;
        }
    }

    private final void invalidateCacheForModuleSourceInfo(ModuleSourceInfo moduleSourceInfo) {
        ConcurrentMap<ModuleSourceInfo, ConcurrentMap<FqName, Boolean>> concurrentMap = this.cache.get(moduleSourceInfo.getModule());
        if (concurrentMap == null) {
            return;
        }
        ConcurrentMap<ModuleSourceInfo, ConcurrentMap<FqName, Boolean>> perSourceInfoData = concurrentMap;
        ConcurrentMap concurrentMap2 = (ConcurrentMap)perSourceInfoData.get(moduleSourceInfo);
        if (concurrentMap2 == null) {
            return;
        }
        ConcurrentMap dataForSourceInfo = concurrentMap2;
        dataForSourceInfo.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void checkPendingChanges() {
        PerModulePackageCacheService perModulePackageCacheService = this;
        synchronized (perModulePackageCacheService) {
            if (this.pendingVFileChanges.size() + this.pendingKtFileChanges.size() >= 1000) {
                this.onTooComplexChange$idea_core();
            } else {
                Collection $receiver$iv = this.pendingVFileChanges;
                PerModulePackageCacheService this_$iv = this;
                $receiver$iv.removeIf(new Predicate<T>(this){
                    final /* synthetic */ PerModulePackageCacheService this$0;
                    {
                        this.this$0 = perModulePackageCacheService;
                    }

                    public final boolean test(T value) {
                        block10: {
                            try {
                                VirtualFile vfile;
                                VFileEvent event = (VFileEvent)value;
                                VirtualFile virtualFile = event.getFile();
                                if (virtualFile == null) {
                                    break block10;
                                }
                                VirtualFile virtualFile2 = vfile = virtualFile;
                                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"vfile");
                                if (virtualFile2.isDirectory() || !vfile.isValid()) {
                                    Map map2 = PerModulePackageCacheService.access$getCache$p(this.this$0);
                                    Iterator<Map.Entry<K, V>> iterator2 = map2.entrySet().iterator();
                                    while (iterator2.hasNext()) {
                                        boolean bl;
                                        ConcurrentMap data;
                                        block11: {
                                            Map.Entry<K, V> entry;
                                            Map.Entry<K, V> entry2 = entry = iterator2.next();
                                            Module module = (Module)entry2.getKey();
                                            entry2 = entry;
                                            data = (ConcurrentMap)entry2.getValue();
                                            String[] sourceRootUrls = ProjectUtil.getRootManager((Module)module).getSourceRootUrls();
                                            Intrinsics.checkExpressionValueIsNotNull((Object)sourceRootUrls, (String)"sourceRootUrls");
                                            String[] $receiver$iv = sourceRootUrls;
                                            int n = $receiver$iv.length;
                                            for (int i = 0; i < n; ++i) {
                                                String element$iv;
                                                String url;
                                                String string = url = (element$iv = $receiver$iv[i]);
                                                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"url");
                                                if (!PerModulePackageCacheService.access$containedInOrContains(this.this$0, vfile, string)) continue;
                                                bl = true;
                                                break block11;
                                            }
                                            bl = false;
                                        }
                                        if (!bl) continue;
                                        data.clear();
                                    }
                                } else {
                                    IdeaModuleInfo ideaModuleInfo = GetModuleInfoKt.getModuleInfoByVirtualFile(PerModulePackageCacheService.access$getProject$p(this.this$0), vfile);
                                    if (!(ideaModuleInfo instanceof ModuleSourceInfo)) {
                                        ideaModuleInfo = null;
                                    }
                                    ModuleSourceInfo moduleSourceInfo = (ModuleSourceInfo)ideaModuleInfo;
                                    if (moduleSourceInfo != null) {
                                        ModuleSourceInfo moduleSourceInfo2;
                                        ModuleSourceInfo it = moduleSourceInfo2 = moduleSourceInfo;
                                        PerModulePackageCacheService.access$invalidateCacheForModuleSourceInfo(this.this$0, it);
                                    }
                                }
                                PerModulePackageCacheService.access$getImplicitPackagePrefixCache$p(this.this$0).update$idea_core(event);
                            }
                            catch (ProcessCanceledException pce) {
                                throw (Throwable)pce;
                            }
                            catch (Exception exc) {
                                PerModulePackageCacheService.access$getLOG$cp().error((Throwable)exc);
                            }
                        }
                        return true;
                    }
                });
                $receiver$iv = this.pendingKtFileChanges;
                this_$iv = this;
                $receiver$iv.removeIf(new Predicate<T>(this){
                    final /* synthetic */ PerModulePackageCacheService this$0;
                    {
                        this.this$0 = perModulePackageCacheService;
                    }

                    public final boolean test(T value) {
                        try {
                            KtFile file = (KtFile)value;
                            if (file.getVirtualFile() == null || PerModulePackageCacheService.access$getProjectScope$p(this.this$0).contains(file.getVirtualFile())) {
                                IdeaModuleInfo ideaModuleInfo = GetModuleInfoKt.getNullableModuleInfo((PsiElement)file);
                                if (!(ideaModuleInfo instanceof ModuleSourceInfo)) {
                                    ideaModuleInfo = null;
                                }
                                ModuleSourceInfo moduleSourceInfo = (ModuleSourceInfo)ideaModuleInfo;
                                if (moduleSourceInfo != null) {
                                    ModuleSourceInfo moduleSourceInfo2;
                                    ModuleSourceInfo it = moduleSourceInfo2 = moduleSourceInfo;
                                    PerModulePackageCacheService.access$invalidateCacheForModuleSourceInfo(this.this$0, it);
                                }
                                PerModulePackageCacheService.access$getImplicitPackagePrefixCache$p(this.this$0).update$idea_core(file);
                            }
                        }
                        catch (ProcessCanceledException pce) {
                            throw (Throwable)pce;
                        }
                        catch (Exception exc) {
                            PerModulePackageCacheService.access$getLOG$cp().error((Throwable)exc);
                        }
                        return true;
                    }
                });
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final <T> void processPending(@NotNull Collection<T> $receiver, Function1<? super T, Unit> body2) {
        $receiver.removeIf(new Predicate<T>(body2){
            final /* synthetic */ Function1 $body;

            public final boolean test(T value) {
                try {
                    this.$body.invoke(value);
                }
                catch (ProcessCanceledException pce) {
                    throw (Throwable)pce;
                }
                catch (Exception exc) {
                    PerModulePackageCacheService.access$getLOG$cp().error((Throwable)exc);
                }
                return true;
            }
            {
                this.$body = function1;
            }
        });
    }

    private final boolean containedInOrContains(@NotNull VirtualFile $receiver, String root) {
        return VfsUtilCore.isEqualOrAncestor((String)$receiver.getUrl(), (String)root) || $receiver.isDirectory() && VfsUtilCore.isEqualOrAncestor((String)root, (String)$receiver.getUrl());
    }

    public final boolean packageExists(@NotNull FqName packageFqName, @NotNull ModuleSourceInfo moduleInfo) {
        ConcurrentMap cacheForCurrentModuleInfo;
        Object object;
        Object default$iv;
        Object object2;
        ConcurrentMap perSourceInfoCache;
        Intrinsics.checkParameterIsNotNull((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkParameterIsNotNull((Object)moduleInfo, (String)"moduleInfo");
        Module module = moduleInfo.getModule();
        this.checkPendingChanges();
        ConcurrentMap $receiver$iv = this.cache;
        Object object3 = $receiver$iv.get(module);
        if (object3 == null) {
            ConcurrentMap concurrentMap;
            Disposer.register((Disposable)((Disposable)module), (Disposable)new Disposable(this, module){
                final /* synthetic */ PerModulePackageCacheService this$0;
                final /* synthetic */ Module $module$inlined;
                {
                    this.this$0 = perModulePackageCacheService;
                    this.$module$inlined = module;
                }

                public final void dispose() {
                    PerModulePackageCacheService.access$getCache$p(this.this$0).remove(this.$module$inlined);
                }
            });
            ConcurrentMap default$iv2 = concurrentMap = ContainerUtil.createConcurrentSoftMap();
            object3 = $receiver$iv.putIfAbsent(module, default$iv2);
            if (object3 == null) {
                object3 = default$iv2;
            }
        }
        ConcurrentMap concurrentMap = perSourceInfoCache = (ConcurrentMap)object3;
        Intrinsics.checkExpressionValueIsNotNull((Object)concurrentMap, (String)"perSourceInfoCache");
        ConcurrentMap $receiver$iv2 = concurrentMap;
        Object object4 = $receiver$iv2.get(moduleInfo);
        if (object4 == null) {
            ConcurrentMap concurrentMap2 = ContainerUtil.createConcurrentSoftMap();
            Intrinsics.checkExpressionValueIsNotNull((Object)concurrentMap2, (String)"ContainerUtil.createConcurrentSoftMap()");
            default$iv = object2 = concurrentMap2;
            object4 = $receiver$iv2.putIfAbsent(moduleInfo, default$iv);
            if (object4 == null) {
                object4 = default$iv;
            }
        }
        if ((object = ($receiver$iv2 = (cacheForCurrentModuleInfo = (ConcurrentMap)object4)).get(packageFqName)) == null) {
            object2 = PackageIndexUtil.packageExists(packageFqName, moduleInfo.contentScope(), this.project);
            default$iv = object2;
            object = $receiver$iv2.putIfAbsent(packageFqName, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        return (Boolean)object;
    }

    @NotNull
    public final FqName getImplicitPackagePrefix(@NotNull VirtualFile sourceRoot) {
        Intrinsics.checkParameterIsNotNull((Object)sourceRoot, (String)"sourceRoot");
        this.checkPendingChanges();
        return this.implicitPackagePrefixCache.getPrefix(sourceRoot);
    }

    public PerModulePackageCacheService(@NotNull Project project) {
        Set set2;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
        this.cache = new ConcurrentHashMap();
        this.implicitPackagePrefixCache = new ImplicitPackagePrefixCache(this.project);
        PerModulePackageCacheService perModulePackageCacheService = this;
        perModulePackageCacheService.pendingVFileChanges = set2 = (Set)new LinkedHashSet();
        perModulePackageCacheService = this;
        perModulePackageCacheService.pendingKtFileChanges = set2 = (Set)new LinkedHashSet();
        this.projectScope = GlobalSearchScope.projectScope((Project)this.project);
    }

    static {
        Companion = new Companion(null);
        LOG = Logger.getInstance(Companion.getClass());
    }

    @NotNull
    public static final /* synthetic */ ConcurrentHashMap access$getCache$p(PerModulePackageCacheService $this) {
        return $this.cache;
    }

    public static final /* synthetic */ boolean access$containedInOrContains(PerModulePackageCacheService $this, @NotNull VirtualFile $receiver, @NotNull String root) {
        return $this.containedInOrContains($receiver, root);
    }

    @NotNull
    public static final /* synthetic */ Project access$getProject$p(PerModulePackageCacheService $this) {
        return $this.project;
    }

    public static final /* synthetic */ void access$invalidateCacheForModuleSourceInfo(PerModulePackageCacheService $this, @NotNull ModuleSourceInfo moduleSourceInfo) {
        $this.invalidateCacheForModuleSourceInfo(moduleSourceInfo);
    }

    @NotNull
    public static final /* synthetic */ ImplicitPackagePrefixCache access$getImplicitPackagePrefixCache$p(PerModulePackageCacheService $this) {
        return $this.implicitPackagePrefixCache;
    }

    @NotNull
    public static final /* synthetic */ GlobalSearchScope access$getProjectScope$p(PerModulePackageCacheService $this) {
        return $this.projectScope;
    }

    @NotNull
    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/caches/PerModulePackageCacheService$Companion;", "", "()V", "FULL_DROP_THRESHOLD", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "Lorg/jetbrains/kotlin/idea/caches/PerModulePackageCacheService;", "project", "Lcom/intellij/openapi/project/Project;", "idea-core"})
    public static final class Companion {
        @NotNull
        public final PerModulePackageCacheService getInstance(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Object object = ServiceManager.getService((Project)project, PerModulePackageCacheService.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ServiceManager.getServic\u2026CacheService::class.java)");
            return (PerModulePackageCacheService)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

