/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.caches.lightClasses;

import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.impl.compiled.ClsFileImpl;
import com.intellij.psi.impl.java.stubs.PsiJavaFileStub;
import com.intellij.psi.impl.java.stubs.impl.PsiJavaFileStubImpl;
import com.intellij.util.cls.ClsFormatException;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u000f2\u00020\u0001:\u0002\u000e\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u0005H\u0002J\u0010\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u0005R*\u0010\u0003\u001a\u001e\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00070\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/caches/lightClasses/ClsJavaStubByVirtualFileCache;", "", "()V", "cache", "Ljava/util/concurrent/ConcurrentMap;", "Lcom/intellij/openapi/vfs/VirtualFile;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/kotlin/idea/caches/lightClasses/ClsJavaStubByVirtualFileCache$CachedJavaStub;", "createStub", "Lcom/intellij/psi/impl/java/stubs/PsiJavaFileStub;", "file", "get", "Lcom/intellij/psi/impl/java/stubs/impl/PsiJavaFileStubImpl;", "classFile", "CachedJavaStub", "Companion", "idea-core"})
public final class ClsJavaStubByVirtualFileCache {
    private final ConcurrentMap<VirtualFile, CachedJavaStub> cache = ContainerUtil.createConcurrentWeakKeySoftValueMap();
    private static final Logger LOG;
    public static final Companion Companion;

    @Nullable
    public final PsiJavaFileStubImpl get(@NotNull VirtualFile classFile) {
        Intrinsics.checkParameterIsNotNull((Object)classFile, (String)"classFile");
        CachedJavaStub cached = (CachedJavaStub)this.cache.get(classFile);
        long fileModificationStamp = classFile.getModificationStamp();
        if (cached != null && cached.getModificationStamp() == fileModificationStamp) {
            return cached.getJavaFileStub();
        }
        PsiJavaFileStubImpl psiJavaFileStubImpl = (PsiJavaFileStubImpl)this.createStub(classFile);
        if (psiJavaFileStubImpl == null) {
            return null;
        }
        PsiJavaFileStubImpl stub = psiJavaFileStubImpl;
        this.cache.put(classFile, new CachedJavaStub(fileModificationStamp, stub));
        return stub;
    }

    private final PsiJavaFileStub createStub(VirtualFile file) {
        if (file.getFileType() != JavaClassFileType.INSTANCE) {
            return null;
        }
        try {
            return ClsFileImpl.buildFileStub((VirtualFile)file, (byte[])file.contentsToByteArray(false));
        }
        catch (ClsFormatException e) {
            StringBuilder stringBuilder = new StringBuilder().append("Failed to build java cls class for ");
            String string = file.getCanonicalPath();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            LOG.error(stringBuilder.append(string).toString(), (Throwable)e);
        }
        catch (IOException e) {
            StringBuilder stringBuilder = new StringBuilder().append("Failed to build java cls class for ");
            String string = file.getCanonicalPath();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            LOG.error(stringBuilder.append(string).toString(), (Throwable)e);
        }
        return null;
    }

    static {
        Companion = new Companion(null);
        LOG = Logger.getInstance(ClsJavaStubByVirtualFileCache.class);
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/caches/lightClasses/ClsJavaStubByVirtualFileCache$CachedJavaStub;", "", "modificationStamp", "", "javaFileStub", "Lcom/intellij/psi/impl/java/stubs/impl/PsiJavaFileStubImpl;", "(JLcom/intellij/psi/impl/java/stubs/impl/PsiJavaFileStubImpl;)V", "getJavaFileStub", "()Lcom/intellij/psi/impl/java/stubs/impl/PsiJavaFileStubImpl;", "getModificationStamp", "()J", "idea-core"})
    private static final class CachedJavaStub {
        private final long modificationStamp;
        @NotNull
        private final PsiJavaFileStubImpl javaFileStub;

        public final long getModificationStamp() {
            return this.modificationStamp;
        }

        @NotNull
        public final PsiJavaFileStubImpl getJavaFileStub() {
            return this.javaFileStub;
        }

        public CachedJavaStub(long modificationStamp, @NotNull PsiJavaFileStubImpl javaFileStub) {
            Intrinsics.checkParameterIsNotNull((Object)javaFileStub, (String)"javaFileStub");
            this.modificationStamp = modificationStamp;
            this.javaFileStub = javaFileStub;
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/caches/lightClasses/ClsJavaStubByVirtualFileCache$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "Lorg/jetbrains/kotlin/idea/caches/lightClasses/ClsJavaStubByVirtualFileCache;", "project", "Lcom/intellij/openapi/project/Project;", "idea-core"})
    public static final class Companion {
        @NotNull
        public final ClsJavaStubByVirtualFileCache getInstance(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Object object = ServiceManager.getService((Project)project, ClsJavaStubByVirtualFileCache.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ServiceManager.getServic\u2026ualFileCache::class.java)");
            return (ClsJavaStubByVirtualFileCache)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

