/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.caches.project;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.PathUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.ModuleInfo;
import org.jetbrains.kotlin.caches.project.LibraryModuleInfo;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.idea.caches.project.BinaryModuleInfo;
import org.jetbrains.kotlin.idea.caches.project.IdeaModuleInfo;
import org.jetbrains.kotlin.idea.caches.project.LibraryDependenciesCache;
import org.jetbrains.kotlin.idea.caches.project.LibrarySourceInfo;
import org.jetbrains.kotlin.idea.caches.project.LibraryWithoutSourceScope;
import org.jetbrains.kotlin.idea.caches.project.ModuleOrigin;
import org.jetbrains.kotlin.idea.caches.project.SdkInfo;
import org.jetbrains.kotlin.idea.caches.project.SourceForBinaryModuleInfo;
import org.jetbrains.kotlin.idea.framework.LibraryKindsKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.TargetPlatform;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u000e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00010 H\u0016J\u0013\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010$H\u0096\u0002J\u000e\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&H\u0016J\b\u0010(\u001a\u00020)H\u0016J\b\u0010*\u001a\u00020'H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006+"}, d2={"Lorg/jetbrains/kotlin/idea/caches/project/LibraryInfo;", "Lorg/jetbrains/kotlin/idea/caches/project/IdeaModuleInfo;", "Lorg/jetbrains/kotlin/caches/project/LibraryModuleInfo;", "Lorg/jetbrains/kotlin/idea/caches/project/BinaryModuleInfo;", "project", "Lcom/intellij/openapi/project/Project;", "library", "Lcom/intellij/openapi/roots/libraries/Library;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/roots/libraries/Library;)V", "getLibrary", "()Lcom/intellij/openapi/roots/libraries/Library;", "moduleOrigin", "Lorg/jetbrains/kotlin/idea/caches/project/ModuleOrigin;", "getModuleOrigin", "()Lorg/jetbrains/kotlin/idea/caches/project/ModuleOrigin;", "name", "Lorg/jetbrains/kotlin/name/Name;", "getName", "()Lorg/jetbrains/kotlin/name/Name;", "platform", "Lorg/jetbrains/kotlin/resolve/TargetPlatform;", "getPlatform", "()Lorg/jetbrains/kotlin/resolve/TargetPlatform;", "getProject", "()Lcom/intellij/openapi/project/Project;", "sourcesModuleInfo", "Lorg/jetbrains/kotlin/idea/caches/project/SourceForBinaryModuleInfo;", "getSourcesModuleInfo", "()Lorg/jetbrains/kotlin/idea/caches/project/SourceForBinaryModuleInfo;", "contentScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "dependencies", "", "equals", "", "other", "", "getLibraryRoots", "", "", "hashCode", "", "toString", "idea-core"})
public final class LibraryInfo
implements IdeaModuleInfo,
LibraryModuleInfo,
BinaryModuleInfo {
    @NotNull
    private final Name name;
    @NotNull
    private final Project project;
    @NotNull
    private final Library library;

    @Override
    @NotNull
    public ModuleOrigin getModuleOrigin() {
        return ModuleOrigin.LIBRARY;
    }

    @Override
    @NotNull
    public Name getName() {
        return this.name;
    }

    @Override
    @NotNull
    public GlobalSearchScope contentScope() {
        return (GlobalSearchScope)new LibraryWithoutSourceScope(this.project, this.library);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<IdeaModuleInfo> dependencies() {
        void $receiver$iv$iv;
        void libraries;
        IdeaModuleInfo ideaModuleInfo;
        Library it;
        Collection collection;
        LinkedHashSet<LibraryInfo> result2 = new LinkedHashSet<LibraryInfo>();
        result2.add(this);
        Pair<List<Library>, List<Sdk>> pair2 = LibraryDependenciesCache.Companion.getInstance(this.project).getLibrariesAndSdksUsedWith(this.library);
        List list2 = (List)pair2.component1();
        List sdks = (List)pair2.component2();
        Iterable $receiver$iv = sdks;
        for (Object item$iv : $receiver$iv) {
            Sdk sdk2 = (Sdk)item$iv;
            collection = result2;
            ideaModuleInfo = new SdkInfo(this.project, (Sdk)it);
            collection.add(ideaModuleInfo);
        }
        $receiver$iv = (Iterable)libraries;
        Iterator iterator2 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            Library it2 = (Library)element$iv$iv;
            if (!(it2 instanceof LibraryEx && !((LibraryEx)it2).isDisposed())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        for (Object item$iv : $receiver$iv) {
            it = (Library)item$iv;
            collection = result2;
            ideaModuleInfo = new LibraryInfo(this.project, it);
            collection.add(ideaModuleInfo);
        }
        return CollectionsKt.toList((Iterable)result2);
    }

    @Override
    @NotNull
    public TargetPlatform getPlatform() {
        return LibraryKindsKt.getLibraryPlatform(this.project, this.library);
    }

    @Override
    @NotNull
    public SourceForBinaryModuleInfo getSourcesModuleInfo() {
        return new LibrarySourceInfo(this.project, this.library);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Collection<String> getLibraryRoots() {
        void var3_3;
        void $receiver$iv$iv;
        VirtualFile[] $receiver$iv;
        VirtualFile[] virtualFileArray = this.library.getFiles(OrderRootType.CLASSES);
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFileArray, (String)"library.getFiles(OrderRootType.CLASSES)");
        VirtualFile[] virtualFileArray2 = $receiver$iv = virtualFileArray;
        Collection destination$iv$iv = new ArrayList();
        for (void element$iv$iv$iv : $receiver$iv$iv) {
            String string;
            void element$iv$iv = element$iv$iv$iv;
            void p1 = element$iv$iv;
            if (PathUtil.getLocalPath((VirtualFile)p1) == null) continue;
            String it$iv$iv = string;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)var3_3;
    }

    @NotNull
    public String toString() {
        return "LibraryInfo(libraryName=" + this.library.getName() + ')';
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof LibraryInfo && Intrinsics.areEqual((Object)this.library, (Object)((LibraryInfo)other).library);
    }

    public int hashCode() {
        return 43 * this.library.hashCode();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final Library getLibrary() {
        return this.library;
    }

    public LibraryInfo(@NotNull Project project, @NotNull Library library) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)library, (String)"library");
        this.project = project;
        this.library = library;
        Name name2 = Name.special("<library " + this.library.getName() + '>');
        Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"Name.special(\"<library ${library.name}>\")");
        this.name = name2;
    }

    @Override
    @NotNull
    public Map<ModuleDescriptor.Capability<?>, Object> getCapabilities() {
        return IdeaModuleInfo.DefaultImpls.getCapabilities(this);
    }

    @Override
    @NotNull
    public String getDisplayedName() {
        return IdeaModuleInfo.DefaultImpls.getDisplayedName(this);
    }

    @Override
    @NotNull
    public List<ModuleInfo> getExpectedBy() {
        return IdeaModuleInfo.DefaultImpls.getExpectedBy(this);
    }

    @Override
    @NotNull
    public ModuleInfo.DependencyOnBuiltIns dependencyOnBuiltIns() {
        return IdeaModuleInfo.DefaultImpls.dependencyOnBuiltIns(this);
    }

    @Override
    @NotNull
    public Collection<ModuleInfo> modulesWhoseInternalsAreVisible() {
        return IdeaModuleInfo.DefaultImpls.modulesWhoseInternalsAreVisible(this);
    }

    @Override
    @NotNull
    public GlobalSearchScope binariesScope() {
        return BinaryModuleInfo.DefaultImpls.binariesScope(this);
    }
}

