/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.caches.project;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.ModuleInfo;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.idea.caches.project.BinaryModuleInfo;
import org.jetbrains.kotlin.idea.caches.project.IdeaModuleInfo;
import org.jetbrains.kotlin.idea.caches.project.LibraryInfo;
import org.jetbrains.kotlin.idea.caches.project.LibrarySourceScope;
import org.jetbrains.kotlin.idea.caches.project.ModuleOrigin;
import org.jetbrains.kotlin.idea.caches.project.SourceForBinaryModuleInfo;
import org.jetbrains.kotlin.idea.stubindex.KotlinSourceFilterScope;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.TargetPlatform;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u0014\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0006H\u00c6\u0003J\u001d\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0016J\b\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020#H\u0016R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/idea/caches/project/LibrarySourceInfo;", "Lorg/jetbrains/kotlin/idea/caches/project/IdeaModuleInfo;", "Lorg/jetbrains/kotlin/idea/caches/project/SourceForBinaryModuleInfo;", "project", "Lcom/intellij/openapi/project/Project;", "library", "Lcom/intellij/openapi/roots/libraries/Library;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/roots/libraries/Library;)V", "binariesModuleInfo", "Lorg/jetbrains/kotlin/idea/caches/project/BinaryModuleInfo;", "getBinariesModuleInfo", "()Lorg/jetbrains/kotlin/idea/caches/project/BinaryModuleInfo;", "getLibrary", "()Lcom/intellij/openapi/roots/libraries/Library;", "name", "Lorg/jetbrains/kotlin/name/Name;", "getName", "()Lorg/jetbrains/kotlin/name/Name;", "getProject", "()Lcom/intellij/openapi/project/Project;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "modulesWhoseInternalsAreVisible", "", "Lorg/jetbrains/kotlin/analyzer/ModuleInfo;", "sourceScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "toString", "", "idea-core"})
public final class LibrarySourceInfo
implements IdeaModuleInfo,
SourceForBinaryModuleInfo {
    @NotNull
    private final Name name;
    @NotNull
    private final Project project;
    @NotNull
    private final Library library;

    @Override
    @NotNull
    public Name getName() {
        return this.name;
    }

    @Override
    @NotNull
    public GlobalSearchScope sourceScope() {
        return KotlinSourceFilterScope.Companion.librarySources((GlobalSearchScope)new LibrarySourceScope(this.project, this.library), this.project);
    }

    @Override
    @NotNull
    public Collection<ModuleInfo> modulesWhoseInternalsAreVisible() {
        return CollectionsKt.listOf((Object)new LibraryInfo(this.project, this.library));
    }

    @Override
    @NotNull
    public BinaryModuleInfo getBinariesModuleInfo() {
        return new LibraryInfo(this.project, this.library);
    }

    @NotNull
    public String toString() {
        return "LibrarySourceInfo(libraryName=" + this.library.getName() + ')';
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final Library getLibrary() {
        return this.library;
    }

    public LibrarySourceInfo(@NotNull Project project, @NotNull Library library) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)library, (String)"library");
        this.project = project;
        this.library = library;
        Name name2 = Name.special("<sources for library " + this.library.getName() + '>');
        Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"Name.special(\"<sources f\u2026ibrary ${library.name}>\")");
        this.name = name2;
    }

    @Override
    @NotNull
    public GlobalSearchScope contentScope() {
        return SourceForBinaryModuleInfo.DefaultImpls.contentScope(this);
    }

    @Override
    @NotNull
    public ModuleOrigin getModuleOrigin() {
        return SourceForBinaryModuleInfo.DefaultImpls.getModuleOrigin(this);
    }

    @Override
    @NotNull
    public Map<ModuleDescriptor.Capability<?>, Object> getCapabilities() {
        return IdeaModuleInfo.DefaultImpls.getCapabilities(this);
    }

    @Override
    @NotNull
    public List<IdeaModuleInfo> dependencies() {
        return SourceForBinaryModuleInfo.DefaultImpls.dependencies(this);
    }

    @Override
    @NotNull
    public String getDisplayedName() {
        return IdeaModuleInfo.DefaultImpls.getDisplayedName(this);
    }

    @Override
    @NotNull
    public List<ModuleInfo> getExpectedBy() {
        return IdeaModuleInfo.DefaultImpls.getExpectedBy(this);
    }

    @Override
    @Nullable
    public TargetPlatform getPlatform() {
        return IdeaModuleInfo.DefaultImpls.getPlatform(this);
    }

    @Override
    @NotNull
    public ModuleInfo.DependencyOnBuiltIns dependencyOnBuiltIns() {
        return IdeaModuleInfo.DefaultImpls.dependencyOnBuiltIns(this);
    }

    @NotNull
    public final Project component1() {
        return this.project;
    }

    @NotNull
    public final Library component2() {
        return this.library;
    }

    @NotNull
    public final LibrarySourceInfo copy(@NotNull Project project, @NotNull Library library) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)library, (String)"library");
        return new LibrarySourceInfo(project, library);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ LibrarySourceInfo copy$default(LibrarySourceInfo librarySourceInfo, Project project, Library library, int n, Object object) {
        if ((n & 1) != 0) {
            project = librarySourceInfo.project;
        }
        if ((n & 2) != 0) {
            library = librarySourceInfo.library;
        }
        return librarySourceInfo.copy(project, library);
    }

    public int hashCode() {
        Project project = this.project;
        Library library = this.library;
        return (project != null ? project.hashCode() : 0) * 31 + (library != null ? library.hashCode() : 0);
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof LibrarySourceInfo)) break block3;
                LibrarySourceInfo librarySourceInfo = (LibrarySourceInfo)object;
                if (!Intrinsics.areEqual((Object)this.project, (Object)librarySourceInfo.project) || !Intrinsics.areEqual((Object)this.library, (Object)librarySourceInfo.library)) break block3;
            }
            return true;
        }
        return false;
    }
}

