/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.surroundWith;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeInsight.CodeInsightUtils;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;

public class KotlinSurrounderUtils {
    public static String SURROUND_WITH = KotlinBundle.message("surround.with", new Object[0]);
    public static String SURROUND_WITH_ERROR = KotlinBundle.message("surround.with.cannot.perform.action", new Object[0]);

    private KotlinSurrounderUtils() {
    }

    public static void addStatementsInBlock(@NotNull KtBlockExpression block, @NotNull PsiElement[] statements) {
        if (block == null) {
            KotlinSurrounderUtils.$$$reportNull$$$0(0);
        }
        if (statements == null) {
            KotlinSurrounderUtils.$$$reportNull$$$0(1);
        }
        PsiElement lBrace = block.getFirstChild();
        block.addRangeAfter(statements[0], statements[statements.length - 1], lBrace);
    }

    public static void showErrorHint(@NotNull Project project, @NotNull Editor editor, @NotNull String message2) {
        if (project == null) {
            KotlinSurrounderUtils.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            KotlinSurrounderUtils.$$$reportNull$$$0(3);
        }
        if (message2 == null) {
            KotlinSurrounderUtils.$$$reportNull$$$0(4);
        }
        CodeInsightUtils.showErrorHint(project, editor, message2, SURROUND_WITH, null);
    }

    public static boolean isUsedAsStatement(@NotNull KtExpression expression2) {
        if (expression2 == null) {
            KotlinSurrounderUtils.$$$reportNull$$$0(5);
        }
        BindingContext context2 = ResolutionUtils.analyze(expression2, BodyResolveMode.PARTIAL_WITH_CFA);
        return BindingContextUtilsKt.isUsedAsStatement(expression2, context2);
    }

    public static boolean isUsedAsExpression(@NotNull KtExpression expression2) {
        if (expression2 == null) {
            KotlinSurrounderUtils.$$$reportNull$$$0(6);
        }
        BindingContext context2 = ResolutionUtils.analyze(expression2, BodyResolveMode.PARTIAL_WITH_CFA);
        return BindingContextUtilsKt.isUsedAsExpression(expression2, context2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statements";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/idea/codeInsight/surroundWith/KotlinSurrounderUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addStatementsInBlock";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "showErrorHint";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isUsedAsStatement";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isUsedAsExpression";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

