/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.upDownMover;

import com.intellij.codeInsight.editorActions.moveUpDown.LineRange;
import com.intellij.codeInsight.editorActions.moveUpDown.StatementUpDownMover;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import java.util.function.Predicate;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.codeInsight.upDownMover.AbstractKotlinUpDownMover;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCatchClause;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDoWhileExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFinallySection;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtScriptInitializer;
import org.jetbrains.kotlin.psi.KtTryExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

public class KotlinExpressionMover
extends AbstractKotlinUpDownMover {
    private static final Predicate<KtElement> IS_CALL_EXPRESSION = input -> input instanceof KtCallExpression;
    private static final Class[] MOVABLE_ELEMENT_CLASSES = new Class[]{KtExpression.class, KtWhenEntry.class, KtValueArgument.class, PsiComment.class};
    private static final Function1<PsiElement, Boolean> MOVABLE_ELEMENT_CONSTRAINT = new Function1<PsiElement, Boolean>(){

        @NotNull
        public Boolean invoke(PsiElement element3) {
            Boolean bl = !(element3 instanceof KtExpression) || element3 instanceof KtDeclaration || element3 instanceof KtBlockExpression || element3.getParent() instanceof KtBlockExpression;
            if (bl == null) {
                1.$$$reportNull$$$0(0);
            }
            return bl;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/KotlinExpressionMover$1", "invoke"));
        }
    };
    private static final Class[] BLOCKLIKE_ELEMENT_CLASSES = new Class[]{KtBlockExpression.class, KtWhenExpression.class, KtClassBody.class, KtFile.class};
    private static final Class[] FUNCTIONLIKE_ELEMENT_CLASSES = new Class[]{KtFunction.class, KtPropertyAccessor.class, KtAnonymousInitializer.class};
    private static final Predicate<KtElement> CHECK_BLOCK_LIKE_ELEMENT = input -> (input instanceof KtBlockExpression || input instanceof KtClassBody) && !PsiTreeUtil.instanceOf((Object)input.getParent(), (Class[])FUNCTIONLIKE_ELEMENT_CLASSES);
    private static final Predicate<KtElement> CHECK_BLOCK = input -> input instanceof KtBlockExpression && !PsiTreeUtil.instanceOf((Object)input.getParent(), (Class[])FUNCTIONLIKE_ELEMENT_CLASSES);
    @Nullable
    private Pair<PsiElement, PsiElement> parametersOrArgsToMove;

    @Nullable
    private static PsiElement getStandaloneClosingBrace(@NotNull PsiFile file, @NotNull Editor editor) {
        if (file == null) {
            KotlinExpressionMover.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            KotlinExpressionMover.$$$reportNull$$$0(1);
        }
        LineRange range = KotlinExpressionMover.getLineRangeFromSelection((Editor)editor);
        if (range.endLine - range.startLine != 1) {
            return null;
        }
        int offset = editor.getCaretModel().getOffset();
        Document document = editor.getDocument();
        int line = document.getLineNumber(offset);
        int lineStartOffset = document.getLineStartOffset(line);
        String lineText = document.getText().substring(lineStartOffset, document.getLineEndOffset(line));
        if (!lineText.trim().equals("}")) {
            return null;
        }
        return file.findElementAt(lineStartOffset + lineText.indexOf(125));
    }

    private static BraceStatus checkForMovableDownClosingBrace(@NotNull PsiElement closingBrace, @NotNull PsiElement block, @NotNull Editor editor, @NotNull StatementUpDownMover.MoveInfo info) {
        if (closingBrace == null) {
            KotlinExpressionMover.$$$reportNull$$$0(2);
        }
        if (block == null) {
            KotlinExpressionMover.$$$reportNull$$$0(3);
        }
        if (editor == null) {
            KotlinExpressionMover.$$$reportNull$$$0(4);
        }
        if (info == null) {
            KotlinExpressionMover.$$$reportNull$$$0(5);
        }
        PsiElement current = block;
        PsiElement nextElement = null;
        PsiElement nextExpression = null;
        do {
            PsiElement sibling;
            if ((sibling = KotlinExpressionMover.firstNonWhiteElement((PsiElement)current.getNextSibling(), (boolean)true)) != null && nextElement == null) {
                nextElement = sibling;
            }
            if (!(sibling instanceof KtExpression)) continue;
            nextExpression = sibling;
            break;
        } while ((current = current.getParent()) != null && !PsiTreeUtil.instanceOf((Object)current, (Class[])BLOCKLIKE_ELEMENT_CLASSES));
        if (nextExpression == null) {
            return BraceStatus.NOT_MOVABLE;
        }
        Document doc = editor.getDocument();
        info.toMove = new LineRange(closingBrace, closingBrace, doc);
        info.toMove2 = new LineRange(nextElement, nextExpression);
        info.indentSource = true;
        return BraceStatus.MOVABLE;
    }

    private static BraceStatus checkForMovableUpClosingBrace(@NotNull PsiElement closingBrace, PsiElement block, @NotNull Editor editor, @NotNull StatementUpDownMover.MoveInfo info) {
        Object prev2;
        if (closingBrace == null) {
            KotlinExpressionMover.$$$reportNull$$$0(6);
        }
        if (editor == null) {
            KotlinExpressionMover.$$$reportNull$$$0(7);
        }
        if (info == null) {
            KotlinExpressionMover.$$$reportNull$$$0(8);
        }
        if ((prev2 = KtPsiUtil.getLastChildByType(block, KtExpression.class)) == null) {
            return BraceStatus.NOT_MOVABLE;
        }
        Document doc = editor.getDocument();
        info.toMove = new LineRange(closingBrace, closingBrace, doc);
        info.toMove2 = new LineRange(prev2, prev2, doc);
        info.indentSource = true;
        return BraceStatus.MOVABLE;
    }

    private static BraceStatus checkForMovableClosingBrace(@NotNull Editor editor, @NotNull PsiFile file, @NotNull StatementUpDownMover.MoveInfo info, boolean down) {
        KtIfExpression ifExpression2;
        PsiElement closingBrace;
        if (editor == null) {
            KotlinExpressionMover.$$$reportNull$$$0(9);
        }
        if (file == null) {
            KotlinExpressionMover.$$$reportNull$$$0(10);
        }
        if (info == null) {
            KotlinExpressionMover.$$$reportNull$$$0(11);
        }
        if ((closingBrace = KotlinExpressionMover.getStandaloneClosingBrace(file, editor)) == null) {
            return BraceStatus.NOT_FOUND;
        }
        PsiElement blockLikeElement = closingBrace.getParent();
        if (!(blockLikeElement instanceof KtBlockExpression)) {
            return BraceStatus.NOT_MOVABLE;
        }
        PsiElement blockParent = blockLikeElement.getParent();
        if (blockParent instanceof KtWhenEntry) {
            return BraceStatus.NOT_FOUND;
        }
        if (PsiTreeUtil.instanceOf((Object)blockParent, (Class[])FUNCTIONLIKE_ELEMENT_CLASSES)) {
            return BraceStatus.NOT_FOUND;
        }
        PsiElement enclosingExpression = PsiTreeUtil.getParentOfType((PsiElement)blockLikeElement, KtExpression.class);
        if (enclosingExpression instanceof KtDoWhileExpression) {
            return BraceStatus.NOT_MOVABLE;
        }
        if (enclosingExpression instanceof KtIfExpression && blockLikeElement == (ifExpression2 = (KtIfExpression)enclosingExpression).getThen() && ifExpression2.getElse() != null) {
            return BraceStatus.NOT_MOVABLE;
        }
        return down ? KotlinExpressionMover.checkForMovableDownClosingBrace(closingBrace, blockLikeElement, editor, info) : KotlinExpressionMover.checkForMovableUpClosingBrace(closingBrace, blockLikeElement, editor, info);
    }

    @Nullable
    private static KtBlockExpression findClosestBlock(@NotNull PsiElement anchor2, boolean down, boolean strict) {
        if (anchor2 == null) {
            KotlinExpressionMover.$$$reportNull$$$0(12);
        }
        PsiElement current = PsiTreeUtil.getParentOfType((PsiElement)anchor2, KtBlockExpression.class, (boolean)strict);
        while (current != null) {
            PsiElement sibling;
            PsiElement parent2 = current.getParent();
            if (parent2 instanceof KtClassBody || parent2 instanceof KtAnonymousInitializer && !(parent2 instanceof KtScriptInitializer) || parent2 instanceof KtNamedFunction || parent2 instanceof KtProperty && !((KtProperty)parent2).isLocal()) {
                return null;
            }
            if (parent2 instanceof KtBlockExpression) {
                return (KtBlockExpression)parent2;
            }
            PsiElement psiElement2 = sibling = down ? current.getNextSibling() : current.getPrevSibling();
            if (sibling != null) {
                KtBlockExpression block = (KtBlockExpression)KtPsiUtil.getOutermostDescendantElement(sibling, down, CHECK_BLOCK);
                if (block != null) {
                    return block;
                }
                current = sibling;
                continue;
            }
            current = parent2;
        }
        return null;
    }

    @Nullable
    private static KtBlockExpression getDSLLambdaBlock(@NotNull Editor editor, @NotNull PsiElement element3, boolean down) {
        TextRange range;
        KtCallExpression callExpression2;
        if (editor == null) {
            KotlinExpressionMover.$$$reportNull$$$0(13);
        }
        if (element3 == null) {
            KotlinExpressionMover.$$$reportNull$$$0(14);
        }
        if ((callExpression2 = (KtCallExpression)KtPsiUtil.getOutermostDescendantElement(element3, down, IS_CALL_EXPRESSION)) == null) {
            return null;
        }
        List<KtLambdaArgument> functionLiterals = callExpression2.getLambdaArguments();
        if (functionLiterals.isEmpty()) {
            return null;
        }
        KtLambdaExpression lambdaExpression2 = functionLiterals.get(0).getLambdaExpression();
        if (lambdaExpression2 == null) {
            return null;
        }
        Document document = editor.getDocument();
        if (document.getLineNumber((range = lambdaExpression2.getTextRange()).getStartOffset()) == document.getLineNumber(range.getEndOffset())) {
            return null;
        }
        return lambdaExpression2.getBodyExpression();
    }

    @Nullable
    private static LineRange getExpressionTargetRange(@NotNull Editor editor, @NotNull PsiElement sibling, boolean down) {
        PsiElement arrow;
        if (editor == null) {
            KotlinExpressionMover.$$$reportNull$$$0(15);
        }
        if (sibling == null) {
            KotlinExpressionMover.$$$reportNull$$$0(16);
        }
        PsiElement start = sibling;
        PsiElement end = sibling;
        if (!down) {
            if (sibling instanceof KtIfExpression) {
                KtIfExpression ifExpression2 = (KtIfExpression)sibling;
                KtExpression elseExpression = ifExpression2.getElse();
                while (elseExpression instanceof KtIfExpression) {
                    KtIfExpression elseIfExpression = (KtIfExpression)elseExpression;
                    KtExpression next2 = elseIfExpression.getElse();
                    if (next2 == null) {
                        elseExpression = elseIfExpression.getThen();
                        break;
                    }
                    elseExpression = next2;
                }
                if (elseExpression instanceof KtBlockExpression) {
                    start = sibling = elseExpression;
                }
            } else if (sibling instanceof KtWhenExpression) {
                List<KtWhenEntry> entries2 = ((KtWhenExpression)sibling).getEntries();
                if (!entries2.isEmpty()) {
                    KtWhenEntry lastEntry = null;
                    for (KtWhenEntry entry : entries2) {
                        if (!(entry.getExpression() instanceof KtBlockExpression)) continue;
                        lastEntry = entry;
                    }
                    if (lastEntry != null) {
                        start = sibling = lastEntry;
                    }
                }
            } else if (sibling instanceof KtTryExpression) {
                KtTryExpression tryExpression = (KtTryExpression)sibling;
                KtFinallySection finallyBlock = tryExpression.getFinallyBlock();
                if (finallyBlock != null) {
                    start = sibling = finallyBlock;
                } else {
                    List<KtCatchClause> clauses = tryExpression.getCatchClauses();
                    if (!clauses.isEmpty()) {
                        start = sibling = (PsiElement)clauses.get(clauses.size() - 1);
                    }
                }
            }
        }
        if (sibling.getNode().getElementType() == (down ? KtTokens.RBRACE : KtTokens.LBRACE)) {
            KtBlockExpression newBlock;
            PsiElement parent2 = sibling.getParent();
            if (!(parent2 instanceof KtBlockExpression) && !(parent2 instanceof KtFunctionLiteral)) {
                return null;
            }
            if (parent2 instanceof KtFunctionLiteral) {
                newBlock = KotlinExpressionMover.findClosestBlock((PsiElement)((KtFunctionLiteral)parent2).getBodyExpression(), down, false);
                if (!down && (arrow = ((KtFunctionLiteral)parent2).getArrow()) != null) {
                    end = arrow;
                }
            } else {
                newBlock = KotlinExpressionMover.findClosestBlock(sibling, down, true);
            }
            if (newBlock == null) {
                return null;
            }
            if (PsiTreeUtil.isAncestor((PsiElement)newBlock, (PsiElement)parent2, (boolean)true)) {
                PsiElement outermostParent = KtPsiUtil.getOutermostParent(parent2, (PsiElement)newBlock, true);
                if (down) {
                    end = outermostParent;
                } else {
                    start = outermostParent;
                }
            } else if (down) {
                end = newBlock.getLBrace();
            } else {
                start = newBlock.getRBrace();
            }
        } else {
            KtBlockExpression dslBlock = KotlinExpressionMover.getDSLLambdaBlock(editor, sibling, down);
            Object blockLikeElement = dslBlock != null ? dslBlock.getParent() : KtPsiUtil.getOutermostDescendantElement(sibling, down, CHECK_BLOCK_LIKE_ELEMENT);
            if (blockLikeElement != null) {
                if (down) {
                    end = KtPsiUtil.findChildByType(blockLikeElement, KtTokens.LBRACE);
                    if (blockLikeElement instanceof KtFunctionLiteral && (arrow = ((KtFunctionLiteral)blockLikeElement).getArrow()) != null) {
                        end = arrow;
                    }
                } else {
                    start = KtPsiUtil.findChildByType(blockLikeElement, KtTokens.RBRACE);
                }
            }
        }
        return start != null && end != null ? new LineRange(start, end, editor.getDocument()) : null;
    }

    @Nullable
    private static LineRange getWhenEntryTargetRange(@NotNull Editor editor, @NotNull PsiElement sibling, boolean down) {
        if (editor == null) {
            KotlinExpressionMover.$$$reportNull$$$0(17);
        }
        if (sibling == null) {
            KotlinExpressionMover.$$$reportNull$$$0(18);
        }
        if (sibling.getNode().getElementType() == (down ? KtTokens.RBRACE : KtTokens.LBRACE) && PsiTreeUtil.getParentOfType((PsiElement)sibling, KtWhenEntry.class) == null) {
            return null;
        }
        return new LineRange(sibling, sibling, editor.getDocument());
    }

    @Nullable
    private LineRange getValueParamOrArgTargetRange(@NotNull Editor editor, @NotNull PsiElement elementToCheck, @NotNull PsiElement sibling, boolean down) {
        LineRange range;
        PsiElement next2;
        if (editor == null) {
            KotlinExpressionMover.$$$reportNull$$$0(19);
        }
        if (elementToCheck == null) {
            KotlinExpressionMover.$$$reportNull$$$0(20);
        }
        if (sibling == null) {
            KotlinExpressionMover.$$$reportNull$$$0(21);
        }
        if ((next2 = sibling).getNode().getElementType() == KtTokens.COMMA) {
            next2 = KotlinExpressionMover.firstNonWhiteSibling(next2, down);
        }
        Object object = range = next2 instanceof KtParameter || next2 instanceof KtValueArgument ? new LineRange(next2, next2, editor.getDocument()) : null;
        if (range != null) {
            this.parametersOrArgsToMove = new Pair((Object)elementToCheck, (Object)next2);
        }
        return range;
    }

    @Nullable
    private LineRange getTargetRange(@NotNull Editor editor, @Nullable PsiElement elementToCheck, @NotNull PsiElement sibling, boolean down) {
        if (editor == null) {
            KotlinExpressionMover.$$$reportNull$$$0(22);
        }
        if (sibling == null) {
            KotlinExpressionMover.$$$reportNull$$$0(23);
        }
        if (elementToCheck instanceof KtParameter || elementToCheck instanceof KtValueArgument) {
            return this.getValueParamOrArgTargetRange(editor, elementToCheck, sibling, down);
        }
        if (elementToCheck instanceof KtExpression || elementToCheck instanceof PsiComment) {
            return KotlinExpressionMover.getExpressionTargetRange(editor, sibling, down);
        }
        if (elementToCheck instanceof KtWhenEntry) {
            return KotlinExpressionMover.getWhenEntryTargetRange(editor, sibling, down);
        }
        return null;
    }

    @Override
    protected boolean checkSourceElement(@NotNull PsiElement element3) {
        if (element3 == null) {
            KotlinExpressionMover.$$$reportNull$$$0(24);
        }
        return PsiTreeUtil.instanceOf((Object)element3, (Class[])MOVABLE_ELEMENT_CLASSES);
    }

    @Override
    protected LineRange getElementSourceLineRange(@NotNull PsiElement element3, @NotNull Editor editor, @NotNull LineRange oldRange) {
        if (element3 == null) {
            KotlinExpressionMover.$$$reportNull$$$0(25);
        }
        if (editor == null) {
            KotlinExpressionMover.$$$reportNull$$$0(26);
        }
        if (oldRange == null) {
            KotlinExpressionMover.$$$reportNull$$$0(27);
        }
        TextRange textRange = element3.getTextRange();
        if (editor.getDocument().getTextLength() < textRange.getEndOffset()) {
            return null;
        }
        int startLine = editor.offsetToLogicalPosition((int)textRange.getStartOffset()).line;
        int endLine = editor.offsetToLogicalPosition((int)textRange.getEndOffset()).line + 1;
        return new LineRange(startLine, endLine);
    }

    @Nullable
    private static PsiElement getMovableElement(@NotNull PsiElement element3, boolean lookRight) {
        PsiElement movableElement;
        if (element3 == null) {
            KotlinExpressionMover.$$$reportNull$$$0(28);
        }
        if ((movableElement = PsiUtilsKt.getParentOfTypesAndPredicate(element3, false, MOVABLE_ELEMENT_CLASSES, MOVABLE_ELEMENT_CONSTRAINT)) == null) {
            return null;
        }
        if (KotlinExpressionMover.isBracelessBlock(movableElement)) {
            movableElement = KotlinExpressionMover.firstNonWhiteElement((PsiElement)(lookRight ? movableElement.getLastChild() : movableElement.getFirstChild()), (!lookRight ? 1 : 0) != 0);
        }
        return movableElement;
    }

    private static boolean isLastOfItsKind(@NotNull PsiElement element3, boolean down) {
        if (element3 == null) {
            KotlinExpressionMover.$$$reportNull$$$0(29);
        }
        return KotlinExpressionMover.getSiblingOfType(element3, down, element3.getClass()) == null;
    }

    private static boolean isForbiddenMove(@NotNull PsiElement element3, boolean down) {
        if (element3 == null) {
            KotlinExpressionMover.$$$reportNull$$$0(30);
        }
        if (element3 instanceof KtParameter || element3 instanceof KtValueArgument) {
            return KotlinExpressionMover.isLastOfItsKind(element3, down);
        }
        return false;
    }

    private static boolean isBracelessBlock(@NotNull PsiElement element3) {
        if (element3 == null) {
            KotlinExpressionMover.$$$reportNull$$$0(31);
        }
        if (!(element3 instanceof KtBlockExpression)) {
            return false;
        }
        KtBlockExpression block = (KtBlockExpression)element3;
        return block.getLBrace() == null && block.getRBrace() == null;
    }

    private static PsiElement adjustSibling(@NotNull Editor editor, @NotNull LineRange sourceRange, @NotNull StatementUpDownMover.MoveInfo info, boolean down) {
        PsiElement parent2;
        PsiElement sibling;
        if (editor == null) {
            KotlinExpressionMover.$$$reportNull$$$0(32);
        }
        if (sourceRange == null) {
            KotlinExpressionMover.$$$reportNull$$$0(33);
        }
        if (info == null) {
            KotlinExpressionMover.$$$reportNull$$$0(34);
        }
        PsiElement element3 = down ? sourceRange.lastElement : sourceRange.firstElement;
        PsiElement whiteSpaceTestSubject = sibling = down ? element3.getNextSibling() : element3.getPrevSibling();
        if (sibling == null && (parent2 = element3.getParent()) != null && KotlinExpressionMover.isBracelessBlock(parent2)) {
            PsiElement psiElement2 = whiteSpaceTestSubject = down ? parent2.getNextSibling() : parent2.getPrevSibling();
        }
        if (whiteSpaceTestSubject instanceof PsiWhiteSpace) {
            if (KotlinRefactoringUtilKt.isMultiLine(whiteSpaceTestSubject)) {
                int nearLine = down ? sourceRange.endLine : sourceRange.startLine - 1;
                info.toMove = sourceRange;
                info.toMove2 = new LineRange(nearLine, nearLine + 1);
                info.indentTarget = false;
                return null;
            }
            if (sibling != null) {
                sibling = KotlinExpressionMover.firstNonWhiteElement((PsiElement)sibling, (boolean)down);
            }
        }
        if (sibling == null) {
            KtBlockExpression dslBlock;
            KtCallExpression callExpression2 = (KtCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element3, KtCallExpression.class);
            if (callExpression2 != null && PsiTreeUtil.isAncestor((PsiElement)(dslBlock = KotlinExpressionMover.getDSLLambdaBlock(editor, (PsiElement)callExpression2, down)), (PsiElement)element3, (boolean)false)) {
                PsiElement blockParent = dslBlock.getParent();
                return down ? KtPsiUtil.findChildByType(blockParent, KtTokens.RBRACE) : KtPsiUtil.findChildByType(blockParent, KtTokens.LBRACE);
            }
            info.toMove2 = null;
            return null;
        }
        return sibling;
    }

    @Override
    public boolean checkAvailable(@NotNull Editor editor, @NotNull PsiFile file, @NotNull StatementUpDownMover.MoveInfo info, boolean down) {
        LineRange sourceRange;
        if (editor == null) {
            KotlinExpressionMover.$$$reportNull$$$0(35);
        }
        if (file == null) {
            KotlinExpressionMover.$$$reportNull$$$0(36);
        }
        if (info == null) {
            KotlinExpressionMover.$$$reportNull$$$0(37);
        }
        this.parametersOrArgsToMove = null;
        if (!super.checkAvailable(editor, file, info, down)) {
            return false;
        }
        switch (KotlinExpressionMover.checkForMovableClosingBrace(editor, file, info, down)) {
            case NOT_MOVABLE: {
                info.toMove2 = null;
                return true;
            }
            case MOVABLE: {
                return true;
            }
        }
        LineRange oldRange = info.toMove;
        Pair psiRange = KotlinExpressionMover.getElementRange((Editor)editor, (PsiFile)file, (LineRange)oldRange);
        if (psiRange == null) {
            return false;
        }
        PsiElement firstElement = KotlinExpressionMover.getMovableElement((PsiElement)psiRange.getFirst(), false);
        PsiElement lastElement = KotlinExpressionMover.getMovableElement((PsiElement)psiRange.getSecond(), true);
        if (firstElement == null || lastElement == null) {
            return false;
        }
        if (KotlinExpressionMover.isForbiddenMove(firstElement, down) || KotlinExpressionMover.isForbiddenMove(lastElement, down)) {
            info.toMove2 = null;
            return true;
        }
        if ((firstElement instanceof KtParameter || firstElement instanceof KtValueArgument) && PsiTreeUtil.isAncestor((PsiElement)lastElement, (PsiElement)firstElement, (boolean)false)) {
            lastElement = firstElement;
        }
        if ((sourceRange = this.getSourceRange(firstElement, lastElement, editor, oldRange)) == null) {
            return false;
        }
        PsiElement sibling = KotlinExpressionMover.getLastNonWhiteSiblingInLine(KotlinExpressionMover.adjustSibling(editor, sourceRange, info, down), editor, down);
        if (sibling == null) {
            return true;
        }
        info.toMove = sourceRange;
        info.toMove2 = this.getTargetRange(editor, sourceRange.firstElement, sibling, down);
        return true;
    }

    private static PsiElement getComma(@NotNull PsiElement element3) {
        PsiElement sibling;
        if (element3 == null) {
            KotlinExpressionMover.$$$reportNull$$$0(38);
        }
        return (sibling = KotlinExpressionMover.firstNonWhiteSibling(element3, true)) != null && sibling.getNode().getElementType() == KtTokens.COMMA ? sibling : null;
    }

    private static void fixCommaIfNeeded(@NotNull PsiElement element3, boolean willBeLast) {
        if (element3 == null) {
            KotlinExpressionMover.$$$reportNull$$$0(39);
        }
        PsiElement comma = KotlinExpressionMover.getComma(element3);
        if (willBeLast && comma != null) {
            comma.delete();
        } else if (!willBeLast && comma == null) {
            PsiElement parent2 = element3.getParent();
            assert (parent2 != null);
            parent2.addAfter(KtPsiFactoryKt.KtPsiFactory(parent2.getProject()).createComma(), element3);
        }
    }

    public void beforeMove(@NotNull Editor editor, @NotNull StatementUpDownMover.MoveInfo info, boolean down) {
        if (editor == null) {
            KotlinExpressionMover.$$$reportNull$$$0(40);
        }
        if (info == null) {
            KotlinExpressionMover.$$$reportNull$$$0(41);
        }
        if (this.parametersOrArgsToMove != null) {
            PsiElement element12 = (PsiElement)this.parametersOrArgsToMove.first;
            PsiElement element22 = (PsiElement)this.parametersOrArgsToMove.second;
            KotlinExpressionMover.fixCommaIfNeeded(element12, down && KotlinExpressionMover.isLastOfItsKind(element22, true));
            KotlinExpressionMover.fixCommaIfNeeded(element22, !down && KotlinExpressionMover.isLastOfItsKind(element12, true));
            PsiDocumentManager.getInstance((Project)editor.getProject()).doPostponedOperationsAndUnblockDocument(editor.getDocument());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 9: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 22: 
            case 26: 
            case 32: 
            case 35: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closingBrace";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 5: 
            case 8: 
            case 11: 
            case 34: 
            case 37: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 14: 
            case 24: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 38: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 16: 
            case 18: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sibling";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToCheck";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldRange";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceRange";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/idea/codeInsight/upDownMover/KotlinExpressionMover";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getStandaloneClosingBrace";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "checkForMovableDownClosingBrace";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "checkForMovableUpClosingBrace";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "checkForMovableClosingBrace";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "findClosestBlock";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "getDSLLambdaBlock";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "getExpressionTargetRange";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "getWhenEntryTargetRange";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "getValueParamOrArgTargetRange";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[2] = "getTargetRange";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[2] = "checkSourceElement";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[2] = "getElementSourceLineRange";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[2] = "getMovableElement";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[2] = "isLastOfItsKind";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[2] = "isForbiddenMove";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[2] = "isBracelessBlock";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[2] = "adjustSibling";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[2] = "checkAvailable";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[2] = "getComma";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[2] = "fixCommaIfNeeded";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeMove";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static enum BraceStatus {
        NOT_FOUND,
        MOVABLE,
        NOT_MOVABLE;

    }
}

