/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.completion;

import com.intellij.codeInsight.completion.AllClassesGetter;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiModifierList;
import com.intellij.util.Consumer;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptorWithTypeParameters;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.idea.completion.CompletionUtilsKt;
import org.jetbrains.kotlin.idea.core.ImportableFqNameClassifierKt;
import org.jetbrains.kotlin.idea.core.KotlinIndicesHelper;
import org.jetbrains.kotlin.idea.project.TargetPlatformDetector;
import org.jetbrains.kotlin.idea.refactoring.fqName.FqNameUtilKt;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacade;
import org.jetbrains.kotlin.load.java.JvmAnnotationNames;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.jvm.platform.JvmPlatform;
import org.jetbrains.kotlin.resolve.scopes.DescriptorKindFilter;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.resolve.scopes.MemberScopeKt;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001BI\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b\u0012\u0006\u0010\u000e\u001a\u00020\r\u0012\u0006\u0010\u000f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u0010J\u001c\u0010\u0011\u001a\u00020\u00122\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00120\u000bH\u0002J.\u0010\u0015\u001a\u00020\u00122\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00120\u000b2\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00120\u000bJ$\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u001b2\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u00120\u000bH\u0002J\u0010\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u0014H\u0002J\f\u0010\u001f\u001a\u00020\r*\u00020\u0014H\u0002R\u000e\u0010\u000f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/idea/completion/AllClassesCompletion;", "", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "kotlinIndicesHelper", "Lorg/jetbrains/kotlin/idea/core/KotlinIndicesHelper;", "prefixMatcher", "Lcom/intellij/codeInsight/completion/PrefixMatcher;", "resolutionFacade", "Lorg/jetbrains/kotlin/idea/resolve/ResolutionFacade;", "kindFilter", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/descriptors/ClassKind;", "", "includeTypeAliases", "includeJavaClassesNotToBeUsed", "(Lcom/intellij/codeInsight/completion/CompletionParameters;Lorg/jetbrains/kotlin/idea/core/KotlinIndicesHelper;Lcom/intellij/codeInsight/completion/PrefixMatcher;Lorg/jetbrains/kotlin/idea/resolve/ResolutionFacade;Lkotlin/jvm/functions/Function1;ZZ)V", "addAdaptedJavaCompletion", "", "collector", "Lcom/intellij/psi/PsiClass;", "collect", "classifierDescriptorCollector", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptorWithTypeParameters;", "javaClassCollector", "collectClassesFromScope", "scope", "Lorg/jetbrains/kotlin/resolve/scopes/MemberScope;", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "isNotToBeUsed", "javaClass", "isSyntheticKotlinClass", "idea"})
public final class AllClassesCompletion {
    private final CompletionParameters parameters;
    private final KotlinIndicesHelper kotlinIndicesHelper;
    private final PrefixMatcher prefixMatcher;
    private final ResolutionFacade resolutionFacade;
    private final Function1<ClassKind, Boolean> kindFilter;
    private final boolean includeTypeAliases;
    private final boolean includeJavaClassesNotToBeUsed;

    public final void collect(@NotNull Function1<? super ClassifierDescriptorWithTypeParameters, Unit> classifierDescriptorCollector2, @NotNull Function1<? super PsiClass, Unit> javaClassCollector2) {
        ClassifierDescriptorWithTypeParameters it;
        Intrinsics.checkParameterIsNotNull(classifierDescriptorCollector2, (String)"classifierDescriptorCollector");
        Intrinsics.checkParameterIsNotNull(javaClassCollector2, (String)"javaClassCollector");
        for (PackageFragmentDescriptor builtinPackage : this.resolutionFacade.getModuleDescriptor().getBuiltIns().getBuiltInsPackageFragmentsImportedByDefault()) {
            this.collectClassesFromScope(builtinPackage.getMemberScope(), (Function1<? super ClassDescriptor, Unit>)((Function1)new Function1<ClassDescriptor, Unit>(classifierDescriptorCollector2){
                final /* synthetic */ Function1 $classifierDescriptorCollector;

                public final void invoke(@NotNull ClassDescriptor it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    if (it.getContainingDeclaration() instanceof ClassDescriptor) {
                        this.$classifierDescriptorCollector.invoke((Object)it);
                    }
                }
                {
                    this.$classifierDescriptorCollector = function1;
                    super(1);
                }
            }));
        }
        Iterable $receiver$iv = KotlinIndicesHelper.getKotlinClasses$default(this.kotlinIndicesHelper, (Function1)new Function1<String, Boolean>(this){
            final /* synthetic */ AllClassesCompletion this$0;

            public final boolean invoke(@NotNull String it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return AllClassesCompletion.access$getPrefixMatcher$p(this.this$0).prefixMatches(it);
            }
            {
                this.this$0 = allClassesCompletion;
                super(1);
            }
        }, null, this.kindFilter, 2, null);
        for (PackageFragmentDescriptor element$iv : $receiver$iv) {
            it = (ClassDescriptor)((Object)element$iv);
            classifierDescriptorCollector2.invoke((Object)it);
        }
        if (this.includeTypeAliases) {
            $receiver$iv = this.kotlinIndicesHelper.getTopLevelTypeAliases(CompletionUtilsKt.asStringNameFilter(this.prefixMatcher));
            for (PackageFragmentDescriptor element$iv : $receiver$iv) {
                it = (TypeAliasDescriptor)((Object)element$iv);
                classifierDescriptorCollector2.invoke((Object)it);
            }
        }
        PsiFile psiFile = this.parameters.getOriginalFile();
        if (psiFile == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
        }
        if (Intrinsics.areEqual((Object)TargetPlatformDetector.getPlatform((KtFile)psiFile), (Object)JvmPlatform.INSTANCE)) {
            this.addAdaptedJavaCompletion(javaClassCollector2);
        }
    }

    private final void collectClassesFromScope(MemberScope scope2, Function1<? super ClassDescriptor, Unit> collector2) {
        for (DeclarationDescriptor descriptor2 : MemberScopeKt.getDescriptorsFiltered$default(scope2, DescriptorKindFilter.CLASSIFIERS, null, 2, null)) {
            if (!(descriptor2 instanceof ClassDescriptor)) continue;
            ClassKind classKind = ((ClassDescriptor)descriptor2).getKind();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)classKind), (String)"descriptor.kind");
            if (((Boolean)this.kindFilter.invoke((Object)classKind)).booleanValue() && this.prefixMatcher.prefixMatches(((ClassDescriptor)descriptor2).getName().asString())) {
                collector2.invoke((Object)descriptor2);
            }
            MemberScope memberScope2 = ((ClassDescriptor)descriptor2).getUnsubstitutedInnerClassesScope();
            Intrinsics.checkExpressionValueIsNotNull((Object)memberScope2, (String)"descriptor.unsubstitutedInnerClassesScope");
            this.collectClassesFromScope(memberScope2, collector2);
        }
    }

    private final void addAdaptedJavaCompletion(Function1<? super PsiClass, Unit> collector2) {
        AllClassesGetter.processJavaClasses((CompletionParameters)this.parameters, (PrefixMatcher)this.prefixMatcher, (boolean)true, (Consumer)((Consumer)new Consumer<PsiClass>(this, collector2){
            final /* synthetic */ AllClassesCompletion this$0;
            final /* synthetic */ Function1 $collector;

            public final void consume(PsiClass psiClass2) {
                PsiClass psiClass3 = psiClass2;
                if (psiClass3 == null) {
                    Intrinsics.throwNpe();
                }
                if (!(psiClass3 instanceof KtLightClass)) {
                    ClassKind kind;
                    if (AllClassesCompletion.access$isSyntheticKotlinClass(this.this$0, psiClass2)) {
                        return;
                    }
                    ClassKind classKind = psiClass2.isAnnotationType() ? ClassKind.ANNOTATION_CLASS : (psiClass2.isInterface() ? ClassKind.INTERFACE : (kind = psiClass2.isEnum() ? ClassKind.ENUM_CLASS : ClassKind.CLASS));
                    if (((Boolean)AllClassesCompletion.access$getKindFilter$p(this.this$0).invoke((Object)((Object)kind))).booleanValue() && !AllClassesCompletion.access$isNotToBeUsed(this.this$0, psiClass2)) {
                        this.$collector.invoke((Object)psiClass2);
                    }
                }
            }
            {
                this.this$0 = allClassesCompletion;
                this.$collector = function1;
            }
        }));
    }

    private final boolean isSyntheticKotlinClass(@NotNull PsiClass $receiver) {
        PsiAnnotation metadata;
        String string = $receiver.getName();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name!!");
        if (!StringsKt.contains$default((CharSequence)string, (char)'$', (boolean)false, (int)2, null)) {
            return false;
        }
        PsiModifierList psiModifierList = $receiver.getModifierList();
        PsiAnnotation psiAnnotation = metadata = psiModifierList != null ? psiModifierList.findAnnotation(JvmAnnotationNames.METADATA_FQ_NAME.asString()) : null;
        Object object = psiAnnotation != null ? psiAnnotation.findAttributeValue("k") : null;
        if (!(object instanceof PsiLiteral)) {
            object = null;
        }
        PsiLiteral psiLiteral = (PsiLiteral)object;
        return Intrinsics.areEqual((Object)(psiLiteral != null ? psiLiteral.getValue() : null), (Object)KotlinClassHeader.Kind.SYNTHETIC_CLASS.getId());
    }

    private final boolean isNotToBeUsed(PsiClass javaClass) {
        if (this.includeJavaClassesNotToBeUsed) {
            return false;
        }
        FqName fqName2 = FqNameUtilKt.getKotlinFqName((PsiElement)javaClass);
        return fqName2 != null && ImportableFqNameClassifierKt.isJavaClassNotToBeUsedInKotlin(fqName2);
    }

    public AllClassesCompletion(@NotNull CompletionParameters parameters2, @NotNull KotlinIndicesHelper kotlinIndicesHelper, @NotNull PrefixMatcher prefixMatcher, @NotNull ResolutionFacade resolutionFacade, @NotNull Function1<? super ClassKind, Boolean> kindFilter, boolean includeTypeAliases, boolean includeJavaClassesNotToBeUsed) {
        Intrinsics.checkParameterIsNotNull((Object)parameters2, (String)"parameters");
        Intrinsics.checkParameterIsNotNull((Object)kotlinIndicesHelper, (String)"kotlinIndicesHelper");
        Intrinsics.checkParameterIsNotNull((Object)prefixMatcher, (String)"prefixMatcher");
        Intrinsics.checkParameterIsNotNull((Object)resolutionFacade, (String)"resolutionFacade");
        Intrinsics.checkParameterIsNotNull(kindFilter, (String)"kindFilter");
        this.parameters = parameters2;
        this.kotlinIndicesHelper = kotlinIndicesHelper;
        this.prefixMatcher = prefixMatcher;
        this.resolutionFacade = resolutionFacade;
        this.kindFilter = kindFilter;
        this.includeTypeAliases = includeTypeAliases;
        this.includeJavaClassesNotToBeUsed = includeJavaClassesNotToBeUsed;
    }

    @NotNull
    public static final /* synthetic */ PrefixMatcher access$getPrefixMatcher$p(AllClassesCompletion $this) {
        return $this.prefixMatcher;
    }

    public static final /* synthetic */ boolean access$isSyntheticKotlinClass(AllClassesCompletion $this, @NotNull PsiClass $receiver) {
        return $this.isSyntheticKotlinClass($receiver);
    }

    public static final /* synthetic */ boolean access$isNotToBeUsed(AllClassesCompletion $this, @NotNull PsiClass javaClass) {
        return $this.isNotToBeUsed(javaClass);
    }

    @NotNull
    public static final /* synthetic */ Function1 access$getKindFilter$p(AllClassesCompletion $this) {
        return $this.kindFilter;
    }
}

