/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.completion;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.filters.ClassFilter;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.NotFilter;
import com.intellij.psi.filters.OrFilter;
import com.intellij.psi.filters.TextFilter;
import com.intellij.psi.filters.position.LeftNeighbour;
import com.intellij.psi.filters.position.PositionElementFilter;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.config.LanguageVersionSettingsImpl;
import org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import org.jetbrains.kotlin.idea.completion.KeywordCompletion;
import org.jetbrains.kotlin.idea.completion.KeywordCompletion$WhenMappings;
import org.jetbrains.kotlin.idea.completion.KeywordLookupObject;
import org.jetbrains.kotlin.idea.completion.handlers.HandlerUtilsKt;
import org.jetbrains.kotlin.idea.completion.handlers.WithTailInsertHandler;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.lexer.KtKeywordToken;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCatchClause;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithInitializer;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtLiteralStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtTryExpression;
import org.jetbrains.kotlin.psi.KtTypeCodeFragment;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.ModifierCheckerCore;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0005>?@ABB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001c\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J$\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J,\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J.\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0013\u001a\u00020\r2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J&\u0010\u001f\u001a\u00020 2\n\u0010!\u001a\u00060\"j\u0002`#2\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010$\u001a\u0004\u0018\u00010\u001aH\u0002J2\u0010%\u001a\u00020 2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010&\u001a\u00020\r2\u0006\u0010'\u001a\u00020\u00182\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020 0\u0017J\u001e\u0010*\u001a\b\u0012\u0004\u0012\u00020\r0\u00102\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010+\u001a\u00020\u0005H\u0002J\u0010\u0010,\u001a\u00020\u00182\u0006\u0010-\u001a\u00020\u001aH\u0002J \u0010.\u001a\u00020\u00182\u0006\u0010+\u001a\u00020\u00052\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u000202H\u0002J\u0018\u00103\u001a\u00020\u00182\u0006\u0010+\u001a\u00020\u00052\u0006\u00101\u001a\u000202H\u0002J \u00104\u001a\u00020\u00182\u0006\u0010+\u001a\u00020\u00052\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u000202H\u0002J\u0018\u00105\u001a\u00020 *\u00060\"j\u0002`#2\u0006\u00106\u001a\u00020\u001aH\u0002J\u0014\u00107\u001a\u000208*\u00020\u001a2\u0006\u00109\u001a\u00020\u001aH\u0002J\u0012\u0010:\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0010*\u00020\u001aH\u0002J\u0014\u0010;\u001a\u00020\u0018*\u00020<2\u0006\u0010=\u001a\u00020\u0005H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\r0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lorg/jetbrains/kotlin/idea/completion/KeywordCompletion;", "", "()V", "ALL_KEYWORDS", "", "Lorg/jetbrains/kotlin/lexer/KtKeywordToken;", "COMPOUND_KEYWORDS", "", "GENERAL_FILTER", "Lcom/intellij/psi/filters/NotFilter;", "KEYWORDS_TO_IGNORE_PREFIX", "Lcom/intellij/psi/tree/TokenSet;", "KEYWORD_CONSTRUCTS", "", "NO_SPACE_AFTER", "buildFilesWithKeywordApplication", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/kotlin/psi/KtFile;", "keywordTokenType", "prefixText", "psiFactory", "Lorg/jetbrains/kotlin/psi/KtPsiFactory;", "buildFilter", "Lkotlin/Function1;", "", "position", "Lcom/intellij/psi/PsiElement;", "buildFilterByText", "buildFilterWithContext", "contextElement", "buildFilterWithReducedContext", "buildReducedContextBefore", "", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "scope", "complete", "prefix", "isJvmModule", "consumer", "Lcom/intellij/codeInsight/lookup/LookupElement;", "computeKeywordApplications", "keyword", "isErrorElementBefore", "token", "isModifierParentSupportedAtLanguageLevel", "target", "Lorg/jetbrains/kotlin/descriptors/annotations/KotlinTarget;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "isModifierSupportedAtLanguageLevel", "isModifierTargetSupportedAtLanguageLevel", "appendReducedText", "element", "getStartOffsetInAncestor", "", "ancestor", "goUpWhileIsLastChild", "matchesKeyword", "Lcom/intellij/psi/tree/IElementType;", "keywordType", "CommentFilter", "FileFilter", "ParentFilter", "SpaceAfterInsertHandler", "UseSiteAnnotationTargetInsertHandler", "idea"})
public final class KeywordCompletion {
    private static final List<KtKeywordToken> ALL_KEYWORDS;
    private static final TokenSet KEYWORDS_TO_IGNORE_PREFIX;
    private static final Map<KtKeywordToken, KtKeywordToken> COMPOUND_KEYWORDS;
    private static final Map<KtKeywordToken, String> KEYWORD_CONSTRUCTS;
    private static final List<String> NO_SPACE_AFTER;
    private static final NotFilter GENERAL_FILTER;
    public static final KeywordCompletion INSTANCE;

    public final void complete(@NotNull PsiElement position, @NotNull String prefix, boolean isJvmModule, @NotNull Function1<? super LookupElement, Unit> consumer2) {
        Intrinsics.checkParameterIsNotNull((Object)position, (String)"position");
        Intrinsics.checkParameterIsNotNull((Object)prefix, (String)"prefix");
        Intrinsics.checkParameterIsNotNull(consumer2, (String)"consumer");
        if (!GENERAL_FILTER.isAcceptable((Object)position, position)) {
            return;
        }
        Function1<KtKeywordToken, Boolean> parserFilter = this.buildFilter(position);
        for (KtKeywordToken keywordToken : ALL_KEYWORDS) {
            LookupElementBuilder element3;
            String keyword = keywordToken.getValue();
            KtKeywordToken nextKeyword = COMPOUND_KEYWORDS.get((Object)keywordToken);
            boolean applicableAsCompound = false;
            if (nextKeyword != null) {
                String next2;
                complete.1 isSpace$ = complete.1.INSTANCE;
                PsiElement psiElement2 = PsiUtilsKt.nextLeaf(position, (Function1<? super PsiElement, Boolean>)((Function1)complete.next.1.INSTANCE));
                String string = next2 = psiElement2 != null ? psiElement2.getText() : null;
                if (next2 != null && StringsKt.startsWith$default((String)next2, (String)"$", (boolean)false, (int)2, null)) {
                    String string2 = next2;
                    int n = 1;
                    String string3 = string2.substring(n);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
                    next2 = string3;
                }
                if (Intrinsics.areEqual((Object)next2, (Object)nextKeyword.getValue()) ^ true) {
                    keyword = keyword + " " + nextKeyword.getValue();
                } else {
                    applicableAsCompound = true;
                }
            }
            if (Intrinsics.areEqual((Object)((Object)keywordToken), (Object)((Object)KtTokens.DYNAMIC_KEYWORD)) && isJvmModule) continue;
            String string = keyword;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"keyword");
            if (!StringsKt.startsWith$default((String)string, (String)prefix, (boolean)false, (int)2, null) && !KEYWORDS_TO_IGNORE_PREFIX.contains((IElementType)keywordToken) || !((Boolean)parserFilter.invoke((Object)keywordToken)).booleanValue()) continue;
            String constructText = KEYWORD_CONSTRUCTS.get((Object)keywordToken);
            if (constructText != null && !applicableAsCompound) {
                Project project = position.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"position.project");
                element3 = HandlerUtilsKt.createKeywordConstructLookupElement$default(project, keyword, constructText, false, 8, null);
                consumer2.invoke((Object)element3);
                continue;
            }
            element3 = LookupElementBuilder.create((Object)new KeywordLookupObject(), (String)keyword).bold();
            PsiElement psiElement3 = PsiUtilsKt.prevLeaf$default(position, false, 1, null);
            boolean isUseSiteAnnotationTarget = Intrinsics.areEqual((Object)(psiElement3 != null && (psiElement3 = psiElement3.getNode()) != null ? psiElement3.getElementType() : null), (Object)((Object)KtTokens.AT));
            InsertHandler insertHandler = isUseSiteAnnotationTarget ? (InsertHandler)UseSiteAnnotationTargetInsertHandler.INSTANCE : (NO_SPACE_AFTER.contains(keyword) ? null : (InsertHandler)SpaceAfterInsertHandler.INSTANCE);
            element3 = element3.withInsertHandler(insertHandler);
            if (isUseSiteAnnotationTarget) {
                element3 = element3.withPresentableText(keyword + ":");
            }
            LookupElementBuilder lookupElementBuilder = element3;
            Intrinsics.checkExpressionValueIsNotNull((Object)lookupElementBuilder, (String)"element");
            consumer2.invoke((Object)lookupElementBuilder);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Function1<KtKeywordToken, Boolean> buildFilter(PsiElement position) {
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = position;
        for (PsiElement parent2 = position.getParent(); parent2 != null; parent2 = parent2.getParent()) {
            void prevParent;
            PsiElement psiElement2 = parent2;
            if (psiElement2 instanceof KtBlockExpression) {
                Object v5;
                String prefixText;
                block26: {
                    void $receiver$iv;
                    prefixText = "fun foo() { ";
                    if ((PsiElement)prevParent.element instanceof KtExpression) {
                        PsiElement prevLeaf2 = PsiUtilsKt.prevLeaf((PsiElement)prevParent.element, (Function1<? super PsiElement, Boolean>)((Function1)buildFilter.prevLeaf.1.INSTANCE));
                        if (prevLeaf2 != null) {
                            boolean bl;
                            block25: {
                                Sequence<PsiElement> $receiver$iv2 = this.goUpWhileIsLastChild(prevLeaf2);
                                for (Object element$iv : $receiver$iv2) {
                                    PsiElement it = (PsiElement)element$iv;
                                    ASTNode aSTNode = it.getNode();
                                    Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"it.node");
                                    if (!Intrinsics.areEqual((Object)aSTNode.getElementType(), (Object)((Object)KtNodeTypes.THEN))) continue;
                                    bl = true;
                                    break block25;
                                }
                                bl = false;
                            }
                            boolean isAfterThen = bl;
                            boolean isAfterTry = false;
                            boolean isAfterCatch = false;
                            ASTNode aSTNode = prevLeaf2.getNode();
                            Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"prevLeaf.node");
                            if (Intrinsics.areEqual((Object)aSTNode.getElementType(), (Object)((Object)KtTokens.RBRACE))) {
                                PsiElement psiElement3 = prevLeaf2.getParent();
                                if (!(psiElement3 instanceof KtBlockExpression)) {
                                    psiElement3 = null;
                                }
                                KtBlockExpression ktBlockExpression = (KtBlockExpression)psiElement3;
                                Object blockParent = ktBlockExpression != null ? ktBlockExpression.getParent() : null;
                                PsiElement psiElement4 = blockParent;
                                if (psiElement4 instanceof KtTryExpression) {
                                    isAfterTry = true;
                                } else if (psiElement4 instanceof KtCatchClause) {
                                    isAfterTry = true;
                                    isAfterCatch = true;
                                }
                            }
                            if (isAfterThen) {
                                prefixText = isAfterTry ? prefixText + "if (a)\n" : prefixText + "if (a) {}\n";
                            }
                            if (isAfterTry) {
                                prefixText = prefixText + "try {}\n";
                            }
                            if (isAfterCatch) {
                                prefixText = prefixText + "catch (e: E) {}\n";
                            }
                        }
                        return this.buildFilterWithContext(prefixText, (PsiElement)prevParent.element, position);
                    }
                    Sequence<PsiElement> isAfterThen = PsiUtilsKt.siblings((PsiElement)prevParent.element, false, false);
                    for (Object element$iv : $receiver$iv) {
                        if (!(element$iv instanceof KtExpression)) continue;
                        v5 = element$iv;
                        break block26;
                    }
                    v5 = null;
                }
                KtExpression lastExpression = v5;
                if (lastExpression != null) {
                    String contextAfterExpression2 = SequencesKt.joinToString$default((Sequence)SequencesKt.takeWhile(PsiUtilsKt.siblings((PsiElement)lastExpression, true, false), (Function1)((Function1)new Function1<PsiElement, Boolean>((Ref.ObjectRef)prevParent){
                        final /* synthetic */ Ref.ObjectRef $prevParent;

                        public final boolean invoke(@NotNull PsiElement it) {
                            Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                            return Intrinsics.areEqual((Object)it, (Object)((PsiElement)this.$prevParent.element)) ^ true;
                        }
                        {
                            this.$prevParent = objectRef;
                            super(1);
                        }
                    })), null, null, null, (int)0, null, (Function1)buildFilter.contextAfterExpression.2.INSTANCE, (int)31, null);
                    return this.buildFilterWithContext(prefixText + "x" + contextAfterExpression2, (PsiElement)prevParent.element, position);
                }
            } else if (psiElement2 instanceof KtDeclarationWithInitializer) {
                KtExpression initializer2 = ((KtDeclarationWithInitializer)parent2).getInitializer();
                if (Intrinsics.areEqual((Object)((PsiElement)prevParent.element), (Object)initializer2)) {
                    return this.buildFilterWithContext("val v = ", (PsiElement)initializer2, position);
                }
            } else if (psiElement2 instanceof KtParameter) {
                KtExpression ktExpression = ((KtParameter)parent2).getDefaultValue();
                if (Intrinsics.areEqual((Object)((PsiElement)prevParent.element), (Object)ktExpression)) {
                    return this.buildFilterWithContext("val v = ", (PsiElement)ktExpression, position);
                }
            } else if (psiElement2 instanceof KtDeclaration) {
                PsiElement scope2 = ((KtDeclaration)parent2).getParent();
                PsiElement psiElement5 = scope2;
                if (psiElement5 instanceof KtClassOrObject) {
                    return parent2 instanceof KtPrimaryConstructor ? this.buildFilterWithReducedContext("class X ", parent2, position) : this.buildFilterWithReducedContext("class X { ", parent2, position);
                }
                if (psiElement5 instanceof KtFile) {
                    return this.buildFilterWithReducedContext("", parent2, position);
                }
            }
            prevParent.element = parent2;
        }
        return this.buildFilterWithReducedContext("", null, position);
    }

    private final Sequence<String> computeKeywordApplications(String prefixText, KtKeywordToken keyword) {
        KtKeywordToken ktKeywordToken = keyword;
        return Intrinsics.areEqual((Object)((Object)ktKeywordToken), (Object)((Object)KtTokens.SUSPEND_KEYWORD)) ? SequencesKt.sequenceOf((Object[])new String[]{"suspend () -> Unit>", "suspend X"}) : (StringsKt.endsWith$default((String)prefixText, (String)"@", (boolean)false, (int)2, null) ? SequencesKt.sequenceOf((Object[])new String[]{keyword.getValue() + ":X Y.Z"}) : SequencesKt.sequenceOf((Object[])new String[]{keyword.getValue() + " X"}));
    }

    private final Function1<KtKeywordToken, Boolean> buildFilterWithContext(String prefixText, PsiElement contextElement, PsiElement position) {
        int offset = this.getStartOffsetInAncestor(position, contextElement);
        String string = contextElement.getText();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        String string2 = string;
        int n = 0;
        String string3 = string2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.substring(n, offset);
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String truncatedContext = string4;
        return this.buildFilterByText(prefixText + truncatedContext, position);
    }

    private final Function1<KtKeywordToken, Boolean> buildFilterWithReducedContext(String prefixText, PsiElement contextElement, PsiElement position) {
        StringBuilder builder = new StringBuilder();
        this.buildReducedContextBefore(builder, position, contextElement);
        return this.buildFilterByText(prefixText + builder.toString(), position);
    }

    private final Sequence<KtFile> buildFilesWithKeywordApplication(KtKeywordToken keywordTokenType, String prefixText, KtPsiFactory psiFactory) {
        return SequencesKt.map(this.computeKeywordApplications(prefixText, keywordTokenType), (Function1)((Function1)new Function1<String, KtFile>(psiFactory, prefixText){
            final /* synthetic */ KtPsiFactory $psiFactory;
            final /* synthetic */ String $prefixText;

            @NotNull
            public final KtFile invoke(@NotNull String application) {
                Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
                return this.$psiFactory.createFile(this.$prefixText + application);
            }
            {
                this.$psiFactory = ktPsiFactory;
                this.$prefixText = string;
                super(1);
            }
        }));
    }

    private final Function1<KtKeywordToken, Boolean> buildFilterByText(String prefixText, PsiElement position) {
        Project project = position.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"position.project");
        KtPsiFactory psiFactory = new KtPsiFactory(project, false, 2, null);
        Function2<KtKeywordToken, KtFile, Boolean> isKeywordCorrectlyApplied$ = new Function2<KtKeywordToken, KtFile, Boolean>(prefixText, position){
            final /* synthetic */ String $prefixText;
            final /* synthetic */ PsiElement $position;

            /*
             * WARNING - void declaration
             */
            public final boolean invoke(@NotNull KtKeywordToken keywordTokenType, @NotNull KtFile file) {
                KotlinTarget kotlinTarget;
                KtDeclaration ownerDeclaration;
                KtDeclaration ktDeclaration;
                Collection collection;
                Set modifierTargets;
                PsiElement container2;
                Intrinsics.checkParameterIsNotNull((Object)((Object)keywordTokenType), (String)"keywordTokenType");
                Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
                PsiElement psiElement2 = file.findElementAt(this.$prefixText.length());
                if (psiElement2 == null) {
                    Intrinsics.throwNpe();
                }
                PsiElement elementAt = psiElement2;
                Object object = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.$position);
                if (object == null || (object = PlatformKt.getLanguageVersionSettings(object)) == null) {
                    object = LanguageVersionSettingsImpl.DEFAULT;
                }
                Object languageVersionSettings = object;
                PsiElement psiElement3 = elementAt;
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement3, (String)"elementAt");
                ASTNode aSTNode = psiElement3.getNode();
                if (aSTNode == null) {
                    Intrinsics.throwNpe();
                }
                IElementType iElementType = aSTNode.getElementType();
                Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"elementAt.node!!.elementType");
                if (!KeywordCompletion.access$matchesKeyword(KeywordCompletion.INSTANCE, iElementType, keywordTokenType)) {
                    return false;
                }
                PsiElement $receiver$iv = elementAt;
                if (PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, PsiErrorElement.class, (boolean)false) != null) {
                    return false;
                }
                if (KeywordCompletion.access$isErrorElementBefore(KeywordCompletion.INSTANCE, elementAt)) {
                    return false;
                }
                if (!KeywordCompletion.access$isModifierSupportedAtLanguageLevel(KeywordCompletion.INSTANCE, keywordTokenType, (LanguageVersionSettings)languageVersionSettings)) {
                    return false;
                }
                if (!(keywordTokenType instanceof KtModifierKeywordToken)) {
                    return true;
                }
                if (!(elementAt.getParent() instanceof KtModifierList)) {
                    return true;
                }
                PsiElement psiElement4 = elementAt.getParent();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement4, (String)"elementAt.parent");
                PsiElement psiElement5 = container2 = psiElement4.getParent();
                List possibleTargets = psiElement5 instanceof KtParameter ? (((KtParameter)container2).getOwnerFunction() instanceof KtPrimaryConstructor ? CollectionsKt.listOf((Object[])new KotlinTarget[]{KotlinTarget.VALUE_PARAMETER, KotlinTarget.MEMBER_PROPERTY}) : CollectionsKt.listOf((Object)((Object)KotlinTarget.VALUE_PARAMETER))) : (psiElement5 instanceof KtTypeParameter ? CollectionsKt.listOf((Object)((Object)KotlinTarget.TYPE_PARAMETER)) : (psiElement5 instanceof KtEnumEntry ? CollectionsKt.listOf((Object)((Object)KotlinTarget.ENUM_ENTRY)) : (psiElement5 instanceof KtClassBody ? CollectionsKt.listOf((Object[])new KotlinTarget[]{KotlinTarget.CLASS_ONLY, KotlinTarget.INTERFACE, KotlinTarget.OBJECT, KotlinTarget.ENUM_CLASS, KotlinTarget.ANNOTATION_CLASS, KotlinTarget.MEMBER_FUNCTION, KotlinTarget.MEMBER_PROPERTY, KotlinTarget.FUNCTION, KotlinTarget.PROPERTY}) : (psiElement5 instanceof KtFile ? CollectionsKt.listOf((Object[])new KotlinTarget[]{KotlinTarget.CLASS_ONLY, KotlinTarget.INTERFACE, KotlinTarget.OBJECT, KotlinTarget.ENUM_CLASS, KotlinTarget.ANNOTATION_CLASS, KotlinTarget.TOP_LEVEL_FUNCTION, KotlinTarget.TOP_LEVEL_PROPERTY, KotlinTarget.FUNCTION, KotlinTarget.PROPERTY}) : CollectionsKt.emptyList()))));
                Set<KotlinTarget> set2 = ModifierCheckerCore.INSTANCE.getPossibleTargetMap().get((Object)((Object)keywordTokenType));
                Set set3 = modifierTargets = set2 != null ? CollectionsKt.intersect((Iterable)set2, (Iterable)possibleTargets) : null;
                if (modifierTargets != null && !(collection = (Collection)possibleTargets).isEmpty()) {
                    boolean bl;
                    block22: {
                        Iterable $receiver$iv2 = modifierTargets;
                        if ($receiver$iv2 instanceof Collection && ((Collection)$receiver$iv2).isEmpty()) {
                            bl = true;
                        } else {
                            for (E element$iv : $receiver$iv2) {
                                KotlinTarget it = (KotlinTarget)((Object)element$iv);
                                if (!KeywordCompletion.access$isModifierTargetSupportedAtLanguageLevel(KeywordCompletion.INSTANCE, keywordTokenType, it, (LanguageVersionSettings)languageVersionSettings)) continue;
                                bl = false;
                                break block22;
                            }
                            bl = true;
                        }
                    }
                    if (bl) {
                        return false;
                    }
                }
                PsiElement psiElement6 = container2;
                if (psiElement6 != null) {
                    void $receiver$iv3;
                    PsiElement psiElement7 = psiElement6;
                    boolean strict$iv = true;
                    ktDeclaration = (KtDeclaration)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv3, KtDeclaration.class, (boolean)strict$iv);
                } else {
                    ktDeclaration = null;
                }
                KtDeclaration ktDeclaration2 = ownerDeclaration = ktDeclaration;
                if (ktDeclaration2 == null) {
                    kotlinTarget = KotlinTarget.FILE;
                } else if (ktDeclaration2 instanceof KtClass) {
                    kotlinTarget = ((KtClass)ownerDeclaration).isInterface() ? KotlinTarget.INTERFACE : (((KtClass)ownerDeclaration).isEnum() ? KotlinTarget.ENUM_CLASS : (((KtClass)ownerDeclaration).isAnnotation() ? KotlinTarget.ANNOTATION_CLASS : KotlinTarget.CLASS_ONLY));
                } else if (ktDeclaration2 instanceof KtObjectDeclaration) {
                    kotlinTarget = ((KtObjectDeclaration)ownerDeclaration).isObjectLiteral() ? KotlinTarget.OBJECT_LITERAL : KotlinTarget.OBJECT;
                } else {
                    return true;
                }
                KotlinTarget parentTarget = kotlinTarget;
                return ModifierCheckerCore.INSTANCE.isPossibleParentTarget((KtModifierKeywordToken)keywordTokenType, parentTarget, (LanguageVersionSettings)languageVersionSettings);
            }
            {
                this.$prefixText = string;
                this.$position = psiElement2;
                super(2);
            }
        };
        return (Function1)new Function1<KtKeywordToken, Boolean>(prefixText, psiFactory, isKeywordCorrectlyApplied$){
            final /* synthetic */ String $prefixText;
            final /* synthetic */ KtPsiFactory $psiFactory;
            final /* synthetic */ buildFilterByText.1 $isKeywordCorrectlyApplied$1;

            public final boolean invoke(@NotNull KtKeywordToken keywordTokenType) {
                boolean bl;
                block1: {
                    Sequence files2;
                    Intrinsics.checkParameterIsNotNull((Object)((Object)keywordTokenType), (String)"keywordTokenType");
                    Sequence $receiver$iv = files2 = KeywordCompletion.access$buildFilesWithKeywordApplication(KeywordCompletion.INSTANCE, keywordTokenType, this.$prefixText, this.$psiFactory);
                    for (E element$iv : $receiver$iv) {
                        KtFile file = (KtFile)element$iv;
                        if (!this.$isKeywordCorrectlyApplied$1.invoke(keywordTokenType, file)) continue;
                        bl = true;
                        break block1;
                    }
                    bl = false;
                }
                return bl;
            }
            {
                this.$prefixText = string;
                this.$psiFactory = ktPsiFactory;
                this.$isKeywordCorrectlyApplied$1 = var3_3;
                super(1);
            }
        };
    }

    private final boolean isErrorElementBefore(PsiElement token) {
        for (PsiElement leaf : PsiUtilsKt.getPrevLeafs(token)) {
            boolean bl;
            block3: {
                if (leaf instanceof PsiWhiteSpace || leaf instanceof PsiComment) continue;
                Sequence<PsiElement> $receiver$iv = PsiUtilsKt.getParentsWithSelf(leaf);
                for (Object element$iv : $receiver$iv) {
                    PsiElement it = (PsiElement)element$iv;
                    if (!(it instanceof PsiErrorElement)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
            if (bl) {
                return true;
            }
            if (leaf.getTextLength() == 0) continue;
            break;
        }
        return false;
    }

    private final boolean matchesKeyword(@NotNull IElementType $receiver, KtKeywordToken keywordType) {
        IElementType iElementType = $receiver;
        return Intrinsics.areEqual((Object)iElementType, (Object)((Object)keywordType)) ? true : (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.NOT_IN)) ? Intrinsics.areEqual((Object)((Object)keywordType), (Object)((Object)KtTokens.IN_KEYWORD)) : (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.NOT_IS)) ? Intrinsics.areEqual((Object)((Object)keywordType), (Object)((Object)KtTokens.IS_KEYWORD)) : false));
    }

    private final boolean isModifierSupportedAtLanguageLevel(KtKeywordToken keyword, LanguageVersionSettings languageVersionSettings) {
        LanguageFeature languageFeature;
        KtKeywordToken ktKeywordToken = keyword;
        if (Intrinsics.areEqual((Object)((Object)ktKeywordToken), (Object)((Object)KtTokens.TYPE_ALIAS_KEYWORD))) {
            languageFeature = LanguageFeature.TypeAliases;
        } else {
            if (Intrinsics.areEqual((Object)((Object)ktKeywordToken), (Object)((Object)KtTokens.HEADER_KEYWORD)) || Intrinsics.areEqual((Object)((Object)ktKeywordToken), (Object)((Object)KtTokens.IMPL_KEYWORD))) {
                return false;
            }
            if (Intrinsics.areEqual((Object)((Object)ktKeywordToken), (Object)((Object)KtTokens.EXPECT_KEYWORD)) || Intrinsics.areEqual((Object)((Object)ktKeywordToken), (Object)((Object)KtTokens.ACTUAL_KEYWORD))) {
                languageFeature = LanguageFeature.MultiPlatformProjects;
            } else if (Intrinsics.areEqual((Object)((Object)ktKeywordToken), (Object)((Object)KtTokens.SUSPEND_KEYWORD))) {
                languageFeature = LanguageFeature.Coroutines;
            } else {
                return true;
            }
        }
        LanguageFeature feature = languageFeature;
        return languageVersionSettings.supportsFeature(feature);
    }

    private final boolean isModifierTargetSupportedAtLanguageLevel(KtKeywordToken keyword, KotlinTarget target, LanguageVersionSettings languageVersionSettings) {
        if (Intrinsics.areEqual((Object)((Object)keyword), (Object)((Object)KtTokens.LATEINIT_KEYWORD))) {
            LanguageFeature languageFeature;
            switch (KeywordCompletion$WhenMappings.$EnumSwitchMapping$0[target.ordinal()]) {
                case 1: {
                    languageFeature = LanguageFeature.LateinitTopLevelProperties;
                    break;
                }
                case 2: {
                    languageFeature = LanguageFeature.LateinitLocalVariables;
                    break;
                }
                default: {
                    return true;
                }
            }
            LanguageFeature feature = languageFeature;
            return languageVersionSettings.supportsFeature(feature);
        }
        return true;
    }

    private final boolean isModifierParentSupportedAtLanguageLevel(KtKeywordToken keyword, KotlinTarget target, LanguageVersionSettings languageVersionSettings) {
        if (Intrinsics.areEqual((Object)((Object)keyword), (Object)((Object)KtTokens.INNER_KEYWORD)) && target == KotlinTarget.ENUM_ENTRY) {
            return languageVersionSettings.supportsFeature(LanguageFeature.InnerClassInEnumEntryClass);
        }
        return true;
    }

    private final void buildReducedContextBefore(StringBuilder builder, PsiElement position, PsiElement scope2) {
        Object v1;
        PsiElement parent2;
        block8: {
            if (Intrinsics.areEqual((Object)position, (Object)scope2)) {
                return;
            }
            PsiElement psiElement2 = position.getParent();
            if (psiElement2 == null) {
                return;
            }
            parent2 = psiElement2;
            this.buildReducedContextBefore(builder, parent2, scope2);
            Sequence<PsiElement> $receiver$iv = PsiUtilsKt.siblings(position, false, false);
            for (Object element$iv : $receiver$iv) {
                PsiElement it = (PsiElement)element$iv;
                if (!(it instanceof KtDeclaration)) continue;
                v1 = element$iv;
                break block8;
            }
            v1 = null;
        }
        PsiElement prevDeclaration = v1;
        PsiElement child = parent2.getFirstChild();
        while (Intrinsics.areEqual((Object)child, (Object)position) ^ true) {
            if (child instanceof KtDeclaration) {
                if (Intrinsics.areEqual((Object)child, (Object)prevDeclaration)) {
                    this.appendReducedText(builder, child);
                }
            } else {
                PsiElement psiElement3 = child;
                if (psiElement3 == null) {
                    Intrinsics.throwNpe();
                }
                builder.append(psiElement3.getText());
            }
            child = child.getNextSibling();
        }
    }

    private final void appendReducedText(@NotNull StringBuilder $receiver, PsiElement element3) {
        PsiElement child = element3.getFirstChild();
        if (child == null) {
            String string = element3.getText();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            $receiver.append(string);
        } else {
            while (child != null) {
                PsiElement psiElement2 = child;
                if (psiElement2 instanceof KtBlockExpression || psiElement2 instanceof KtClassBody) {
                    $receiver.append("{}");
                } else {
                    this.appendReducedText($receiver, child);
                }
                child = child.getNextSibling();
            }
        }
    }

    private final int getStartOffsetInAncestor(@NotNull PsiElement $receiver, PsiElement ancestor) {
        if (Intrinsics.areEqual((Object)ancestor, (Object)$receiver)) {
            return 0;
        }
        PsiElement psiElement2 = $receiver.getParent();
        if (psiElement2 == null) {
            Intrinsics.throwNpe();
        }
        return this.getStartOffsetInAncestor(psiElement2, ancestor) + $receiver.getStartOffsetInParent();
    }

    private final Sequence<PsiElement> goUpWhileIsLastChild(@NotNull PsiElement $receiver) {
        return SequencesKt.generateSequence((Object)$receiver, (Function1)goUpWhileIsLastChild.1.INSTANCE);
    }

    private KeywordCompletion() {
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        Object object;
        Collection collection;
        Object $receiver$iv$iv;
        KeywordCompletion keywordCompletion;
        INSTANCE = keywordCompletion = new KeywordCompletion();
        TokenSet tokenSet = KtTokens.KEYWORDS;
        Intrinsics.checkExpressionValueIsNotNull((Object)tokenSet, (String)"KEYWORDS");
        Object[] objectArray = tokenSet.getTypes();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"KEYWORDS.types");
        TokenSet tokenSet2 = KtTokens.SOFT_KEYWORDS;
        Intrinsics.checkExpressionValueIsNotNull((Object)tokenSet2, (String)"SOFT_KEYWORDS");
        Object[] objectArray2 = tokenSet2.getTypes();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray2, (String)"SOFT_KEYWORDS.types");
        Object $receiver$iv = ArraysKt.plus((Object[])objectArray, (Object[])objectArray2);
        Object[] objectArray3 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(((Object[])$receiver$iv).length);
        for (KtKeywordToken item$iv$iv : $receiver$iv$iv) {
            void it;
            IElementType iElementType = item$iv$iv;
            collection = destination$iv$iv;
            void v4 = it;
            if (v4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.lexer.KtKeywordToken");
            }
            object = (KtKeywordToken)v4;
            collection.add(object);
        }
        ALL_KEYWORDS = (List)destination$iv$iv;
        KEYWORDS_TO_IGNORE_PREFIX = TokenSet.create((IElementType[])new IElementType[]{KtTokens.OVERRIDE_KEYWORD});
        COMPOUND_KEYWORDS = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)((Object)KtTokens.COMPANION_KEYWORD), (Object)((Object)KtTokens.OBJECT_KEYWORD)), TuplesKt.to((Object)((Object)KtTokens.ENUM_KEYWORD), (Object)((Object)KtTokens.CLASS_KEYWORD)), TuplesKt.to((Object)((Object)KtTokens.ANNOTATION_KEYWORD), (Object)((Object)KtTokens.CLASS_KEYWORD)), TuplesKt.to((Object)((Object)KtTokens.SEALED_KEYWORD), (Object)((Object)KtTokens.CLASS_KEYWORD)), TuplesKt.to((Object)((Object)KtTokens.LATEINIT_KEYWORD), (Object)((Object)KtTokens.VAR_KEYWORD))});
        KEYWORD_CONSTRUCTS = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)((Object)KtTokens.IF_KEYWORD), (Object)"fun foo() { if (caret)"), TuplesKt.to((Object)((Object)KtTokens.WHILE_KEYWORD), (Object)"fun foo() { while(caret)"), TuplesKt.to((Object)((Object)KtTokens.FOR_KEYWORD), (Object)"fun foo() { for(caret)"), TuplesKt.to((Object)((Object)KtTokens.TRY_KEYWORD), (Object)"fun foo() { try {\ncaret\n}"), TuplesKt.to((Object)((Object)KtTokens.CATCH_KEYWORD), (Object)"fun foo() { try {} catch (caret)"), TuplesKt.to((Object)((Object)KtTokens.FINALLY_KEYWORD), (Object)"fun foo() { try {\n}\nfinally{\ncaret\n}"), TuplesKt.to((Object)((Object)KtTokens.DO_KEYWORD), (Object)"fun foo() { do {\ncaret\n}"), TuplesKt.to((Object)((Object)KtTokens.INIT_KEYWORD), (Object)"class C { init {\ncaret\n}"), TuplesKt.to((Object)((Object)KtTokens.CONSTRUCTOR_KEYWORD), (Object)"class C { constructor(caret)"), TuplesKt.to((Object)((Object)KtTokens.COMPANION_KEYWORD), (Object)"class C { companion object {\ncaret\n}")});
        $receiver$iv = CollectionsKt.listOf((Object[])new KtKeywordToken[]{KtTokens.THIS_KEYWORD, KtTokens.SUPER_KEYWORD, KtTokens.NULL_KEYWORD, KtTokens.TRUE_KEYWORD, KtTokens.FALSE_KEYWORD, KtTokens.BREAK_KEYWORD, KtTokens.CONTINUE_KEYWORD, KtTokens.ELSE_KEYWORD, KtTokens.WHEN_KEYWORD, KtTokens.FILE_KEYWORD, KtTokens.DYNAMIC_KEYWORD, KtTokens.GET_KEYWORD, KtTokens.SET_KEYWORD});
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        Iterator iterator2 = $receiver$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            KtKeywordToken item$iv$iv;
            Object item$iv$iv2 = iterator2.next();
            item$iv$iv = (KtKeywordToken)((Object)item$iv$iv2);
            collection = destination$iv$iv;
            void v5 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"it");
            object = v5.getValue();
            collection.add(object);
        }
        NO_SPACE_AFTER = CollectionsKt.plus((Collection)((List)var3_3), (Object)"companion object");
        GENERAL_FILTER = new NotFilter((ElementFilter)new OrFilter(new ElementFilter[]{new CommentFilter(), (ElementFilter)new ParentFilter((ElementFilter)new ClassFilter(KtLiteralStringTemplateEntry.class)), (ElementFilter)new ParentFilter((ElementFilter)new ClassFilter(KtConstantExpression.class)), (ElementFilter)new FileFilter((ElementFilter)new ClassFilter(KtTypeCodeFragment.class)), (ElementFilter)new LeftNeighbour((ElementFilter)new TextFilter(".")), (ElementFilter)new LeftNeighbour((ElementFilter)new TextFilter("?."))}));
    }

    public static final /* synthetic */ boolean access$matchesKeyword(KeywordCompletion $this, @NotNull IElementType $receiver, @NotNull KtKeywordToken keywordType) {
        return $this.matchesKeyword($receiver, keywordType);
    }

    public static final /* synthetic */ boolean access$isErrorElementBefore(KeywordCompletion $this, @NotNull PsiElement token) {
        return $this.isErrorElementBefore(token);
    }

    public static final /* synthetic */ boolean access$isModifierSupportedAtLanguageLevel(KeywordCompletion $this, @NotNull KtKeywordToken keyword, @NotNull LanguageVersionSettings languageVersionSettings) {
        return $this.isModifierSupportedAtLanguageLevel(keyword, languageVersionSettings);
    }

    public static final /* synthetic */ boolean access$isModifierTargetSupportedAtLanguageLevel(KeywordCompletion $this, @NotNull KtKeywordToken keyword, @NotNull KotlinTarget target, @NotNull LanguageVersionSettings languageVersionSettings) {
        return $this.isModifierTargetSupportedAtLanguageLevel(keyword, target, languageVersionSettings);
    }

    @NotNull
    public static final /* synthetic */ Sequence access$buildFilesWithKeywordApplication(KeywordCompletion $this, @NotNull KtKeywordToken keywordTokenType, @NotNull String prefixText, @NotNull KtPsiFactory psiFactory) {
        return $this.buildFilesWithKeywordApplication(keywordTokenType, prefixText, psiFactory);
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/completion/KeywordCompletion$UseSiteAnnotationTargetInsertHandler;", "Lcom/intellij/codeInsight/completion/InsertHandler;", "Lcom/intellij/codeInsight/lookup/LookupElement;", "()V", "handleInsert", "", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "item", "idea"})
    private static final class UseSiteAnnotationTargetInsertHandler
    implements InsertHandler<LookupElement> {
        public static final UseSiteAnnotationTargetInsertHandler INSTANCE;

        public void handleInsert(@NotNull InsertionContext context2, @NotNull LookupElement item) {
            Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
            new WithTailInsertHandler(":", false, false, false, 8, null).postHandleInsert(context2, item);
        }

        private UseSiteAnnotationTargetInsertHandler() {
        }

        static {
            UseSiteAnnotationTargetInsertHandler useSiteAnnotationTargetInsertHandler;
            INSTANCE = useSiteAnnotationTargetInsertHandler = new UseSiteAnnotationTargetInsertHandler();
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/completion/KeywordCompletion$SpaceAfterInsertHandler;", "Lcom/intellij/codeInsight/completion/InsertHandler;", "Lcom/intellij/codeInsight/lookup/LookupElement;", "()V", "handleInsert", "", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "item", "idea"})
    private static final class SpaceAfterInsertHandler
    implements InsertHandler<LookupElement> {
        public static final SpaceAfterInsertHandler INSTANCE;

        public void handleInsert(@NotNull InsertionContext context2, @NotNull LookupElement item) {
            Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
            WithTailInsertHandler.Companion.getSPACE().postHandleInsert(context2, item);
        }

        private SpaceAfterInsertHandler() {
        }

        static {
            SpaceAfterInsertHandler spaceAfterInsertHandler;
            INSTANCE = spaceAfterInsertHandler = new SpaceAfterInsertHandler();
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u001a\u0010\t\u001a\u00020\u00042\u0010\u0010\n\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00060\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/completion/KeywordCompletion$CommentFilter;", "Lcom/intellij/psi/filters/ElementFilter;", "()V", "isAcceptable", "", "element", "", "context", "Lcom/intellij/psi/PsiElement;", "isClassAcceptable", "hintClass", "Ljava/lang/Class;", "idea"})
    private static final class CommentFilter
    implements ElementFilter {
        public boolean isAcceptable(@Nullable Object element3, @Nullable PsiElement context2) {
            return element3 instanceof PsiElement && KtPsiUtil.isInComment((PsiElement)element3);
        }

        public boolean isClassAcceptable(@NotNull Class<? extends Object> hintClass) {
            Intrinsics.checkParameterIsNotNull(hintClass, (String)"hintClass");
            return true;
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/completion/KeywordCompletion$ParentFilter;", "Lcom/intellij/psi/filters/position/PositionElementFilter;", "filter", "Lcom/intellij/psi/filters/ElementFilter;", "(Lcom/intellij/psi/filters/ElementFilter;)V", "isAcceptable", "", "element", "", "context", "Lcom/intellij/psi/PsiElement;", "idea"})
    private static final class ParentFilter
    extends PositionElementFilter {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean isAcceptable(@Nullable Object element3, @Nullable PsiElement context2) {
            Object object = element3;
            if (!(object instanceof PsiElement)) {
                object = null;
            }
            PsiElement psiElement2 = (PsiElement)object;
            if (psiElement2 == null) return false;
            PsiElement psiElement3 = psiElement2.getParent();
            PsiElement parent2 = psiElement3;
            if (parent2 == null) return false;
            ElementFilter elementFilter = this.getFilter();
            if (elementFilter == null) return true;
            boolean bl = elementFilter.isAcceptable((Object)parent2, context2);
            if (!bl) return false;
            return true;
        }

        public ParentFilter(@NotNull ElementFilter filter2) {
            Intrinsics.checkParameterIsNotNull((Object)filter2, (String)"filter");
            this.setFilter(filter2);
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/completion/KeywordCompletion$FileFilter;", "Lcom/intellij/psi/filters/position/PositionElementFilter;", "filter", "Lcom/intellij/psi/filters/ElementFilter;", "(Lcom/intellij/psi/filters/ElementFilter;)V", "isAcceptable", "", "element", "", "context", "Lcom/intellij/psi/PsiElement;", "idea"})
    private static final class FileFilter
    extends PositionElementFilter {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean isAcceptable(@Nullable Object element3, @Nullable PsiElement context2) {
            Object object = element3;
            if (!(object instanceof PsiElement)) {
                object = null;
            }
            PsiElement psiElement2 = (PsiElement)object;
            if (psiElement2 == null) return false;
            PsiFile psiFile = psiElement2.getContainingFile();
            PsiFile file = psiFile;
            if (file == null) return false;
            ElementFilter elementFilter = this.getFilter();
            if (elementFilter == null) return true;
            boolean bl = elementFilter.isAcceptable((Object)file, context2);
            if (!bl) return false;
            return true;
        }

        public FileFilter(@NotNull ElementFilter filter2) {
            Intrinsics.checkParameterIsNotNull((Object)filter2, (String)"filter");
            this.setFilter(filter2);
        }
    }
}

