/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.completion.handlers;

import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptorWithTypeParameters;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.completion.CompletionUtilsKt;
import org.jetbrains.kotlin.idea.completion.handlers.BaseDeclarationInsertHandler;
import org.jetbrains.kotlin.idea.completion.handlers.HandlerUtilsKt;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.core.completion.DeclarationLookupObject;
import org.jetbrains.kotlin.idea.util.CallTypeAndReceiver;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.renderer.RenderingUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/completion/handlers/KotlinClassifierInsertHandler;", "Lorg/jetbrains/kotlin/idea/completion/handlers/BaseDeclarationInsertHandler;", "()V", "handleInsert", "", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "item", "Lcom/intellij/codeInsight/lookup/LookupElement;", "qualifiedName", "", "lookupObject", "Lorg/jetbrains/kotlin/idea/core/completion/DeclarationLookupObject;", "idea"})
public final class KotlinClassifierInsertHandler
extends BaseDeclarationInsertHandler {
    public static final KotlinClassifierInsertHandler INSTANCE;

    @Override
    public void handleInsert(@NotNull InsertionContext context2, @NotNull LookupElement item) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
        HandlerUtilsKt.surroundWithBracesIfInStringTemplate(context2);
        super.handleInsert(context2, item);
        PsiFile file = context2.getFile();
        if (file instanceof KtFile && !CompletionUtilsKt.isAfterDot(context2)) {
            boolean isAnnotation;
            KtNameReferenceExpression nameRef;
            PsiElement token;
            PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)context2.getProject());
            psiDocumentManager.commitAllDocuments();
            int startOffset = context2.getStartOffset();
            Document document = context2.getDocument();
            Object object = item.getObject();
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.idea.core.completion.DeclarationLookupObject");
            }
            DeclarationLookupObject lookupObject2 = (DeclarationLookupObject)object;
            DeclarationDescriptor declarationDescriptor = lookupObject2.getDescriptor();
            if (declarationDescriptor != null) {
                if (CompletionUtilsKt.isArtificialImportAliasedDescriptor(declarationDescriptor)) {
                    return;
                }
            }
            String qualifiedName2 = this.qualifiedName(lookupObject2);
            PsiElement psiElement2 = file.findElementAt(startOffset);
            if (psiElement2 == null) {
                Intrinsics.throwNpe();
            }
            PsiElement psiElement3 = token = psiElement2;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement3, (String)"token");
            PsiElement psiElement4 = psiElement3.getParent();
            if (!(psiElement4 instanceof KtNameReferenceExpression)) {
                psiElement4 = null;
            }
            if ((nameRef = (KtNameReferenceExpression)psiElement4) != null) {
                ClassifierDescriptorWithTypeParameters target;
                BindingContext bindingContext2 = ResolutionUtils.analyze(nameRef, BodyResolveMode.PARTIAL);
                ClassifierDescriptorWithTypeParameters classifierDescriptorWithTypeParameters = (ClassifierDescriptorWithTypeParameters)bindingContext2.get(BindingContext.SHORT_REFERENCE_TO_COMPANION_OBJECT, nameRef);
                if (classifierDescriptorWithTypeParameters == null) {
                    Object v = bindingContext2.get(BindingContext.REFERENCE_TARGET, nameRef);
                    if (!(v instanceof ClassDescriptor)) {
                        v = null;
                    }
                    classifierDescriptorWithTypeParameters = target = (ClassifierDescriptorWithTypeParameters)((ClassDescriptor)v);
                }
                if (target != null && Intrinsics.areEqual((Object)IdeDescriptorRenderers.SOURCE_CODE.renderClassifierName(target), (Object)qualifiedName2)) {
                    return;
                }
            }
            String tempPrefix = nameRef != null ? ((isAnnotation = CallTypeAndReceiver.Companion.detect(nameRef) instanceof CallTypeAndReceiver.ANNOTATION) ? "" : " ") : "$;val v:";
            String tempSuffix = ".xxx";
            document.replaceString(startOffset, context2.getTailOffset(), (CharSequence)(tempPrefix + qualifiedName2 + tempSuffix));
            psiDocumentManager.commitAllDocuments();
            int classNameStart = startOffset + tempPrefix.length();
            int classNameEnd = classNameStart + qualifiedName2.length();
            RangeMarker rangeMarker = document.createRangeMarker(classNameStart, classNameEnd);
            RangeMarker wholeRangeMarker = document.createRangeMarker(startOffset, classNameEnd + tempSuffix.length());
            ShortenReferences.DEFAULT.process((KtFile)file, classNameStart, classNameEnd);
            psiDocumentManager.doPostponedOperationsAndUnblockDocument(document);
            RangeMarker rangeMarker2 = rangeMarker;
            Intrinsics.checkExpressionValueIsNotNull((Object)rangeMarker2, (String)"rangeMarker");
            if (rangeMarker2.isValid()) {
                RangeMarker rangeMarker3 = wholeRangeMarker;
                Intrinsics.checkExpressionValueIsNotNull((Object)rangeMarker3, (String)"wholeRangeMarker");
                if (rangeMarker3.isValid()) {
                    document.deleteString(wholeRangeMarker.getStartOffset(), rangeMarker.getStartOffset());
                    document.deleteString(rangeMarker.getEndOffset(), wholeRangeMarker.getEndOffset());
                }
            }
        }
    }

    private final String qualifiedName(DeclarationLookupObject lookupObject2) {
        String string;
        if (lookupObject2.getDescriptor() != null) {
            DeclarationDescriptor declarationDescriptor = lookupObject2.getDescriptor();
            if (declarationDescriptor == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassifierDescriptor");
            }
            string = IdeDescriptorRenderers.SOURCE_CODE.renderClassifierName((ClassifierDescriptor)declarationDescriptor);
        } else {
            String qualifiedName2;
            PsiElement psiElement2 = lookupObject2.getPsiElement();
            if (psiElement2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.PsiClass");
            }
            String string2 = ((PsiClass)psiElement2).getQualifiedName();
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            if (FqNameUnsafe.isValid(qualifiedName2 = string2)) {
                string = RenderingUtilsKt.render(new FqNameUnsafe(qualifiedName2));
            } else {
                String string3 = qualifiedName2;
                string = string3;
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"qualifiedName");
            }
        }
        return string;
    }

    private KotlinClassifierInsertHandler() {
    }

    static {
        KotlinClassifierInsertHandler kotlinClassifierInsertHandler;
        INSTANCE = kotlinClassifierInsertHandler = new KotlinClassifierInsertHandler();
    }
}

