/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.completion.smart;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.completion.CompletionUtilsKt;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/completion/smart/ArtificialElementInsertHandler;", "Lcom/intellij/codeInsight/completion/InsertHandler;", "Lcom/intellij/codeInsight/lookup/LookupElement;", "textBeforeCaret", "", "textAfterCaret", "shortenRefs", "", "(Ljava/lang/String;Ljava/lang/String;Z)V", "handleInsert", "", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "item", "idea"})
public final class ArtificialElementInsertHandler
implements InsertHandler<LookupElement> {
    private final String textBeforeCaret;
    private final String textAfterCaret;
    private final boolean shortenRefs;

    public void handleInsert(@NotNull InsertionContext context2, @NotNull LookupElement item) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
        Editor editor = context2.getEditor();
        Intrinsics.checkExpressionValueIsNotNull((Object)editor, (String)"context.editor");
        CaretModel caretModel = editor.getCaretModel();
        Intrinsics.checkExpressionValueIsNotNull((Object)caretModel, (String)"context.editor.caretModel");
        int offset = caretModel.getOffset();
        int startOffset = offset - item.getLookupString().length();
        context2.getDocument().deleteString(startOffset, offset);
        context2.getDocument().insertString(startOffset, (CharSequence)(this.textBeforeCaret + this.textAfterCaret));
        Editor editor2 = context2.getEditor();
        Intrinsics.checkExpressionValueIsNotNull((Object)editor2, (String)"context.editor");
        editor2.getCaretModel().moveToOffset(startOffset + this.textBeforeCaret.length());
        if (this.shortenRefs) {
            CompletionUtilsKt.shortenReferences(context2, startOffset, startOffset + this.textBeforeCaret.length() + this.textAfterCaret.length());
        }
    }

    public ArtificialElementInsertHandler(@NotNull String textBeforeCaret, @NotNull String textAfterCaret, boolean shortenRefs) {
        Intrinsics.checkParameterIsNotNull((Object)textBeforeCaret, (String)"textBeforeCaret");
        Intrinsics.checkParameterIsNotNull((Object)textAfterCaret, (String)"textAfterCaret");
        this.textBeforeCaret = textBeforeCaret;
        this.textAfterCaret = textAfterCaret;
        this.shortenRefs = shortenRefs;
    }
}

