/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration;

import com.intellij.facet.Facet;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleGrouperKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.CommonToolArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JSCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.ParseCommandLineArgumentsKt;
import org.jetbrains.kotlin.config.CoroutineSupport;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.config.KotlinFacetSettings;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.TargetPlatformKind;
import org.jetbrains.kotlin.gradle.ArgsInfo;
import org.jetbrains.kotlin.idea.configuration.AndroidGradle;
import org.jetbrains.kotlin.idea.configuration.BuildSystemTypeKt;
import org.jetbrains.kotlin.idea.configuration.KotlinGradleProjectResolverExtensionKt;
import org.jetbrains.kotlin.idea.facet.FacetUtilsKt;
import org.jetbrains.kotlin.idea.facet.KotlinFacet;
import org.jetbrains.kotlin.idea.facet.KotlinFacetConfiguration;
import org.jetbrains.kotlin.idea.facet.KotlinFacetType;
import org.jetbrains.kotlin.idea.inspections.gradle.DifferentStdlibGradleVersionInspectionKt;
import org.jetbrains.kotlin.idea.inspections.gradle.KotlinGradleInspectionVisitorKt;
import org.jetbrains.kotlin.idea.inspections.gradle.NodeWithData;
import org.jetbrains.kotlin.psi.UserDataProperty;
import org.jetbrains.plugins.gradle.model.data.BuildScriptClasspathData;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000T\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u001e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001H\u0002\u001a \u0010\u001a\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u00052\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d\u001a0\u0010\u001e\u001a\u0004\u0018\u00010\u00182\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\"\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u001d\u001a\u001c\u0010#\u001a\b\u0012\u0002\b\u0003\u0018\u00010$2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 H\u0002\u001a\u001a\u0010%\u001a\b\u0012\u0002\b\u0003\u0018\u00010$2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 \u001a\u0010\u0010&\u001a\u00020\u00022\u0006\u0010'\u001a\u00020(H\u0002\u001a.\u0010)\u001a\u0004\u0018\u00010\u00022\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 2\f\u0010*\u001a\b\u0012\u0002\b\u0003\u0018\u00010$2\u0006\u0010+\u001a\u00020\u0002H\u0002\u001a.\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00022\u0006\u0010'\u001a\u00020(H\u0002\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"W\u0010\u0007\u001a\u0016\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004j\u0004\u0018\u0001`\u0006*\u00020\b2\u001a\u0010\u0003\u001a\u0016\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004j\u0004\u0018\u0001`\u00068F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\r\u0010\u000e\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\"3\u0010\u000f\u001a\u0004\u0018\u00010\u0002*\u00020\b2\b\u0010\u0003\u001a\u0004\u0018\u00010\u00028F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0014\u0010\u000e\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006-"}, d2={"gradlePropertyFiles", "", "", "<set-?>", "", "Lorg/jetbrains/kotlin/gradle/ArgsInfo;", "Lorg/jetbrains/kotlin/gradle/CompilerArgumentsBySourceSet;", "compilerArgumentsBySourceSet", "Lcom/intellij/openapi/module/Module;", "getCompilerArgumentsBySourceSet", "(Lcom/intellij/openapi/module/Module;)Ljava/util/Map;", "setCompilerArgumentsBySourceSet", "(Lcom/intellij/openapi/module/Module;Ljava/util/Map;)V", "compilerArgumentsBySourceSet$delegate", "Lorg/jetbrains/kotlin/psi/UserDataProperty;", "sourceSetName", "getSourceSetName", "(Lcom/intellij/openapi/module/Module;)Ljava/lang/String;", "setSourceSetName", "(Lcom/intellij/openapi/module/Module;Ljava/lang/String;)V", "sourceSetName$delegate", "adjustClasspath", "", "kotlinFacet", "Lorg/jetbrains/kotlin/idea/facet/KotlinFacet;", "dependencyClasspath", "configureFacetByCompilerArguments", "argsInfo", "modelsProvider", "Lcom/intellij/openapi/externalSystem/service/project/IdeModifiableModelsProvider;", "configureFacetByGradleModule", "moduleNode", "Lcom/intellij/openapi/externalSystem/model/DataNode;", "Lcom/intellij/openapi/externalSystem/model/project/ModuleData;", "ideModule", "detectPlatformByLibrary", "Lorg/jetbrains/kotlin/config/TargetPlatformKind;", "detectPlatformByPlugin", "findKotlinCoroutinesProperty", "project", "Lcom/intellij/openapi/project/Project;", "getExplicitOutputPath", "platformKind", "sourceSet", "getImplementedModuleNames", "idea-gradle"})
public final class KotlinGradleSourceSetDataServiceKt {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    @Nullable
    private static final UserDataProperty compilerArgumentsBySourceSet$delegate;
    @Nullable
    private static final UserDataProperty sourceSetName$delegate;
    private static final List<String> gradlePropertyFiles;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl(Reflection.getOrCreateKotlinPackage(KotlinGradleSourceSetDataServiceKt.class, (String)"idea-gradle"), "compilerArgumentsBySourceSet", "getCompilerArgumentsBySourceSet(Lcom/intellij/openapi/module/Module;)Ljava/util/Map;")), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl(Reflection.getOrCreateKotlinPackage(KotlinGradleSourceSetDataServiceKt.class, (String)"idea-gradle"), "sourceSetName", "getSourceSetName(Lcom/intellij/openapi/module/Module;)Ljava/lang/String;"))};
        com.intellij.openapi.util.Key key = com.intellij.openapi.util.Key.create((String)"CURRENT_COMPILER_ARGUMENTS");
        Intrinsics.checkExpressionValueIsNotNull((Object)key, (String)"Key.create<CompilerArgum\u2026RENT_COMPILER_ARGUMENTS\")");
        compilerArgumentsBySourceSet$delegate = new UserDataProperty(key);
        com.intellij.openapi.util.Key key2 = com.intellij.openapi.util.Key.create((String)"SOURCE_SET_NAME");
        Intrinsics.checkExpressionValueIsNotNull((Object)key2, (String)"Key.create<String>(\"SOURCE_SET_NAME\")");
        sourceSetName$delegate = new UserDataProperty(key2);
        gradlePropertyFiles = CollectionsKt.listOf((Object[])new String[]{"local.properties", "gradle.properties"});
    }

    @Nullable
    public static final Map<String, ArgsInfo> getCompilerArgumentsBySourceSet(@NotNull Module $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return (Map)compilerArgumentsBySourceSet$delegate.getValue((UserDataHolder)$receiver, $$delegatedProperties[0]);
    }

    public static final void setCompilerArgumentsBySourceSet(@NotNull Module $receiver, @Nullable Map<String, ? extends ArgsInfo> map2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        compilerArgumentsBySourceSet$delegate.setValue((UserDataHolder)$receiver, $$delegatedProperties[0], map2);
    }

    @Nullable
    public static final String getSourceSetName(@NotNull Module $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return (String)sourceSetName$delegate.getValue((UserDataHolder)$receiver, $$delegatedProperties[1]);
    }

    public static final void setSourceSetName(@NotNull Module $receiver, @Nullable String string) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        sourceSetName$delegate.setValue((UserDataHolder)$receiver, $$delegatedProperties[1], string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static final TargetPlatformKind<?> detectPlatformByPlugin(@NotNull DataNode<ModuleData> moduleNode) {
        Intrinsics.checkParameterIsNotNull(moduleNode, (String)"moduleNode");
        String string = KotlinGradleProjectResolverExtensionKt.getPlatformPluginId(moduleNode);
        if (string == null) return null;
        switch (string) {
            case "kotlin-platform-jvm": {
                TargetPlatformKind targetPlatformKind = (TargetPlatformKind)TargetPlatformKind.Jvm.Companion.get(JvmTarget.JVM_1_6);
                return targetPlatformKind;
            }
            case "kotlin-platform-js": {
                TargetPlatformKind targetPlatformKind = (TargetPlatformKind)TargetPlatformKind.JavaScript.INSTANCE;
                return targetPlatformKind;
            }
            case "kotlin-platform-common": {
                TargetPlatformKind targetPlatformKind = (TargetPlatformKind)TargetPlatformKind.Common.INSTANCE;
                return targetPlatformKind;
            }
            default: {
                return null;
            }
        }
    }

    private static final TargetPlatformKind<?> detectPlatformByLibrary(DataNode<ModuleData> moduleNode) {
        Map.Entry it;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv = FacetUtilsKt.getMavenLibraryIdToPlatform().entrySet();
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (Map.Entry)element$iv$iv;
            if (!(DifferentStdlibGradleVersionInspectionKt.getResolvedKotlinStdlibVersionByModuleData(moduleNode, CollectionsKt.listOf(it.getKey())) != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            TargetPlatformKind targetPlatformKind = (TargetPlatformKind)it.getValue();
            collection.add(targetPlatformKind);
        }
        List detectedPlatforms = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        TargetPlatformKind targetPlatformKind = (TargetPlatformKind)CollectionsKt.singleOrNull((List)detectedPlatforms);
        if (targetPlatformKind == null) {
            Object v1;
            block4: {
                $receiver$iv = detectedPlatforms;
                for (Object element$iv : $receiver$iv) {
                    TargetPlatformKind it2 = (TargetPlatformKind)element$iv;
                    if (!(Intrinsics.areEqual((Object)it2, (Object)TargetPlatformKind.Common.INSTANCE) ^ true)) continue;
                    v1 = element$iv;
                    break block4;
                }
                v1 = null;
            }
            targetPlatformKind = v1;
        }
        return targetPlatformKind;
    }

    @Nullable
    public static final KotlinFacet configureFacetByGradleModule(@NotNull DataNode<ModuleData> moduleNode, @Nullable String sourceSetName, @NotNull Module ideModule, @NotNull IdeModifiableModelsProvider modelsProvider) {
        KotlinFacetSettings kotlinFacetSettings;
        ArgsInfo argsInfo;
        ArgsInfo argsInfo2;
        String string;
        TargetPlatformKind<?> platformKind;
        NodeWithData facet2;
        NodeWithData p1;
        Intrinsics.checkParameterIsNotNull(moduleNode, (String)"moduleNode");
        Intrinsics.checkParameterIsNotNull((Object)ideModule, (String)"ideModule");
        Intrinsics.checkParameterIsNotNull((Object)modelsProvider, (String)"modelsProvider");
        if (!KotlinGradleProjectResolverExtensionKt.isResolved(moduleNode).booleanValue()) {
            return null;
        }
        if (!KotlinGradleProjectResolverExtensionKt.getHasKotlinPlugin(moduleNode).booleanValue()) {
            ModifiableFacetModel facetModel = modelsProvider.getModifiableFacetModel(ideModule);
            KotlinFacet facet2 = (KotlinFacet)facetModel.getFacetByType(KotlinFacetType.Companion.getTYPE_ID());
            if (facet2 != null) {
                facetModel.removeFacet((Facet)facet2);
            }
            return null;
        }
        Key key = BuildScriptClasspathData.KEY;
        Intrinsics.checkExpressionValueIsNotNull((Object)key, (String)"BuildScriptClasspathData.KEY");
        Object object = (NodeWithData)CollectionsKt.firstOrNull(KotlinGradleInspectionVisitorKt.findAll(moduleNode, key));
        if (object == null || (object = (BuildScriptClasspathData)((NodeWithData)object).getData()) == null || (object = KotlinGradleInspectionVisitorKt.findKotlinPluginVersion((BuildScriptClasspathData)(p1 = (facet2 = object)))) == null) {
            return null;
        }
        Object compilerVersion = object;
        TargetPlatformKind<?> targetPlatformKind = KotlinGradleSourceSetDataServiceKt.detectPlatformByPlugin(moduleNode);
        if (targetPlatformKind == null) {
            targetPlatformKind = platformKind = KotlinGradleSourceSetDataServiceKt.detectPlatformByLibrary(moduleNode);
        }
        if ((string = KotlinGradleProjectResolverExtensionKt.getCoroutines(moduleNode)) == null) {
            Project project = ideModule.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"ideModule.project");
            string = KotlinGradleSourceSetDataServiceKt.findKotlinCoroutinesProperty(project);
        }
        LanguageFeature.State coroutinesProperty = CoroutineSupport.INSTANCE.byCompilerArgument(string);
        KotlinFacet kotlinFacet = FacetUtilsKt.getOrCreateFacet$default(ideModule, modelsProvider, false, false, 4, null);
        FacetUtilsKt.configureFacet(kotlinFacet, (String)compilerVersion, coroutinesProperty, platformKind, modelsProvider);
        KotlinGradleSourceSetDataServiceKt.setCompilerArgumentsBySourceSet(ideModule, KotlinGradleProjectResolverExtensionKt.getCompilerArgumentsBySourceSet(moduleNode));
        KotlinGradleSourceSetDataServiceKt.setSourceSetName(ideModule, sourceSetName);
        Map<String, ArgsInfo> map2 = KotlinGradleProjectResolverExtensionKt.getCompilerArgumentsBySourceSet(moduleNode);
        if (map2 != null) {
            String string2 = sourceSetName;
            if (string2 == null) {
                string2 = "main";
            }
            argsInfo2 = map2.get(string2);
        } else {
            argsInfo2 = argsInfo = null;
        }
        if (argsInfo != null) {
            KotlinGradleSourceSetDataServiceKt.configureFacetByCompilerArguments(kotlinFacet, argsInfo, modelsProvider);
        }
        KotlinFacetSettings $receiver = kotlinFacetSettings = ((KotlinFacetConfiguration)kotlinFacet.getConfiguration()).getSettings();
        String sourceSetNameForImplementedModules = Intrinsics.areEqual((Object)BuildSystemTypeKt.getBuildSystemType(ideModule), (Object)AndroidGradle.INSTANCE) ? null : sourceSetName;
        Project project = ideModule.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"ideModule.project");
        $receiver.setImplementedModuleNames(KotlinGradleSourceSetDataServiceKt.getImplementedModuleNames(moduleNode, sourceSetNameForImplementedModules, project));
        $receiver.setProductionOutputPath(KotlinGradleSourceSetDataServiceKt.getExplicitOutputPath(moduleNode, platformKind, "main"));
        $receiver.setTestOutputPath(KotlinGradleSourceSetDataServiceKt.getExplicitOutputPath(moduleNode, platformKind, "test"));
        FacetUtilsKt.noVersionAutoAdvance(kotlinFacet);
        return kotlinFacet;
    }

    /*
     * WARNING - void declaration
     */
    public static final void configureFacetByCompilerArguments(@NotNull KotlinFacet kotlinFacet, @NotNull ArgsInfo argsInfo, @Nullable IdeModifiableModelsProvider modelsProvider) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)((Object)kotlinFacet), (String)"kotlinFacet");
        Intrinsics.checkParameterIsNotNull((Object)argsInfo, (String)"argsInfo");
        List currentCompilerArguments = argsInfo.getCurrentArguments();
        List defaultCompilerArguments = argsInfo.getDefaultArguments();
        Iterable iterable = $receiver$iv = (Iterable)argsInfo.getDependencyClasspath();
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            String string2 = PathUtil.toSystemIndependentName((String)it);
            collection.add(string2);
        }
        List dependencyClasspath = (List)destination$iv$iv;
        Collection collection = currentCompilerArguments;
        if (!collection.isEmpty()) {
            FacetUtilsKt.parseCompilerArgumentsToFacet(currentCompilerArguments, defaultCompilerArguments, kotlinFacet, modelsProvider);
        }
        KotlinGradleSourceSetDataServiceKt.adjustClasspath(kotlinFacet, dependencyClasspath);
    }

    /*
     * WARNING - void declaration
     */
    private static final List<String> getImplementedModuleNames(DataNode<ModuleData> moduleNode, String sourceSetName, Project project) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        List<String> baseModuleNames = KotlinGradleProjectResolverExtensionKt.getImplementedModuleNames(moduleNode);
        if (baseModuleNames.isEmpty() || sourceSetName == null) {
            List<String> list2 = baseModuleNames;
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"baseModuleNames");
            return list2;
        }
        String delimiter = ModuleGrouperKt.isQualifiedModuleNamesEnabled((Project)project) ? "." : "_";
        List<String> list3 = baseModuleNames;
        Intrinsics.checkExpressionValueIsNotNull(list3, (String)"baseModuleNames");
        Iterable iterable = $receiver$iv = (Iterable)list3;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            String string2 = (String)it + delimiter + sourceSetName;
            collection.add(string2);
        }
        return (List)destination$iv$iv;
    }

    private static final String getExplicitOutputPath(DataNode<ModuleData> moduleNode, TargetPlatformKind<?> platformKind, String sourceSet) {
        K2JSCompilerArguments k2JSCompilerArguments;
        if (platformKind != TargetPlatformKind.JavaScript.INSTANCE) {
            return null;
        }
        Object object = KotlinGradleProjectResolverExtensionKt.getCompilerArgumentsBySourceSet(moduleNode);
        if (object == null || (object = object.get(sourceSet)) == null || (object = object.getCurrentArguments()) == null) {
            return null;
        }
        Object k2jsArgumentList = object;
        K2JSCompilerArguments $receiver = k2JSCompilerArguments = new K2JSCompilerArguments();
        ParseCommandLineArgumentsKt.parseCommandLineArguments((List<String>)k2jsArgumentList, (CommonToolArguments)$receiver);
        return k2JSCompilerArguments.getOutputFile();
    }

    private static final void adjustClasspath(KotlinFacet kotlinFacet, List<String> dependencyClasspath) {
        String string;
        boolean bl;
        Object fullClasspath;
        K2JVMCompilerArguments arguments2;
        block10: {
            Object object;
            block9: {
                if (dependencyClasspath.isEmpty()) {
                    return;
                }
                CommonCompilerArguments commonCompilerArguments = ((KotlinFacetConfiguration)kotlinFacet.getConfiguration()).getSettings().getCompilerArguments();
                if (!(commonCompilerArguments instanceof K2JVMCompilerArguments)) {
                    commonCompilerArguments = null;
                }
                K2JVMCompilerArguments k2JVMCompilerArguments = (K2JVMCompilerArguments)commonCompilerArguments;
                if (k2JVMCompilerArguments == null) {
                    return;
                }
                arguments2 = k2JVMCompilerArguments;
                object = arguments2.getClasspath();
                if (object == null) break block9;
                CharSequence charSequence = (CharSequence)object;
                String[] stringArray = new String[1];
                String string2 = File.pathSeparator;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"File.pathSeparator");
                stringArray[0] = string2;
                object = StringsKt.split$default((CharSequence)charSequence, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                if (object != null) break block10;
            }
            object = fullClasspath = CollectionsKt.emptyList();
        }
        if (fullClasspath.isEmpty()) {
            return;
        }
        List newClasspath = CollectionsKt.minus((Iterable)((Iterable)fullClasspath), (Iterable)dependencyClasspath);
        Collection collection = newClasspath;
        K2JVMCompilerArguments k2JVMCompilerArguments = arguments2;
        boolean bl2 = bl = !collection.isEmpty();
        if (bl) {
            Iterable iterable = newClasspath;
            String string3 = File.pathSeparator;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"File.pathSeparator");
            string = CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string3, null, null, (int)0, null, null, (int)62, null);
        } else {
            string = null;
        }
        k2JVMCompilerArguments.setClasspath(string);
    }

    private static final String findKotlinCoroutinesProperty(Project project) {
        for (String propertyFileName : gradlePropertyFiles) {
            String string;
            VirtualFile propertyFile;
            if (project.getBaseDir().findChild(propertyFileName) == null) {
                continue;
            }
            Properties properties2 = new Properties();
            VirtualFile virtualFile = propertyFile;
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"propertyFile");
            properties2.load(virtualFile.getInputStream());
            String string2 = properties2.getProperty("kotlin.coroutines");
            if (string2 == null) continue;
            String it = string = string2;
            return it;
        }
        return CoroutineSupport.INSTANCE.getCompilerArgument(LanguageFeature.Coroutines.getDefaultState());
    }
}

