/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageVersion;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0082\b\u0018\u0000 \u00142\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0014B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0011\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0000H\u0096\u0002J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\n\u001a\u0004\u0018\u00010\u0010H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/MajorVersion;", "", "major", "", "minor", "(II)V", "getMajor", "()I", "getMinor", "compareTo", "other", "component1", "component2", "copy", "equals", "", "", "hashCode", "toString", "", "Companion", "idea"})
final class MajorVersion
implements Comparable<MajorVersion> {
    private final int major;
    private final int minor;
    public static final Companion Companion = new Companion(null);

    @Override
    public int compareTo(@NotNull MajorVersion other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        if (this.major > other.major) {
            return 1;
        }
        if (this.major < other.major) {
            return -1;
        }
        if (this.minor > other.minor) {
            return 1;
        }
        if (this.minor < other.minor) {
            return -1;
        }
        return 0;
    }

    @NotNull
    public String toString() {
        return "" + this.major + '.' + this.minor;
    }

    public final int getMajor() {
        return this.major;
    }

    public final int getMinor() {
        return this.minor;
    }

    public MajorVersion(int major, int minor) {
        this.major = major;
        this.minor = minor;
    }

    public final int component1() {
        return this.major;
    }

    public final int component2() {
        return this.minor;
    }

    @NotNull
    public final MajorVersion copy(int major, int minor) {
        return new MajorVersion(major, minor);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ MajorVersion copy$default(MajorVersion majorVersion, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = majorVersion.major;
        }
        if ((n3 & 2) != 0) {
            n2 = majorVersion.minor;
        }
        return majorVersion.copy(n, n2);
    }

    public int hashCode() {
        return Integer.hashCode(this.major) * 31 + Integer.hashCode(this.minor);
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof MajorVersion)) break block3;
                MajorVersion majorVersion = (MajorVersion)object;
                if (!(this.major == majorVersion.major) || !(this.minor == majorVersion.minor)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/MajorVersion$Companion;", "", "()V", "create", "Lorg/jetbrains/kotlin/idea/configuration/MajorVersion;", "versionStr", "", "languageVersion", "Lorg/jetbrains/kotlin/config/LanguageVersion;", "idea"})
    public static final class Companion {
        @NotNull
        public final MajorVersion create(@NotNull LanguageVersion languageVersion) {
            Intrinsics.checkParameterIsNotNull((Object)languageVersion, (String)"languageVersion");
            return new MajorVersion(languageVersion.getMajor(), languageVersion.getMinor());
        }

        @Nullable
        public final MajorVersion create(@NotNull String versionStr) {
            Intrinsics.checkParameterIsNotNull((Object)versionStr, (String)"versionStr");
            if (Intrinsics.areEqual((Object)versionStr, (Object)"@snapshot@")) {
                return new MajorVersion(Integer.MAX_VALUE, Integer.MAX_VALUE);
            }
            String string = "(\\d+)\\.(\\d+).*";
            Regex regex = new Regex(string);
            MatchResult matchResult = regex.matchEntire((CharSequence)versionStr);
            if (matchResult == null) {
                return null;
            }
            MatchResult matchResult2 = matchResult;
            String string2 = (String)matchResult2.getGroupValues().get(1);
            int major = Integer.parseInt(string2);
            String string3 = (String)matchResult2.getGroupValues().get(2);
            int minor = Integer.parseInt(string3);
            return new MajorVersion(major, minor);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

