/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration;

import com.intellij.ide.DataManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.AsyncResult;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.text.VersionComparatorUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinPluginUtil;
import org.jetbrains.kotlin.idea.actions.ConfigurePluginUpdatesAction;
import org.jetbrains.kotlin.idea.configuration.MajorVersion;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.psi.UserDataProperty;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000(\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u001a\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0001\u001a\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u0010\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\"3\u0010\u0006\u001a\u0004\u0018\u00010\u0001*\u00020\u00072\b\u0010\u0005\u001a\u0004\u0018\u00010\u00018F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\f\u0010\r\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"OUTDATED_BUNDLED_COMPILER_GROUP_DISPLAY_ID", "", "SUPPRESSED_OUTDATED_COMPILER_PROPERTY_NAME", "alreadyNotified", "Ljava/util/concurrent/ConcurrentHashMap;", "<set-?>", "externalCompilerVersion", "Lcom/intellij/openapi/module/Module;", "getExternalCompilerVersion", "(Lcom/intellij/openapi/module/Module;)Ljava/lang/String;", "setExternalCompilerVersion", "(Lcom/intellij/openapi/module/Module;Ljava/lang/String;)V", "externalCompilerVersion$delegate", "Lorg/jetbrains/kotlin/psi/UserDataProperty;", "createOutdatedBundledCompilerMessage", "project", "Lcom/intellij/openapi/project/Project;", "bundledCompilerVersion", "notifyOutdatedBundledCompilerIfNecessary", "", "idea"})
public final class OutdatedBundledCompilerNotificationKt {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    @Nullable
    private static final UserDataProperty externalCompilerVersion$delegate;
    private static ConcurrentHashMap<String, String> alreadyNotified;
    private static final String SUPPRESSED_OUTDATED_COMPILER_PROPERTY_NAME = "outdated.bundled.kotlin.compiler";
    private static final String OUTDATED_BUNDLED_COMPILER_GROUP_DISPLAY_ID = "Outdated Bundled Kotlin Compiler";

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl(Reflection.getOrCreateKotlinPackage(OutdatedBundledCompilerNotificationKt.class, (String)"idea"), "externalCompilerVersion", "getExternalCompilerVersion(Lcom/intellij/openapi/module/Module;)Ljava/lang/String;"))};
        Key key = Key.create((String)"EXTERNAL_COMPILER_VERSION");
        Intrinsics.checkExpressionValueIsNotNull((Object)key, (String)"Key.create(\"EXTERNAL_COMPILER_VERSION\")");
        externalCompilerVersion$delegate = new UserDataProperty(key);
        alreadyNotified = new ConcurrentHashMap();
    }

    @Nullable
    public static final String getExternalCompilerVersion(@NotNull Module $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return (String)externalCompilerVersion$delegate.getValue((UserDataHolder)$receiver, $$delegatedProperties[0]);
    }

    public static final void setExternalCompilerVersion(@NotNull Module $receiver, @Nullable String string) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        externalCompilerVersion$delegate.setValue((UserDataHolder)$receiver, $$delegatedProperties[0], string);
    }

    public static final void notifyOutdatedBundledCompilerIfNecessary(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        String pluginVersion = KotlinPluginUtil.getPluginVersion();
        if (Intrinsics.areEqual((Object)pluginVersion, (Object)PropertiesComponent.getInstance((Project)project).getValue(SUPPRESSED_OUTDATED_COMPILER_PROPERTY_NAME))) {
            return;
        }
        String string = OutdatedBundledCompilerNotificationKt.createOutdatedBundledCompilerMessage$default(project, null, 2, null);
        if (string == null) {
            return;
        }
        String message2 = string;
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.isUnitTestMode()) {
            return;
        }
        Notifications.Bus.notify((Notification)new Notification(OUTDATED_BUNDLED_COMPILER_GROUP_DISPLAY_ID, OUTDATED_BUNDLED_COMPILER_GROUP_DISPLAY_ID, message2, NotificationType.WARNING, new NotificationListener(project, pluginVersion){
            final /* synthetic */ Project $project;
            final /* synthetic */ String $pluginVersion;

            public final void hyperlinkUpdate(@NotNull Notification notification2, @NotNull HyperlinkEvent event) {
                Intrinsics.checkParameterIsNotNull((Object)notification2, (String)"notification");
                Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                if (Intrinsics.areEqual((Object)event.getEventType(), (Object)HyperlinkEvent.EventType.ACTIVATED)) {
                    if (Intrinsics.areEqual((Object)"update", (Object)event.getDescription())) {
                        AnAction action2 = ActionManager.getInstance().getAction(ConfigurePluginUpdatesAction.Companion.getACTION_ID());
                        DataManager dataManager = DataManager.getInstance();
                        Intrinsics.checkExpressionValueIsNotNull((Object)dataManager, (String)"DataManager.getInstance()");
                        AsyncResult asyncResult = dataManager.getDataContextFromFocus();
                        Intrinsics.checkExpressionValueIsNotNull((Object)asyncResult, (String)"DataManager.getInstance().dataContextFromFocus");
                        DataContext dataContext = (DataContext)asyncResult.getResult();
                        AnActionEvent actionEvent = AnActionEvent.createFromAnAction((AnAction)action2, null, (String)"GoToAction", (DataContext)dataContext);
                        action2.actionPerformed(actionEvent);
                    } else if (Intrinsics.areEqual((Object)"ignore", (Object)event.getDescription())) {
                        if (!this.$project.isDisposed()) {
                            PropertiesComponent.getInstance((Project)this.$project).setValue("outdated.bundled.kotlin.compiler", this.$pluginVersion);
                        }
                    } else {
                        throw (Throwable)((Object)new AssertionError());
                    }
                    notification2.expire();
                }
            }
            {
                this.$project = project;
                this.$pluginVersion = string;
            }
        }), (Project)project);
    }

    @Nullable
    public static final String createOutdatedBundledCompilerMessage(@NotNull Project project, @NotNull String bundledCompilerVersion) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)bundledCompilerVersion, (String)"bundledCompilerVersion");
        MajorVersion majorVersion = MajorVersion.Companion.create(bundledCompilerVersion);
        if (majorVersion == null) {
            return null;
        }
        MajorVersion bundledCompilerMajorVersion = majorVersion;
        String maxCompilerVersion = null;
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        Intrinsics.checkExpressionValueIsNotNull((Object)moduleManager, (String)"ModuleManager.getInstance(project)");
        Object object = moduleManager.getModules();
        int n = ((Module[])object).length;
        for (int i = 0; i < n; ++i) {
            MajorVersion externalCompilerMajorVersion;
            String externalCompilerVersion;
            Module module;
            Module module2 = module = object[i];
            Intrinsics.checkExpressionValueIsNotNull((Object)module2, (String)"module");
            if (OutdatedBundledCompilerNotificationKt.getExternalCompilerVersion(module2) == null) {
                continue;
            }
            if (MajorVersion.Companion.create(externalCompilerVersion) == null) {
                continue;
            }
            MajorVersion languageMajorVersion = MajorVersion.Companion.create(PlatformKt.getLanguageVersionSettings(module).getLanguageVersion());
            if (externalCompilerMajorVersion.compareTo(bundledCompilerMajorVersion) <= 0 || languageMajorVersion.compareTo(bundledCompilerMajorVersion) <= 0 || maxCompilerVersion != null && VersionComparatorUtil.COMPARATOR.compare(externalCompilerVersion, maxCompilerVersion) <= 0) continue;
            maxCompilerVersion = externalCompilerVersion;
        }
        if (maxCompilerVersion == null) {
            return null;
        }
        String lastProjectNotified = alreadyNotified.get(project.getName());
        if (Intrinsics.areEqual((Object)lastProjectNotified, (Object)maxCompilerVersion)) {
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
            if (!application.isUnitTestMode()) {
                return null;
            }
        }
        Map map2 = alreadyNotified;
        String string = project.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"project.name");
        object = string;
        String string2 = maxCompilerVersion;
        map2.put(object, string2);
        return StringsKt.replace$default((String)CollectionsKt.joinToString$default((Iterable)StringsKt.lines((CharSequence)StringsKt.trimIndent((String)("\n        <p>The compiler bundled to Kotlin plugin (" + bundledCompilerVersion + ") is older than external compiler (" + maxCompilerVersion + ").</p>\n        <p>Kotlin plugin should be updated to avoid compatibility problems.</p>\n        <p><a href=\"update\">Update</a>  <a href=\"ignore\">Ignore</a></p>"))), (CharSequence)"", null, null, (int)0, null, null, (int)62, null), (String)"<br/>", (String)"\n", (boolean)false, (int)4, null);
    }

    @Nullable
    public static /* bridge */ /* synthetic */ String createOutdatedBundledCompilerMessage$default(Project project, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = "1.2.61";
        }
        return OutdatedBundledCompilerNotificationKt.createOutdatedBundledCompilerMessage(project, string);
    }
}

