/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiPackage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.caches.PerModulePackageCacheService;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtilKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0001*\u00020\u0004\u001a\f\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u0004\u001a\n\u0010\u0007\u001a\u00020\b*\u00020\t\u001a\n\u0010\n\u001a\u00020\b*\u00020\t\u00a8\u0006\u000b"}, d2={"getFqNameByDirectory", "Lorg/jetbrains/kotlin/name/FqName;", "Lcom/intellij/psi/PsiFile;", "getFqNameWithImplicitPrefix", "Lcom/intellij/psi/PsiDirectory;", "getPackage", "Lcom/intellij/psi/PsiPackage;", "packageMatchesDirectory", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "packageMatchesDirectoryOrImplicit", "idea-core"})
public final class PackageUtilsKt {
    @Nullable
    public static final PsiPackage getPackage(@NotNull PsiDirectory $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        JavaDirectoryService javaDirectoryService = JavaDirectoryService.getInstance();
        if (javaDirectoryService == null) {
            Intrinsics.throwNpe();
        }
        return javaDirectoryService.getPackage($receiver);
    }

    @NotNull
    public static final FqName getFqNameByDirectory(@NotNull PsiFile $receiver) {
        FqName fqName2;
        String qualifiedNameByDirectory;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        PsiDirectory psiDirectory = $receiver.getParent();
        String string = qualifiedNameByDirectory = psiDirectory != null && (psiDirectory = PackageUtilsKt.getPackage(psiDirectory)) != null ? psiDirectory.getQualifiedName() : null;
        if (string != null) {
            String string2;
            String p1 = string2 = string;
            fqName2 = new FqName(p1);
        } else {
            FqName fqName3 = FqName.ROOT;
            fqName2 = fqName3;
            Intrinsics.checkExpressionValueIsNotNull((Object)fqName3, (String)"FqName.ROOT");
        }
        return fqName2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final FqName getFqNameWithImplicitPrefix(@NotNull PsiDirectory $receiver) {
        FqName fqName2;
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Object object2 = PackageUtilsKt.getPackage($receiver);
        if (object2 != null && (object2 = object2.getQualifiedName()) != null) {
            Object p1 = object = object2;
            fqName2 = new FqName((String)p1);
        } else {
            fqName2 = FqName.ROOT;
        }
        FqName packageFqName = fqName2;
        VirtualFile virtualFile = ProjectRootsUtilKt.getSourceRoot((PsiFileSystemItem)$receiver);
        if (virtualFile != null) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Object it = object = virtualFile;
            Project project = $receiver.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
            FqName implicitPrefix = PerModulePackageCacheService.Companion.getInstance(project).getImplicitPackagePrefix((VirtualFile)it);
            List<Name> list2 = implicitPrefix.pathSegments();
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"implicitPrefix.pathSegments()");
            Collection collection = list2;
            List<Name> list3 = packageFqName.pathSegments();
            Intrinsics.checkExpressionValueIsNotNull(list3, (String)"packageFqName.pathSegments()");
            Iterable iterable = $receiver$iv = (Iterable)CollectionsKt.plus((Collection)collection, (Iterable)list3);
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it2;
                Name name2 = (Name)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                String string = it2.asString();
                collection2.add(string);
            }
            FqName fqName3 = FqName.fromSegments((List)destination$iv$iv);
            Intrinsics.checkExpressionValueIsNotNull((Object)fqName3, (String)"FqName.fromSegments((imp\u2026)).map { it.asString() })");
            return fqName3;
        }
        FqName fqName4 = packageFqName;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName4, (String)"packageFqName");
        return fqName4;
    }

    public static final boolean packageMatchesDirectory(@NotNull KtFile $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return Intrinsics.areEqual((Object)$receiver.getPackageFqName(), (Object)PackageUtilsKt.getFqNameByDirectory((PsiFile)$receiver));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean packageMatchesDirectoryOrImplicit(@NotNull KtFile $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if (Intrinsics.areEqual((Object)$receiver.getPackageFqName(), (Object)PackageUtilsKt.getFqNameByDirectory((PsiFile)$receiver))) return true;
        PsiDirectory psiDirectory = $receiver.getParent();
        if (!Intrinsics.areEqual((Object)$receiver.getPackageFqName(), (Object)(psiDirectory != null ? PackageUtilsKt.getFqNameWithImplicitPrefix(psiDirectory) : null))) return false;
        return true;
    }
}

