/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.script;

import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.script.experimental.location.ScriptExpectedLocation;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.core.script.ScriptDefinitionContributor;
import org.jetbrains.kotlin.idea.core.script.ScriptDependenciesCache;
import org.jetbrains.kotlin.idea.core.script.ScriptTemplatesProviderAdapter;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtil;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.script.KotlinScriptDefinition;
import org.jetbrains.kotlin.script.LazyScriptDefinitionProvider;
import org.jetbrains.kotlin.script.ScriptDefinitionProvider;
import org.jetbrains.kotlin.script.ScriptTemplatesProvider;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\r0\u000eH\u0002J\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u000e2\u0006\u0010\u0011\u001a\u00020\rJ\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0007J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\rJ\u0006\u0010\u0019\u001a\u00020\u0018J\b\u0010\u001a\u001a\u00020\u0018H\u0002J\u0012\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00070\u000e*\u00020\rH\u0002R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0016\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u000e0\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/ScriptDefinitionsManager;", "Lorg/jetbrains/kotlin/script/LazyScriptDefinitionProvider;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "currentDefinitions", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/kotlin/script/KotlinScriptDefinition;", "getCurrentDefinitions", "()Lkotlin/sequences/Sequence;", "definitions", "definitionsByContributor", "", "Lorg/jetbrains/kotlin/idea/core/script/ScriptDefinitionContributor;", "", "getContributors", "getDefinitionsBy", "contributor", "isInExpectedLocation", "", "ktFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "scriptDefinition", "reloadDefinitionsBy", "", "reloadScriptDefinitions", "updateDefinitions", "safeGetDefinitions", "Companion", "idea-core"})
public final class ScriptDefinitionsManager
extends LazyScriptDefinitionProvider {
    private Map<ScriptDefinitionContributor, List<KotlinScriptDefinition>> definitionsByContributor;
    private Sequence<? extends KotlinScriptDefinition> definitions;
    private final Project project;
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void reloadDefinitionsBy(@NotNull ScriptDefinitionContributor contributor) {
        int n;
        Intrinsics.checkParameterIsNotNull((Object)contributor, (String)"contributor");
        ReentrantReadWriteLock reentrantReadWriteLock = this.getLock();
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n2 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        int n3 = 0;
        int n4 = n2;
        while (n3 < n4) {
            n = n3++;
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            if (this.definitions == null) {
                return;
            }
            Map<ScriptDefinitionContributor, List<KotlinScriptDefinition>> map2 = this.definitionsByContributor;
            Object object = map2;
            ScriptDefinitionContributor scriptDefinitionContributor = contributor;
            if (!object.containsKey(scriptDefinitionContributor)) {
                map2 = "Unknown contributor: " + contributor.getId();
                throw (Throwable)new IllegalStateException(map2.toString());
            }
            map2 = this.definitionsByContributor;
            scriptDefinitionContributor = contributor;
            object = this.safeGetDefinitions(contributor);
            map2.put(scriptDefinitionContributor, (List<KotlinScriptDefinition>)object);
            this.updateDefinitions();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            n = 0;
            int n5 = n2;
            while (n < n5) {
                int n6 = n++;
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<KotlinScriptDefinition> getDefinitionsBy(@NotNull ScriptDefinitionContributor contributor) {
        int n;
        Intrinsics.checkParameterIsNotNull((Object)contributor, (String)"contributor");
        ReentrantReadWriteLock reentrantReadWriteLock = this.getLock();
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n2 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        int n3 = 0;
        int n4 = n2;
        while (n3 < n4) {
            n = n3++;
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            if (this.definitions == null) {
                List list2 = CollectionsKt.emptyList();
                return list2;
            }
            Map<ScriptDefinitionContributor, List<KotlinScriptDefinition>> map2 = this.definitionsByContributor;
            Map<ScriptDefinitionContributor, List<KotlinScriptDefinition>> map3 = map2;
            ScriptDefinitionContributor scriptDefinitionContributor = contributor;
            if (!map3.containsKey(scriptDefinitionContributor)) {
                map2 = "Unknown contributor: " + contributor.getId();
                throw (Throwable)new IllegalStateException(map2.toString());
            }
            List list3 = this.definitionsByContributor.get(contributor);
            if (list3 == null) {
                list3 = CollectionsKt.emptyList();
            }
            List list4 = list3;
            return list4;
        }
        finally {
            n = 0;
            int n5 = n2;
            while (n < n5) {
                int n6 = n++;
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    @Override
    @NotNull
    protected Sequence<KotlinScriptDefinition> getCurrentDefinitions() {
        Sequence<? extends KotlinScriptDefinition> sequence2 = this.definitions;
        if (sequence2 == null) {
            this.reloadScriptDefinitions();
            sequence2 = this.definitions;
            if (sequence2 == null) {
                Intrinsics.throwNpe();
            }
        }
        return sequence2;
    }

    /*
     * WARNING - void declaration
     */
    private final List<ScriptDefinitionContributor> getContributors() {
        void $receiver$iv$iv;
        ExtensionPoint extensionPoint = Extensions.getArea((AreaInstance)((AreaInstance)this.project)).getExtensionPoint(ScriptTemplatesProvider.Companion.getEP_NAME());
        Intrinsics.checkExpressionValueIsNotNull((Object)extensionPoint, (String)"Extensions.getArea(proje\u2026emplatesProvider.EP_NAME)");
        Object[] objectArray = extensionPoint.getExtensions();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"Extensions.getArea(proje\u2026vider.EP_NAME).extensions");
        Iterable $receiver$iv = ArraysKt.toList((Object[])objectArray);
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void p1;
            ScriptTemplatesProvider scriptTemplatesProvider = (ScriptTemplatesProvider)item$iv$iv;
            Collection collection = destination$iv$iv;
            ScriptTemplatesProviderAdapter scriptTemplatesProviderAdapter = new ScriptTemplatesProviderAdapter((ScriptTemplatesProvider)p1);
            collection.add(scriptTemplatesProviderAdapter);
        }
        List fromDeprecatedEP = (List)destination$iv$iv;
        ExtensionPoint extensionPoint2 = Extensions.getArea((AreaInstance)((AreaInstance)this.project)).getExtensionPoint(ScriptDefinitionContributor.Companion.getEP_NAME());
        Intrinsics.checkExpressionValueIsNotNull((Object)extensionPoint2, (String)"Extensions.getArea(proje\u2026itionContributor.EP_NAME)");
        Object[] objectArray2 = extensionPoint2.getExtensions();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray2, (String)"Extensions.getArea(proje\u2026butor.EP_NAME).extensions");
        List fromNewEp = ArraysKt.toList((Object[])objectArray2);
        return CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.dropLast((List)fromNewEp, (int)1), (Iterable)fromDeprecatedEP), (Object)CollectionsKt.last((List)fromNewEp));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void reloadScriptDefinitions() {
        int n;
        ReentrantReadWriteLock reentrantReadWriteLock = this.getLock();
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n2 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        int n3 = 0;
        int n4 = n2;
        while (n3 < n4) {
            n = n3++;
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            for (ScriptDefinitionContributor contributor : this.getContributors()) {
                List<KotlinScriptDefinition> definitions = this.safeGetDefinitions(contributor);
                Map<ScriptDefinitionContributor, List<KotlinScriptDefinition>> map2 = this.definitionsByContributor;
                List<KotlinScriptDefinition> list2 = definitions;
                map2.put(contributor, list2);
            }
            this.updateDefinitions();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            n = 0;
            int n5 = n2;
            while (n < n5) {
                int n6 = n++;
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isInExpectedLocation(@NotNull KtFile ktFile, @NotNull KotlinScriptDefinition scriptDefinition2) {
        Intrinsics.checkParameterIsNotNull((Object)ktFile, (String)"ktFile");
        Intrinsics.checkParameterIsNotNull((Object)((Object)scriptDefinition2), (String)"scriptDefinition");
        if (ScratchFileService.isInScratchRoot((VirtualFile)ktFile.getVirtualFile())) {
            return true;
        }
        List<ScriptExpectedLocation> scriptScope = scriptDefinition2.getScriptExpectedLocations();
        if (scriptScope.contains(ScriptExpectedLocation.Everywhere)) {
            return true;
        }
        if (scriptScope.contains(ScriptExpectedLocation.Project)) {
            ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)ktFile.getProject());
            Intrinsics.checkExpressionValueIsNotNull((Object)projectRootManager, (String)"ProjectRootManager.getInstance(ktFile.project)");
            if (projectRootManager.getFileIndex().isInContent(ktFile.getVirtualFile())) {
                return true;
            }
        }
        if (!scriptScope.contains(ScriptExpectedLocation.TestsOnly)) return ProjectRootsUtil.isInContent((PsiElement)ktFile, scriptScope.contains(ScriptExpectedLocation.SourcesOnly), scriptScope.contains(ScriptExpectedLocation.Libraries), scriptScope.contains(ScriptExpectedLocation.Libraries), scriptScope.contains(ScriptExpectedLocation.Libraries));
        if (!com.intellij.ide.projectView.impl.ProjectRootsUtil.isInTestSource((PsiFile)((PsiFile)ktFile))) return ProjectRootsUtil.isInContent((PsiElement)ktFile, scriptScope.contains(ScriptExpectedLocation.SourcesOnly), scriptScope.contains(ScriptExpectedLocation.Libraries), scriptScope.contains(ScriptExpectedLocation.Libraries), scriptScope.contains(ScriptExpectedLocation.Libraries));
        return true;
    }

    private final void updateDefinitions() {
        boolean bl = this.getLock().isWriteLocked();
        if (_Assertions.ENABLED && !bl) {
            String string = "updateDefinitions should only be called under the write lock";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        Iterable iterable = this.definitionsByContributor.values();
        ScriptDefinitionsManager scriptDefinitionsManager = this;
        List list2 = new ArrayList();
        scriptDefinitionsManager.definitions = CollectionsKt.asSequence((Iterable)AddToStdlibKt.flattenTo(iterable, (Collection)list2));
        this.clearCache();
        ((ScriptDependenciesCache)ServiceManager.getService((Project)this.project, ScriptDependenciesCache.class)).clear();
    }

    private final List<KotlinScriptDefinition> safeGetDefinitions(@NotNull ScriptDefinitionContributor $receiver) {
        List list2;
        try {
            list2 = $receiver.getDefinitions();
        }
        catch (Throwable t) {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    public ScriptDefinitionsManager(@NotNull Project project) {
        Map map2;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
        ScriptDefinitionsManager scriptDefinitionsManager = this;
        scriptDefinitionsManager.definitionsByContributor = map2 = (Map)new LinkedHashMap();
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/ScriptDefinitionsManager$Companion;", "", "()V", "getInstance", "Lorg/jetbrains/kotlin/idea/core/script/ScriptDefinitionsManager;", "project", "Lcom/intellij/openapi/project/Project;", "idea-core"})
    public static final class Companion {
        @NotNull
        public final ScriptDefinitionsManager getInstance(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Object object = ServiceManager.getService((Project)project, ScriptDefinitionProvider.class);
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.idea.core.script.ScriptDefinitionsManager");
            }
            return (ScriptDefinitionsManager)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

