/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.script;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.Alarm;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.script.experimental.dependencies.ScriptDependencies;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.idea.core.script.ScriptDefinitionsManager;
import org.jetbrains.kotlin.idea.core.script.ScriptDependenciesCache;
import org.jetbrains.kotlin.idea.core.script.ScriptDependenciesUpdater;
import org.jetbrains.kotlin.idea.core.script.ScriptDependenciesUpdaterKt;
import org.jetbrains.kotlin.idea.core.script.dependencies.FromFileAttributeScriptDependenciesLoader;
import org.jetbrains.kotlin.idea.core.script.dependencies.ScriptDependenciesLoader;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.script.KotlinScriptDefinition;
import org.jetbrains.kotlin.script.KotlinScriptDefinitionProviderKt;
import org.jetbrains.kotlin.script.ScriptDefinitionProvider;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\b\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/ScriptDependenciesUpdater;", "", "project", "Lcom/intellij/openapi/project/Project;", "cache", "Lorg/jetbrains/kotlin/idea/core/script/ScriptDependenciesCache;", "scriptDefinitionProvider", "Lorg/jetbrains/kotlin/script/ScriptDefinitionProvider;", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/kotlin/idea/core/script/ScriptDependenciesCache;Lorg/jetbrains/kotlin/script/ScriptDefinitionProvider;)V", "scriptChangesListenerDelay", "", "scriptsQueue", "Lcom/intellij/util/Alarm;", "getCurrentDependencies", "Lkotlin/script/experimental/dependencies/ScriptDependencies;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "listenForChangesInScripts", "", "idea-core"})
public final class ScriptDependenciesUpdater {
    private final Alarm scriptsQueue;
    private final int scriptChangesListenerDelay = 1400;
    private final Project project;
    private final ScriptDependenciesCache cache;
    private final ScriptDefinitionProvider scriptDefinitionProvider;

    @NotNull
    public final ScriptDependencies getCurrentDependencies(@NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        ScriptDependencies scriptDependencies2 = this.cache.get(file);
        if (scriptDependencies2 != null) {
            ScriptDependencies scriptDependencies3;
            ScriptDependencies it = scriptDependencies3 = scriptDependencies2;
            return it;
        }
        KotlinScriptDefinition kotlinScriptDefinition = KotlinScriptDefinitionProviderKt.findScriptDefinition(this.scriptDefinitionProvider, file);
        if (kotlinScriptDefinition == null) {
            return ScriptDependencies.Companion.getEmpty();
        }
        KotlinScriptDefinition scriptDef = kotlinScriptDefinition;
        new FromFileAttributeScriptDependenciesLoader(file, scriptDef, this.project).updateDependencies();
        ScriptDependenciesLoader.Companion.updateDependencies(file, scriptDef, this.project, false);
        ScriptDependencies scriptDependencies4 = this.cache.get(file);
        if (scriptDependencies4 == null) {
            scriptDependencies4 = ScriptDependencies.Companion.getEmpty();
        }
        return scriptDependencies4;
    }

    private final void listenForChangesInScripts() {
        this.project.getMessageBus().connect().subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener(this){
            final /* synthetic */ ScriptDependenciesUpdater this$0;

            public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
                Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
                Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
                this.runScriptDependenciesUpdateIfNeeded(file);
            }

            public void selectionChanged(@NotNull FileEditorManagerEvent event) {
                block0: {
                    VirtualFile virtualFile;
                    VirtualFile it;
                    Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                    VirtualFile virtualFile2 = event.getNewFile();
                    if (virtualFile2 == null) break block0;
                    VirtualFile virtualFile3 = it = (virtualFile = virtualFile2);
                    Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile3, (String)"it");
                    this.runScriptDependenciesUpdateIfNeeded(virtualFile3);
                }
            }

            private final void runScriptDependenciesUpdateIfNeeded(VirtualFile file) {
                if (Intrinsics.areEqual((Object)file.getFileType(), (Object)((Object)KotlinFileType.INSTANCE)) ^ true) {
                    return;
                }
                KotlinScriptDefinition kotlinScriptDefinition = KotlinScriptDefinitionProviderKt.findScriptDefinition(ScriptDependenciesUpdater.access$getScriptDefinitionProvider$p(this.this$0), file);
                if (kotlinScriptDefinition == null) {
                    return;
                }
                KotlinScriptDefinition scriptDef = kotlinScriptDefinition;
                PsiFile psiFile = PsiManager.getInstance((Project)ScriptDependenciesUpdater.access$getProject$p(this.this$0)).findFile(file);
                if (!(psiFile instanceof KtFile)) {
                    psiFile = null;
                }
                KtFile ktFile = (KtFile)psiFile;
                if (ktFile == null) {
                    return;
                }
                KtFile ktFile2 = ktFile;
                if (!ScriptDefinitionsManager.Companion.getInstance(ScriptDependenciesUpdater.access$getProject$p(this.this$0)).isInExpectedLocation(ktFile2, scriptDef)) {
                    return;
                }
                ScriptDependenciesLoader.Companion.updateDependencies(file, scriptDef, ScriptDependenciesUpdater.access$getProject$p(this.this$0), true);
            }
            {
                this.this$0 = $outer;
            }
        });
        EditorFactory editorFactory = EditorFactory.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)editorFactory, (String)"EditorFactory.getInstance()");
        editorFactory.getEventMulticaster().addDocumentListener(new DocumentListener(this){
            final /* synthetic */ ScriptDependenciesUpdater this$0;

            public void documentChanged(@NotNull DocumentEvent event) {
                VirtualFile file;
                Object object;
                Document document;
                block13: {
                    block12: {
                        VirtualFile virtualFile;
                        VirtualFile it;
                        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                        if (ScriptDependenciesUpdater.access$getProject$p(this.this$0).isDisposed()) {
                            return;
                        }
                        Application application = ApplicationManager.getApplication();
                        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
                        if (application.isUnitTestMode()) {
                            Application application2 = ApplicationManager.getApplication();
                            Intrinsics.checkExpressionValueIsNotNull((Object)application2, (String)"ApplicationManager.getApplication()");
                            if (Intrinsics.areEqual((Object)ScriptDependenciesUpdaterKt.isScriptDependenciesUpdaterDisabled(application2), (Object)true)) {
                                return;
                            }
                        }
                        document = event.getDocument();
                        object = FileDocumentManager.getInstance().getFile(document);
                        if (object == null) break block12;
                        VirtualFile virtualFile2 = it = (virtualFile = object);
                        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"it");
                        object = virtualFile2.isInLocalFileSystem() ? virtualFile : null;
                        if (object != null) break block13;
                    }
                    return;
                }
                VirtualFile virtualFile = file = object;
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"file");
                if (!virtualFile.isValid()) {
                    ScriptDependenciesUpdater.access$getCache$p(this.this$0).delete(file);
                    return;
                }
                if (ScriptDependenciesUpdater.access$getCache$p(this.this$0).get(file) == null) {
                    return;
                }
                KotlinScriptDefinition kotlinScriptDefinition = KotlinScriptDefinitionProviderKt.findScriptDefinition(ScriptDependenciesUpdater.access$getScriptDefinitionProvider$p(this.this$0), file);
                if (kotlinScriptDefinition == null) {
                    return;
                }
                KotlinScriptDefinition scriptDef = kotlinScriptDefinition;
                PsiFile psiFile = PsiManager.getInstance((Project)ScriptDependenciesUpdater.access$getProject$p(this.this$0)).findFile(file);
                if (!(psiFile instanceof KtFile)) {
                    psiFile = null;
                }
                KtFile ktFile = (KtFile)psiFile;
                if (ktFile == null) {
                    return;
                }
                KtFile ktFile2 = ktFile;
                if (!ScriptDefinitionsManager.Companion.getInstance(ScriptDependenciesUpdater.access$getProject$p(this.this$0)).isInExpectedLocation(ktFile2, scriptDef)) {
                    return;
                }
                ScriptDependenciesUpdater.access$getScriptsQueue$p(this.this$0).cancelAllRequests();
                ScriptDependenciesUpdater.access$getScriptsQueue$p(this.this$0).addRequest(new Runnable(this, document, file, scriptDef){
                    final /* synthetic */ listenForChangesInScripts.2 this$0;
                    final /* synthetic */ Document $document;
                    final /* synthetic */ VirtualFile $file;
                    final /* synthetic */ KotlinScriptDefinition $scriptDef;

                    public final void run() {
                        FileDocumentManager.getInstance().saveDocument(this.$document);
                        VirtualFile virtualFile = this.$file;
                        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"file");
                        ScriptDependenciesLoader.Companion.updateDependencies(virtualFile, this.$scriptDef, ScriptDependenciesUpdater.access$getProject$p(this.this$0.this$0), true);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$document = document;
                        this.$file = virtualFile;
                        this.$scriptDef = kotlinScriptDefinition;
                    }
                }, ScriptDependenciesUpdater.access$getScriptChangesListenerDelay$p(this.this$0), true);
            }
            {
                this.this$0 = $outer;
            }
        }, (Disposable)this.project.getMessageBus().connect());
    }

    public ScriptDependenciesUpdater(@NotNull Project project, @NotNull ScriptDependenciesCache cache2, @NotNull ScriptDefinitionProvider scriptDefinitionProvider) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)cache2, (String)"cache");
        Intrinsics.checkParameterIsNotNull((Object)scriptDefinitionProvider, (String)"scriptDefinitionProvider");
        this.project = project;
        this.cache = cache2;
        this.scriptDefinitionProvider = scriptDefinitionProvider;
        this.scriptsQueue = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)this.project);
        this.scriptChangesListenerDelay = 1400;
        this.listenForChangesInScripts();
    }

    @NotNull
    public static final /* synthetic */ ScriptDefinitionProvider access$getScriptDefinitionProvider$p(ScriptDependenciesUpdater $this) {
        return $this.scriptDefinitionProvider;
    }

    @NotNull
    public static final /* synthetic */ Project access$getProject$p(ScriptDependenciesUpdater $this) {
        return $this.project;
    }

    @NotNull
    public static final /* synthetic */ ScriptDependenciesCache access$getCache$p(ScriptDependenciesUpdater $this) {
        return $this.cache;
    }

    @NotNull
    public static final /* synthetic */ Alarm access$getScriptsQueue$p(ScriptDependenciesUpdater $this) {
        return $this.scriptsQueue;
    }

    public static final /* synthetic */ int access$getScriptChangesListenerDelay$p(ScriptDependenciesUpdater $this) {
        return $this.scriptChangesListenerDelay;
    }
}

