/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.decompiler.classFile;

import com.intellij.openapi.vfs.VirtualFile;
import java.io.InputStream;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.caches.IDEKotlinBinaryClassCache;
import org.jetbrains.kotlin.idea.decompiler.classFile.ClassFileDecompilerUtilKt;
import org.jetbrains.kotlin.load.java.structure.JavaClass;
import org.jetbrains.kotlin.load.java.structure.JavaElementsKt;
import org.jetbrains.kotlin.load.kotlin.KotlinClassFinder;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u0005H\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0005H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/decompiler/classFile/DirectoryBasedClassFinder;", "Lorg/jetbrains/kotlin/load/kotlin/KotlinClassFinder;", "packageDirectory", "Lcom/intellij/openapi/vfs/VirtualFile;", "directoryPackageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "(Lcom/intellij/openapi/vfs/VirtualFile;Lorg/jetbrains/kotlin/name/FqName;)V", "getDirectoryPackageFqName", "()Lorg/jetbrains/kotlin/name/FqName;", "getPackageDirectory", "()Lcom/intellij/openapi/vfs/VirtualFile;", "findBuiltInsData", "Ljava/io/InputStream;", "packageFqName", "findKotlinClass", "Lorg/jetbrains/kotlin/load/kotlin/KotlinJvmBinaryClass;", "javaClass", "Lorg/jetbrains/kotlin/load/java/structure/JavaClass;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "findMetadata", "hasMetadataPackage", "", "fqName", "idea-core"})
public final class DirectoryBasedClassFinder
implements KotlinClassFinder {
    @NotNull
    private final VirtualFile packageDirectory;
    @NotNull
    private final FqName directoryPackageFqName;

    @Override
    @Nullable
    public KotlinJvmBinaryClass findKotlinClass(@NotNull JavaClass javaClass) {
        Intrinsics.checkParameterIsNotNull((Object)javaClass, (String)"javaClass");
        ClassId classId = JavaElementsKt.getClassId(javaClass);
        if (classId == null) {
            Intrinsics.throwNpe();
        }
        return this.findKotlinClass(classId);
    }

    @Override
    @Nullable
    public KotlinJvmBinaryClass findKotlinClass(@NotNull ClassId classId) {
        Intrinsics.checkParameterIsNotNull((Object)classId, (String)"classId");
        if (Intrinsics.areEqual((Object)classId.getPackageFqName(), (Object)this.directoryPackageFqName) ^ true) {
            return null;
        }
        List<Name> list2 = classId.getRelativeClassName().pathSegments();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"classId.relativeClassName.pathSegments()");
        String targetName = CollectionsKt.joinToString$default((Iterable)list2, (CharSequence)"$", null, (CharSequence)".class", (int)0, null, null, (int)58, null);
        VirtualFile virtualFile = this.packageDirectory.findChild(targetName);
        if (virtualFile != null && ClassFileDecompilerUtilKt.isKotlinWithCompatibleAbiVersion(virtualFile)) {
            return IDEKotlinBinaryClassCache.getKotlinBinaryClass$default(IDEKotlinBinaryClassCache.INSTANCE, virtualFile, null, 2, null);
        }
        return null;
    }

    @Override
    @Nullable
    public InputStream findMetadata(@NotNull ClassId classId) {
        Intrinsics.checkParameterIsNotNull((Object)classId, (String)"classId");
        return null;
    }

    @Override
    public boolean hasMetadataPackage(@NotNull FqName fqName2) {
        Intrinsics.checkParameterIsNotNull((Object)fqName2, (String)"fqName");
        return false;
    }

    @Override
    @Nullable
    public InputStream findBuiltInsData(@NotNull FqName packageFqName) {
        Intrinsics.checkParameterIsNotNull((Object)packageFqName, (String)"packageFqName");
        return null;
    }

    @NotNull
    public final VirtualFile getPackageDirectory() {
        return this.packageDirectory;
    }

    @NotNull
    public final FqName getDirectoryPackageFqName() {
        return this.directoryPackageFqName;
    }

    public DirectoryBasedClassFinder(@NotNull VirtualFile packageDirectory, @NotNull FqName directoryPackageFqName) {
        Intrinsics.checkParameterIsNotNull((Object)packageDirectory, (String)"packageDirectory");
        Intrinsics.checkParameterIsNotNull((Object)directoryPackageFqName, (String)"directoryPackageFqName");
        this.packageDirectory = packageDirectory;
        this.directoryPackageFqName = directoryPackageFqName;
    }
}

