/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.decompiler.common;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiManager;
import com.intellij.psi.compiled.ClassFileDecompilers;
import java.io.IOException;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.decompiler.KotlinDecompiledFileViewProvider;
import org.jetbrains.kotlin.idea.decompiler.KtDecompiledFile;
import org.jetbrains.kotlin.idea.decompiler.common.FileWithMetadata;
import org.jetbrains.kotlin.idea.decompiler.common.IncompatibleAbiVersionKt;
import org.jetbrains.kotlin.idea.decompiler.common.KotlinMetadataDecompiler;
import org.jetbrains.kotlin.idea.decompiler.common.KotlinMetadataDeserializerForDecompiler;
import org.jetbrains.kotlin.idea.decompiler.common.KotlinMetadataStubBuilder;
import org.jetbrains.kotlin.idea.decompiler.textBuilder.BuildDecompiledTextKt;
import org.jetbrains.kotlin.idea.decompiler.textBuilder.DecompiledText;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.BinaryVersion;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.renderer.DescriptorRendererOptions;
import org.jetbrains.kotlin.resolve.TargetPlatform;
import org.jetbrains.kotlin.serialization.SerializerExtensionProtocol;
import org.jetbrains.kotlin.serialization.deserialization.FlexibleTypeDeserializer;
import org.jetbrains.kotlin.serialization.deserialization.NameResolverUtilKt;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\b&\u0018\u0000*\n\b\u0000\u0010\u0001 \u0001*\u00020\u00022\u00020\u0003B=\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00028\u0000\u0012\u0006\u0010\r\u001a\u00028\u0000\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0019H\u0002J \u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0017H\u0016J\b\u0010\"\u001a\u00020\u0015H\u0016J\u001a\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020&2\u0006\u0010\u0018\u001a\u00020\u0019H&J\u001e\u0010'\u001a\u0004\u0018\u00010$2\u0006\u0010\u0018\u001a\u00020\u00192\n\b\u0002\u0010(\u001a\u0004\u0018\u00010&H\u0002R\u0010\u0010\f\u001a\u00028\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00028\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/idea/decompiler/common/KotlinMetadataDecompiler;", "V", "Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;", "Lcom/intellij/psi/compiled/ClassFileDecompilers$Full;", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "targetPlatform", "Lorg/jetbrains/kotlin/resolve/TargetPlatform;", "serializerProtocol", "Lorg/jetbrains/kotlin/serialization/SerializerExtensionProtocol;", "flexibleTypeDeserializer", "Lorg/jetbrains/kotlin/serialization/deserialization/FlexibleTypeDeserializer;", "expectedBinaryVersion", "invalidBinaryVersion", "stubVersion", "", "(Lcom/intellij/openapi/fileTypes/FileType;Lorg/jetbrains/kotlin/resolve/TargetPlatform;Lorg/jetbrains/kotlin/serialization/SerializerExtensionProtocol;Lorg/jetbrains/kotlin/serialization/deserialization/FlexibleTypeDeserializer;Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;I)V", "Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;", "renderer", "Lorg/jetbrains/kotlin/renderer/DescriptorRenderer;", "stubBuilder", "Lorg/jetbrains/kotlin/idea/decompiler/common/KotlinMetadataStubBuilder;", "accepts", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "buildDecompiledText", "Lorg/jetbrains/kotlin/idea/decompiler/textBuilder/DecompiledText;", "virtualFile", "createFileViewProvider", "Lcom/intellij/psi/FileViewProvider;", "manager", "Lcom/intellij/psi/PsiManager;", "physical", "getStubBuilder", "readFile", "Lorg/jetbrains/kotlin/idea/decompiler/common/FileWithMetadata;", "bytes", "", "readFileSafely", "content", "idea-core"})
public abstract class KotlinMetadataDecompiler<V extends BinaryVersion>
extends ClassFileDecompilers.Full {
    private final KotlinMetadataStubBuilder stubBuilder;
    private final DescriptorRenderer renderer;
    private final FileType fileType;
    private final TargetPlatform targetPlatform;
    private final SerializerExtensionProtocol serializerProtocol;
    private final FlexibleTypeDeserializer flexibleTypeDeserializer;
    private final V expectedBinaryVersion;
    private final V invalidBinaryVersion;

    @Nullable
    public abstract FileWithMetadata readFile(@NotNull byte[] var1, @NotNull VirtualFile var2);

    public boolean accepts(@NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return Intrinsics.areEqual((Object)file.getFileType(), (Object)this.fileType);
    }

    @NotNull
    public KotlinMetadataStubBuilder getStubBuilder() {
        return this.stubBuilder;
    }

    @NotNull
    public FileViewProvider createFileViewProvider(@NotNull VirtualFile file, @NotNull PsiManager manager, boolean physical) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)manager, (String)"manager");
        return (FileViewProvider)new KotlinDecompiledFileViewProvider(manager, file, physical, (Function1<? super KotlinDecompiledFileViewProvider, ? extends KtDecompiledFile>)((Function1)new Function1<KotlinDecompiledFileViewProvider, KtDecompiledFile>(this){
            final /* synthetic */ KotlinMetadataDecompiler this$0;

            @Nullable
            public final KtDecompiledFile invoke(@NotNull KotlinDecompiledFileViewProvider provider2) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)provider2), (String)"provider");
                VirtualFile virtualFile = provider2.getVirtualFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"provider.virtualFile");
                return KotlinMetadataDecompiler.readFileSafely$default(this.this$0, virtualFile, null, 2, null) == null ? null : new KtDecompiledFile(provider2, (Function1<? super VirtualFile, DecompiledText>)((Function1)new Function1<VirtualFile, DecompiledText>(this.this$0){

                    @NotNull
                    public final DecompiledText invoke(@NotNull VirtualFile p1) {
                        Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                        return KotlinMetadataDecompiler.access$buildDecompiledText((KotlinMetadataDecompiler)((Object)this.receiver), p1);
                    }

                    public final KDeclarationContainer getOwner() {
                        return Reflection.getOrCreateKotlinClass(KotlinMetadataDecompiler.class);
                    }

                    public final String getName() {
                        return "buildDecompiledText";
                    }

                    public final String getSignature() {
                        return "buildDecompiledText(Lcom/intellij/openapi/vfs/VirtualFile;)Lorg/jetbrains/kotlin/idea/decompiler/textBuilder/DecompiledText;";
                    }
                }));
            }
            {
                this.this$0 = kotlinMetadataDecompiler;
                super(1);
            }
        }));
    }

    private final FileWithMetadata readFileSafely(VirtualFile file, byte[] content2) {
        FileWithMetadata fileWithMetadata;
        if (!file.isValid()) {
            return null;
        }
        try {
            byte[] byArray = content2;
            if (content2 == null) {
                byte[] byArray2 = file.contentsToByteArray(false);
                byArray = byArray2;
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"file.contentsToByteArray(false)");
            }
            fileWithMetadata = this.readFile(byArray, file);
        }
        catch (IOException e) {
            fileWithMetadata = null;
        }
        return fileWithMetadata;
    }

    static /* bridge */ /* synthetic */ FileWithMetadata readFileSafely$default(KotlinMetadataDecompiler kotlinMetadataDecompiler, VirtualFile virtualFile, byte[] byArray, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: readFileSafely");
        }
        if ((n & 2) != 0) {
            byArray = null;
        }
        return kotlinMetadataDecompiler.readFileSafely(virtualFile, byArray);
    }

    private final DecompiledText buildDecompiledText(VirtualFile virtualFile) {
        DecompiledText decompiledText2;
        if (Intrinsics.areEqual((Object)virtualFile.getFileType(), (Object)this.fileType) ^ true) {
            String string = "Unexpected file type " + virtualFile.getFileType();
            throw (Throwable)new IllegalStateException(string.toString());
        }
        FileWithMetadata file = KotlinMetadataDecompiler.readFileSafely$default(this, virtualFile, null, 2, null);
        FileWithMetadata fileWithMetadata = file;
        if (fileWithMetadata == null) {
            decompiledText2 = IncompatibleAbiVersionKt.createIncompatibleAbiVersionDecompiledText(this.expectedBinaryVersion, this.invalidBinaryVersion);
        } else if (fileWithMetadata instanceof FileWithMetadata.Incompatible) {
            decompiledText2 = IncompatibleAbiVersionKt.createIncompatibleAbiVersionDecompiledText(this.expectedBinaryVersion, ((FileWithMetadata.Incompatible)file).getVersion());
        } else if (fileWithMetadata instanceof FileWithMetadata.Compatible) {
            FqName packageFqName = ((FileWithMetadata.Compatible)file).getPackageFqName();
            KotlinMetadataDeserializerForDecompiler resolver2 = new KotlinMetadataDeserializerForDecompiler(packageFqName, ((FileWithMetadata.Compatible)file).getProto(), ((FileWithMetadata.Compatible)file).getNameResolver(), this.targetPlatform, this.serializerProtocol, this.flexibleTypeDeserializer);
            ArrayList declarations2 = new ArrayList();
            declarations2.addAll(resolver2.resolveDeclarationsInFacade(packageFqName));
            for (ProtoBuf.Class classProto : ((FileWithMetadata.Compatible)file).getClassesToDecompile()) {
                ClassId classId = NameResolverUtilKt.getClassId(((FileWithMetadata.Compatible)file).getNameResolver(), classProto.getFqName());
                CollectionsKt.addIfNotNull(declarations2, resolver2.resolveTopLevelClass(classId));
            }
            decompiledText2 = BuildDecompiledTextKt.buildDecompiledText$default(packageFqName, declarations2, this.renderer, null, 8, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return decompiledText2;
    }

    public KotlinMetadataDecompiler(@NotNull FileType fileType, @NotNull TargetPlatform targetPlatform, @NotNull SerializerExtensionProtocol serializerProtocol, @NotNull FlexibleTypeDeserializer flexibleTypeDeserializer, @NotNull V expectedBinaryVersion, @NotNull V invalidBinaryVersion, int stubVersion) {
        Intrinsics.checkParameterIsNotNull((Object)fileType, (String)"fileType");
        Intrinsics.checkParameterIsNotNull((Object)targetPlatform, (String)"targetPlatform");
        Intrinsics.checkParameterIsNotNull((Object)serializerProtocol, (String)"serializerProtocol");
        Intrinsics.checkParameterIsNotNull((Object)flexibleTypeDeserializer, (String)"flexibleTypeDeserializer");
        Intrinsics.checkParameterIsNotNull(expectedBinaryVersion, (String)"expectedBinaryVersion");
        Intrinsics.checkParameterIsNotNull(invalidBinaryVersion, (String)"invalidBinaryVersion");
        this.fileType = fileType;
        this.targetPlatform = targetPlatform;
        this.serializerProtocol = serializerProtocol;
        this.flexibleTypeDeserializer = flexibleTypeDeserializer;
        this.expectedBinaryVersion = expectedBinaryVersion;
        this.invalidBinaryVersion = invalidBinaryVersion;
        this.stubBuilder = new KotlinMetadataStubBuilder(stubVersion, this.fileType, this.serializerProtocol, (Function2<? super VirtualFile, ? super byte[], ? extends FileWithMetadata>)((Function2)new Function2<VirtualFile, byte[], FileWithMetadata>(this){

            @Nullable
            public final FileWithMetadata invoke(@NotNull VirtualFile p1, @Nullable byte[] p2) {
                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                return KotlinMetadataDecompiler.access$readFileSafely((KotlinMetadataDecompiler)((Object)this.receiver), p1, p2);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(KotlinMetadataDecompiler.class);
            }

            public final String getName() {
                return "readFileSafely";
            }

            public final String getSignature() {
                return "readFileSafely(Lcom/intellij/openapi/vfs/VirtualFile;[B)Lorg/jetbrains/kotlin/idea/decompiler/common/FileWithMetadata;";
            }
        }));
        this.renderer = DescriptorRenderer.Companion.withOptions((Function1<? super DescriptorRendererOptions, Unit>)((Function1)renderer.1.INSTANCE));
    }

    @NotNull
    public static final /* synthetic */ DecompiledText access$buildDecompiledText(KotlinMetadataDecompiler $this, @NotNull VirtualFile virtualFile) {
        return $this.buildDecompiledText(virtualFile);
    }

    @Nullable
    public static final /* synthetic */ FileWithMetadata access$readFileSafely(KotlinMetadataDecompiler $this, @NotNull VirtualFile file, @Nullable byte[] content2) {
        return $this.readFileSafely(file, content2);
    }
}

