/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.decompiler.navigation;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StringStubIndexExtension;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.caches.project.BinaryModuleInfo;
import org.jetbrains.kotlin.idea.caches.project.GetModuleInfoKt;
import org.jetbrains.kotlin.idea.caches.project.LibrarySourceInfo;
import org.jetbrains.kotlin.idea.caches.project.SourceForBinaryModuleInfo;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.decompiler.navigation.MemberMatching;
import org.jetbrains.kotlin.idea.decompiler.navigation.SourceNavigationHelper$WhenMappings;
import org.jetbrains.kotlin.idea.decompiler.navigation.SourceNavigationHelperKt;
import org.jetbrains.kotlin.idea.stubindex.KotlinFullClassNameIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinTopLevelFunctionFqnNameIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinTopLevelPropertyFqnNameIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinTopLevelTypeAliasFqNameIndex;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtil;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationStub;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwner;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.debugText.DebugTextUtilKt;
import org.jetbrains.kotlin.resolve.TargetPlatform;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u000267B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0002J7\u0010\u000f\u001a\u0004\u0018\u0001H\u0010\"\b\b\u0000\u0010\u0010*\u00020\b2\u0006\u0010\u0011\u001a\u0002H\u00102\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00100\u0013H\u0002\u00a2\u0006\u0002\u0010\u0014J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u0010\u001a\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u00132\u0006\u0010\u001b\u001a\u00020\bH\u0002J.\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\b0\u001d2\u0006\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020\u00172\u000e\u0010 \u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0!H\u0002J\u001e\u0010\"\u001a\b\u0012\u0004\u0012\u00020\b0#2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u000e\u0010$\u001a\u00020%2\u0006\u0010\t\u001a\u00020%J\u0010\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010(\u001a\u00020\rJ\u000e\u0010)\u001a\u00020%2\u0006\u0010\t\u001a\u00020%J\u0016\u0010*\u001a\u00020\u00062\f\u0010+\u001a\b\u0012\u0004\u0012\u00020,0#H\u0002J\u0018\u0010-\u001a\u00020%2\u0006\u0010.\u001a\u00020%2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u000e\u0010/\u001a\u0002002\u0006\u0010\u0005\u001a\u00020\u0006J\u001e\u00101\u001a\b\u0012\u0004\u0012\u0002020\u001d2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0012\u00103\u001a\b\u0012\u0004\u0012\u0002040\u001d*\u000204H\u0002J\u0018\u00105\u001a\b\u0012\u0004\u0012\u0002020\u001d*\b\u0012\u0004\u0012\u0002020#H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lorg/jetbrains/kotlin/idea/decompiler/navigation/SourceNavigationHelper;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "forceResolve", "", "convertPropertyOrFunction", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "declaration", "navigationKind", "Lorg/jetbrains/kotlin/idea/decompiler/navigation/SourceNavigationHelper$NavigationKind;", "findClassOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "decompiledClassOrObject", "findFirstMatchingInIndex", "T", "entity", "index", "Lcom/intellij/psi/stubs/StringStubIndexExtension;", "(Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;Lorg/jetbrains/kotlin/idea/decompiler/navigation/SourceNavigationHelper$NavigationKind;Lcom/intellij/psi/stubs/StringStubIndexExtension;)Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "findSpecialProperty", "memberName", "Lorg/jetbrains/kotlin/name/Name;", "containingClass", "Lorg/jetbrains/kotlin/psi/KtClass;", "getIndexForTopLevelPropertyOrFunction", "decompiledDeclaration", "getInitialMemberCandidates", "", "sourceClassOrObject", "name", "declarationClass", "Ljava/lang/Class;", "getInitialTopLevelCandidates", "", "getNavigationElement", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "getOriginalClass", "Lcom/intellij/psi/PsiClass;", "classOrObject", "getOriginalElement", "haveRenamesInImports", "files", "Lorg/jetbrains/kotlin/psi/KtFile;", "navigateToDeclaration", "from", "setForceResolve", "", "targetScopes", "Lcom/intellij/psi/search/GlobalSearchScope;", "associatedCommonLibraries", "Lorg/jetbrains/kotlin/idea/caches/project/BinaryModuleInfo;", "union", "NavigationKind", "SourceAndDecompiledConversionVisitor", "idea-core"})
public final class SourceNavigationHelper {
    private static final Logger LOG;
    private static boolean forceResolve;
    public static final SourceNavigationHelper INSTANCE;

    public final void setForceResolve(boolean forceResolve) {
        SourceNavigationHelper.forceResolve = forceResolve;
    }

    /*
     * WARNING - void declaration
     */
    private final List<GlobalSearchScope> targetScopes(KtNamedDeclaration declaration2, NavigationKind navigationKind) {
        List list2;
        KtFile containingFile;
        KtFile ktFile = containingFile = declaration2.getContainingKtFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)ktFile, (String)"containingFile");
        VirtualFile virtualFile = ktFile.getVirtualFile();
        if (virtualFile == null) {
            return CollectionsKt.emptyList();
        }
        VirtualFile vFile = virtualFile;
        switch (SourceNavigationHelper$WhenMappings.$EnumSwitchMapping$0[navigationKind.ordinal()]) {
            case 1: {
                Object element$iv$iv3;
                Iterable $receiver$iv$iv;
                Iterable $receiver$iv;
                Iterable $receiver$iv$iv2;
                void $receiver$iv2;
                Project project = declaration2.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"declaration.project");
                Collection<BinaryModuleInfo> binaryModuleInfos = GetModuleInfoKt.getBinaryLibrariesModuleInfos(project, vFile);
                Iterable iterable = binaryModuleInfos;
                SourceNavigationHelper sourceNavigationHelper = this;
                void var8_11 = $receiver$iv2;
                Collection destination$iv$iv = new ArrayList();
                void $receiver$iv$iv$iv = $receiver$iv$iv2;
                Iterator iterator2 = $receiver$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    GlobalSearchScope globalSearchScope;
                    Object element$iv$iv$iv;
                    Object element$iv$iv2 = element$iv$iv$iv = iterator2.next();
                    BinaryModuleInfo it = (BinaryModuleInfo)element$iv$iv2;
                    SourceForBinaryModuleInfo sourceForBinaryModuleInfo = it.getSourcesModuleInfo();
                    Object object = sourceForBinaryModuleInfo != null ? sourceForBinaryModuleInfo.sourceScope() : null;
                    if (object == null) continue;
                    GlobalSearchScope it$iv$iv = globalSearchScope = object;
                    destination$iv$iv.add(it$iv$iv);
                }
                List list3 = (List)destination$iv$iv;
                List<GlobalSearchScope> primaryScope = sourceNavigationHelper.union(list3);
                $receiver$iv$iv2 = binaryModuleInfos;
                sourceNavigationHelper = this;
                destination$iv$iv = $receiver$iv;
                Collection destination$iv$iv2 = new ArrayList();
                for (Object element$iv$iv3 : $receiver$iv$iv) {
                    BinaryModuleInfo it = (BinaryModuleInfo)element$iv$iv3;
                    Iterable list$iv$iv = INSTANCE.associatedCommonLibraries(it);
                    CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
                }
                list3 = (List)destination$iv$iv2;
                $receiver$iv$iv = $receiver$iv = (Iterable)list3;
                destination$iv$iv2 = new ArrayList();
                Iterable $receiver$iv$iv$iv2 = $receiver$iv$iv;
                element$iv$iv3 = $receiver$iv$iv$iv2.iterator();
                while (element$iv$iv3.hasNext()) {
                    GlobalSearchScope globalSearchScope;
                    Object element$iv$iv$iv;
                    Object element$iv$iv4 = element$iv$iv$iv = element$iv$iv3.next();
                    BinaryModuleInfo it = (BinaryModuleInfo)element$iv$iv4;
                    SourceForBinaryModuleInfo sourceForBinaryModuleInfo = it.getSourcesModuleInfo();
                    Object object = sourceForBinaryModuleInfo != null ? sourceForBinaryModuleInfo.sourceScope() : null;
                    if (object == null) continue;
                    GlobalSearchScope it$iv$iv = globalSearchScope = object;
                    destination$iv$iv2.add(it$iv$iv);
                }
                list3 = (List)destination$iv$iv2;
                List<GlobalSearchScope> additionalScope = sourceNavigationHelper.union(list3);
                list2 = CollectionsKt.plus((Collection)primaryScope, (Iterable)additionalScope);
                break;
            }
            case 2: {
                Collection<GlobalSearchScope> collection;
                void $receiver$iv$iv;
                void $receiver$iv;
                Project project = declaration2.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"declaration.project");
                Iterable binaryModuleInfos = GetModuleInfoKt.getLibrarySourcesModuleInfos(project, vFile);
                SourceNavigationHelper sourceNavigationHelper = this;
                void primaryScope = $receiver$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (Object item$iv$iv : $receiver$iv$iv) {
                    void it;
                    LibrarySourceInfo destination$iv$iv3 = (LibrarySourceInfo)item$iv$iv;
                    collection = destination$iv$iv;
                    GlobalSearchScope globalSearchScope = it.getBinariesModuleInfo().binariesScope();
                    collection.add(globalSearchScope);
                }
                collection = (List)destination$iv$iv;
                list2 = sourceNavigationHelper.union((Collection<? extends GlobalSearchScope>)collection);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return list2;
    }

    private final List<BinaryModuleInfo> associatedCommonLibraries(@NotNull BinaryModuleInfo $receiver) {
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        TargetPlatform platform2 = $receiver.getPlatform();
        if (platform2 == null || Intrinsics.areEqual((Object)platform2, (Object)TargetPlatform.Common.INSTANCE)) {
            return CollectionsKt.emptyList();
        }
        Iterable iterable = $receiver$iv = (Iterable)$receiver.dependencies();
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            if (!(element$iv$iv instanceof BinaryModuleInfo)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            BinaryModuleInfo it = (BinaryModuleInfo)element$iv$iv;
            if (!Intrinsics.areEqual((Object)it.getPlatform(), (Object)TargetPlatform.Common.INSTANCE)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final List<GlobalSearchScope> union(@NotNull Collection<? extends GlobalSearchScope> $receiver) {
        List list2;
        Collection<? extends GlobalSearchScope> collection = $receiver;
        if (!collection.isEmpty()) {
            Collection<? extends GlobalSearchScope> $receiver$iv;
            Collection<? extends GlobalSearchScope> collection2 = $receiver$iv = $receiver;
            if (collection2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
            }
            Collection<? extends GlobalSearchScope> thisCollection$iv = collection2;
            GlobalSearchScope[] globalSearchScopeArray = thisCollection$iv.toArray(new GlobalSearchScope[0]);
            if (globalSearchScopeArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            list2 = CollectionsKt.listOf((Object)GlobalSearchScope.union((GlobalSearchScope[])globalSearchScopeArray));
        } else {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    private final boolean haveRenamesInImports(Collection<? extends KtFile> files2) {
        boolean bl;
        block7: {
            Iterable $receiver$iv = files2;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    boolean bl2;
                    block6: {
                        KtFile it = (KtFile)element$iv;
                        Iterable $receiver$iv2 = it.getImportDirectives();
                        if ($receiver$iv2 instanceof Collection && ((Collection)$receiver$iv2).isEmpty()) {
                            bl2 = false;
                        } else {
                            for (Object element$iv2 : $receiver$iv2) {
                                KtImportDirective it2 = (KtImportDirective)element$iv2;
                                if (!(it2.getAliasName() != null)) continue;
                                bl2 = true;
                                break block6;
                            }
                            bl2 = false;
                        }
                    }
                    if (!bl2) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final KtNamedDeclaration findSpecialProperty(Name memberName2, KtClass containingClass) {
        List<KtParameter> constructorParameters = containingClass.getPrimaryConstructorParameters();
        for (KtParameter constructorParameter : constructorParameters) {
            if (!Intrinsics.areEqual((Object)memberName2, (Object)constructorParameter.getNameAsName()) || !constructorParameter.hasValOrVar()) continue;
            return constructorParameter;
        }
        if (containingClass.hasModifier(KtTokens.ENUM_KEYWORD)) {
            Iterator<KtParameter> iterator2 = ContainerUtil.findAll((Collection)containingClass.getDeclarations(), KtEnumEntry.class).iterator();
            while (iterator2.hasNext()) {
                KtEnumEntry enumEntry;
                KtEnumEntry ktEnumEntry = enumEntry = (KtEnumEntry)((Object)iterator2.next());
                Intrinsics.checkExpressionValueIsNotNull((Object)ktEnumEntry, (String)"enumEntry");
                if (!Intrinsics.areEqual((Object)memberName2, (Object)ktEnumEntry.getNameAsName())) continue;
                return enumEntry;
            }
        }
        return null;
    }

    private final KtNamedDeclaration convertPropertyOrFunction(KtNamedDeclaration declaration2, NavigationKind navigationKind) {
        Object decompiledClassOrObject;
        Collection candidates2;
        if (declaration2 instanceof KtPrimaryConstructor) {
            KtClassOrObject sourceClassOrObject = this.findClassOrObject(((KtPrimaryConstructor)declaration2).getContainingClassOrObject(), navigationKind);
            KtDeclarationStub ktDeclarationStub = sourceClassOrObject;
            return ktDeclarationStub != null && (ktDeclarationStub = ktDeclarationStub.getPrimaryConstructor()) != null ? (KtNamedDeclaration)((Object)ktDeclarationStub) : (KtNamedDeclaration)sourceClassOrObject;
        }
        String memberNameAsString = declaration2.getName();
        if (memberNameAsString == null) {
            LOG.debug("Declaration with null name:" + DebugTextUtilKt.getDebugText(declaration2));
            return null;
        }
        Name memberName2 = Name.identifier(memberNameAsString);
        PsiElement decompiledContainer = declaration2.getParent();
        PsiElement psiElement2 = decompiledContainer;
        if (psiElement2 instanceof KtFile) {
            candidates2 = this.getInitialTopLevelCandidates(declaration2, navigationKind);
        } else if (psiElement2 instanceof KtClassBody) {
            Object object;
            Object object2;
            Iterator iterator2;
            KtClassOrObject sourceClassOrObject;
            PsiElement psiElement3 = decompiledContainer.getParent();
            if (psiElement3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtClassOrObject");
            }
            decompiledClassOrObject = (KtClassOrObject)psiElement3;
            KtClassOrObject ktClassOrObject = sourceClassOrObject = this.findClassOrObject((KtClassOrObject)decompiledClassOrObject, navigationKind);
            if (ktClassOrObject != null) {
                iterator2 = ktClassOrObject;
                KtClassOrObject it = iterator2;
                Name name2 = memberName2;
                Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"memberName");
                object2 = INSTANCE.getInitialMemberCandidates(sourceClassOrObject, name2, declaration2.getClass());
            } else {
                object2 = iterator2 = null;
            }
            if ((object = iterator2) == null) {
                object = CollectionsKt.emptyList();
            }
            candidates2 = (Collection)object;
            if (candidates2.isEmpty() && declaration2 instanceof KtProperty && sourceClassOrObject instanceof KtClass) {
                Name name3 = memberName2;
                Intrinsics.checkExpressionValueIsNotNull((Object)name3, (String)"memberName");
                return this.findSpecialProperty(name3, (KtClass)sourceClassOrObject);
            }
        } else {
            throw (Throwable)new IllegalStateException("Unexpected container of " + (navigationKind == NavigationKind.CLASS_FILES_TO_SOURCES ? "decompiled" : "source") + " declaration: " + decompiledContainer.getClass().getSimpleName());
        }
        if (candidates2.isEmpty()) {
            return null;
        }
        if (!forceResolve) {
            KtNamedDeclaration it;
            Iterable $receiver$iv$iv;
            Iterable $receiver$iv = candidates2;
            decompiledClassOrObject = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                it = (KtNamedDeclaration)element$iv$iv;
                if (!MemberMatching.sameReceiverPresenceAndParametersCount(it, declaration2)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            candidates2 = (List)destination$iv$iv;
            if (candidates2.size() <= 1) {
                return (KtNamedDeclaration)CollectionsKt.firstOrNull((List)((List)candidates2));
            }
            if (!this.haveRenamesInImports(SourceNavigationHelperKt.access$getContainingFiles(candidates2))) {
                $receiver$iv$iv = $receiver$iv = (Iterable)candidates2;
                destination$iv$iv = new ArrayList();
                for (Object element$iv$iv : $receiver$iv$iv) {
                    it = (KtNamedDeclaration)element$iv$iv;
                    if (!MemberMatching.receiverAndParametersShortTypesMatch(it, declaration2)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                candidates2 = (List)destination$iv$iv;
                if (candidates2.size() <= 1) {
                    return (KtNamedDeclaration)CollectionsKt.firstOrNull((List)((List)candidates2));
                }
            }
        }
        for (KtNamedDeclaration candidate : candidates2) {
            CallableDescriptor candidateDescriptor;
            DeclarationDescriptor declarationDescriptor = ResolutionUtils.resolveToDescriptorIfAny$default(candidate, null, 1, null);
            if (!(declarationDescriptor instanceof CallableDescriptor)) {
                declarationDescriptor = null;
            }
            if ((CallableDescriptor)declarationDescriptor == null) {
                continue;
            }
            if (!MemberMatching.receiversMatch(declaration2, candidateDescriptor) || !MemberMatching.valueParametersTypesMatch(declaration2, candidateDescriptor)) continue;
            KtNamedDeclaration ktNamedDeclaration = declaration2;
            if (ktNamedDeclaration == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtTypeParameterListOwner");
            }
            if (!MemberMatching.typeParametersMatch((KtTypeParameterListOwner)ktNamedDeclaration, candidateDescriptor.getTypeParameters())) continue;
            return candidate;
        }
        return null;
    }

    private final <T extends KtNamedDeclaration> T findFirstMatchingInIndex(T entity, NavigationKind navigationKind, StringStubIndexExtension<T> index2) {
        KtNamedDeclaration ktNamedDeclaration;
        block2: {
            FqName fqName2 = entity.getFqName();
            if (fqName2 == null) {
                return null;
            }
            FqName classFqName = fqName2;
            Iterable $receiver$iv = this.targetScopes(entity, navigationKind);
            for (Object element$iv : $receiver$iv) {
                GlobalSearchScope it = (GlobalSearchScope)element$iv;
                Collection collection = index2.get((Object)classFqName.asString(), entity.getProject(), it);
                Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"index.get(classFqName.as\u2026ng(), entity.project, it)");
                KtNamedDeclaration result$iv = (KtNamedDeclaration)CollectionsKt.firstOrNull((Iterable)collection);
                if (result$iv == null) continue;
                ktNamedDeclaration = result$iv;
                break block2;
            }
            ktNamedDeclaration = null;
        }
        return (T)ktNamedDeclaration;
    }

    private final KtClassOrObject findClassOrObject(KtClassOrObject decompiledClassOrObject, NavigationKind navigationKind) {
        KtNamedDeclaration ktNamedDeclaration = decompiledClassOrObject;
        KotlinFullClassNameIndex kotlinFullClassNameIndex = KotlinFullClassNameIndex.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)kotlinFullClassNameIndex), (String)"KotlinFullClassNameIndex.getInstance()");
        return (KtClassOrObject)this.findFirstMatchingInIndex(ktNamedDeclaration, navigationKind, kotlinFullClassNameIndex);
    }

    private final Collection<KtNamedDeclaration> getInitialTopLevelCandidates(KtNamedDeclaration declaration2, NavigationKind navigationKind) {
        List<GlobalSearchScope> scopes = this.targetScopes(declaration2, navigationKind);
        StringStubIndexExtension<? extends KtNamedDeclaration> index2 = this.getIndexForTopLevelPropertyOrFunction(declaration2);
        for (GlobalSearchScope scope2 : scopes) {
            Collection collection;
            FqName fqName2 = declaration2.getFqName();
            if (fqName2 == null) {
                Intrinsics.throwNpe();
            }
            Collection candidates2 = index2.get((Object)fqName2.asString(), declaration2.getProject(), scope2);
            Intrinsics.checkExpressionValueIsNotNull((Object)candidates2, (String)"candidates");
            if (!(!collection.isEmpty())) continue;
            return candidates2;
        }
        return CollectionsKt.emptyList();
    }

    private final StringStubIndexExtension<? extends KtNamedDeclaration> getIndexForTopLevelPropertyOrFunction(KtNamedDeclaration decompiledDeclaration) {
        StringStubIndexExtension stringStubIndexExtension;
        KtNamedDeclaration ktNamedDeclaration = decompiledDeclaration;
        if (ktNamedDeclaration instanceof KtNamedFunction) {
            KotlinTopLevelFunctionFqnNameIndex kotlinTopLevelFunctionFqnNameIndex = KotlinTopLevelFunctionFqnNameIndex.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)kotlinTopLevelFunctionFqnNameIndex), (String)"KotlinTopLevelFunctionFqnNameIndex.getInstance()");
            stringStubIndexExtension = kotlinTopLevelFunctionFqnNameIndex;
        } else if (ktNamedDeclaration instanceof KtProperty) {
            KotlinTopLevelPropertyFqnNameIndex kotlinTopLevelPropertyFqnNameIndex = KotlinTopLevelPropertyFqnNameIndex.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)kotlinTopLevelPropertyFqnNameIndex), (String)"KotlinTopLevelPropertyFqnNameIndex.getInstance()");
            stringStubIndexExtension = kotlinTopLevelPropertyFqnNameIndex;
        } else {
            throw (Throwable)new IllegalArgumentException("Neither function nor declaration: " + decompiledDeclaration.getClass().getName());
        }
        return stringStubIndexExtension;
    }

    /*
     * WARNING - void declaration
     */
    private final List<KtNamedDeclaration> getInitialMemberCandidates(KtClassOrObject sourceClassOrObject, Name name2, Class<? extends KtNamedDeclaration> declarationClass2) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)CollectionsKt.filterIsInstance((Iterable)sourceClassOrObject.getDeclarations(), declarationClass2);
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            KtNamedDeclaration declaration2 = (KtNamedDeclaration)element$iv$iv;
            if (!Intrinsics.areEqual((Object)name2, (Object)declaration2.getNameAsSafeName())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public final PsiClass getOriginalClass(@NotNull KtClassOrObject classOrObject) {
        KtFile file;
        Intrinsics.checkParameterIsNotNull((Object)classOrObject, (String)"classOrObject");
        FqName fqName2 = classOrObject.getFqName();
        if (fqName2 == null) {
            return null;
        }
        FqName fqName3 = fqName2;
        KtFile ktFile = file = classOrObject.getContainingKtFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)ktFile, (String)"file");
        VirtualFile vFile = ktFile.getVirtualFile();
        Project project = file.getProject();
        ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)project);
        Intrinsics.checkExpressionValueIsNotNull((Object)projectRootManager, (String)"ProjectRootManager.getInstance(project)");
        ProjectFileIndex idx = projectRootManager.getFileIndex();
        if (vFile == null || !idx.isInLibrarySource(vFile)) {
            return null;
        }
        THashSet orderEntries = new THashSet((Collection)idx.getOrderEntriesForFile(vFile));
        return JavaPsiFacade.getInstance((Project)project).findClass(fqName3.asString(), new GlobalSearchScope(idx, orderEntries, project, project){
            final /* synthetic */ ProjectFileIndex $idx;
            final /* synthetic */ THashSet $orderEntries;
            final /* synthetic */ Project $project;

            public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
                Intrinsics.checkParameterIsNotNull((Object)file1, (String)"file1");
                Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file2");
                return 0;
            }

            public boolean contains(@NotNull VirtualFile file) {
                boolean bl;
                block3: {
                    List entries2;
                    Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
                    List list2 = entries2 = this.$idx.getOrderEntriesForFile(file);
                    Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"entries");
                    Iterable $receiver$iv = list2;
                    if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $receiver$iv) {
                            OrderEntry it = (OrderEntry)element$iv;
                            if (!this.$orderEntries.contains((Object)it)) continue;
                            bl = true;
                            break block3;
                        }
                        bl = false;
                    }
                }
                return bl;
            }

            public boolean isSearchInModuleContent(@NotNull Module aModule) {
                Intrinsics.checkParameterIsNotNull((Object)aModule, (String)"aModule");
                return false;
            }

            public boolean isSearchInLibraries() {
                return true;
            }
            {
                this.$idx = $captured_local_variable$0;
                this.$orderEntries = $captured_local_variable$1;
                this.$project = $captured_local_variable$2;
                super($super_call_param$3);
            }
        });
    }

    @NotNull
    public final KtDeclaration getNavigationElement(@NotNull KtDeclaration declaration2) {
        Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
        return this.navigateToDeclaration(declaration2, NavigationKind.CLASS_FILES_TO_SOURCES);
    }

    @NotNull
    public final KtDeclaration getOriginalElement(@NotNull KtDeclaration declaration2) {
        Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
        return this.navigateToDeclaration(declaration2, NavigationKind.SOURCES_TO_CLASS_FILES);
    }

    private final KtDeclaration navigateToDeclaration(KtDeclaration from, NavigationKind navigationKind) {
        KtDeclaration ktDeclaration;
        if (DumbService.isDumb((Project)from.getProject())) {
            return from;
        }
        switch (SourceNavigationHelper$WhenMappings.$EnumSwitchMapping$1[navigationKind.ordinal()]) {
            case 1: {
                if (from.getContainingKtFile().isCompiled()) break;
                return from;
            }
            case 2: {
                PsiFile file = from.getContainingFile();
                if (file instanceof KtFile && ((KtFile)file).isCompiled()) {
                    return from;
                }
                if (!ProjectRootsUtil.isInContent(from, false, true, false, true)) {
                    return from;
                }
                if (!KtPsiUtil.isLocal(from)) break;
                return from;
            }
        }
        if ((ktDeclaration = (KtDeclaration)from.accept(new SourceAndDecompiledConversionVisitor(navigationKind), Unit.INSTANCE)) == null) {
            ktDeclaration = from;
        }
        return ktDeclaration;
    }

    private SourceNavigationHelper() {
    }

    static {
        SourceNavigationHelper sourceNavigationHelper;
        INSTANCE = sourceNavigationHelper = new SourceNavigationHelper();
        LOG = Logger.getInstance(SourceNavigationHelper.class);
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/idea/decompiler/navigation/SourceNavigationHelper$NavigationKind;", "", "(Ljava/lang/String;I)V", "CLASS_FILES_TO_SOURCES", "SOURCES_TO_CLASS_FILES", "idea-core"})
    public static final class NavigationKind
    extends Enum<NavigationKind> {
        public static final /* enum */ NavigationKind CLASS_FILES_TO_SOURCES;
        public static final /* enum */ NavigationKind SOURCES_TO_CLASS_FILES;
        private static final /* synthetic */ NavigationKind[] $VALUES;

        static {
            NavigationKind[] navigationKindArray = new NavigationKind[2];
            NavigationKind[] navigationKindArray2 = navigationKindArray;
            navigationKindArray[0] = CLASS_FILES_TO_SOURCES = new NavigationKind();
            navigationKindArray[1] = SOURCES_TO_CLASS_FILES = new NavigationKind();
            $VALUES = navigationKindArray;
        }

        public static NavigationKind[] values() {
            return (NavigationKind[])$VALUES.clone();
        }

        public static NavigationKind valueOf(String string) {
            return Enum.valueOf(NavigationKind.class, string);
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001f\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\fJ\u001f\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\u0011J\u001f\u0010\u0012\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\u0015J\u001f\u0010\u0016\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000b\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\u0019J\u001f\u0010\u001a\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000b\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\u001dJ\u001f\u0010\u001e\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u000b\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010!J\u001f\u0010\"\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001b\u001a\u00020#2\u0006\u0010\u000b\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010$J\u001f\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020&2\u0006\u0010\u000b\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010(R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/idea/decompiler/navigation/SourceNavigationHelper$SourceAndDecompiledConversionVisitor;", "Lorg/jetbrains/kotlin/psi/KtVisitor;", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "", "navigationKind", "Lorg/jetbrains/kotlin/idea/decompiler/navigation/SourceNavigationHelper$NavigationKind;", "(Lorg/jetbrains/kotlin/idea/decompiler/navigation/SourceNavigationHelper$NavigationKind;)V", "visitClass", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "klass", "Lorg/jetbrains/kotlin/psi/KtClass;", "data", "(Lorg/jetbrains/kotlin/psi/KtClass;Lkotlin/Unit;)Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "visitNamedFunction", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "(Lorg/jetbrains/kotlin/psi/KtNamedFunction;Lkotlin/Unit;)Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "visitObjectDeclaration", "declaration", "Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;", "(Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;Lkotlin/Unit;)Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "visitParameter", "parameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "(Lorg/jetbrains/kotlin/psi/KtParameter;Lkotlin/Unit;)Lorg/jetbrains/kotlin/psi/KtDeclaration;", "visitPrimaryConstructor", "constructor", "Lorg/jetbrains/kotlin/psi/KtPrimaryConstructor;", "(Lorg/jetbrains/kotlin/psi/KtPrimaryConstructor;Lkotlin/Unit;)Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "visitProperty", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "(Lorg/jetbrains/kotlin/psi/KtProperty;Lkotlin/Unit;)Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "visitSecondaryConstructor", "Lorg/jetbrains/kotlin/psi/KtSecondaryConstructor;", "(Lorg/jetbrains/kotlin/psi/KtSecondaryConstructor;Lkotlin/Unit;)Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "visitTypeAlias", "Lorg/jetbrains/kotlin/psi/KtTypeAlias;", "typeAlias", "(Lorg/jetbrains/kotlin/psi/KtTypeAlias;Lkotlin/Unit;)Lorg/jetbrains/kotlin/psi/KtTypeAlias;", "idea-core"})
    private static final class SourceAndDecompiledConversionVisitor
    extends KtVisitor<KtDeclaration, Unit> {
        private final NavigationKind navigationKind;

        @Override
        @Nullable
        public KtNamedDeclaration visitNamedFunction(@NotNull KtNamedFunction function2, @NotNull Unit data) {
            Intrinsics.checkParameterIsNotNull((Object)function2, (String)"function");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return INSTANCE.convertPropertyOrFunction(function2, this.navigationKind);
        }

        @Override
        @Nullable
        public KtNamedDeclaration visitProperty(@NotNull KtProperty property, @NotNull Unit data) {
            Intrinsics.checkParameterIsNotNull((Object)property, (String)"property");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return INSTANCE.convertPropertyOrFunction(property, this.navigationKind);
        }

        @Override
        @Nullable
        public KtClassOrObject visitObjectDeclaration(@NotNull KtObjectDeclaration declaration2, @NotNull Unit data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return INSTANCE.findClassOrObject(declaration2, this.navigationKind);
        }

        @Override
        @Nullable
        public KtClassOrObject visitClass(@NotNull KtClass klass2, @NotNull Unit data) {
            Intrinsics.checkParameterIsNotNull((Object)klass2, (String)"klass");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return INSTANCE.findClassOrObject(klass2, this.navigationKind);
        }

        @Override
        @Nullable
        public KtTypeAlias visitTypeAlias(@NotNull KtTypeAlias typeAlias2, @NotNull Unit data) {
            Intrinsics.checkParameterIsNotNull((Object)typeAlias2, (String)"typeAlias");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return (KtTypeAlias)INSTANCE.findFirstMatchingInIndex(typeAlias2, this.navigationKind, KotlinTopLevelTypeAliasFqNameIndex.Companion.getInstance());
        }

        @Override
        @Nullable
        public KtDeclaration visitParameter(@NotNull KtParameter parameter, @NotNull Unit data) {
            Intrinsics.checkParameterIsNotNull((Object)parameter, (String)"parameter");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            PsiElement psiElement2 = parameter.getParent();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"parameter.parent");
            PsiElement psiElement3 = psiElement2.getParent();
            if (psiElement3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtCallableDeclaration");
            }
            KtCallableDeclaration callableDeclaration = (KtCallableDeclaration)psiElement3;
            List<KtParameter> parameters2 = callableDeclaration.getValueParameters();
            int index2 = parameters2.indexOf(parameter);
            Object r = callableDeclaration.accept(this, Unit.INSTANCE);
            if (!(r instanceof KtCallableDeclaration)) {
                r = null;
            }
            KtCallableDeclaration ktCallableDeclaration = (KtCallableDeclaration)r;
            if (ktCallableDeclaration == null) {
                return null;
            }
            KtCallableDeclaration sourceCallable = ktCallableDeclaration;
            List<KtParameter> sourceParameters = sourceCallable.getValueParameters();
            if (sourceParameters.size() != parameters2.size()) {
                return null;
            }
            return sourceParameters.get(index2);
        }

        @Override
        @Nullable
        public KtNamedDeclaration visitPrimaryConstructor(@NotNull KtPrimaryConstructor constructor2, @NotNull Unit data) {
            Intrinsics.checkParameterIsNotNull((Object)constructor2, (String)"constructor");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return INSTANCE.convertPropertyOrFunction(constructor2, this.navigationKind);
        }

        @Override
        @Nullable
        public KtNamedDeclaration visitSecondaryConstructor(@NotNull KtSecondaryConstructor constructor2, @NotNull Unit data) {
            Intrinsics.checkParameterIsNotNull((Object)constructor2, (String)"constructor");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return INSTANCE.convertPropertyOrFunction(constructor2, this.navigationKind);
        }

        public SourceAndDecompiledConversionVisitor(@NotNull NavigationKind navigationKind) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)navigationKind), (String)"navigationKind");
            this.navigationKind = navigationKind;
        }
    }
}

