/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.formatter;

import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.psi.PsiElement;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeType;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.idea.core.formatter.KotlinCodeStyleSettings;
import org.jetbrains.kotlin.idea.formatter.CommonAlignmentStrategy;
import org.jetbrains.kotlin.idea.formatter.KotlinCommonBlockKt;
import org.jetbrains.kotlin.idea.formatter.KotlinCommonBlockKt$INDENT_RULES$14;
import org.jetbrains.kotlin.idea.formatter.KotlinCommonBlockKt$INDENT_RULES$16;
import org.jetbrains.kotlin.idea.formatter.KotlinCommonBlockKt$INDENT_RULES$2;
import org.jetbrains.kotlin.idea.formatter.KotlinCommonBlockKt$INDENT_RULES$6;
import org.jetbrains.kotlin.idea.formatter.KotlinCommonBlockKt$INDENT_RULES$8;
import org.jetbrains.kotlin.idea.formatter.KotlinCommonBlockKt$INDENT_RULES$9;
import org.jetbrains.kotlin.idea.formatter.KotlinCommonCodeStyleSettings;
import org.jetbrains.kotlin.idea.formatter.NodeIndentStrategy;
import org.jetbrains.kotlin.kdoc.lexer.KDocToken;
import org.jetbrains.kotlin.kdoc.lexer.KDocTokens;
import org.jetbrains.kotlin.kdoc.parser.KDocElementTypes;
import org.jetbrains.kotlin.lexer.KtKeywordToken;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000\u0088\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002\u001a8\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020!2\u0006\u0010%\u001a\u00020!H\u0002\u001a\u0012\u0010&\u001a\u0004\u0018\u00010!2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002\u001a\u0012\u0010'\u001a\u0004\u0018\u00010\u001b2\u0006\u0010(\u001a\u00020\u001bH\u0002\u001a\u0012\u0010)\u001a\u0004\u0018\u00010\u001b2\u0006\u0010(\u001a\u00020\u001bH\u0002\u001a\u001a\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010,\u001a\u00020\u001b2\u0006\u0010-\u001a\u00020\u000bH\u0002\u001aC\u0010.\u001a#\u0012\u0013\u0012\u00110\u001b\u00a2\u0006\f\b0\u0012\b\b1\u0012\u0004\b\b(,\u0012\u0006\u0012\u0004\u0018\u00010+0/j\u0002`22\u0006\u0010-\u001a\u00020\u000b2\u0006\u00103\u001a\u00020!2\b\b\u0002\u00104\u001a\u00020\u001fH\u0002\u001aC\u0010.\u001a#\u0012\u0013\u0012\u00110\u001b\u00a2\u0006\f\b0\u0012\b\b1\u0012\u0004\b\b(,\u0012\u0006\u0012\u0004\u0018\u00010+0/j\u0002`22\u0006\u0010-\u001a\u00020\u000b2\u0006\u00105\u001a\u00020\u00012\b\b\u0002\u00104\u001a\u00020\u001fH\u0002\u001a\u000e\u00106\u001a\u00020\u001f2\u0006\u0010\u001a\u001a\u00020\u001b\u001a\u0010\u00107\u001a\u00020\u001f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002\u001a\u000e\u00108\u001a\u00020\u001f2\u0006\u00109\u001a\u00020:\u001a\u0010\u0010;\u001a\u0004\u0018\u00010+2\u0006\u0010,\u001a\u00020\u001b\u001a1\u0010<\u001a#\u0012\u0013\u0012\u00110\u001b\u00a2\u0006\f\b0\u0012\b\b1\u0012\u0004\b\b(,\u0012\u0006\u0012\u0004\u0018\u00010+0/j\u0002`22\u0006\u0010-\u001a\u00020\u000bH\u0002\u001a(\u0010=\u001a\u00020\b*\u00020>2\u0012\u0010?\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u001f0/2\b\b\u0002\u0010@\u001a\u00020\u001f\u001a\u001a\u0010A\u001a\u00020\u000b*\b\u0012\u0004\u0012\u00020C0B2\u0006\u0010D\u001a\u00020\u0001H\u0002\u001a\f\u0010E\u001a\u00020\u001f*\u00020\u001bH\u0002\u001a\f\u0010F\u001a\u00020\u001f*\u00020\u001bH\u0002\u001a\f\u0010G\u001a\u00020\u001f*\u00020\u001bH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\t\"\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\r\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000e\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0015\u0010\u000f\u001a\u00020\u0010*\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\"\u0015\u0010\u0014\u001a\u00020\u0015*\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017*D\u0010H\"\u001f\u0012\u0013\u0012\u00110\u001b\u00a2\u0006\f\b0\u0012\b\b1\u0012\u0004\b\b(,\u0012\u0006\u0012\u0004\u0018\u00010+0/2\u001f\u0012\u0013\u0012\u00110\u001b\u00a2\u0006\f\b0\u0012\b\b1\u0012\u0004\b\b(,\u0012\u0006\u0012\u0004\u0018\u00010+0/\u00a8\u0006I"}, d2={"ALIGN_FOR_BINARY_OPERATIONS", "Lcom/intellij/psi/tree/TokenSet;", "ANNOTATIONS", "BINARY_EXPRESSIONS", "CODE_BLOCKS", "ELVIS_SET", "INDENT_RULES", "", "Lorg/jetbrains/kotlin/idea/formatter/NodeIndentStrategy;", "[Lorg/jetbrains/kotlin/idea/formatter/NodeIndentStrategy;", "KDOC_COMMENT_INDENT", "", "KDOC_CONTENT", "QUALIFIED_EXPRESSIONS", "QUALIFIED_OPERATION", "kotlinCommonSettings", "Lorg/jetbrains/kotlin/idea/formatter/KotlinCommonCodeStyleSettings;", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "getKotlinCommonSettings", "(Lcom/intellij/psi/codeStyle/CodeStyleSettings;)Lorg/jetbrains/kotlin/idea/formatter/KotlinCommonCodeStyleSettings;", "kotlinCustomSettings", "Lorg/jetbrains/kotlin/idea/core/formatter/KotlinCodeStyleSettings;", "getKotlinCustomSettings", "(Lcom/intellij/psi/codeStyle/CodeStyleSettings;)Lorg/jetbrains/kotlin/idea/core/formatter/KotlinCodeStyleSettings;", "extractIndent", "", "node", "Lcom/intellij/lang/ASTNode;", "getAlignmentForChildInParenthesis", "Lorg/jetbrains/kotlin/idea/formatter/CommonAlignmentStrategy;", "shouldAlignChild", "", "parameter", "Lcom/intellij/psi/tree/IElementType;", "delimiter", "shouldAlignParenthesis", "openBracket", "closeBracket", "getOperationType", "getPrevWithoutWhitespace", "pNode", "getPrevWithoutWhitespaceAndComments", "getWrapAfterAnnotation", "Lcom/intellij/formatting/Wrap;", "childElement", "wrapType", "getWrappingStrategyForItemList", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "Lorg/jetbrains/kotlin/idea/formatter/WrappingStrategy;", "itemType", "wrapFirstElement", "itemTypes", "hasErrorElementBefore", "hasLineBreakBefore", "needWrapArgumentList", "psi", "Lcom/intellij/psi/PsiElement;", "noWrapping", "wrapAfterAnnotation", "continuationIf", "Lorg/jetbrains/kotlin/idea/formatter/NodeIndentStrategy$PositionStrategy;", "option", "indentFirst", "indexOfBlockWithType", "", "Lcom/intellij/formatting/ASTBlock;", "tokenSet", "isFirstParameter", "startsWithAnnotation", "suppressBinaryExpressionIndent", "WrappingStrategy", "formatter"})
public final class KotlinCommonBlockKt {
    private static final TokenSet QUALIFIED_OPERATION = TokenSet.create((IElementType[])new IElementType[]{KtTokens.DOT, KtTokens.SAFE_ACCESS});
    private static final TokenSet QUALIFIED_EXPRESSIONS = TokenSet.create((IElementType[])new IElementType[]{KtNodeTypes.DOT_QUALIFIED_EXPRESSION, KtNodeTypes.SAFE_ACCESS_EXPRESSION});
    private static final TokenSet ELVIS_SET = TokenSet.create((IElementType[])new IElementType[]{KtTokens.ELVIS});
    private static final int KDOC_COMMENT_INDENT = 1;
    private static final TokenSet BINARY_EXPRESSIONS = TokenSet.create((IElementType[])new IElementType[]{KtNodeTypes.BINARY_EXPRESSION, KtNodeTypes.BINARY_WITH_TYPE, KtNodeTypes.IS_EXPRESSION});
    private static final TokenSet KDOC_CONTENT = TokenSet.create((IElementType[])new IElementType[]{(IElementType)KDocTokens.KDOC, KDocElementTypes.KDOC_SECTION, KDocElementTypes.KDOC_TAG});
    private static final TokenSet CODE_BLOCKS = TokenSet.create((IElementType[])new IElementType[]{KtNodeTypes.BLOCK, KtNodeTypes.CLASS_BODY, KtNodeTypes.FUNCTION_LITERAL});
    private static final TokenSet ALIGN_FOR_BINARY_OPERATIONS = TokenSet.create((IElementType[])new IElementType[]{KtTokens.MUL, KtTokens.DIV, KtTokens.PERC, KtTokens.PLUS, KtTokens.MINUS, KtTokens.ELVIS, KtTokens.LT, KtTokens.GT, KtTokens.LTEQ, KtTokens.GTEQ, KtTokens.ANDAND, KtTokens.OROR});
    private static final TokenSet ANNOTATIONS = TokenSet.create((IElementType[])new IElementType[]{KtNodeTypes.ANNOTATION_ENTRY, KtNodeTypes.ANNOTATION});
    private static final NodeIndentStrategy[] INDENT_RULES;

    @NotNull
    public static final KotlinCommonCodeStyleSettings getKotlinCommonSettings(@NotNull CodeStyleSettings $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        CommonCodeStyleSettings commonCodeStyleSettings = $receiver.getCommonSettings((Language)KotlinLanguage.INSTANCE);
        if (commonCodeStyleSettings == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.idea.formatter.KotlinCommonCodeStyleSettings");
        }
        return (KotlinCommonCodeStyleSettings)commonCodeStyleSettings;
    }

    @NotNull
    public static final KotlinCodeStyleSettings getKotlinCustomSettings(@NotNull CodeStyleSettings $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        CustomCodeStyleSettings customCodeStyleSettings = $receiver.getCustomSettings(KotlinCodeStyleSettings.class);
        if (customCodeStyleSettings == null) {
            Intrinsics.throwNpe();
        }
        return (KotlinCodeStyleSettings)customCodeStyleSettings;
    }

    @Nullable
    public static final Wrap noWrapping(@NotNull ASTNode childElement) {
        Intrinsics.checkParameterIsNotNull((Object)childElement, (String)"childElement");
        return null;
    }

    private static final boolean startsWithAnnotation(@NotNull ASTNode $receiver) {
        ASTNode aSTNode = $receiver.getFirstChildNode();
        return Intrinsics.areEqual((Object)(aSTNode != null && (aSTNode = aSTNode.getFirstChildNode()) != null ? aSTNode.getElementType() : null), (Object)KtNodeTypes.ANNOTATION_ENTRY);
    }

    private static final boolean isFirstParameter(@NotNull ASTNode $receiver) {
        ASTNode aSTNode = $receiver.getTreePrev();
        return Intrinsics.areEqual((Object)(aSTNode != null ? aSTNode.getElementType() : null), (Object)((Object)KtTokens.LPAR));
    }

    private static final Function1<ASTNode, Wrap> wrapAfterAnnotation(int wrapType) {
        return (Function1)new Function1<ASTNode, Wrap>(wrapType){
            final /* synthetic */ int $wrapType;

            @Nullable
            public final Wrap invoke(@NotNull ASTNode childElement) {
                Intrinsics.checkParameterIsNotNull((Object)childElement, (String)"childElement");
                return KotlinCommonBlockKt.access$getWrapAfterAnnotation(childElement, this.$wrapType);
            }
            {
                this.$wrapType = n;
                super(1);
            }
        };
    }

    private static final Wrap getWrapAfterAnnotation(ASTNode childElement, int wrapType) {
        ASTNode aSTNode;
        if (KtTokens.COMMENTS.contains(childElement.getElementType())) {
            return null;
        }
        ASTNode prevLeaf2 = childElement.getTreePrev();
        while (true) {
            ASTNode aSTNode2 = prevLeaf2;
            if (!Intrinsics.areEqual((Object)(aSTNode2 != null ? aSTNode2.getElementType() : null), (Object)TokenType.WHITE_SPACE)) break;
            ASTNode aSTNode3 = prevLeaf2;
            Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode3, (String)"prevLeaf");
            prevLeaf2 = aSTNode3.getTreePrev();
        }
        ASTNode aSTNode4 = prevLeaf2;
        if (Intrinsics.areEqual((Object)(aSTNode4 != null ? aSTNode4.getElementType() : null), (Object)KtNodeTypes.MODIFIER_LIST) && ANNOTATIONS.contains((aSTNode = prevLeaf2) != null && (aSTNode = aSTNode.getLastChildNode()) != null ? aSTNode.getElementType() : null)) {
            return Wrap.createWrap((int)wrapType, (boolean)true);
        }
        return null;
    }

    public static final boolean needWrapArgumentList(@NotNull PsiElement psi) {
        Intrinsics.checkParameterIsNotNull((Object)psi, (String)"psi");
        PsiElement psiElement2 = psi;
        if (!(psiElement2 instanceof KtValueArgumentList)) {
            psiElement2 = null;
        }
        KtValueArgumentList ktValueArgumentList = (KtValueArgumentList)psiElement2;
        List<KtValueArgument> args = ktValueArgumentList != null ? ktValueArgumentList.getArguments() : null;
        List<KtValueArgument> list2 = args;
        return !((list2 != null && (list2 = (KtValueArgument)CollectionsKt.singleOrNull(list2)) != null ? ((KtValueArgument)((Object)list2)).getArgumentExpression() : null) instanceof KtObjectLiteralExpression);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean hasLineBreakBefore(ASTNode node) {
        ASTNode prevSibling2;
        ASTNode aSTNode = prevSibling2 = (ASTNode)SequencesKt.firstOrNull((Sequence)SequencesKt.dropWhile(PsiUtilsKt.leaves(node, false), (Function1)hasLineBreakBefore.prevSibling.1.INSTANCE));
        if (!Intrinsics.areEqual((Object)(aSTNode != null ? aSTNode.getElementType() : null), (Object)TokenType.WHITE_SPACE)) return false;
        ASTNode aSTNode2 = prevSibling2;
        if (aSTNode2 == null) return false;
        if (!aSTNode2.textContains('\n')) return false;
        return true;
    }

    @NotNull
    public static final NodeIndentStrategy continuationIf(@NotNull NodeIndentStrategy.PositionStrategy $receiver, @NotNull Function1<? super KotlinCodeStyleSettings, Boolean> option, boolean indentFirst) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(option, (String)"option");
        return $receiver.set((Function1<? super CodeStyleSettings, ? extends Indent>)((Function1)new Function1<CodeStyleSettings, Indent>(option, indentFirst){
            final /* synthetic */ Function1 $option;
            final /* synthetic */ boolean $indentFirst;

            @NotNull
            public final Indent invoke(@NotNull CodeStyleSettings settings2) {
                Indent indent;
                Intrinsics.checkParameterIsNotNull((Object)settings2, (String)"settings");
                if (((Boolean)this.$option.invoke((Object)((Object)KotlinCommonBlockKt.getKotlinCustomSettings(settings2)))).booleanValue()) {
                    Indent indent2 = this.$indentFirst ? Indent.getContinuationIndent() : Indent.getContinuationWithoutFirstIndent();
                    indent = indent2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)indent2, (String)"if (indentFirst)\n       \u2026ationWithoutFirstIndent()");
                } else {
                    Indent indent3 = Indent.getNormalIndent();
                    indent = indent3;
                    Intrinsics.checkExpressionValueIsNotNull((Object)indent3, (String)"Indent.getNormalIndent()");
                }
                return indent;
            }
            {
                this.$option = function1;
                this.$indentFirst = bl;
                super(1);
            }
        }));
    }

    @NotNull
    public static /* bridge */ /* synthetic */ NodeIndentStrategy continuationIf$default(NodeIndentStrategy.PositionStrategy positionStrategy, Function1 function1, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return KotlinCommonBlockKt.continuationIf(positionStrategy, (Function1<? super KotlinCodeStyleSettings, Boolean>)function1, bl);
    }

    private static final IElementType getOperationType(ASTNode node) {
        ASTNode aSTNode = node.findChildByType((IElementType)KtNodeTypes.OPERATION_REFERENCE);
        return aSTNode != null && (aSTNode = aSTNode.getFirstChildNode()) != null ? aSTNode.getElementType() : null;
    }

    public static final boolean hasErrorElementBefore(@NotNull ASTNode node) {
        ASTNode lastChild;
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        ASTNode aSTNode = KotlinCommonBlockKt.getPrevWithoutWhitespace(node);
        if (aSTNode == null) {
            return false;
        }
        ASTNode prevSibling2 = aSTNode;
        if (Intrinsics.areEqual((Object)prevSibling2.getElementType(), (Object)TokenType.ERROR_ELEMENT)) {
            return true;
        }
        ASTNode aSTNode2 = lastChild = TreeUtil.getLastChild((ASTNode)prevSibling2);
        return Intrinsics.areEqual((Object)(aSTNode2 != null ? aSTNode2.getElementType() : null), (Object)TokenType.ERROR_ELEMENT);
    }

    private static final boolean suppressBinaryExpressionIndent(@NotNull ASTNode $receiver) {
        PsiElement psiElement2 = $receiver.getPsi();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"psi");
        PsiElement psiElement3 = psiElement2.getParent();
        if (!(psiElement3 instanceof KtBinaryExpression)) {
            psiElement3 = null;
        }
        KtBinaryExpression ktBinaryExpression = (KtBinaryExpression)psiElement3;
        if (ktBinaryExpression == null) {
            return false;
        }
        KtBinaryExpression psi = ktBinaryExpression;
        while (psi.getParent() instanceof KtBinaryExpression) {
            PsiElement psiElement4 = psi.getParent();
            if (psiElement4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBinaryExpression");
            }
            psi = (KtBinaryExpression)psiElement4;
        }
        PsiElement psiElement5 = psi.getParent();
        return Intrinsics.areEqual((Object)(psiElement5 != null && (psiElement5 = psiElement5.getNode()) != null ? psiElement5.getElementType() : null), (Object)((Object)KtNodeTypes.CONDITION)) || Intrinsics.areEqual((Object)psi.getOperationToken(), (Object)((Object)KtTokens.ELVIS));
    }

    private static final CommonAlignmentStrategy getAlignmentForChildInParenthesis(boolean shouldAlignChild, IElementType parameter, IElementType delimiter, boolean shouldAlignParenthesis, IElementType openBracket, IElementType closeBracket) {
        Alignment parameterAlignment = shouldAlignChild ? Alignment.createAlignment() : null;
        Alignment bracketsAlignment = shouldAlignParenthesis ? Alignment.createAlignment() : null;
        return new CommonAlignmentStrategy(parameterAlignment, openBracket, closeBracket, bracketsAlignment, parameter, delimiter){
            final /* synthetic */ Alignment $parameterAlignment;
            final /* synthetic */ IElementType $openBracket;
            final /* synthetic */ IElementType $closeBracket;
            final /* synthetic */ Alignment $bracketsAlignment;
            final /* synthetic */ IElementType $parameter;
            final /* synthetic */ IElementType $delimiter;

            @Nullable
            public Alignment getAlignment(@NotNull ASTNode node) {
                Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                IElementType childNodeType = node.getElementType();
                ASTNode prev2 = KotlinCommonBlockKt.access$getPrevWithoutWhitespace(node);
                if (prev2 != null && prev2.getElementType() == TokenType.ERROR_ELEMENT || childNodeType == TokenType.ERROR_ELEMENT) {
                    return this.$parameterAlignment;
                }
                if (childNodeType == this.$openBracket || childNodeType == this.$closeBracket) {
                    return this.$bracketsAlignment;
                }
                if (childNodeType == this.$parameter || childNodeType == this.$delimiter) {
                    return this.$parameterAlignment;
                }
                return null;
            }
            {
                this.$parameterAlignment = $captured_local_variable$0;
                this.$openBracket = $captured_local_variable$1;
                this.$closeBracket = $captured_local_variable$2;
                this.$bracketsAlignment = $captured_local_variable$3;
                this.$parameter = $captured_local_variable$4;
                this.$delimiter = $captured_local_variable$5;
            }
        };
    }

    private static final ASTNode getPrevWithoutWhitespace(ASTNode pNode) {
        Object v0;
        block1: {
            Sequence<ASTNode> $receiver$iv = PsiUtilsKt.siblings(pNode, false);
            for (Object element$iv : $receiver$iv) {
                ASTNode it = (ASTNode)element$iv;
                if (!(Intrinsics.areEqual((Object)it.getElementType(), (Object)TokenType.WHITE_SPACE) ^ true)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private static final ASTNode getPrevWithoutWhitespaceAndComments(ASTNode pNode) {
        Object v0;
        block1: {
            Sequence<ASTNode> $receiver$iv = PsiUtilsKt.siblings(pNode, false);
            for (Object element$iv : $receiver$iv) {
                ASTNode it = (ASTNode)element$iv;
                if (!(Intrinsics.areEqual((Object)it.getElementType(), (Object)TokenType.WHITE_SPACE) ^ true && !KtTokens.COMMENTS.contains(it.getElementType()))) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private static final Function1<ASTNode, Wrap> getWrappingStrategyForItemList(int wrapType, IElementType itemType, boolean wrapFirstElement) {
        Wrap itemWrap = Wrap.createWrap((int)wrapType, (boolean)wrapFirstElement);
        return (Function1)new Function1<ASTNode, Wrap>(itemType, itemWrap){
            final /* synthetic */ IElementType $itemType;
            final /* synthetic */ Wrap $itemWrap;

            @Nullable
            public final Wrap invoke(@NotNull ASTNode childElement) {
                Intrinsics.checkParameterIsNotNull((Object)childElement, (String)"childElement");
                return childElement.getElementType() == this.$itemType ? this.$itemWrap : null;
            }
            {
                this.$itemType = iElementType;
                this.$itemWrap = wrap2;
                super(1);
            }
        };
    }

    static /* bridge */ /* synthetic */ Function1 getWrappingStrategyForItemList$default(int n, IElementType iElementType, boolean bl, int n2, Object object) {
        if ((n2 & 4) != 0) {
            bl = false;
        }
        return KotlinCommonBlockKt.getWrappingStrategyForItemList(n, iElementType, bl);
    }

    private static final Function1<ASTNode, Wrap> getWrappingStrategyForItemList(int wrapType, TokenSet itemTypes, boolean wrapFirstElement) {
        Wrap itemWrap = Wrap.createWrap((int)wrapType, (boolean)wrapFirstElement);
        return (Function1)new Function1<ASTNode, Wrap>(itemTypes, itemWrap){
            final /* synthetic */ TokenSet $itemTypes;
            final /* synthetic */ Wrap $itemWrap;

            @Nullable
            public final Wrap invoke(@NotNull ASTNode childElement) {
                Intrinsics.checkParameterIsNotNull((Object)childElement, (String)"childElement");
                IElementType thisType = childElement.getElementType();
                ASTNode aSTNode = KotlinCommonBlockKt.access$getPrevWithoutWhitespace(childElement);
                IElementType prevType = aSTNode != null ? aSTNode.getElementType() : null;
                return this.$itemTypes.contains(thisType) || this.$itemTypes.contains(prevType) && Intrinsics.areEqual((Object)thisType, (Object)((Object)KtTokens.EOL_COMMENT)) ^ true && Intrinsics.areEqual((Object)prevType, (Object)((Object)KtTokens.EOL_COMMENT)) ^ true ? this.$itemWrap : null;
            }
            {
                this.$itemTypes = tokenSet;
                this.$itemWrap = wrap2;
                super(1);
            }
        };
    }

    static /* bridge */ /* synthetic */ Function1 getWrappingStrategyForItemList$default(int n, TokenSet tokenSet, boolean bl, int n2, Object object) {
        if ((n2 & 4) != 0) {
            bl = false;
        }
        return KotlinCommonBlockKt.getWrappingStrategyForItemList(n, tokenSet, bl);
    }

    private static final int indexOfBlockWithType(@NotNull List<? extends ASTBlock> $receiver, TokenSet tokenSet) {
        int n;
        block2: {
            List<? extends ASTBlock> $receiver$iv = $receiver;
            int index$iv = 0;
            Iterator<? extends ASTBlock> iterator2 = $receiver$iv.iterator();
            while (iterator2.hasNext()) {
                ASTBlock item$iv;
                ASTBlock block = item$iv = iterator2.next();
                ASTNode aSTNode = block.getNode();
                if (tokenSet.contains((IElementType)(aSTNode != null ? aSTNode.getElementType() : null))) {
                    n = index$iv;
                    break block2;
                }
                ++index$iv;
            }
            n = -1;
        }
        return n;
    }

    private static final String extractIndent(ASTNode node) {
        ASTNode prevNode;
        ASTNode aSTNode = prevNode = node.getTreePrev();
        if (Intrinsics.areEqual((Object)(aSTNode != null ? aSTNode.getElementType() : null), (Object)TokenType.WHITE_SPACE) ^ true) {
            return "";
        }
        ASTNode aSTNode2 = prevNode;
        Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode2, (String)"prevNode");
        String string = aSTNode2.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"prevNode.text");
        String string2 = prevNode.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"prevNode.text");
        return StringsKt.substringAfterLast((String)string, (String)"\n", (String)string2);
    }

    static {
        NodeIndentStrategy[] nodeIndentStrategyArray = new NodeIndentStrategy[27];
        NodeIndentStrategy.PositionStrategy positionStrategy = NodeIndentStrategy.Companion.strategy("No indent for braces in blocks");
        KtNodeType ktNodeType = KtNodeTypes.BLOCK;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktNodeType), (String)"KtNodeTypes.BLOCK");
        IElementType iElementType = ktNodeType;
        IElementType[] iElementTypeArray = new IElementType[2];
        IElementType iElementType2 = KtNodeTypes.CLASS_BODY;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType2, (String)"KtNodeTypes.CLASS_BODY");
        iElementTypeArray[0] = iElementType2;
        KtNodeType ktNodeType2 = KtNodeTypes.FUNCTION_LITERAL;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktNodeType2), (String)"KtNodeTypes.FUNCTION_LITERAL");
        iElementTypeArray[1] = ktNodeType2;
        NodeIndentStrategy.PositionStrategy positionStrategy2 = positionStrategy.within(iElementType, iElementTypeArray);
        KtSingleValueToken ktSingleValueToken = KtTokens.RBRACE;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktSingleValueToken), (String)"RBRACE");
        IElementType iElementType3 = ktSingleValueToken;
        IElementType[] iElementTypeArray2 = new IElementType[1];
        KtSingleValueToken ktSingleValueToken2 = KtTokens.LBRACE;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktSingleValueToken2), (String)"LBRACE");
        iElementTypeArray2[0] = ktSingleValueToken2;
        NodeIndentStrategy.PositionStrategy positionStrategy3 = positionStrategy2.forType(iElementType3, iElementTypeArray2);
        Indent indent = Indent.getNoneIndent();
        Intrinsics.checkExpressionValueIsNotNull((Object)indent, (String)"Indent.getNoneIndent()");
        nodeIndentStrategyArray[0] = positionStrategy3.set(indent);
        NodeIndentStrategy.PositionStrategy positionStrategy4 = NodeIndentStrategy.Companion.strategy("Indent for block content");
        KtNodeType ktNodeType3 = KtNodeTypes.BLOCK;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktNodeType3), (String)"KtNodeTypes.BLOCK");
        IElementType iElementType4 = ktNodeType3;
        IElementType[] iElementTypeArray3 = new IElementType[2];
        IElementType iElementType5 = KtNodeTypes.CLASS_BODY;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType5, (String)"KtNodeTypes.CLASS_BODY");
        iElementTypeArray3[0] = iElementType5;
        KtNodeType ktNodeType4 = KtNodeTypes.FUNCTION_LITERAL;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktNodeType4), (String)"KtNodeTypes.FUNCTION_LITERAL");
        iElementTypeArray3[1] = ktNodeType4;
        NodeIndentStrategy.PositionStrategy positionStrategy5 = positionStrategy4.within(iElementType4, iElementTypeArray3);
        KtSingleValueToken ktSingleValueToken3 = KtTokens.RBRACE;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktSingleValueToken3), (String)"RBRACE");
        IElementType iElementType6 = ktSingleValueToken3;
        IElementType[] iElementTypeArray4 = new IElementType[2];
        KtSingleValueToken ktSingleValueToken4 = KtTokens.LBRACE;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktSingleValueToken4), (String)"LBRACE");
        iElementTypeArray4[0] = ktSingleValueToken4;
        KtNodeType ktNodeType5 = KtNodeTypes.BLOCK;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktNodeType5), (String)"KtNodeTypes.BLOCK");
        iElementTypeArray4[1] = ktNodeType5;
        NodeIndentStrategy.PositionStrategy positionStrategy6 = positionStrategy5.notForType(iElementType6, iElementTypeArray4);
        Indent indent2 = Indent.getNormalIndent((boolean)false);
        Intrinsics.checkExpressionValueIsNotNull((Object)indent2, (String)"Indent.getNormalIndent(false)");
        nodeIndentStrategyArray[1] = positionStrategy6.set(indent2);
        NodeIndentStrategy.PositionStrategy positionStrategy7 = NodeIndentStrategy.Companion.strategy("Indent for property accessors");
        IElementType iElementType7 = KtNodeTypes.PROPERTY;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType7, (String)"KtNodeTypes.PROPERTY");
        NodeIndentStrategy.PositionStrategy positionStrategy8 = positionStrategy7.within(iElementType7, new IElementType[0]);
        IElementType iElementType8 = KtNodeTypes.PROPERTY_ACCESSOR;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType8, (String)"KtNodeTypes.PROPERTY_ACCESSOR");
        NodeIndentStrategy.PositionStrategy positionStrategy9 = positionStrategy8.forType(iElementType8, new IElementType[0]);
        Indent indent3 = Indent.getNormalIndent();
        Intrinsics.checkExpressionValueIsNotNull((Object)indent3, (String)"Indent.getNormalIndent()");
        nodeIndentStrategyArray[2] = positionStrategy9.set(indent3);
        NodeIndentStrategy.PositionStrategy positionStrategy10 = NodeIndentStrategy.Companion.strategy("For a single statement in 'for'");
        KtNodeType ktNodeType6 = KtNodeTypes.BODY;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktNodeType6), (String)"KtNodeTypes.BODY");
        NodeIndentStrategy.PositionStrategy positionStrategy11 = positionStrategy10.within(ktNodeType6, new IElementType[0]);
        KtNodeType ktNodeType7 = KtNodeTypes.BLOCK;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktNodeType7), (String)"KtNodeTypes.BLOCK");
        NodeIndentStrategy.PositionStrategy positionStrategy12 = positionStrategy11.notForType(ktNodeType7, new IElementType[0]);
        Indent indent4 = Indent.getNormalIndent();
        Intrinsics.checkExpressionValueIsNotNull((Object)indent4, (String)"Indent.getNormalIndent()");
        nodeIndentStrategyArray[3] = positionStrategy12.set(indent4);
        NodeIndentStrategy.PositionStrategy positionStrategy13 = NodeIndentStrategy.Companion.strategy("For WHEN content");
        KtNodeType ktNodeType8 = KtNodeTypes.WHEN;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktNodeType8), (String)"KtNodeTypes.WHEN");
        NodeIndentStrategy.PositionStrategy positionStrategy14 = positionStrategy13.within(ktNodeType8, new IElementType[0]);
        KtSingleValueToken ktSingleValueToken5 = KtTokens.RBRACE;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktSingleValueToken5), (String)"RBRACE");
        IElementType iElementType9 = ktSingleValueToken5;
        IElementType[] iElementTypeArray5 = new IElementType[2];
        KtSingleValueToken ktSingleValueToken6 = KtTokens.LBRACE;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktSingleValueToken6), (String)"LBRACE");
        iElementTypeArray5[0] = ktSingleValueToken6;
        KtKeywordToken ktKeywordToken = KtTokens.WHEN_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktKeywordToken), (String)"WHEN_KEYWORD");
        iElementTypeArray5[1] = ktKeywordToken;
        NodeIndentStrategy.PositionStrategy positionStrategy15 = positionStrategy14.notForType(iElementType9, iElementTypeArray5);
        Indent indent5 = Indent.getNormalIndent();
        Intrinsics.checkExpressionValueIsNotNull((Object)indent5, (String)"Indent.getNormalIndent()");
        nodeIndentStrategyArray[4] = positionStrategy15.set(indent5);
        NodeIndentStrategy.PositionStrategy positionStrategy16 = NodeIndentStrategy.Companion.strategy("For single statement in THEN and ELSE");
        KtNodeType ktNodeType9 = KtNodeTypes.THEN;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktNodeType9), (String)"KtNodeTypes.THEN");
        IElementType iElementType10 = ktNodeType9;
        IElementType[] iElementTypeArray6 = new IElementType[1];
        KtNodeType ktNodeType10 = KtNodeTypes.ELSE;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktNodeType10), (String)"KtNodeTypes.ELSE");
        iElementTypeArray6[0] = ktNodeType10;
        NodeIndentStrategy.PositionStrategy positionStrategy17 = positionStrategy16.within(iElementType10, iElementTypeArray6);
        KtNodeType ktNodeType11 = KtNodeTypes.BLOCK;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktNodeType11), (String)"KtNodeTypes.BLOCK");
        NodeIndentStrategy.PositionStrategy positionStrategy18 = positionStrategy17.notForType(ktNodeType11, new IElementType[0]);
        Indent indent6 = Indent.getNormalIndent();
        Intrinsics.checkExpressionValueIsNotNull((Object)indent6, (String)"Indent.getNormalIndent()");
        nodeIndentStrategyArray[5] = positionStrategy18.set(indent6);
        NodeIndentStrategy.PositionStrategy positionStrategy19 = NodeIndentStrategy.Companion.strategy("Expression body");
        IElementType iElementType11 = KtNodeTypes.FUN;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType11, (String)"KtNodeTypes.FUN");
        nodeIndentStrategyArray[6] = KotlinCommonBlockKt.continuationIf(positionStrategy19.within(iElementType11, new IElementType[0]).forElement((Function1<? super ASTNode, Boolean>)((Function1)INDENT_RULES.1.INSTANCE)), (Function1<? super KotlinCodeStyleSettings, Boolean>)((Function1)KotlinCommonBlockKt$INDENT_RULES$2.INSTANCE), true);
        NodeIndentStrategy.PositionStrategy positionStrategy20 = NodeIndentStrategy.Companion.strategy("If condition");
        KtNodeType ktNodeType12 = KtNodeTypes.CONDITION;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktNodeType12), (String)"KtNodeTypes.CONDITION");
        nodeIndentStrategyArray[7] = positionStrategy20.within(ktNodeType12, new IElementType[0]).set((Function1<? super CodeStyleSettings, ? extends Indent>)((Function1)INDENT_RULES.3.INSTANCE));
        NodeIndentStrategy.PositionStrategy positionStrategy21 = NodeIndentStrategy.Companion.strategy("Property accessor expression body");
        IElementType iElementType12 = KtNodeTypes.PROPERTY_ACCESSOR;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType12, (String)"KtNodeTypes.PROPERTY_ACCESSOR");
        NodeIndentStrategy.PositionStrategy positionStrategy22 = positionStrategy21.within(iElementType12, new IElementType[0]).forElement((Function1<? super ASTNode, Boolean>)((Function1)INDENT_RULES.4.INSTANCE));
        Indent indent7 = Indent.getNormalIndent();
        Intrinsics.checkExpressionValueIsNotNull((Object)indent7, (String)"Indent.getNormalIndent()");
        nodeIndentStrategyArray[8] = positionStrategy22.set(indent7);
        NodeIndentStrategy.PositionStrategy positionStrategy23 = NodeIndentStrategy.Companion.strategy("Property initializer");
        IElementType iElementType13 = KtNodeTypes.PROPERTY;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType13, (String)"KtNodeTypes.PROPERTY");
        nodeIndentStrategyArray[9] = KotlinCommonBlockKt.continuationIf$default(positionStrategy23.within(iElementType13, new IElementType[0]).forElement((Function1<? super ASTNode, Boolean>)((Function1)INDENT_RULES.5.INSTANCE)), (Function1)KotlinCommonBlockKt$INDENT_RULES$6.INSTANCE, false, 2, null);
        NodeIndentStrategy.PositionStrategy positionStrategy24 = NodeIndentStrategy.Companion.strategy("Indent for parts");
        IElementType iElementType14 = KtNodeTypes.PROPERTY;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType14, (String)"KtNodeTypes.PROPERTY");
        IElementType[] iElementTypeArray7 = new IElementType[3];
        IElementType iElementType15 = KtNodeTypes.FUN;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType15, (String)"KtNodeTypes.FUN");
        iElementTypeArray7[0] = iElementType15;
        IElementType iElementType16 = KtNodeTypes.DESTRUCTURING_DECLARATION;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType16, (String)"KtNodeTypes.DESTRUCTURING_DECLARATION");
        iElementTypeArray7[1] = iElementType16;
        IElementType iElementType17 = KtNodeTypes.SECONDARY_CONSTRUCTOR;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType17, (String)"KtNodeTypes.SECONDARY_CONSTRUCTOR");
        iElementTypeArray7[2] = iElementType17;
        NodeIndentStrategy.PositionStrategy positionStrategy25 = positionStrategy24.within(iElementType14, iElementTypeArray7);
        KtNodeType ktNodeType13 = KtNodeTypes.BLOCK;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktNodeType13), (String)"KtNodeTypes.BLOCK");
        IElementType iElementType18 = ktNodeType13;
        IElementType[] iElementTypeArray8 = new IElementType[6];
        KtKeywordToken ktKeywordToken2 = KtTokens.FUN_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktKeywordToken2), (String)"FUN_KEYWORD");
        iElementTypeArray8[0] = ktKeywordToken2;
        KtKeywordToken ktKeywordToken3 = KtTokens.VAL_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktKeywordToken3), (String)"VAL_KEYWORD");
        iElementTypeArray8[1] = ktKeywordToken3;
        KtKeywordToken ktKeywordToken4 = KtTokens.VAR_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktKeywordToken4), (String)"VAR_KEYWORD");
        iElementTypeArray8[2] = ktKeywordToken4;
        KtKeywordToken ktKeywordToken5 = KtTokens.CONSTRUCTOR_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktKeywordToken5), (String)"CONSTRUCTOR_KEYWORD");
        iElementTypeArray8[3] = ktKeywordToken5;
        KtSingleValueToken ktSingleValueToken7 = KtTokens.RPAR;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktSingleValueToken7), (String)"KtTokens.RPAR");
        iElementTypeArray8[4] = ktSingleValueToken7;
        KtToken ktToken = KtTokens.EOL_COMMENT;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktToken), (String)"KtTokens.EOL_COMMENT");
        iElementTypeArray8[5] = ktToken;
        NodeIndentStrategy.PositionStrategy positionStrategy26 = positionStrategy25.notForType(iElementType18, iElementTypeArray8);
        Indent indent8 = Indent.getContinuationWithoutFirstIndent();
        Intrinsics.checkExpressionValueIsNotNull((Object)indent8, (String)"Indent.getContinuationWithoutFirstIndent()");
        nodeIndentStrategyArray[10] = positionStrategy26.set(indent8);
        NodeIndentStrategy.PositionStrategy positionStrategy27 = NodeIndentStrategy.Companion.strategy("Chained calls");
        TokenSet tokenSet = QUALIFIED_EXPRESSIONS;
        Intrinsics.checkExpressionValueIsNotNull((Object)tokenSet, (String)"QUALIFIED_EXPRESSIONS");
        NodeIndentStrategy.PositionStrategy positionStrategy28 = positionStrategy27.within(tokenSet);
        KtSingleValueToken ktSingleValueToken8 = KtTokens.DOT;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktSingleValueToken8), (String)"KtTokens.DOT");
        IElementType iElementType19 = ktSingleValueToken8;
        IElementType[] iElementTypeArray9 = new IElementType[1];
        KtSingleValueToken ktSingleValueToken9 = KtTokens.SAFE_ACCESS;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktSingleValueToken9), (String)"KtTokens.SAFE_ACCESS");
        iElementTypeArray9[0] = ktSingleValueToken9;
        nodeIndentStrategyArray[11] = KotlinCommonBlockKt.continuationIf$default(positionStrategy28.notForType(iElementType19, iElementTypeArray9).forElement((Function1<? super ASTNode, Boolean>)((Function1)INDENT_RULES.7.INSTANCE)), (Function1)KotlinCommonBlockKt$INDENT_RULES$8.INSTANCE, false, 2, null);
        NodeIndentStrategy.PositionStrategy positionStrategy29 = NodeIndentStrategy.Companion.strategy("Colon of delegation list");
        IElementType iElementType20 = KtNodeTypes.CLASS;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType20, (String)"KtNodeTypes.CLASS");
        IElementType[] iElementTypeArray10 = new IElementType[1];
        IElementType iElementType21 = KtNodeTypes.OBJECT_DECLARATION;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType21, (String)"KtNodeTypes.OBJECT_DECLARATION");
        iElementTypeArray10[0] = iElementType21;
        NodeIndentStrategy.PositionStrategy positionStrategy30 = positionStrategy29.within(iElementType20, iElementTypeArray10);
        KtSingleValueToken ktSingleValueToken10 = KtTokens.COLON;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktSingleValueToken10), (String)"KtTokens.COLON");
        NodeIndentStrategy.PositionStrategy positionStrategy31 = positionStrategy30.forType(ktSingleValueToken10, new IElementType[0]);
        Indent indent9 = Indent.getNormalIndent((boolean)false);
        Intrinsics.checkExpressionValueIsNotNull((Object)indent9, (String)"Indent.getNormalIndent(false)");
        nodeIndentStrategyArray[12] = positionStrategy31.set(indent9);
        NodeIndentStrategy.PositionStrategy positionStrategy32 = NodeIndentStrategy.Companion.strategy("Delegation list");
        IElementType iElementType22 = KtNodeTypes.SUPER_TYPE_LIST;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType22, (String)"KtNodeTypes.SUPER_TYPE_LIST");
        IElementType[] iElementTypeArray11 = new IElementType[1];
        IElementType iElementType23 = KtNodeTypes.INITIALIZER_LIST;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType23, (String)"KtNodeTypes.INITIALIZER_LIST");
        iElementTypeArray11[0] = iElementType23;
        nodeIndentStrategyArray[13] = KotlinCommonBlockKt.continuationIf(positionStrategy32.within(iElementType22, iElementTypeArray11), (Function1<? super KotlinCodeStyleSettings, Boolean>)((Function1)KotlinCommonBlockKt$INDENT_RULES$9.INSTANCE), true);
        NodeIndentStrategy.PositionStrategy positionStrategy33 = NodeIndentStrategy.Companion.strategy("Indices");
        KtNodeType ktNodeType14 = KtNodeTypes.INDICES;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktNodeType14), (String)"KtNodeTypes.INDICES");
        NodeIndentStrategy.PositionStrategy positionStrategy34 = positionStrategy33.within(ktNodeType14, new IElementType[0]);
        KtSingleValueToken ktSingleValueToken11 = KtTokens.RBRACKET;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktSingleValueToken11), (String)"KtTokens.RBRACKET");
        NodeIndentStrategy.PositionStrategy positionStrategy35 = positionStrategy34.notForType(ktSingleValueToken11, new IElementType[0]);
        Indent indent10 = Indent.getContinuationIndent((boolean)false);
        Intrinsics.checkExpressionValueIsNotNull((Object)indent10, (String)"Indent.getContinuationIndent(false)");
        nodeIndentStrategyArray[14] = positionStrategy35.set(indent10);
        NodeIndentStrategy.PositionStrategy positionStrategy36 = NodeIndentStrategy.Companion.strategy("Binary expressions");
        TokenSet tokenSet2 = BINARY_EXPRESSIONS;
        Intrinsics.checkExpressionValueIsNotNull((Object)tokenSet2, (String)"BINARY_EXPRESSIONS");
        NodeIndentStrategy.PositionStrategy positionStrategy37 = positionStrategy36.within(tokenSet2).forElement((Function1<? super ASTNode, Boolean>)((Function1)INDENT_RULES.10.INSTANCE));
        Indent indent11 = Indent.getContinuationWithoutFirstIndent((boolean)false);
        Intrinsics.checkExpressionValueIsNotNull((Object)indent11, (String)"Indent.getContinuationWithoutFirstIndent(false)");
        nodeIndentStrategyArray[15] = positionStrategy37.set(indent11);
        NodeIndentStrategy.PositionStrategy positionStrategy38 = NodeIndentStrategy.Companion.strategy("Parenthesized expression");
        KtNodeType ktNodeType15 = KtNodeTypes.PARENTHESIZED;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktNodeType15), (String)"KtNodeTypes.PARENTHESIZED");
        NodeIndentStrategy.PositionStrategy positionStrategy39 = positionStrategy38.within(ktNodeType15, new IElementType[0]);
        Indent indent12 = Indent.getContinuationWithoutFirstIndent((boolean)false);
        Intrinsics.checkExpressionValueIsNotNull((Object)indent12, (String)"Indent.getContinuationWithoutFirstIndent(false)");
        nodeIndentStrategyArray[16] = positionStrategy39.set(indent12);
        NodeIndentStrategy.PositionStrategy positionStrategy40 = NodeIndentStrategy.Companion.strategy("Opening parenthesis for conditions");
        KtSingleValueToken ktSingleValueToken12 = KtTokens.LPAR;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktSingleValueToken12), (String)"LPAR");
        NodeIndentStrategy.PositionStrategy positionStrategy41 = positionStrategy40.forType(ktSingleValueToken12, new IElementType[0]);
        KtNodeType ktNodeType16 = KtNodeTypes.IF;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktNodeType16), (String)"IF");
        IElementType iElementType24 = ktNodeType16;
        IElementType[] iElementTypeArray12 = new IElementType[3];
        KtNodeType ktNodeType17 = KtNodeTypes.WHEN_ENTRY;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktNodeType17), (String)"KtNodeTypes.WHEN_ENTRY");
        iElementTypeArray12[0] = ktNodeType17;
        KtNodeType ktNodeType18 = KtNodeTypes.WHILE;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktNodeType18), (String)"WHILE");
        iElementTypeArray12[1] = ktNodeType18;
        KtNodeType ktNodeType19 = KtNodeTypes.DO_WHILE;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktNodeType19), (String)"DO_WHILE");
        iElementTypeArray12[2] = ktNodeType19;
        NodeIndentStrategy.PositionStrategy positionStrategy42 = positionStrategy41.within(iElementType24, iElementTypeArray12);
        Indent indent13 = Indent.getContinuationWithoutFirstIndent((boolean)true);
        Intrinsics.checkExpressionValueIsNotNull((Object)indent13, (String)"Indent.getContinuationWithoutFirstIndent(true)");
        nodeIndentStrategyArray[17] = positionStrategy42.set(indent13);
        NodeIndentStrategy.PositionStrategy positionStrategy43 = NodeIndentStrategy.Companion.strategy("Closing parenthesis for conditions");
        KtSingleValueToken ktSingleValueToken13 = KtTokens.RPAR;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktSingleValueToken13), (String)"RPAR");
        NodeIndentStrategy.PositionStrategy positionStrategy44 = positionStrategy43.forType(ktSingleValueToken13, new IElementType[0]).forElement((Function1<? super ASTNode, Boolean>)((Function1)INDENT_RULES.11.INSTANCE));
        KtNodeType ktNodeType20 = KtNodeTypes.IF;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktNodeType20), (String)"IF");
        IElementType iElementType25 = ktNodeType20;
        IElementType[] iElementTypeArray13 = new IElementType[3];
        KtNodeType ktNodeType21 = KtNodeTypes.WHEN_ENTRY;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktNodeType21), (String)"KtNodeTypes.WHEN_ENTRY");
        iElementTypeArray13[0] = ktNodeType21;
        KtNodeType ktNodeType22 = KtNodeTypes.WHILE;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktNodeType22), (String)"WHILE");
        iElementTypeArray13[1] = ktNodeType22;
        KtNodeType ktNodeType23 = KtNodeTypes.DO_WHILE;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktNodeType23), (String)"DO_WHILE");
        iElementTypeArray13[2] = ktNodeType23;
        NodeIndentStrategy.PositionStrategy positionStrategy45 = positionStrategy44.within(iElementType25, iElementTypeArray13);
        Indent indent14 = Indent.getNoneIndent();
        Intrinsics.checkExpressionValueIsNotNull((Object)indent14, (String)"Indent.getNoneIndent()");
        nodeIndentStrategyArray[18] = positionStrategy45.set(indent14);
        NodeIndentStrategy.PositionStrategy positionStrategy46 = NodeIndentStrategy.Companion.strategy("Closing parenthesis for incomplete conditions");
        KtSingleValueToken ktSingleValueToken14 = KtTokens.RPAR;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktSingleValueToken14), (String)"RPAR");
        NodeIndentStrategy.PositionStrategy positionStrategy47 = positionStrategy46.forType(ktSingleValueToken14, new IElementType[0]).forElement((Function1<? super ASTNode, Boolean>)((Function1)INDENT_RULES.12.INSTANCE));
        KtNodeType ktNodeType24 = KtNodeTypes.IF;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktNodeType24), (String)"IF");
        IElementType iElementType26 = ktNodeType24;
        IElementType[] iElementTypeArray14 = new IElementType[3];
        KtNodeType ktNodeType25 = KtNodeTypes.WHEN_ENTRY;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktNodeType25), (String)"KtNodeTypes.WHEN_ENTRY");
        iElementTypeArray14[0] = ktNodeType25;
        KtNodeType ktNodeType26 = KtNodeTypes.WHILE;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktNodeType26), (String)"WHILE");
        iElementTypeArray14[1] = ktNodeType26;
        KtNodeType ktNodeType27 = KtNodeTypes.DO_WHILE;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktNodeType27), (String)"DO_WHILE");
        iElementTypeArray14[2] = ktNodeType27;
        NodeIndentStrategy.PositionStrategy positionStrategy48 = positionStrategy47.within(iElementType26, iElementTypeArray14);
        Indent indent15 = Indent.getContinuationWithoutFirstIndent();
        Intrinsics.checkExpressionValueIsNotNull((Object)indent15, (String)"Indent.getContinuationWithoutFirstIndent()");
        nodeIndentStrategyArray[19] = positionStrategy48.set(indent15);
        NodeIndentStrategy.PositionStrategy positionStrategy49 = NodeIndentStrategy.Companion.strategy("KDoc comment indent");
        TokenSet tokenSet3 = KDOC_CONTENT;
        Intrinsics.checkExpressionValueIsNotNull((Object)tokenSet3, (String)"KDOC_CONTENT");
        NodeIndentStrategy.PositionStrategy positionStrategy50 = positionStrategy49.within(tokenSet3);
        KDocToken kDocToken = KDocTokens.LEADING_ASTERISK;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)kDocToken), (String)"KDocTokens.LEADING_ASTERISK");
        IElementType iElementType27 = kDocToken;
        IElementType[] iElementTypeArray15 = new IElementType[1];
        KDocToken kDocToken2 = KDocTokens.END;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)kDocToken2), (String)"KDocTokens.END");
        iElementTypeArray15[0] = kDocToken2;
        NodeIndentStrategy.PositionStrategy positionStrategy51 = positionStrategy50.forType(iElementType27, iElementTypeArray15);
        Indent indent16 = Indent.getSpaceIndent((int)1);
        Intrinsics.checkExpressionValueIsNotNull((Object)indent16, (String)"Indent.getSpaceIndent(KDOC_COMMENT_INDENT)");
        nodeIndentStrategyArray[20] = positionStrategy51.set(indent16);
        NodeIndentStrategy.PositionStrategy positionStrategy52 = NodeIndentStrategy.Companion.strategy("Block in when entry");
        KtNodeType ktNodeType28 = KtNodeTypes.WHEN_ENTRY;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktNodeType28), (String)"KtNodeTypes.WHEN_ENTRY");
        NodeIndentStrategy.PositionStrategy positionStrategy53 = positionStrategy52.within(ktNodeType28, new IElementType[0]);
        KtNodeType ktNodeType29 = KtNodeTypes.BLOCK;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktNodeType29), (String)"KtNodeTypes.BLOCK");
        IElementType iElementType28 = ktNodeType29;
        IElementType[] iElementTypeArray16 = new IElementType[5];
        KtNodeType ktNodeType30 = KtNodeTypes.WHEN_CONDITION_EXPRESSION;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktNodeType30), (String)"KtNodeTypes.WHEN_CONDITION_EXPRESSION");
        iElementTypeArray16[0] = ktNodeType30;
        KtNodeType ktNodeType31 = KtNodeTypes.WHEN_CONDITION_IN_RANGE;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktNodeType31), (String)"KtNodeTypes.WHEN_CONDITION_IN_RANGE");
        iElementTypeArray16[1] = ktNodeType31;
        KtNodeType ktNodeType32 = KtNodeTypes.WHEN_CONDITION_IS_PATTERN;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktNodeType32), (String)"KtNodeTypes.WHEN_CONDITION_IS_PATTERN");
        iElementTypeArray16[2] = ktNodeType32;
        KtKeywordToken ktKeywordToken6 = KtTokens.ELSE_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktKeywordToken6), (String)"ELSE_KEYWORD");
        iElementTypeArray16[3] = ktKeywordToken6;
        KtSingleValueToken ktSingleValueToken15 = KtTokens.ARROW;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktSingleValueToken15), (String)"ARROW");
        iElementTypeArray16[4] = ktSingleValueToken15;
        NodeIndentStrategy.PositionStrategy positionStrategy54 = positionStrategy53.notForType(iElementType28, iElementTypeArray16);
        Indent indent17 = Indent.getNormalIndent();
        Intrinsics.checkExpressionValueIsNotNull((Object)indent17, (String)"Indent.getNormalIndent()");
        nodeIndentStrategyArray[21] = positionStrategy54.set(indent17);
        NodeIndentStrategy.PositionStrategy positionStrategy55 = NodeIndentStrategy.Companion.strategy("Parameter list");
        IElementType iElementType29 = KtNodeTypes.VALUE_PARAMETER_LIST;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType29, (String)"KtNodeTypes.VALUE_PARAMETER_LIST");
        nodeIndentStrategyArray[22] = KotlinCommonBlockKt.continuationIf(positionStrategy55.within(iElementType29, new IElementType[0]).forElement((Function1<? super ASTNode, Boolean>)((Function1)INDENT_RULES.13.INSTANCE)), (Function1<? super KotlinCodeStyleSettings, Boolean>)((Function1)KotlinCommonBlockKt$INDENT_RULES$14.INSTANCE), true);
        NodeIndentStrategy.PositionStrategy positionStrategy56 = NodeIndentStrategy.Companion.strategy("Where clause");
        IElementType iElementType30 = KtNodeTypes.CLASS;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType30, (String)"KtNodeTypes.CLASS");
        IElementType[] iElementTypeArray17 = new IElementType[2];
        IElementType iElementType31 = KtNodeTypes.FUN;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType31, (String)"KtNodeTypes.FUN");
        iElementTypeArray17[0] = iElementType31;
        IElementType iElementType32 = KtNodeTypes.PROPERTY;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType32, (String)"KtNodeTypes.PROPERTY");
        iElementTypeArray17[1] = iElementType32;
        NodeIndentStrategy.PositionStrategy positionStrategy57 = positionStrategy56.within(iElementType30, iElementTypeArray17);
        KtKeywordToken ktKeywordToken7 = KtTokens.WHERE_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktKeywordToken7), (String)"KtTokens.WHERE_KEYWORD");
        NodeIndentStrategy.PositionStrategy positionStrategy58 = positionStrategy57.forType(ktKeywordToken7, new IElementType[0]);
        Indent indent18 = Indent.getContinuationIndent();
        Intrinsics.checkExpressionValueIsNotNull((Object)indent18, (String)"Indent.getContinuationIndent()");
        nodeIndentStrategyArray[23] = positionStrategy58.set(indent18);
        NodeIndentStrategy.PositionStrategy positionStrategy59 = NodeIndentStrategy.Companion.strategy("Array literals");
        KtNodeType ktNodeType33 = KtNodeTypes.COLLECTION_LITERAL_EXPRESSION;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktNodeType33), (String)"KtNodeTypes.COLLECTION_LITERAL_EXPRESSION");
        NodeIndentStrategy.PositionStrategy positionStrategy60 = positionStrategy59.within(ktNodeType33, new IElementType[0]);
        KtSingleValueToken ktSingleValueToken16 = KtTokens.LBRACKET;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktSingleValueToken16), (String)"LBRACKET");
        IElementType iElementType33 = ktSingleValueToken16;
        IElementType[] iElementTypeArray18 = new IElementType[1];
        KtSingleValueToken ktSingleValueToken17 = KtTokens.RBRACKET;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktSingleValueToken17), (String)"RBRACKET");
        iElementTypeArray18[0] = ktSingleValueToken17;
        NodeIndentStrategy.PositionStrategy positionStrategy61 = positionStrategy60.notForType(iElementType33, iElementTypeArray18);
        Indent indent19 = Indent.getNormalIndent();
        Intrinsics.checkExpressionValueIsNotNull((Object)indent19, (String)"Indent.getNormalIndent()");
        nodeIndentStrategyArray[24] = positionStrategy61.set(indent19);
        NodeIndentStrategy.PositionStrategy positionStrategy62 = NodeIndentStrategy.Companion.strategy("Type aliases");
        IElementType iElementType34 = KtNodeTypes.TYPEALIAS;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType34, (String)"KtNodeTypes.TYPEALIAS");
        NodeIndentStrategy.PositionStrategy positionStrategy63 = positionStrategy62.within(iElementType34, new IElementType[0]);
        KtKeywordToken ktKeywordToken8 = KtTokens.TYPE_ALIAS_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktKeywordToken8), (String)"KtTokens.TYPE_ALIAS_KEYWORD");
        IElementType iElementType35 = ktKeywordToken8;
        IElementType[] iElementTypeArray19 = new IElementType[4];
        KtToken ktToken2 = KtTokens.EOL_COMMENT;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktToken2), (String)"KtTokens.EOL_COMMENT");
        iElementTypeArray19[0] = ktToken2;
        IElementType iElementType36 = KtNodeTypes.MODIFIER_LIST;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType36, (String)"KtNodeTypes.MODIFIER_LIST");
        iElementTypeArray19[1] = iElementType36;
        KtToken ktToken3 = KtTokens.BLOCK_COMMENT;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktToken3), (String)"KtTokens.BLOCK_COMMENT");
        iElementTypeArray19[2] = ktToken3;
        IElementType iElementType37 = KtTokens.DOC_COMMENT;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType37, (String)"KtTokens.DOC_COMMENT");
        iElementTypeArray19[3] = iElementType37;
        NodeIndentStrategy.PositionStrategy positionStrategy64 = positionStrategy63.notForType(iElementType35, iElementTypeArray19);
        Indent indent20 = Indent.getContinuationIndent();
        Intrinsics.checkExpressionValueIsNotNull((Object)indent20, (String)"Indent.getContinuationIndent()");
        nodeIndentStrategyArray[25] = positionStrategy64.set(indent20);
        NodeIndentStrategy.PositionStrategy positionStrategy65 = NodeIndentStrategy.Companion.strategy("Default parameter values");
        IElementType iElementType38 = KtNodeTypes.VALUE_PARAMETER;
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType38, (String)"KtNodeTypes.VALUE_PARAMETER");
        nodeIndentStrategyArray[26] = KotlinCommonBlockKt.continuationIf(positionStrategy65.within(iElementType38, new IElementType[0]).forElement((Function1<? super ASTNode, Boolean>)((Function1)INDENT_RULES.15.INSTANCE)), (Function1<? super KotlinCodeStyleSettings, Boolean>)((Function1)KotlinCommonBlockKt$INDENT_RULES$16.INSTANCE), true);
        INDENT_RULES = nodeIndentStrategyArray;
    }

    @NotNull
    public static final /* synthetic */ TokenSet access$getQUALIFIED_EXPRESSIONS$p() {
        return QUALIFIED_EXPRESSIONS;
    }

    public static final /* synthetic */ int access$indexOfBlockWithType(@NotNull List $receiver, @NotNull TokenSet tokenSet) {
        return KotlinCommonBlockKt.indexOfBlockWithType($receiver, tokenSet);
    }

    @NotNull
    public static final /* synthetic */ TokenSet access$getQUALIFIED_OPERATION$p() {
        return QUALIFIED_OPERATION;
    }

    public static final /* synthetic */ boolean access$hasLineBreakBefore(@NotNull ASTNode node) {
        return KotlinCommonBlockKt.hasLineBreakBefore(node);
    }

    @NotNull
    public static final /* synthetic */ TokenSet access$getCODE_BLOCKS$p() {
        return CODE_BLOCKS;
    }

    @NotNull
    public static final /* synthetic */ TokenSet access$getELVIS_SET$p() {
        return ELVIS_SET;
    }

    @Nullable
    public static final /* synthetic */ ASTNode access$getPrevWithoutWhitespace(@NotNull ASTNode pNode) {
        return KotlinCommonBlockKt.getPrevWithoutWhitespace(pNode);
    }

    @Nullable
    public static final /* synthetic */ ASTNode access$getPrevWithoutWhitespaceAndComments(@NotNull ASTNode pNode) {
        return KotlinCommonBlockKt.getPrevWithoutWhitespaceAndComments(pNode);
    }

    @NotNull
    public static final /* synthetic */ NodeIndentStrategy[] access$getINDENT_RULES$p() {
        return INDENT_RULES;
    }

    @NotNull
    public static final /* synthetic */ CommonAlignmentStrategy access$getAlignmentForChildInParenthesis(boolean shouldAlignChild, @NotNull IElementType parameter, @NotNull IElementType delimiter, boolean shouldAlignParenthesis, @NotNull IElementType openBracket, @NotNull IElementType closeBracket) {
        return KotlinCommonBlockKt.getAlignmentForChildInParenthesis(shouldAlignChild, parameter, delimiter, shouldAlignParenthesis, openBracket, closeBracket);
    }

    @NotNull
    public static final /* synthetic */ TokenSet access$getBINARY_EXPRESSIONS$p() {
        return BINARY_EXPRESSIONS;
    }

    @NotNull
    public static final /* synthetic */ TokenSet access$getALIGN_FOR_BINARY_OPERATIONS$p() {
        return ALIGN_FOR_BINARY_OPERATIONS;
    }

    @Nullable
    public static final /* synthetic */ IElementType access$getOperationType(@NotNull ASTNode node) {
        return KotlinCommonBlockKt.getOperationType(node);
    }

    @NotNull
    public static final /* synthetic */ String access$extractIndent(@NotNull ASTNode node) {
        return KotlinCommonBlockKt.extractIndent(node);
    }

    public static final /* synthetic */ boolean access$startsWithAnnotation(@NotNull ASTNode $receiver) {
        return KotlinCommonBlockKt.startsWithAnnotation($receiver);
    }

    @NotNull
    public static final /* synthetic */ Function1 access$getWrappingStrategyForItemList(int wrapType, @NotNull TokenSet itemTypes, boolean wrapFirstElement) {
        return KotlinCommonBlockKt.getWrappingStrategyForItemList(wrapType, itemTypes, wrapFirstElement);
    }

    @NotNull
    public static final /* synthetic */ TokenSet access$getANNOTATIONS$p() {
        return ANNOTATIONS;
    }

    public static final /* synthetic */ boolean access$isFirstParameter(@NotNull ASTNode $receiver) {
        return KotlinCommonBlockKt.isFirstParameter($receiver);
    }

    @NotNull
    public static final /* synthetic */ Function1 access$wrapAfterAnnotation(int wrapType) {
        return KotlinCommonBlockKt.wrapAfterAnnotation(wrapType);
    }

    @Nullable
    public static final /* synthetic */ Wrap access$getWrapAfterAnnotation(@NotNull ASTNode childElement, int wrapType) {
        return KotlinCommonBlockKt.getWrapAfterAnnotation(childElement, wrapType);
    }

    public static final /* synthetic */ boolean access$suppressBinaryExpressionIndent(@NotNull ASTNode $receiver) {
        return KotlinCommonBlockKt.suppressBinaryExpressionIndent($receiver);
    }
}

