/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.framework;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.impl.ProjectJdkImpl;
import com.intellij.openapi.projectRoots.impl.SdkConfigurationUtil;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.util.Consumer;
import java.io.File;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinIcons;
import org.jetbrains.kotlin.idea.framework.KotlinSdkType;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.idea.versions.KotlinRuntimeLibraryUtilKt;
import org.jetbrains.kotlin.utils.PathUtil;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 *2\u00020\u0001:\u0001*B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0014\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fJ\u0010\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fH\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\rH\u0016J\u0012\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0012H\u0016J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\rH\u0016J0\u0010\u001f\u001a\u00020\u00192\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010\r2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\r0$H\u0016J\n\u0010%\u001a\u0004\u0018\u00010\u0004H\u0016J\u001c\u0010&\u001a\u00020\u00122\b\u0010'\u001a\u0004\u0018\u00010\u00122\b\u0010(\u001a\u0004\u0018\u00010\u0012H\u0016J\b\u0010)\u001a\u00020\u0016H\u0016\u00a8\u0006+"}, d2={"Lorg/jetbrains/kotlin/idea/framework/KotlinSdkType;", "Lcom/intellij/openapi/projectRoots/SdkType;", "()V", "createAdditionalDataConfigurable", "", "sdkModel", "Lcom/intellij/openapi/projectRoots/SdkModel;", "sdkModificator", "Lcom/intellij/openapi/projectRoots/SdkModificator;", "createSdkWithUniqueName", "Lcom/intellij/openapi/projectRoots/impl/ProjectJdkImpl;", "existingSdks", "", "Lcom/intellij/openapi/projectRoots/Sdk;", "getIcon", "Ljavax/swing/Icon;", "kotlin.jvm.PlatformType", "getPresentableName", "", "getVersionString", "sdk", "isValidSdkHome", "", "path", "saveAdditionalData", "", "additionalData", "Lcom/intellij/openapi/projectRoots/SdkAdditionalData;", "additional", "Lorg/jdom/Element;", "sdkHasValidPath", "showCustomCreateUI", "parentComponent", "Ljavax/swing/JComponent;", "selectedSdk", "sdkCreatedCallback", "Lcom/intellij/util/Consumer;", "suggestHomePath", "suggestSdkName", "currentSdkName", "sdkHome", "supportsCustomCreateUI", "Companion", "idea"})
public final class KotlinSdkType
extends SdkType {
    @JvmField
    @NotNull
    public static final KotlinSdkType INSTANCE;
    public static final Companion Companion;

    @NotNull
    public String getPresentableName() {
        return "Kotlin SDK";
    }

    public Icon getIcon() {
        return KotlinIcons.SMALL_LOGO;
    }

    public boolean isValidSdkHome(@Nullable String path) {
        return true;
    }

    @NotNull
    public String suggestSdkName(@Nullable String currentSdkName, @Nullable String sdkHome) {
        return "Kotlin SDK";
    }

    @Nullable
    public Void suggestHomePath() {
        return null;
    }

    public boolean sdkHasValidPath(@NotNull Sdk sdk2) {
        Intrinsics.checkParameterIsNotNull((Object)sdk2, (String)"sdk");
        return true;
    }

    @NotNull
    public String getVersionString(@NotNull Sdk sdk2) {
        Intrinsics.checkParameterIsNotNull((Object)sdk2, (String)"sdk");
        return KotlinRuntimeLibraryUtilKt.bundledRuntimeVersion();
    }

    public boolean supportsCustomCreateUI() {
        return true;
    }

    public void showCustomCreateUI(@NotNull SdkModel sdkModel, @NotNull JComponent parentComponent, @Nullable Sdk selectedSdk, @NotNull Consumer<Sdk> sdkCreatedCallback) {
        Intrinsics.checkParameterIsNotNull((Object)sdkModel, (String)"sdkModel");
        Intrinsics.checkParameterIsNotNull((Object)parentComponent, (String)"parentComponent");
        Intrinsics.checkParameterIsNotNull(sdkCreatedCallback, (String)"sdkCreatedCallback");
        Object[] objectArray = sdkModel.getSdks();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"sdkModel.sdks");
        sdkCreatedCallback.consume((Object)this.createSdkWithUniqueName(ArraysKt.toList((Object[])objectArray)));
    }

    @NotNull
    public final ProjectJdkImpl createSdkWithUniqueName(@NotNull Collection<? extends Sdk> existingSdks) {
        ProjectJdkImpl projectJdkImpl;
        Intrinsics.checkParameterIsNotNull(existingSdks, (String)"existingSdks");
        String sdkName = this.suggestSdkName(SdkConfigurationUtil.createUniqueSdkName((SdkType)this, (String)"", existingSdks), "");
        ProjectJdkImpl $receiver = projectJdkImpl = new ProjectJdkImpl(sdkName, (SdkTypeId)this);
        $receiver.setHomePath(Companion.getDefaultHomePath());
        return projectJdkImpl;
    }

    @Nullable
    public Void createAdditionalDataConfigurable(@NotNull SdkModel sdkModel, @NotNull SdkModificator sdkModificator) {
        Intrinsics.checkParameterIsNotNull((Object)sdkModel, (String)"sdkModel");
        Intrinsics.checkParameterIsNotNull((Object)sdkModificator, (String)"sdkModificator");
        return null;
    }

    public void saveAdditionalData(@NotNull SdkAdditionalData additionalData, @NotNull Element additional) {
        Intrinsics.checkParameterIsNotNull((Object)additionalData, (String)"additionalData");
        Intrinsics.checkParameterIsNotNull((Object)additional, (String)"additional");
    }

    public KotlinSdkType() {
        super("KotlinSDK");
    }

    static {
        Companion = new Companion(null);
        INSTANCE = new KotlinSdkType();
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\t\u001a\u00020\nR\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/framework/KotlinSdkType$Companion;", "", "()V", "INSTANCE", "Lorg/jetbrains/kotlin/idea/framework/KotlinSdkType;", "defaultHomePath", "", "getDefaultHomePath", "()Ljava/lang/String;", "setUpIfNeeded", "", "idea"})
    public static final class Companion {
        @NotNull
        public final String getDefaultHomePath() {
            File file = PathUtil.getKotlinPathsForIdeaPlugin().getHomePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"PathUtil.kotlinPathsForIdeaPlugin.homePath");
            String string = file.getAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"PathUtil.kotlinPathsForI\u2026gin.homePath.absolutePath");
            return string;
        }

        public final void setUpIfNeeded() {
            boolean bl;
            ProjectSdksModel $receiver;
            block2: {
                ProjectSdksModel projectSdksModel;
                $receiver = projectSdksModel = new ProjectSdksModel();
                $receiver.reset(null);
                Sdk[] sdkArray = $receiver.getSdks();
                Intrinsics.checkExpressionValueIsNotNull((Object)sdkArray, (String)"sdks");
                Sdk[] $receiver$iv = sdkArray;
                int n = $receiver$iv.length;
                for (int i = 0; i < n; ++i) {
                    Sdk element$iv;
                    Sdk it;
                    Sdk sdk2 = it = (element$iv = $receiver$iv[i]);
                    Intrinsics.checkExpressionValueIsNotNull((Object)sdk2, (String)"it");
                    if (!(sdk2.getSdkType() instanceof KotlinSdkType)) continue;
                    bl = true;
                    break block2;
                }
                bl = false;
            }
            if (bl) {
                return;
            }
            $receiver.addSdk((SdkType)INSTANCE, Companion.getDefaultHomePath(), null);
            ApplicationManager.getApplication().invokeAndWait(new Runnable($receiver){
                final /* synthetic */ ProjectSdksModel receiver$0;

                public final void run() {
                    ApplicationUtilsKt.runWriteAction((Function0)new Function0<Unit>(this){
                        final /* synthetic */ setUpIfNeeded.1.2 this$0;

                        public final void invoke() {
                            this.this$0.receiver$0.apply(null, true);
                        }
                        {
                            this.this$0 = var1_1;
                            super(0);
                        }
                    });
                }
                {
                    this.receiver$0 = projectSdksModel;
                }
            });
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

