/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.checkers.DebugInfoUtil;
import org.jetbrains.kotlin.idea.KotlinPluginUtil;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.highlighter.KotlinHighlightingColors;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtil;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtDeclarationContainer;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.resolve.BindingContext;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/DebugInfoAnnotator;", "Lcom/intellij/lang/annotation/Annotator;", "()V", "annotate", "", "element", "Lcom/intellij/psi/PsiElement;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "Companion", "idea-core"})
public final class DebugInfoAnnotator
implements Annotator {
    public static final Companion Companion = new Companion(null);

    public void annotate(@NotNull PsiElement element3, @NotNull AnnotationHolder holder) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        if (!Companion.isDebugInfoEnabled() || !ProjectRootsUtil.isInProjectOrLibSource(element3)) {
            return;
        }
        if (element3 instanceof KtFile && !(element3 instanceof KtCodeFragment)) {
            try {
                KtDeclarationContainer $receiver$iv = (KtDeclarationContainer)element3;
                BindingContext bindingContext2 = ResolutionUtils.getResolutionFacade((KtElement)((Object)$receiver$iv)).analyzeWithAllCompilerChecks(CollectionsKt.listOf((Object)$receiver$iv)).getBindingContext();
                DebugInfoUtil.markDebugAnnotations(element3, bindingContext2, new DebugInfoUtil.DebugInfoReporter(holder){
                    final /* synthetic */ AnnotationHolder $holder;

                    public void reportElementWithErrorType(@NotNull KtReferenceExpression expression2) {
                        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                        Annotation annotation2 = this.$holder.createErrorAnnotation((PsiElement)expression2, "[DEBUG] Resolved to error element");
                        Intrinsics.checkExpressionValueIsNotNull((Object)annotation2, (String)"holder.createErrorAnnota\u2026solved to error element\")");
                        annotation2.setTextAttributes(KotlinHighlightingColors.RESOLVED_TO_ERROR);
                    }

                    public void reportMissingUnresolved(@NotNull KtReferenceExpression expression2) {
                        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                        Annotation annotation2 = this.$holder.createErrorAnnotation((PsiElement)expression2, "[DEBUG] Reference is not resolved to anything, but is not marked unresolved");
                        Intrinsics.checkExpressionValueIsNotNull((Object)annotation2, (String)"holder.createErrorAnnota\u2026                        )");
                        annotation2.setTextAttributes(KotlinHighlightingColors.DEBUG_INFO);
                    }

                    public void reportUnresolvedWithTarget(@NotNull KtReferenceExpression expression2, @NotNull String target) {
                        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
                        Annotation annotation2 = this.$holder.createErrorAnnotation((PsiElement)expression2, "[DEBUG] Reference marked as unresolved is actually resolved to " + target);
                        Intrinsics.checkExpressionValueIsNotNull((Object)annotation2, (String)"holder.createErrorAnnota\u2026y resolved to \" + target)");
                        annotation2.setTextAttributes(KotlinHighlightingColors.DEBUG_INFO);
                    }
                    {
                        this.$holder = $captured_local_variable$0;
                    }
                });
            }
            catch (ProcessCanceledException e) {
                throw (Throwable)e;
            }
            catch (Throwable e) {
                holder.createErrorAnnotation(element3, e.getClass().getCanonicalName() + ": " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/DebugInfoAnnotator$Companion;", "", "()V", "isDebugInfoEnabled", "", "()Z", "idea-core"})
    public static final class Companion {
        public final boolean isDebugInfoEnabled() {
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
            return application.isInternal() && (KotlinPluginUtil.isSnapshotVersion() || KotlinPluginUtil.isDevVersion());
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

