/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.SyntheticFieldDescriptor;
import org.jetbrains.kotlin.idea.highlighter.AfterAnalysisHighlightingVisitor;
import org.jetbrains.kotlin.idea.highlighter.HighlightingVisitor;
import org.jetbrains.kotlin.idea.highlighter.KotlinHighlightingColors;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtValueArgumentName;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.smartcasts.ExplicitSmartCasts;
import org.jetbrains.kotlin.resolve.calls.smartcasts.ImplicitSmartCasts;
import org.jetbrains.kotlin.resolve.calls.smartcasts.MultipleSmartCasts;
import org.jetbrains.kotlin.resolve.calls.tasks.DynamicCallsKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExtensionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ImplicitClassReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ImplicitReceiver;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.expressions.CaptureKind;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/VariablesHighlightingVisitor;", "Lorg/jetbrains/kotlin/idea/highlighter/AfterAnalysisHighlightingVisitor;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "(Lcom/intellij/lang/annotation/AnnotationHolder;Lorg/jetbrains/kotlin/resolve/BindingContext;)V", "getSmartCastTarget", "Lcom/intellij/psi/PsiElement;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "highlightVariable", "", "elementToHighlight", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "visitExpression", "visitParameter", "parameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "visitProperty", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "visitSimpleNameExpression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "visitVariableDeclaration", "declaration", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "idea-core"})
public final class VariablesHighlightingVisitor
extends AfterAnalysisHighlightingVisitor {
    @Override
    public void visitSimpleNameExpression(@NotNull KtSimpleNameExpression expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)this.getBindingContext().get(BindingContext.REFERENCE_TARGET, expression2);
        if (declarationDescriptor == null) {
            return;
        }
        DeclarationDescriptor target = declarationDescriptor;
        if (target instanceof ValueParameterDescriptor && Intrinsics.areEqual((Object)((Boolean)this.getBindingContext().get(BindingContext.AUTO_CREATED_IT, target)), (Object)true)) {
            this.createInfoAnnotation((PsiElement)expression2, "Automatically declared based on the expected type").setTextAttributes(KotlinHighlightingColors.FUNCTION_LITERAL_DEFAULT_PARAMETER);
        }
        if (!(expression2.getParent() instanceof KtValueArgumentName)) {
            PsiElement psiElement2 = (PsiElement)expression2;
            DeclarationDescriptor declarationDescriptor2 = target;
            Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor2, (String)"target");
            this.highlightVariable(psiElement2, declarationDescriptor2);
        }
        super.visitSimpleNameExpression(expression2);
    }

    @Override
    public void visitProperty(@NotNull KtProperty property) {
        Intrinsics.checkParameterIsNotNull((Object)property, (String)"property");
        this.visitVariableDeclaration(property);
        super.visitProperty(property);
    }

    @Override
    public void visitParameter(@NotNull KtParameter parameter) {
        Intrinsics.checkParameterIsNotNull((Object)parameter, (String)"parameter");
        PropertyDescriptor propertyDescriptor = (PropertyDescriptor)this.getBindingContext().get(BindingContext.PRIMARY_CONSTRUCTOR_PARAMETER, parameter);
        if (propertyDescriptor == null) {
            this.visitVariableDeclaration(parameter);
        }
        super.visitParameter(parameter);
    }

    private final PsiElement getSmartCastTarget(KtExpression expression2) {
        PsiElement psiElement2;
        PsiElement psiElement3;
        PsiElement target = (PsiElement)expression2;
        if (target instanceof KtParenthesizedExpression) {
            KtExpression ktExpression = KtPsiUtil.deparenthesize((KtExpression)target);
            PsiElement psiElement4 = target = ktExpression != null ? (PsiElement)ktExpression : (PsiElement)expression2;
        }
        if ((psiElement3 = target) instanceof KtIfExpression) {
            PsiElement psiElement5 = ((KtIfExpression)target).getIfKeyword();
            psiElement2 = psiElement5;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement5, (String)"target.ifKeyword");
        } else if (psiElement3 instanceof KtWhenExpression) {
            PsiElement psiElement6 = ((KtWhenExpression)target).getWhenKeyword();
            psiElement2 = psiElement6;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement6, (String)"target.whenKeyword");
        } else if (psiElement3 instanceof KtBinaryExpression) {
            KtOperationReferenceExpression ktOperationReferenceExpression = ((KtBinaryExpression)target).getOperationReference();
            Intrinsics.checkExpressionValueIsNotNull((Object)ktOperationReferenceExpression, (String)"target.operationReference");
            psiElement2 = (PsiElement)ktOperationReferenceExpression;
        } else {
            psiElement2 = target;
        }
        return psiElement2;
    }

    @Override
    public void visitExpression(@NotNull KtExpression expression2) {
        ExplicitSmartCasts smartCast;
        boolean nullSmartCast;
        Object object;
        Object object2;
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        ImplicitSmartCasts implicitSmartCast = (ImplicitSmartCasts)this.getBindingContext().get(BindingContext.IMPLICIT_RECEIVER_SMARTCAST, expression2);
        if (implicitSmartCast != null) {
            Map<ImplicitReceiver, KotlinType> map2 = implicitSmartCast.getReceiverTypes();
            for (Map.Entry<ImplicitReceiver, KotlinType> entry : map2.entrySet()) {
                object2 = entry;
                ImplicitReceiver receiver = object2.getKey();
                object2 = entry;
                KotlinType type2 = object2.getValue();
                object = receiver;
                String receiverName = object instanceof ExtensionReceiver ? "Extension implicit receiver" : (object instanceof ImplicitClassReceiver ? "Implicit receiver" : "Unknown receiver");
                this.createInfoAnnotation((PsiElement)expression2, receiverName + " smart cast to " + DescriptorRenderer.FQ_NAMES_IN_TYPES.renderType(type2)).setTextAttributes(KotlinHighlightingColors.SMART_CAST_RECEIVER);
            }
        }
        if (nullSmartCast = Intrinsics.areEqual((Object)((Boolean)this.getBindingContext().get(BindingContext.SMARTCAST_NULL, expression2)), (Object)true)) {
            this.createInfoAnnotation((PsiElement)expression2, "Always null").setTextAttributes(KotlinHighlightingColors.SMART_CONSTANT);
        }
        if ((smartCast = (ExplicitSmartCasts)this.getBindingContext().get(BindingContext.SMARTCAST, expression2)) != null) {
            KotlinType defaultType2 = smartCast.getDefaultType();
            if (defaultType2 != null) {
                this.createInfoAnnotation(this.getSmartCastTarget(expression2), "Smart cast to " + DescriptorRenderer.FQ_NAMES_IN_TYPES.renderType(defaultType2)).setTextAttributes(KotlinHighlightingColors.SMART_CAST_VALUE);
            } else if (smartCast instanceof MultipleSmartCasts) {
                object = ((MultipleSmartCasts)smartCast).getMap();
                object2 = object.entrySet().iterator();
                while (object2.hasNext()) {
                    Map.Entry entry;
                    Map.Entry entry2 = entry = (Map.Entry)object2.next();
                    Call call2 = (Call)entry2.getKey();
                    entry2 = entry;
                    KotlinType type3 = (KotlinType)entry2.getValue();
                    this.createInfoAnnotation(this.getSmartCastTarget(expression2), "Smart cast to " + DescriptorRenderer.FQ_NAMES_IN_TYPES.renderType(type3) + " (for " + call2 + " call)").setTextAttributes(KotlinHighlightingColors.SMART_CAST_VALUE);
                }
            }
        }
        super.visitExpression(expression2);
    }

    private final void visitVariableDeclaration(KtNamedDeclaration declaration2) {
        DeclarationDescriptor declarationDescriptor = this.getBindingContext().get(BindingContext.DECLARATION_TO_DESCRIPTOR, declaration2);
        PsiElement nameIdentifier = declaration2.getNameIdentifier();
        if (nameIdentifier != null && declarationDescriptor != null) {
            this.highlightVariable(nameIdentifier, declarationDescriptor);
        }
    }

    private final void highlightVariable(PsiElement elementToHighlight, DeclarationDescriptor descriptor2) {
        if (descriptor2 instanceof VariableDescriptor) {
            if (DynamicCallsKt.isDynamic(descriptor2)) {
                TextAttributesKey textAttributesKey = KotlinHighlightingColors.DYNAMIC_PROPERTY_CALL;
                Intrinsics.checkExpressionValueIsNotNull((Object)textAttributesKey, (String)"DYNAMIC_PROPERTY_CALL");
                HighlightingVisitor.highlightName$default((HighlightingVisitor)this, elementToHighlight, textAttributesKey, null, 4, null);
                return;
            }
            if (((VariableDescriptor)descriptor2).isVar()) {
                TextAttributesKey textAttributesKey = KotlinHighlightingColors.MUTABLE_VARIABLE;
                Intrinsics.checkExpressionValueIsNotNull((Object)textAttributesKey, (String)"MUTABLE_VARIABLE");
                HighlightingVisitor.highlightName$default((HighlightingVisitor)this, elementToHighlight, textAttributesKey, null, 4, null);
            }
            if ((CaptureKind)((Object)this.getBindingContext().get(BindingContext.CAPTURED_IN_CLOSURE, descriptor2)) == CaptureKind.NOT_INLINE) {
                String msg = ((VariableDescriptor)descriptor2).isVar() ? "Wrapped into a reference object to be modified when captured in a closure" : "Value captured in a closure";
                PsiElement parent2 = elementToHighlight.getParent();
                if (!(parent2 instanceof PsiNameIdentifierOwner) || !Intrinsics.areEqual((Object)((PsiNameIdentifierOwner)parent2).getNameIdentifier(), (Object)elementToHighlight)) {
                    this.createInfoAnnotation(elementToHighlight, msg).setTextAttributes(KotlinHighlightingColors.WRAPPED_INTO_REF);
                    return;
                }
            }
            if (descriptor2 instanceof LocalVariableDescriptor && !(descriptor2 instanceof SyntheticFieldDescriptor)) {
                TextAttributesKey textAttributesKey = KotlinHighlightingColors.LOCAL_VARIABLE;
                Intrinsics.checkExpressionValueIsNotNull((Object)textAttributesKey, (String)"LOCAL_VARIABLE");
                HighlightingVisitor.highlightName$default((HighlightingVisitor)this, elementToHighlight, textAttributesKey, null, 4, null);
            }
            if (descriptor2 instanceof ValueParameterDescriptor) {
                TextAttributesKey textAttributesKey = KotlinHighlightingColors.PARAMETER;
                Intrinsics.checkExpressionValueIsNotNull((Object)textAttributesKey, (String)"PARAMETER");
                HighlightingVisitor.highlightName$default((HighlightingVisitor)this, elementToHighlight, textAttributesKey, null, 4, null);
            }
        }
    }

    public VariablesHighlightingVisitor(@NotNull AnnotationHolder holder, @NotNull BindingContext bindingContext2) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        Intrinsics.checkParameterIsNotNull((Object)bindingContext2, (String)"bindingContext");
        super(holder, bindingContext2);
    }
}

