/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter.markers;

import com.intellij.codeInsight.highlighting.TooltipLinkHandler;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.stubindex.KotlinFullClassNameIndex;
import org.jetbrains.kotlin.psi.KtClassOrObject;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/markers/KotlinClassTooltipLinkHandler;", "Lcom/intellij/codeInsight/highlighting/TooltipLinkHandler;", "()V", "handleLink", "", "refSuffix", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "idea"})
public final class KotlinClassTooltipLinkHandler
extends TooltipLinkHandler {
    public boolean handleLink(@NotNull String refSuffix, @NotNull Editor editor) {
        GlobalSearchScope globalSearchScope;
        Intrinsics.checkParameterIsNotNull((Object)refSuffix, (String)"refSuffix");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Project project = editor.getProject();
        if (project == null) {
            return false;
        }
        Project project2 = project;
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)project2);
        String qualifiedName2 = StringsKt.substringAfterLast$default((String)refSuffix, (String)":", null, (int)2, null);
        if (qualifiedName2.length() == refSuffix.length()) {
            globalSearchScope = GlobalSearchScope.allScope((Project)project2);
        } else {
            GlobalSearchScope globalSearchScope2;
            GlobalSearchScope it;
            String moduleName = StringsKt.substringBeforeLast$default((String)refSuffix, (String)":", null, (int)2, null);
            Module module = ModuleManager.getInstance((Project)project2).findModuleByName(moduleName);
            globalSearchScope = module;
            if (globalSearchScope == null || (globalSearchScope = GlobalSearchScope.moduleScope((Module)(it = (globalSearchScope2 = globalSearchScope)))) == null) {
                globalSearchScope = GlobalSearchScope.allScope((Project)project2);
            }
        }
        GlobalSearchScope scope2 = globalSearchScope;
        Collection<KtClassOrObject> collection = KotlinFullClassNameIndex.getInstance().get(qualifiedName2, project2, scope2);
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"KotlinFullClassNameIndex\u2026fiedName, project, scope)");
        KtClassOrObject ktClassOrObject = (KtClassOrObject)CollectionsKt.firstOrNull((Iterable)collection);
        PsiElement psiElement2 = ktClassOrObject != null ? (PsiElement)ktClassOrObject : (PsiElement)javaPsiFacade.findClass(qualifiedName2, scope2);
        if (psiElement2 == null) {
            return false;
        }
        PsiElement aClassElement = psiElement2;
        NavigationUtil.activateFileWithPsiElement((PsiElement)aClassElement);
        return true;
    }
}

