/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter.markers;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.NavigateAction;
import com.intellij.codeInsight.daemon.impl.LineMarkerNavigator;
import com.intellij.codeInsight.daemon.impl.MarkerType;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.util.Function;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtil;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.idea.KotlinIcons;
import org.jetbrains.kotlin.idea.caches.lightClasses.KtFakeLightClass;
import org.jetbrains.kotlin.idea.caches.lightClasses.KtFakeLightMethod;
import org.jetbrains.kotlin.idea.caches.project.MultiplatformUtilKt;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.PsiModificationUtilsKt;
import org.jetbrains.kotlin.idea.highlighter.markers.HasActualMarkerKt;
import org.jetbrains.kotlin.idea.highlighter.markers.HasExpectedMarkerKt;
import org.jetbrains.kotlin.idea.highlighter.markers.JavaPsiUtilsKt;
import org.jetbrains.kotlin.idea.highlighter.markers.KotlinLineMarkerProviderKt;
import org.jetbrains.kotlin.idea.highlighter.markers.NavigationPopupDescriptor;
import org.jetbrains.kotlin.idea.highlighter.markers.OverridenFunctionMarkerKt;
import org.jetbrains.kotlin.idea.highlighter.markers.OverridenPropertyMarkerKt;
import org.jetbrains.kotlin.idea.highlighter.markers.ResolveWithParentsResult;
import org.jetbrains.kotlin.idea.highlighter.markers.SuperDeclarationMarkerKt;
import org.jetbrains.kotlin.idea.highlighter.markers.SuperDeclarationMarkerNavigationHandler;
import org.jetbrains.kotlin.idea.highlighter.markers.SuperDeclarationMarkerTooltip;
import org.jetbrains.kotlin.idea.presentation.DeclarationByModuleRenderer;
import org.jetbrains.kotlin.idea.search.declarationsSearch.OverridersSearchKt;
import org.jetbrains.kotlin.idea.util.ExpectActualUtilKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0004\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0002\u0006\n\u001a\"\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00112\u0010\u0010\u001b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001d0\u001cH\u0002\u001a\"\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00112\u0010\u0010\u001b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001d0\u001cH\u0002\u001a\"\u0010\u001f\u001a\u00020\u00192\u0006\u0010 \u001a\u00020!2\u0010\u0010\u001b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001d0\u001cH\u0002\u001a\"\u0010\"\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00112\u0010\u0010\u001b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001d0\u001cH\u0002\u001a(\u0010#\u001a\u00020\u00192\f\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%2\u0010\u0010\u001b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001d0\u001cH\u0002\u001a(\u0010'\u001a\u00020\u00192\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00110%2\u0010\u0010\u001b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001d0\u001cH\u0002\u001a\"\u0010)\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00152\u0010\u0010\u001b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001d0\u001cH\u0002\u001a\u001e\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020-0%H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\"\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000b\"\u000e\u0010\f\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\r\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000e\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0018\u0010\u000f\u001a\u00020\u0010*\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\"\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u0015*\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006/"}, d2={"EXPECTED_DECLARATION", "Lcom/intellij/codeInsight/daemon/impl/MarkerType;", "IMPLEMENTED_MARK", "Ljavax/swing/Icon;", "IMPLEMENTING_MARK", "OVERRIDDEN_FUNCTION", "org/jetbrains/kotlin/idea/highlighter/markers/KotlinLineMarkerProviderKt$OVERRIDDEN_FUNCTION$1", "Lorg/jetbrains/kotlin/idea/highlighter/markers/KotlinLineMarkerProviderKt$OVERRIDDEN_FUNCTION$1;", "OVERRIDDEN_MARK", "OVERRIDDEN_PROPERTY", "org/jetbrains/kotlin/idea/highlighter/markers/KotlinLineMarkerProviderKt$OVERRIDDEN_PROPERTY$1", "Lorg/jetbrains/kotlin/idea/highlighter/markers/KotlinLineMarkerProviderKt$OVERRIDDEN_PROPERTY$1;", "OVERRIDING_MARK", "PLATFORM_ACTUAL", "SUBCLASSED_CLASS", "expectOrActualAnchor", "Lcom/intellij/psi/PsiElement;", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "getExpectOrActualAnchor", "(Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;)Lcom/intellij/psi/PsiElement;", "markerDeclaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "getMarkerDeclaration", "(Lcom/intellij/psi/PsiElement;)Lorg/jetbrains/kotlin/psi/KtDeclaration;", "collectActualMarkers", "", "declaration", "result", "", "Lcom/intellij/codeInsight/daemon/LineMarkerInfo;", "collectExpectedMarkers", "collectInheritedClassMarker", "element", "Lorg/jetbrains/kotlin/psi/KtClass;", "collectMultiplatformMarkers", "collectOverriddenFunctions", "functions", "", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "collectOverriddenPropertyAccessors", "properties", "collectSuperDeclarationMarkers", "isImplementsAndNotOverrides", "", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "overriddenMembers", "idea"})
public final class KotlinLineMarkerProviderKt {
    private static final Icon OVERRIDING_MARK;
    private static final Icon IMPLEMENTING_MARK;
    private static final Icon OVERRIDDEN_MARK;
    private static final Icon IMPLEMENTED_MARK;
    private static final MarkerType SUBCLASSED_CLASS;
    private static final OVERRIDDEN_FUNCTION.1 OVERRIDDEN_FUNCTION;
    private static final OVERRIDDEN_PROPERTY.1 OVERRIDDEN_PROPERTY;
    private static final MarkerType PLATFORM_ACTUAL;
    private static final MarkerType EXPECTED_DECLARATION;

    private static final KtDeclaration getMarkerDeclaration(@NotNull PsiElement $receiver) {
        KtDeclaration ktDeclaration;
        PsiElement psiElement2 = $receiver;
        if (!(psiElement2 instanceof KtDeclaration)) {
            psiElement2 = null;
        }
        if ((ktDeclaration = (KtDeclaration)psiElement2) == null) {
            PsiElement psiElement3 = $receiver.getParent();
            if (!(psiElement3 instanceof KtDeclaration)) {
                psiElement3 = null;
            }
            ktDeclaration = (KtDeclaration)psiElement3;
        }
        return ktDeclaration;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isImplementsAndNotOverrides(CallableMemberDescriptor descriptor2, Collection<? extends CallableMemberDescriptor> overriddenMembers) {
        boolean bl;
        if (descriptor2.getModality() == Modality.ABSTRACT) return false;
        Iterable $receiver$iv = overriddenMembers;
        if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
            return true;
        }
        Iterator iterator2 = $receiver$iv.iterator();
        do {
            if (!iterator2.hasNext()) return true;
            Object element$iv = iterator2.next();
            CallableMemberDescriptor it = (CallableMemberDescriptor)element$iv;
            if (it.getModality() != Modality.ABSTRACT) return false;
            bl = true;
        } while (bl);
        return false;
    }

    private static final void collectSuperDeclarationMarkers(KtDeclaration declaration2, Collection<LineMarkerInfo<?>> result2) {
        KtNamedDeclaration anchor2;
        KtNamedDeclaration ktNamedDeclaration;
        boolean bl;
        boolean bl2 = bl = declaration2 instanceof KtNamedFunction || declaration2 instanceof KtProperty || declaration2 instanceof KtParameter;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        if (!declaration2.hasModifier(KtTokens.OVERRIDE_KEYWORD)) {
            return;
        }
        ResolveWithParentsResult resolveWithParents = SuperDeclarationMarkerKt.resolveDeclarationWithParents(declaration2);
        if (resolveWithParents.getOverriddenDescriptors().isEmpty()) {
            return;
        }
        CallableMemberDescriptor callableMemberDescriptor = resolveWithParents.getDescriptor();
        if (callableMemberDescriptor == null) {
            Intrinsics.throwNpe();
        }
        boolean bl3 = KotlinLineMarkerProviderKt.isImplementsAndNotOverrides(callableMemberDescriptor, resolveWithParents.getOverriddenDescriptors());
        KtDeclaration ktDeclaration = declaration2;
        if (!(ktDeclaration instanceof KtNamedDeclaration)) {
            ktDeclaration = null;
        }
        if ((ktNamedDeclaration = (KtNamedDeclaration)ktDeclaration) == null || (ktNamedDeclaration = ktNamedDeclaration.getNameIdentifier()) == null) {
            ktNamedDeclaration = declaration2;
        }
        KtNamedDeclaration ktNamedDeclaration2 = anchor2 = ktNamedDeclaration;
        Intrinsics.checkExpressionValueIsNotNull((Object)ktNamedDeclaration2, (String)"anchor");
        LineMarkerInfo lineMarkerInfo = new LineMarkerInfo((PsiElement)anchor2, ktNamedDeclaration2.getTextRange(), bl3 ? IMPLEMENTING_MARK : OVERRIDING_MARK, 11, (Function)SuperDeclarationMarkerTooltip.INSTANCE, (GutterIconNavigationHandler)new SuperDeclarationMarkerNavigationHandler(), GutterIconRenderer.Alignment.RIGHT);
        NavigateAction.setNavigateAction((LineMarkerInfo)lineMarkerInfo, (String)(declaration2 instanceof KtNamedFunction ? "Go to super method" : "Go to super property"), (String)"GotoSuperMethod");
        result2.add(lineMarkerInfo);
    }

    private static final void collectInheritedClassMarker(KtClass element3, Collection<LineMarkerInfo<?>> result2) {
        PsiElement anchor2;
        KtLightClass lightClass;
        if (!PsiModificationUtilsKt.isInheritable(element3)) {
            return;
        }
        KtLightClass ktLightClass = LightClassUtilsKt.toLightClass(element3);
        if (ktLightClass == null) {
            ktLightClass = lightClass = (KtLightClass)new KtFakeLightClass(element3);
        }
        if (ClassInheritorsSearch.search((PsiClass)lightClass, (boolean)false).findFirst() == null) {
            return;
        }
        PsiElement psiElement2 = element3.getNameIdentifier();
        if (psiElement2 == null) {
            psiElement2 = element3;
        }
        PsiElement psiElement3 = anchor2 = psiElement2;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement3, (String)"anchor");
        LineMarkerInfo lineMarkerInfo = new LineMarkerInfo(anchor2, psiElement3.getTextRange(), element3.isInterface() ? IMPLEMENTED_MARK : OVERRIDDEN_MARK, 11, SUBCLASSED_CLASS.getTooltip(), SUBCLASSED_CLASS.getNavigationHandler(), GutterIconRenderer.Alignment.RIGHT);
        NavigateAction.setNavigateAction((LineMarkerInfo)lineMarkerInfo, (String)(element3.isInterface() ? "Go to implementations" : "Go to subclasses"), (String)"GotoImplementation");
        result2.add(lineMarkerInfo);
    }

    /*
     * WARNING - void declaration
     */
    private static final void collectOverriddenPropertyAccessors(Collection<? extends KtNamedDeclaration> properties2, Collection<LineMarkerInfo<?>> result2) {
        void $receiver$iv$iv;
        Object $receiver$iv;
        HashMap mappingToJava = new HashMap();
        for (KtNamedDeclaration ktNamedDeclaration : properties2) {
            if (!PsiModificationUtilsKt.isOverridable(ktNamedDeclaration)) continue;
            $receiver$iv = OverridersSearchKt.toPossiblyFakeLightMethods(ktNamedDeclaration);
            Object object = $receiver$iv.iterator();
            while (object.hasNext()) {
                Iterator element$iv = object.next();
                PsiMethod it = (PsiMethod)element$iv;
                Map map2 = mappingToJava;
                KtNamedDeclaration ktNamedDeclaration2 = ktNamedDeclaration;
                map2.put(it, ktNamedDeclaration2);
            }
            $receiver$iv = mappingToJava;
            object = ktNamedDeclaration;
            $receiver$iv.put(ktNamedDeclaration, object);
        }
        Set set2 = mappingToJava.keySet();
        Intrinsics.checkExpressionValueIsNotNull(set2, (String)"mappingToJava.keys");
        Iterable $receiver$iv2 = set2;
        $receiver$iv = $receiver$iv2;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            if (!(element$iv$iv instanceof PsiMethod)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Set<PsiClass> set3 = JavaPsiUtilsKt.collectContainingClasses((List)destination$iv$iv);
        for (KtNamedDeclaration property : OverridenFunctionMarkerKt.getOverriddenDeclarations(mappingToJava, set3)) {
            PsiNameIdentifierOwner anchor2;
            PsiNameIdentifierOwner psiNameIdentifierOwner;
            ProgressManager.checkCanceled();
            KtNamedDeclaration ktNamedDeclaration = property;
            if (!(ktNamedDeclaration instanceof PsiNameIdentifierOwner)) {
                ktNamedDeclaration = null;
            }
            if ((psiNameIdentifierOwner = (PsiNameIdentifierOwner)ktNamedDeclaration) == null || (psiNameIdentifierOwner = psiNameIdentifierOwner.getNameIdentifier()) == null) {
                psiNameIdentifierOwner = property;
            }
            PsiNameIdentifierOwner psiNameIdentifierOwner2 = anchor2 = psiNameIdentifierOwner;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiNameIdentifierOwner2, (String)"anchor");
            LineMarkerInfo lineMarkerInfo = new LineMarkerInfo((PsiElement)anchor2, psiNameIdentifierOwner2.getTextRange(), OverridenPropertyMarkerKt.isImplemented(property) ? IMPLEMENTED_MARK : OVERRIDDEN_MARK, 11, OVERRIDDEN_PROPERTY.getTooltip(), OVERRIDDEN_PROPERTY.getNavigationHandler(), GutterIconRenderer.Alignment.RIGHT);
            NavigateAction.setNavigateAction((LineMarkerInfo)lineMarkerInfo, (String)"Go to overridden properties", (String)"GotoImplementation");
            result2.add(lineMarkerInfo);
        }
    }

    private static final PsiElement getExpectOrActualAnchor(@NotNull KtNamedDeclaration $receiver) {
        PsiElement psiElement2;
        Object object = $receiver.getNameIdentifier();
        if (object == null) {
            KtNamedDeclaration ktNamedDeclaration = $receiver;
            if (ktNamedDeclaration instanceof KtConstructor) {
                object = ((KtConstructor)$receiver).getConstructorKeyword();
                if (object == null) {
                    KtParameterList ktParameterList = ((KtConstructor)$receiver).getValueParameterList();
                    object = ktParameterList != null ? ktParameterList.getLeftParenthesis() : null;
                }
            } else {
                object = psiElement2 = ktNamedDeclaration instanceof KtObjectDeclaration ? ((KtObjectDeclaration)$receiver).getObjectKeyword() : null;
            }
        }
        if (object == null) {
            psiElement2 = $receiver;
        }
        return psiElement2;
    }

    private static final void collectMultiplatformMarkers(KtNamedDeclaration declaration2, Collection<LineMarkerInfo<?>> result2) {
        if (ExpectActualUtilKt.isExpectDeclaration(declaration2)) {
            KotlinLineMarkerProviderKt.collectActualMarkers(declaration2, result2);
        } else if (ExpectActualUtilKt.isEffectivelyActual(declaration2)) {
            KotlinLineMarkerProviderKt.collectExpectedMarkers(declaration2, result2);
        }
    }

    private static final void collectActualMarkers(KtNamedDeclaration declaration2, Collection<LineMarkerInfo<?>> result2) {
        boolean bl;
        block7: {
            if (declaration2 instanceof KtPrimaryConstructor) {
                return;
            }
            DeclarationDescriptor declarationDescriptor = PsiModificationUtilsKt.toDescriptor(declaration2);
            if (!(declarationDescriptor instanceof MemberDescriptor)) {
                declarationDescriptor = null;
            }
            MemberDescriptor memberDescriptor = (MemberDescriptor)declarationDescriptor;
            if (memberDescriptor == null) {
                return;
            }
            MemberDescriptor descriptor2 = memberDescriptor;
            KtFile ktFile = declaration2.getContainingKtFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)ktFile, (String)"declaration.containingKtFile");
            ModuleDescriptor commonModuleDescriptor = ResolutionUtils.findModuleDescriptor(ktFile);
            Iterable $receiver$iv = MultiplatformUtilKt.getImplementingDescriptors(commonModuleDescriptor);
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $receiver$iv) {
                    ModuleDescriptor it = (ModuleDescriptor)element$iv;
                    if (!ExpectActualUtilKt.hasActualsFor(it, descriptor2)) continue;
                    bl = false;
                    break block7;
                }
                bl = true;
            }
        }
        if (bl) {
            return;
        }
        PsiElement anchor2 = KotlinLineMarkerProviderKt.getExpectOrActualAnchor(declaration2);
        LineMarkerInfo lineMarkerInfo = new LineMarkerInfo(anchor2, anchor2.getTextRange(), KotlinIcons.ACTUAL, 11, PLATFORM_ACTUAL.getTooltip(), PLATFORM_ACTUAL.getNavigationHandler(), GutterIconRenderer.Alignment.RIGHT);
        NavigateAction.setNavigateAction((LineMarkerInfo)lineMarkerInfo, (String)"Go to actual declarations", (String)"GotoImplementation");
        result2.add(lineMarkerInfo);
    }

    private static final void collectExpectedMarkers(KtNamedDeclaration declaration2, Collection<LineMarkerInfo<?>> result2) {
        boolean bl;
        block7: {
            if (declaration2 instanceof KtPrimaryConstructor) {
                return;
            }
            DeclarationDescriptor declarationDescriptor = PsiModificationUtilsKt.toDescriptor(declaration2);
            if (!(declarationDescriptor instanceof MemberDescriptor)) {
                declarationDescriptor = null;
            }
            MemberDescriptor memberDescriptor = (MemberDescriptor)declarationDescriptor;
            if (memberDescriptor == null) {
                return;
            }
            MemberDescriptor descriptor2 = memberDescriptor;
            KtFile ktFile = declaration2.getContainingKtFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)ktFile, (String)"declaration.containingKtFile");
            ModuleDescriptor platformModuleDescriptor = ResolutionUtils.findModuleDescriptor(ktFile);
            Iterable $receiver$iv = MultiplatformUtilKt.getImplementedDescriptors(platformModuleDescriptor);
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    ModuleDescriptor it = (ModuleDescriptor)element$iv;
                    if (!ExpectActualUtilKt.hasDeclarationOf(it, descriptor2)) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        if (!bl) {
            return;
        }
        PsiElement anchor2 = KotlinLineMarkerProviderKt.getExpectOrActualAnchor(declaration2);
        LineMarkerInfo lineMarkerInfo = new LineMarkerInfo(anchor2, anchor2.getTextRange(), KotlinIcons.EXPECT, 11, EXPECTED_DECLARATION.getTooltip(), EXPECTED_DECLARATION.getNavigationHandler(), GutterIconRenderer.Alignment.RIGHT);
        NavigateAction.setNavigateAction((LineMarkerInfo)lineMarkerInfo, (String)"Go to expected declaration", null);
        result2.add(lineMarkerInfo);
    }

    /*
     * WARNING - void declaration
     */
    private static final void collectOverriddenFunctions(Collection<? extends KtNamedFunction> functions2, Collection<LineMarkerInfo<?>> result2) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable method;
        HashMap mappingToJava = new HashMap();
        for (KtNamedFunction ktNamedFunction : functions2) {
            Object object;
            Map map2;
            if (!PsiModificationUtilsKt.isOverridable(ktNamedFunction)) continue;
            Object object2 = LightClassUtil.INSTANCE.getLightClassMethod(ktNamedFunction);
            if (object2 == null) {
                object2 = method = (PsiMethod)KtFakeLightMethod.Companion.get(ktNamedFunction);
            }
            if (method != null) {
                map2 = mappingToJava;
                object = ktNamedFunction;
                map2.put(method, object);
            }
            map2 = mappingToJava;
            object = ktNamedFunction;
            map2.put(ktNamedFunction, object);
        }
        Set set2 = mappingToJava.keySet();
        Intrinsics.checkExpressionValueIsNotNull(set2, (String)"mappingToJava.keys");
        method = $receiver$iv = (Iterable)set2;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            if (!(element$iv$iv instanceof PsiMethod)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Set<PsiClass> set3 = JavaPsiUtilsKt.collectContainingClasses((List)destination$iv$iv);
        for (KtNamedFunction function3 : OverridenFunctionMarkerKt.getOverriddenDeclarations(mappingToJava, set3)) {
            PsiElement anchor2;
            ProgressManager.checkCanceled();
            PsiElement psiElement2 = function3.getNameIdentifier();
            if (psiElement2 == null) {
                psiElement2 = function3;
            }
            PsiElement psiElement3 = anchor2 = psiElement2;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement3, (String)"anchor");
            LineMarkerInfo lineMarkerInfo = new LineMarkerInfo(anchor2, psiElement3.getTextRange(), OverridenPropertyMarkerKt.isImplemented(function3) ? IMPLEMENTED_MARK : OVERRIDDEN_MARK, 11, OVERRIDDEN_FUNCTION.getTooltip(), OVERRIDDEN_FUNCTION.getNavigationHandler(), GutterIconRenderer.Alignment.RIGHT);
            NavigateAction.setNavigateAction((LineMarkerInfo)lineMarkerInfo, (String)"Go to overridden methods", (String)"GotoImplementation");
            result2.add(lineMarkerInfo);
        }
    }

    static {
        Icon icon = AllIcons.Gutter.OverridingMethod;
        Intrinsics.checkExpressionValueIsNotNull((Object)icon, (String)"AllIcons.Gutter.OverridingMethod");
        OVERRIDING_MARK = icon;
        Icon icon2 = AllIcons.Gutter.ImplementingMethod;
        Intrinsics.checkExpressionValueIsNotNull((Object)icon2, (String)"AllIcons.Gutter.ImplementingMethod");
        IMPLEMENTING_MARK = icon2;
        Icon icon3 = AllIcons.Gutter.OverridenMethod;
        Intrinsics.checkExpressionValueIsNotNull((Object)icon3, (String)"AllIcons.Gutter.OverridenMethod");
        OVERRIDDEN_MARK = icon3;
        Icon icon4 = AllIcons.Gutter.ImplementedMethod;
        Intrinsics.checkExpressionValueIsNotNull((Object)icon4, (String)"AllIcons.Gutter.ImplementedMethod");
        IMPLEMENTED_MARK = icon4;
        SUBCLASSED_CLASS = new MarkerType("SUBCLASSED_CLASS", (Function)SUBCLASSED_CLASS.1.INSTANCE, new LineMarkerNavigator(){

            public void browse(@Nullable MouseEvent e, @Nullable PsiElement element3) {
                block0: {
                    PsiClass psiClass2;
                    PsiClass psiClass3 = JavaPsiUtilsKt.getPsiClass(element3);
                    if (psiClass3 == null) break block0;
                    PsiClass it = psiClass2 = psiClass3;
                    MarkerType.navigateToSubclassedClass((MouseEvent)e, (PsiClass)it, (PsiElementListCellRenderer)new DeclarationByModuleRenderer());
                }
            }
        });
        OVERRIDDEN_FUNCTION = new MarkerType("OVERRIDDEN_FUNCTION", OVERRIDDEN_FUNCTION.2.INSTANCE, new LineMarkerNavigator(){

            public void browse(@Nullable MouseEvent e, @Nullable PsiElement element3) {
                block0: {
                    NavigationPopupDescriptor navigationPopupDescriptor = OverridenFunctionMarkerKt.buildNavigateToOverriddenMethodPopup(e, element3);
                    if (navigationPopupDescriptor == null) break block0;
                    navigationPopupDescriptor.showPopup(e);
                }
            }
        }){

            @NotNull
            public GutterIconNavigationHandler<PsiElement> getNavigationHandler() {
                GutterIconNavigationHandler superHandler = super.getNavigationHandler();
                return (GutterIconNavigationHandler)new GutterIconNavigationHandler<PsiElement>(superHandler){
                    final /* synthetic */ GutterIconNavigationHandler $superHandler;

                    public void navigate(@Nullable MouseEvent e, @Nullable PsiElement elt) {
                        this.$superHandler.navigate(e, elt);
                    }

                    @Nullable
                    public NavigationPopupDescriptor getTargetsPopupDescriptor(@Nullable PsiElement element3) {
                        return OverridenFunctionMarkerKt.buildNavigateToOverriddenMethodPopup(null, element3);
                    }
                    {
                        this.$superHandler = $captured_local_variable$0;
                    }
                };
            }
        };
        OVERRIDDEN_PROPERTY = new MarkerType("OVERRIDDEN_PROPERTY", OVERRIDDEN_PROPERTY.2.INSTANCE, new LineMarkerNavigator(){

            public void browse(@Nullable MouseEvent e, @Nullable PsiElement element3) {
                block0: {
                    NavigationPopupDescriptor navigationPopupDescriptor = OverridenPropertyMarkerKt.buildNavigateToPropertyOverriddenDeclarationsPopup(e, element3);
                    if (navigationPopupDescriptor == null) break block0;
                    navigationPopupDescriptor.showPopup(e);
                }
            }
        }){

            @NotNull
            public GutterIconNavigationHandler<PsiElement> getNavigationHandler() {
                GutterIconNavigationHandler superHandler = super.getNavigationHandler();
                return (GutterIconNavigationHandler)new GutterIconNavigationHandler<PsiElement>(superHandler){
                    final /* synthetic */ GutterIconNavigationHandler $superHandler;

                    public void navigate(@Nullable MouseEvent e, @Nullable PsiElement elt) {
                        this.$superHandler.navigate(e, elt);
                    }

                    @Nullable
                    public NavigationPopupDescriptor getTargetsPopupDescriptor(@Nullable PsiElement element3) {
                        return OverridenPropertyMarkerKt.buildNavigateToPropertyOverriddenDeclarationsPopup(null, element3);
                    }
                    {
                        this.$superHandler = $captured_local_variable$0;
                    }
                };
            }
        };
        PLATFORM_ACTUAL = new MarkerType("PLATFORM_ACTUAL", (Function)PLATFORM_ACTUAL.1.INSTANCE, new LineMarkerNavigator(){

            public void browse(@Nullable MouseEvent e, @Nullable PsiElement element3) {
                block0: {
                    PsiElement psiElement2;
                    PsiElement psiElement3 = element3;
                    if (psiElement3 == null) break block0;
                    PsiElement it = psiElement2 = psiElement3;
                    HasActualMarkerKt.navigateToPlatformActual(e, KotlinLineMarkerProviderKt.access$getMarkerDeclaration$p(it));
                }
            }
        });
        EXPECTED_DECLARATION = new MarkerType("EXPECTED_DECLARATION", (Function)EXPECTED_DECLARATION.1.INSTANCE, new LineMarkerNavigator(){

            public void browse(@Nullable MouseEvent e, @Nullable PsiElement element3) {
                block0: {
                    PsiElement psiElement2;
                    PsiElement psiElement3 = element3;
                    if (psiElement3 == null) break block0;
                    PsiElement it = psiElement2 = psiElement3;
                    HasExpectedMarkerKt.navigateToExpectedDeclaration(KotlinLineMarkerProviderKt.access$getMarkerDeclaration$p(it));
                }
            }
        });
    }

    public static final /* synthetic */ void access$collectInheritedClassMarker(@NotNull KtClass element3, @NotNull Collection result2) {
        KotlinLineMarkerProviderKt.collectInheritedClassMarker(element3, result2);
    }

    public static final /* synthetic */ void access$collectSuperDeclarationMarkers(@NotNull KtDeclaration declaration2, @NotNull Collection result2) {
        KotlinLineMarkerProviderKt.collectSuperDeclarationMarkers(declaration2, result2);
    }

    public static final /* synthetic */ void access$collectMultiplatformMarkers(@NotNull KtNamedDeclaration declaration2, @NotNull Collection result2) {
        KotlinLineMarkerProviderKt.collectMultiplatformMarkers(declaration2, result2);
    }

    public static final /* synthetic */ void access$collectOverriddenFunctions(@NotNull Collection functions2, @NotNull Collection result2) {
        KotlinLineMarkerProviderKt.collectOverriddenFunctions(functions2, result2);
    }

    public static final /* synthetic */ void access$collectOverriddenPropertyAccessors(@NotNull Collection properties2, @NotNull Collection result2) {
        KotlinLineMarkerProviderKt.collectOverriddenPropertyAccessors(properties2, result2);
    }

    @Nullable
    public static final /* synthetic */ KtDeclaration access$getMarkerDeclaration$p(@NotNull PsiElement $receiver) {
        return KotlinLineMarkerProviderKt.getMarkerDeclaration($receiver);
    }
}

