/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter.renderersUtil;

import com.google.common.html.HtmlEscapers;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.rendering.RenderersKt;
import org.jetbrains.kotlin.diagnostics.rendering.RenderingContext;
import org.jetbrains.kotlin.diagnostics.rendering.SmartDescriptorRenderer;
import org.jetbrains.kotlin.diagnostics.rendering.SmartTypeRenderer;
import org.jetbrains.kotlin.idea.highlighter.renderersUtil.RenderersUtilKt;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.renderer.DescriptorRendererOptions;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.components.ArgumentsUtilsKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u001a\u000e\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u001a\u0010\b\u001a\u00020\u00032\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\u000b\u001a\u00020\f\u001a\u000e\u0010\r\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0016\u0010\r\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"HTML_FOR_UNINFERRED_TYPE_PARAMS", "Lorg/jetbrains/kotlin/renderer/DescriptorRenderer;", "RED_TEMPLATE", "", "STRONG_TEMPLATE", "renderError", "o", "", "renderResolvedCall", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "context", "Lorg/jetbrains/kotlin/diagnostics/rendering/RenderingContext;", "renderStrong", "error", "", "idea-core"})
public final class RenderersUtilKt {
    private static final String RED_TEMPLATE = "<font color=red><b>%s</b></font>";
    private static final String STRONG_TEMPLATE = "<b>%s</b>";
    private static final DescriptorRenderer HTML_FOR_UNINFERRED_TYPE_PARAMS;

    @NotNull
    public static final String renderStrong(@NotNull Object o) {
        Intrinsics.checkParameterIsNotNull((Object)o, (String)"o");
        String string = STRONG_TEMPLATE;
        Object[] objectArray = new Object[]{o};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(this, *args)");
        return string2;
    }

    @NotNull
    public static final String renderError(@NotNull Object o) {
        Intrinsics.checkParameterIsNotNull((Object)o, (String)"o");
        String string = RED_TEMPLATE;
        Object[] objectArray = new Object[]{o};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(this, *args)");
        return string2;
    }

    @NotNull
    public static final String renderStrong(@NotNull Object o, boolean error) {
        Intrinsics.checkParameterIsNotNull((Object)o, (String)"o");
        String string = error ? RED_TEMPLATE : STRONG_TEMPLATE;
        Object[] objectArray = new Object[]{o};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(this, *args)");
        return string2;
    }

    @NotNull
    public static final String renderResolvedCall(@NotNull ResolvedCall<?> resolvedCall2, @NotNull RenderingContext context2) {
        Object resultingDescriptor;
        Intrinsics.checkParameterIsNotNull(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        SmartTypeRenderer typeRenderer2 = new SmartTypeRenderer(HTML_FOR_UNINFERRED_TYPE_PARAMS);
        SmartDescriptorRenderer descriptorRenderer2 = RenderersKt.asRenderer(HTML_FOR_UNINFERRED_TYPE_PARAMS);
        StringBuilder stringBuilder = new StringBuilder("");
        String indent = "&nbsp;&nbsp;";
        Function1<Object, StringBuilder> append$ = new Function1<Object, StringBuilder>(stringBuilder){
            final /* synthetic */ StringBuilder $stringBuilder;

            @NotNull
            public final StringBuilder invoke(@NotNull Object any2) {
                Intrinsics.checkParameterIsNotNull((Object)any2, (String)"any");
                StringBuilder stringBuilder = this.$stringBuilder.append(any2);
                Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder, (String)"stringBuilder.append(any)");
                return stringBuilder;
            }
            {
                this.$stringBuilder = stringBuilder;
                super(1);
            }
        };
        Function1<ValueParameterDescriptor, String> renderParameter$ = new Function1<ValueParameterDescriptor, String>(typeRenderer2, context2, resolvedCall2){
            final /* synthetic */ SmartTypeRenderer $typeRenderer;
            final /* synthetic */ RenderingContext $context;
            final /* synthetic */ ResolvedCall $resolvedCall;

            @NotNull
            public final String invoke(@NotNull ValueParameterDescriptor parameter) {
                Intrinsics.checkParameterIsNotNull((Object)parameter, (String)"parameter");
                KotlinType varargElementType = parameter.getVarargElementType();
                KotlinType kotlinType = varargElementType;
                if (kotlinType == null) {
                    KotlinType kotlinType2 = parameter.getType();
                    kotlinType = kotlinType2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"parameter.type");
                }
                KotlinType parameterType = kotlinType;
                String renderedParameter = (varargElementType != null ? "<b>vararg</b> " : "") + this.$typeRenderer.render(parameterType, this.$context) + (ArgumentsUtilsKt.hasDefaultValue(parameter) ? " = ..." : "");
                if (CallUtilKt.hasTypeMismatchErrorOnParameter(this.$resolvedCall, parameter)) {
                    return RenderersUtilKt.renderError(renderedParameter);
                }
                return renderedParameter;
            }
            {
                this.$typeRenderer = smartTypeRenderer;
                this.$context = renderingContext;
                this.$resolvedCall = resolvedCall2;
                super(1);
            }
        };
        Function0<Unit> appendTypeParametersSubstitution$ = new Function0<Unit>(resolvedCall2, append$, indent, typeRenderer2, context2){
            final /* synthetic */ ResolvedCall $resolvedCall;
            final /* synthetic */ renderResolvedCall.1 $append$1;
            final /* synthetic */ String $indent;
            final /* synthetic */ SmartTypeRenderer $typeRenderer;
            final /* synthetic */ RenderingContext $context;

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                void inferredTypeParameters;
                List<TypeParameterDescriptor> typeParameters;
                Map<TypeParameterDescriptor, KotlinType> parametersToArgumentsMap = this.$resolvedCall.getTypeArguments();
                Function1<TypeParameterDescriptor, Boolean> isInferred$ = new Function1<TypeParameterDescriptor, Boolean>(parametersToArgumentsMap){
                    final /* synthetic */ Map $parametersToArgumentsMap;

                    public final boolean invoke(@NotNull TypeParameterDescriptor $receiver) {
                        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                        KotlinType typeArgument = (KotlinType)this.$parametersToArgumentsMap.get($receiver);
                        if (typeArgument == null) {
                            return false;
                        }
                        return !ErrorUtils.isUninferredParameter(typeArgument);
                    }
                    {
                        this.$parametersToArgumentsMap = map2;
                        super(1);
                    }
                };
                D d = this.$resolvedCall.getCandidateDescriptor();
                Intrinsics.checkExpressionValueIsNotNull(d, (String)"resolvedCall.candidateDescriptor");
                List<TypeParameterDescriptor> list2 = typeParameters = d.getTypeParameters();
                Intrinsics.checkExpressionValueIsNotNull(list2, (String)"typeParameters");
                Iterable $receiver$iv = list2;
                ArrayList<T> first$iv = new ArrayList<T>();
                ArrayList<T> second$iv = new ArrayList<T>();
                for (T element$iv : $receiver$iv) {
                    TypeParameterDescriptor p1 = (TypeParameterDescriptor)element$iv;
                    if (isInferred$.invoke(p1)) {
                        first$iv.add(element$iv);
                        continue;
                    }
                    second$iv.add(element$iv);
                }
                Pair pair2 = new Pair(first$iv, second$iv);
                List list3 = (List)pair2.component1();
                List notInferredTypeParameters = (List)pair2.component2();
                this.$append$1.invoke("<br/>" + this.$indent + "<i>where</i> ");
                if (!notInferredTypeParameters.isEmpty()) {
                    this.$append$1.invoke(CollectionsKt.joinToString$default((Iterable)notInferredTypeParameters, null, null, null, (int)0, null, (Function1)renderResolvedCall.3.INSTANCE, (int)31, null));
                    this.$append$1.invoke("<i> cannot be inferred</i>");
                    if (!inferredTypeParameters.isEmpty()) {
                        this.$append$1.invoke("; ");
                    }
                }
                Map<TypeParameterDescriptor, KotlinType> typeParameterToTypeArgumentMap = this.$resolvedCall.getTypeArguments();
                if (!inferredTypeParameters.isEmpty()) {
                    this.$append$1.invoke(CollectionsKt.joinToString$default((Iterable)((Iterable)inferredTypeParameters), null, null, null, (int)0, null, (Function1)((Function1)new Function1<TypeParameterDescriptor, String>(this, typeParameterToTypeArgumentMap){
                        final /* synthetic */ renderResolvedCall.3 this$0;
                        final /* synthetic */ Map $typeParameterToTypeArgumentMap;

                        @NotNull
                        public final String invoke(TypeParameterDescriptor typeParameter) {
                            StringBuilder stringBuilder = new StringBuilder();
                            TypeParameterDescriptor typeParameterDescriptor = typeParameter;
                            Intrinsics.checkExpressionValueIsNotNull((Object)typeParameterDescriptor, (String)"typeParameter");
                            StringBuilder stringBuilder2 = stringBuilder.append(typeParameterDescriptor.getName()).append(" = ");
                            SmartTypeRenderer smartTypeRenderer = this.this$0.$typeRenderer;
                            V v = this.$typeParameterToTypeArgumentMap.get(typeParameter);
                            if (v == null) {
                                Intrinsics.throwNpe();
                            }
                            return stringBuilder2.append(smartTypeRenderer.render((KotlinType)v, this.this$0.$context)).toString();
                        }
                        {
                            this.this$0 = var1_1;
                            this.$typeParameterToTypeArgumentMap = map2;
                            super(1);
                        }
                    }), (int)31, null));
                }
            }
            {
                this.$resolvedCall = resolvedCall2;
                this.$append$1 = var2_2;
                this.$indent = string;
                this.$typeRenderer = smartTypeRenderer;
                this.$context = renderingContext;
                super(0);
            }
        };
        Object obj = resultingDescriptor = resolvedCall2.getResultingDescriptor();
        Intrinsics.checkExpressionValueIsNotNull(obj, (String)"resultingDescriptor");
        ReceiverParameterDescriptor receiverParameter = obj.getExtensionReceiverParameter();
        if (receiverParameter != null) {
            KotlinType kotlinType = receiverParameter.getType();
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"receiverParameter.type");
            ((StringBuilder)append$.invoke((Object)typeRenderer2.render(kotlinType, context2))).append(".");
        }
        String string = HtmlEscapers.htmlEscaper().escape(resultingDescriptor.getName().asString());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"HtmlEscapers.htmlEscaper\u2026scriptor.name.asString())");
        ((StringBuilder)append$.invoke((Object)string)).append("(");
        List<ValueParameterDescriptor> list2 = resultingDescriptor.getValueParameters();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"resultingDescriptor.valueParameters");
        append$.invoke((Object)CollectionsKt.joinToString$default((Iterable)list2, null, null, null, (int)0, null, (Function1)((Function1)new Function1<ValueParameterDescriptor, String>(renderParameter$){
            final /* synthetic */ renderResolvedCall.2 $renderParameter$2;

            @NotNull
            public final String invoke(@NotNull ValueParameterDescriptor p1) {
                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                return this.$renderParameter$2.invoke(p1);
            }

            public final KDeclarationContainer getOwner() {
                return null;
            }

            public final String getName() {
                return "renderParameter";
            }

            public final String getSignature() {
                return "invoke(Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;)Ljava/lang/String;";
            }
            {
                this.$renderParameter$2 = var1_1;
                super(1);
            }
        }), (int)31, null));
        append$.invoke((Object)(CallUtilKt.hasUnmappedArguments(resolvedCall2) ? RenderersUtilKt.renderError(")") : ")"));
        Object obj2 = resolvedCall2.getCandidateDescriptor();
        Intrinsics.checkExpressionValueIsNotNull(obj2, (String)"resolvedCall.candidateDescriptor");
        if (!obj2.getTypeParameters().isEmpty()) {
            appendTypeParametersSubstitution$.invoke();
            append$.invoke((Object)("<i> for </i><br/>" + indent));
            Object obj3 = resolvedCall2.getCandidateDescriptor();
            Intrinsics.checkExpressionValueIsNotNull(obj3, (String)"resolvedCall.candidateDescriptor");
            append$.invoke((Object)descriptorRenderer2.render((DeclarationDescriptor)obj3, RenderingContext.Companion.of(resolvedCall2.getCandidateDescriptor())));
        } else {
            String string2;
            FqNameUnsafe fqName2;
            append$.invoke((Object)" <i>defined in</i> ");
            DeclarationDescriptor containingDeclaration2 = resultingDescriptor.getContainingDeclaration();
            FqNameUnsafe fqNameUnsafe = fqName2 = DescriptorUtils.getFqName(containingDeclaration2);
            Intrinsics.checkExpressionValueIsNotNull((Object)fqNameUnsafe, (String)"fqName");
            if (fqNameUnsafe.isRoot()) {
                string2 = "root package";
            } else {
                String string3 = fqName2.asString();
                string2 = string3;
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"fqName.asString()");
            }
            append$.invoke((Object)string2);
        }
        String string4 = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"stringBuilder.toString()");
        return string4;
    }

    static {
        RED_TEMPLATE = RED_TEMPLATE;
        STRONG_TEMPLATE = STRONG_TEMPLATE;
        HTML_FOR_UNINFERRED_TYPE_PARAMS = DescriptorRenderer.Companion.withOptions((Function1<? super DescriptorRendererOptions, Unit>)((Function1)HTML_FOR_UNINFERRED_TYPE_PARAMS.1.INSTANCE));
    }
}

