/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.inspections.ConstantConditionIfInspectionKt;
import org.jetbrains.kotlin.idea.intentions.branchedTransformations.IfThenUtilsKt;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\t\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ConstantConditionIfInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "RemoveFix", "SimplifyFix", "idea"})
public final class ConstantConditionIfInspection
extends AbstractKotlinInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        return VisitorWrappersKt.ifExpressionVisitor((Function1<? super KtIfExpression, Unit>)((Function1)new Function1<KtIfExpression, Unit>(holder){
            final /* synthetic */ ProblemsHolder $holder;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull KtIfExpression expression2) {
                LocalQuickFix[] localQuickFixArray;
                void $receiver$iv;
                Object object;
                KtExpression condition2;
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                KtExpression ktExpression = expression2.getCondition();
                if (ktExpression == null) {
                    return;
                }
                KtExpression ktExpression2 = condition2 = ktExpression;
                Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression2, (String)"condition");
                BindingContext context2 = ResolutionUtils.analyze(ktExpression2, BodyResolveMode.PARTIAL_WITH_CFA);
                Boolean bl = ConstantConditionIfInspectionKt.access$constantBooleanValue(condition2, context2);
                if (bl == null) {
                    return;
                }
                boolean constantValue = bl;
                List fixes = new ArrayList<E>();
                if (ConstantConditionIfInspectionKt.access$branch(expression2, constantValue) != null) {
                    boolean keepBraces = IfThenUtilsKt.isElseIf(expression2) && ConstantConditionIfInspectionKt.access$branch(expression2, constantValue) instanceof KtBlockExpression;
                    object = fixes;
                    SimplifyFix simplifyFix = new SimplifyFix(constantValue, BindingContextUtilsKt.isUsedAsExpression(expression2, context2), keepBraces);
                    object.add(simplifyFix);
                }
                if (!constantValue && expression2.getElse() == null) {
                    Collection keepBraces = fixes;
                    object = new RemoveFix();
                    keepBraces.add(object);
                }
                Collection keepBraces = fixes;
                String string = "Condition is always '" + constantValue + '\'';
                PsiElement psiElement2 = (PsiElement)condition2;
                ProblemsHolder problemsHolder = this.$holder;
                void thisCollection$iv = $receiver$iv;
                LocalQuickFix[] localQuickFixArray2 = thisCollection$iv.toArray(new LocalQuickFix[0]);
                if (localQuickFixArray2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                LocalQuickFix[] localQuickFixArray3 = localQuickFixArray = localQuickFixArray2;
                problemsHolder.registerProblem(psiElement2, string, Arrays.copyOf(localQuickFixArray3, localQuickFixArray3.length));
            }
            {
                this.$holder = problemsHolder;
                super(1);
            }
        }));
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ConstantConditionIfInspection$SimplifyFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "conditionValue", "", "isUsedAsExpression", "keepBraces", "(ZZZ)V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "getName", "idea"})
    private static final class SimplifyFix
    implements LocalQuickFix {
        private final boolean conditionValue;
        private final boolean isUsedAsExpression;
        private final boolean keepBraces;

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        @NotNull
        public String getName() {
            return "Simplify expression";
        }

        /*
         * WARNING - void declaration
         */
        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            KtExpression ktExpression;
            KtIfExpression ifExpression2;
            block7: {
                block6: {
                    KtExpression ktExpression2;
                    KtExpression ktExpression3;
                    void $receiver$iv;
                    Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                    Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
                    PsiElement psiElement2 = descriptor2.getPsiElement();
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"descriptor.psiElement");
                    PsiElement psiElement3 = psiElement2;
                    boolean strict$iv = true;
                    KtIfExpression ktIfExpression = (KtIfExpression)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtIfExpression.class, (boolean)strict$iv);
                    if (ktIfExpression == null) {
                        return;
                    }
                    ifExpression2 = ktIfExpression;
                    ktExpression = ConstantConditionIfInspectionKt.access$branch(ifExpression2, this.conditionValue);
                    if (ktExpression == null) break block6;
                    KtExpression it = ktExpression3 = ktExpression;
                    if (this.keepBraces) {
                        ktExpression2 = it;
                    } else {
                        KtExpression ktExpression4 = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression4, (String)"it");
                        ktExpression2 = ktExpression = IfThenUtilsKt.unwrapBlockOrParenthesis(ktExpression4);
                    }
                    if (ktExpression2 != null) break block7;
                }
                return;
            }
            KtExpression branch = ktExpression;
            KtExpression ktExpression5 = ifExpression2;
            KtExpression ktExpression6 = branch;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression6, (String)"branch");
            ConstantConditionIfInspectionKt.replaceWithBranch(ktExpression5, ktExpression6, this.isUsedAsExpression, this.keepBraces);
        }

        public SimplifyFix(boolean conditionValue, boolean isUsedAsExpression, boolean keepBraces) {
            this.conditionValue = conditionValue;
            this.isUsedAsExpression = isUsedAsExpression;
            this.keepBraces = keepBraces;
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ConstantConditionIfInspection$RemoveFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "getName", "idea"})
    private static final class RemoveFix
    implements LocalQuickFix {
        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        @NotNull
        public String getName() {
            return "Delete expression";
        }

        /*
         * WARNING - void declaration
         */
        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            void $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            PsiElement psiElement2 = descriptor2.getPsiElement();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"descriptor.psiElement");
            PsiElement psiElement3 = psiElement2;
            boolean strict$iv = true;
            KtIfExpression ktIfExpression = (KtIfExpression)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtIfExpression.class, (boolean)strict$iv);
            if (ktIfExpression == null) {
                return;
            }
            KtIfExpression ifExpression2 = ktIfExpression;
            ifExpression2.delete();
        }
    }
}

