/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.IntentionWrapper;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.intentions.ConvertLambdaToReferenceIntention;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/MoveSuspiciousCallableReferenceIntoParenthesesInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "MoveIntoParenthesesIntention", "idea"})
public final class MoveSuspiciousCallableReferenceIntoParenthesesInspection
extends AbstractKotlinInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        return VisitorWrappersKt.lambdaExpressionVisitor((Function1<? super KtLambdaExpression, Unit>)((Function1)new Function1<KtLambdaExpression, Unit>(holder){
            final /* synthetic */ ProblemsHolder $holder;

            public final void invoke(@NotNull KtLambdaExpression lambdaExpression2) {
                KtCallableReferenceExpression callableReference2;
                KtExpression ktExpression;
                Intrinsics.checkParameterIsNotNull((Object)lambdaExpression2, (String)"lambdaExpression");
                Object object = lambdaExpression2.getBodyExpression();
                if (!((object != null && (object = ((KtBlockExpression)object).getStatements()) != null ? (KtExpression)CollectionsKt.singleOrNull((List)object) : (ktExpression = null)) instanceof KtCallableReferenceExpression)) {
                    ktExpression = null;
                }
                if ((callableReference2 = (KtCallableReferenceExpression)ktExpression) != null) {
                    BindingContext context2 = ResolutionUtils.analyze$default(lambdaExpression2, null, 1, null);
                    ResolvedCall parentResolvedCall = CallUtilKt.getParentResolvedCall$default(lambdaExpression2, context2, false, 2, null);
                    if (parentResolvedCall != null) {
                        ValueParameterDescriptor originalParameterDescriptor;
                        PsiElement psiElement2 = lambdaExpression2.getParent();
                        if (!(psiElement2 instanceof ValueArgument)) {
                            psiElement2 = null;
                        }
                        ValueParameterDescriptor valueParameterDescriptor = CallUtilKt.getParameterForArgument(parentResolvedCall, (ValueArgument)psiElement2);
                        ValueParameterDescriptor valueParameterDescriptor2 = originalParameterDescriptor = valueParameterDescriptor != null ? valueParameterDescriptor.getOriginal() : null;
                        if (originalParameterDescriptor != null) {
                            KotlinType expectedType;
                            KotlinType kotlinType = expectedType = originalParameterDescriptor.getType();
                            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"expectedType");
                            if (FunctionTypesKt.isBuiltinFunctionalType(kotlinType)) {
                                KotlinType returnType2 = FunctionTypesKt.getReturnTypeFromFunctionType(expectedType);
                                if (FunctionTypesKt.isBuiltinFunctionalTypeOrSubtype(returnType2)) {
                                    return;
                                }
                                Call call2 = parentResolvedCall.getCall();
                                Intrinsics.checkExpressionValueIsNotNull((Object)call2, (String)"parentResolvedCall.call");
                                KtElement ktElement = call2.getCallElement();
                                Intrinsics.checkExpressionValueIsNotNull((Object)ktElement, (String)"parentResolvedCall.call.callElement");
                                if (CallUtilKt.getParentCall$default(ktElement, context2, false, 2, null) != null) {
                                    return;
                                }
                            }
                        }
                    }
                    this.$holder.registerProblem((PsiElement)lambdaExpression2, "Suspicious callable reference as the only lambda element", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{(LocalQuickFix)new IntentionWrapper((IntentionAction)new MoveIntoParenthesesIntention(), lambdaExpression2.getContainingFile())});
                }
            }
            {
                this.$holder = problemsHolder;
                super(1);
            }
        }));
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/MoveSuspiciousCallableReferenceIntoParenthesesInspection$MoveIntoParenthesesIntention;", "Lorg/jetbrains/kotlin/idea/intentions/ConvertLambdaToReferenceIntention;", "()V", "buildReferenceText", "", "element", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "isApplicableTo", "", "idea"})
    public static final class MoveIntoParenthesesIntention
    extends ConvertLambdaToReferenceIntention {
        @Override
        @Nullable
        public String buildReferenceText(@NotNull KtLambdaExpression element3) {
            ResolvedCall<? extends CallableDescriptor> resolvedCall2;
            KtSimpleNameExpression callableReference2;
            block6: {
                KtExpression receiverExpression;
                block8: {
                    block9: {
                        block7: {
                            block5: {
                                KtExpression ktExpression;
                                Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                                Object object = element3.getBodyExpression();
                                if (!((object != null && (object = ((KtBlockExpression)object).getStatements()) != null ? (KtExpression)CollectionsKt.singleOrNull((List)object) : (ktExpression = null)) instanceof KtCallableReferenceExpression)) {
                                    ktExpression = null;
                                }
                                KtCallableReferenceExpression ktCallableReferenceExpression = (KtCallableReferenceExpression)ktExpression;
                                if (ktCallableReferenceExpression == null) {
                                    return null;
                                }
                                KtCallableReferenceExpression callableReferenceExpression = ktCallableReferenceExpression;
                                callableReference2 = callableReferenceExpression.getCallableReference();
                                receiverExpression = callableReferenceExpression.getReceiverExpression();
                                if (receiverExpression != null) break block5;
                                resolvedCall2 = "";
                                break block6;
                            }
                            CallableDescriptor descriptor2 = UtilsKt.getCallableDescriptor(receiverExpression);
                            KtFunctionLiteral literal = element3.getFunctionLiteral();
                            if (descriptor2 == null) break block7;
                            if (!(descriptor2 instanceof ValueParameterDescriptor)) break block8;
                            CallableDescriptor callableDescriptor = ((ValueParameterDescriptor)descriptor2).getContainingDeclaration();
                            KtFunctionLiteral ktFunctionLiteral = literal;
                            Intrinsics.checkExpressionValueIsNotNull((Object)ktFunctionLiteral, (String)"literal");
                            if (!Intrinsics.areEqual((Object)callableDescriptor, (Object)ResolutionUtils.resolveToDescriptorIfAny$default(ktFunctionLiteral, null, 1, null))) break block8;
                        }
                        KtSimpleNameExpression ktSimpleNameExpression = callableReference2;
                        Intrinsics.checkExpressionValueIsNotNull((Object)ktSimpleNameExpression, (String)"callableReference");
                        resolvedCall2 = ResolutionUtils.resolveToCall(ktSimpleNameExpression, BodyResolveMode.FULL);
                        if (resolvedCall2 == null) break block9;
                        ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
                        ResolvedCall<? extends CallableDescriptor> it = resolvedCall3;
                        Object object = it.getExtensionReceiver();
                        if (object == null) {
                            object = resolvedCall2 = it.getDispatchReceiver();
                        }
                        if (object != null && (resolvedCall2 = String.valueOf((it = (resolvedCall3 = resolvedCall2)).getType())) != null) break block6;
                    }
                    resolvedCall2 = "";
                    break block6;
                }
                resolvedCall2 = receiverExpression.getText();
            }
            String receiver = resolvedCall2;
            StringBuilder stringBuilder = new StringBuilder().append(receiver).append("::");
            KtSimpleNameExpression ktSimpleNameExpression = callableReference2;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktSimpleNameExpression, (String)"callableReference");
            return stringBuilder.append(ktSimpleNameExpression.getText()).toString();
        }

        @Override
        public boolean isApplicableTo(@NotNull KtLambdaExpression element3) {
            Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
            return true;
        }

        public MoveIntoParenthesesIntention() {
            super("Move suspicious callable reference into parentheses '()'");
        }
    }
}

