/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.IntentionWrapper;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.EditorTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.regex.PatternSyntaxException;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.intellij.lang.regexp.RegExpFileType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.idea.quickfix.AddExclExclCallFix;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00162\u00020\u0001:\u0002\u0016\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016R$\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/PlatformExtensionReceiverOfInlineInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "()V", "value", "", "namePattern", "getNamePattern", "()Ljava/lang/String;", "setNamePattern", "(Ljava/lang/String;)V", "nameRegex", "Lkotlin/text/Regex;", "buildVisitor", "Lorg/jetbrains/kotlin/psi/KtVisitorVoid;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "createOptionsPanel", "Lorg/jetbrains/kotlin/idea/inspections/PlatformExtensionReceiverOfInlineInspection$OptionsPanel;", "Companion", "OptionsPanel", "idea"})
public final class PlatformExtensionReceiverOfInlineInspection
extends AbstractKotlinInspection {
    private Regex nameRegex;
    @NotNull
    private String namePattern;
    @NotNull
    public static final String defaultNamePattern = "(toBoolean)|(content.*)";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final String getNamePattern() {
        return this.namePattern;
    }

    public final void setNamePattern(@NotNull String value) {
        PlatformExtensionReceiverOfInlineInspection platformExtensionReceiverOfInlineInspection;
        String string;
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this.namePattern = value;
        PlatformExtensionReceiverOfInlineInspection platformExtensionReceiverOfInlineInspection2 = this;
        try {
            string = value;
            PlatformExtensionReceiverOfInlineInspection platformExtensionReceiverOfInlineInspection3 = platformExtensionReceiverOfInlineInspection2;
            Regex regex = new Regex(string);
            platformExtensionReceiverOfInlineInspection = platformExtensionReceiverOfInlineInspection3;
            string = regex;
        }
        catch (PatternSyntaxException patternSyntaxException) {
            platformExtensionReceiverOfInlineInspection = platformExtensionReceiverOfInlineInspection2;
            string = null;
        }
        platformExtensionReceiverOfInlineInspection.nameRegex = string;
    }

    @NotNull
    public KtVisitorVoid buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        return new KtVisitorVoid(this, holder){
            final /* synthetic */ PlatformExtensionReceiverOfInlineInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;

            public void visitDotQualifiedExpression(@NotNull KtDotQualifiedExpression expression2) {
                Object extensionReceiverType;
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                super.visitDotQualifiedExpression(expression2);
                if (!PlatformKt.getLanguageVersionSettings(expression2).supportsFeature(LanguageFeature.NullabilityAssertionOnExtensionReceiver)) {
                    return;
                }
                Regex nameRegex = PlatformExtensionReceiverOfInlineInspection.access$getNameRegex$p(this.this$0);
                KtExpression ktExpression = expression2.getSelectorExpression();
                if (!(ktExpression instanceof KtCallExpression)) {
                    ktExpression = null;
                }
                KtCallExpression ktCallExpression = (KtCallExpression)ktExpression;
                if (ktCallExpression == null) {
                    return;
                }
                KtCallExpression callExpression2 = ktCallExpression;
                Object object = callExpression2.getCalleeExpression();
                if (object == null || (object = object.getText()) == null) {
                    return;
                }
                Object calleeText = object;
                if (nameRegex != null && !nameRegex.matches((CharSequence)calleeText)) {
                    return;
                }
                ResolvedCall resolvedCall2 = ResolutionUtils.resolveToCall$default(expression2, null, 1, null);
                if (resolvedCall2 == null) {
                    return;
                }
                ResolvedCall resolvedCall3 = resolvedCall2;
                Object object2 = resolvedCall3.getExtensionReceiver();
                if (object2 == null || (object2 = object2.getType()) == null) {
                    return;
                }
                Object object3 = extensionReceiverType = object2;
                Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"extensionReceiverType");
                if (!FlexibleTypesKt.isNullabilityFlexible((KotlinType)object3)) {
                    return;
                }
                D d = resolvedCall3.getResultingDescriptor();
                if (!(d instanceof FunctionDescriptor)) {
                    d = null;
                }
                FunctionDescriptor functionDescriptor2 = (FunctionDescriptor)d;
                if (functionDescriptor2 == null) {
                    return;
                }
                FunctionDescriptor descriptor2 = functionDescriptor2;
                if (!descriptor2.isInline()) {
                    return;
                }
                KtExpression receiverExpression = expression2.getReceiverExpression();
                this.$holder.registerProblem((PsiElement)receiverExpression, "Call of inline function with nullable extension receiver can provoke NPE in Kotlin 1.2+", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{(LocalQuickFix)new IntentionWrapper((IntentionAction)new AddExclExclCallFix((PsiElement)receiverExpression), (PsiFile)receiverExpression.getContainingKtFile())});
            }
            {
                this.this$0 = $outer;
                this.$holder = $captured_local_variable$1;
            }
        };
    }

    @NotNull
    public OptionsPanel createOptionsPanel() {
        return new OptionsPanel(this);
    }

    public PlatformExtensionReceiverOfInlineInspection() {
        Regex regex;
        String string = defaultNamePattern;
        PlatformExtensionReceiverOfInlineInspection platformExtensionReceiverOfInlineInspection = this;
        platformExtensionReceiverOfInlineInspection.nameRegex = regex = new Regex(string);
        this.namePattern = defaultNamePattern;
    }

    @Nullable
    public static final /* synthetic */ Regex access$getNameRegex$p(PlatformExtensionReceiverOfInlineInspection $this) {
        return $this.nameRegex;
    }

    public static final /* synthetic */ void access$setNameRegex$p(PlatformExtensionReceiverOfInlineInspection $this, @Nullable Regex regex) {
        $this.nameRegex = regex;
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/PlatformExtensionReceiverOfInlineInspection$OptionsPanel;", "Ljavax/swing/JPanel;", "owner", "Lorg/jetbrains/kotlin/idea/inspections/PlatformExtensionReceiverOfInlineInspection;", "(Lorg/jetbrains/kotlin/idea/inspections/PlatformExtensionReceiverOfInlineInspection;)V", "idea"})
    public static final class OptionsPanel
    extends JPanel {
        public OptionsPanel(final @NotNull PlatformExtensionReceiverOfInlineInspection owner) {
            EditorTextField editorTextField;
            Intrinsics.checkParameterIsNotNull((Object)((Object)owner), (String)"owner");
            this.setLayout(new BorderLayout());
            EditorTextField $receiver = editorTextField = new EditorTextField(owner.getNamePattern(), null, (FileType)RegExpFileType.INSTANCE);
            $receiver.setOneLineMode(true);
            final EditorTextField regexField = editorTextField;
            regexField.getDocument().addDocumentListener(new DocumentListener(){

                public void documentChanged(@Nullable DocumentEvent e) {
                    String string = regexField.getText();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"regexField.text");
                    owner.setNamePattern(string);
                }
            });
            LabeledComponent labeledComponent = LabeledComponent.create((JComponent)((JComponent)regexField), (String)"Pattern:", (String)"West");
            this.add((Component)labeledComponent, "North");
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/PlatformExtensionReceiverOfInlineInspection$Companion;", "", "()V", "defaultNamePattern", "", "idea"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

