/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.inspections.AbstractApplicabilityBasedInspection;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\"\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0010\u0010\u0011\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u0002H\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ReplaceArrayEqualityOpWithArraysEqualsInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractApplicabilityBasedInspection;", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "()V", "defaultFixText", "", "getDefaultFixText", "()Ljava/lang/String;", "applyTo", "", "element", "Lcom/intellij/psi/PsiElement;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "fixText", "inspectionText", "isApplicable", "", "idea"})
public final class ReplaceArrayEqualityOpWithArraysEqualsInspection
extends AbstractApplicabilityBasedInspection<KtBinaryExpression> {
    @Override
    public void applyTo(@NotNull PsiElement element3, @NotNull Project project, @Nullable Editor editor) {
        StringBuilder stringBuilder;
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        PsiElement psiElement2 = element3;
        if (!(psiElement2 instanceof KtBinaryExpression)) {
            psiElement2 = null;
        }
        KtBinaryExpression ktBinaryExpression = (KtBinaryExpression)psiElement2;
        if (ktBinaryExpression == null) {
            return;
        }
        KtBinaryExpression expression2 = ktBinaryExpression;
        KtExpression ktExpression = expression2.getRight();
        if (ktExpression == null) {
            return;
        }
        KtExpression right = ktExpression;
        KtExpression ktExpression2 = expression2.getLeft();
        if (ktExpression2 == null) {
            return;
        }
        KtExpression left = ktExpression2;
        KtPsiFactory factory2 = new KtPsiFactory(project, false, 2, null);
        StringBuilder $receiver = stringBuilder = new StringBuilder();
        if (Intrinsics.areEqual((Object)expression2.getOperationToken(), (Object)((Object)KtTokens.EXCLEQ))) {
            $receiver.append("!");
        }
        $receiver.append("$0.contentEquals($1)");
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        String template2 = string;
        Object[] objectArray = new Object[2];
        KtExpression ktExpression3 = left;
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression3, (String)"left");
        objectArray[0] = ktExpression3;
        KtExpression ktExpression4 = right;
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression4, (String)"right");
        objectArray[1] = ktExpression4;
        expression2.replace((PsiElement)CreateByPatternKt.createExpressionByPattern$default(factory2, template2, objectArray, false, 4, null));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isApplicable(@NotNull KtBinaryExpression element3) {
        IElementType operationToken;
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        IElementType iElementType = operationToken = element3.getOperationToken();
        if (!Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.EQEQ))) {
            if (!Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.EXCLEQ))) return false;
        }
        KtExpression right = element3.getRight();
        KtExpression left = element3.getLeft();
        if (right == null) return false;
        if (left == null) {
            return false;
        }
        BindingContext context2 = ResolutionUtils.analyze$default(element3, null, 1, null);
        ResolvedCall<? extends CallableDescriptor> rightResolvedCall = CallUtilKt.getResolvedCall(right, context2);
        ResolvedCall<? extends CallableDescriptor> leftResolvedCall = CallUtilKt.getResolvedCall(left, context2);
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = rightResolvedCall;
        if (resolvedCall2 == null) return false;
        if (!UtilsKt.resolvedToArrayType(resolvedCall2)) return false;
        ResolvedCall<? extends CallableDescriptor> resolvedCall3 = leftResolvedCall;
        if (resolvedCall3 == null) return false;
        if (!UtilsKt.resolvedToArrayType(resolvedCall3)) return false;
        return true;
    }

    @Override
    @NotNull
    public String inspectionText(@NotNull KtBinaryExpression element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        return "Dangerous array comparison";
    }

    @Override
    @NotNull
    public String getDefaultFixText() {
        return "Replace with 'contentEquals'";
    }

    @Override
    @NotNull
    public String fixText(@NotNull KtBinaryExpression element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        IElementType iElementType = element3.getOperationToken();
        return Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.EQEQ)) ? "Replace '==' with 'contentEquals'" : (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.EXCLEQ)) ? "Replace '!=' with 'contentEquals'" : "");
    }

    public ReplaceArrayEqualityOpWithArraysEqualsInspection() {
        super(KtBinaryExpression.class);
    }
}

