/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.intentions.conventionNameCalls.ConventionUtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/UnusedEqualsInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "idea"})
public final class UnusedEqualsInspection
extends AbstractKotlinInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        return new KtVisitorVoid(holder){
            final /* synthetic */ ProblemsHolder $holder;

            private final void reportIfNotUsedAsExpression(KtExpression expression2, KtExpression target) {
                BindingContext context2 = ResolutionUtils.analyze$default(expression2, null, 1, null);
                if (!BindingContextUtilsKt.isUsedAsExpression(expression2, context2)) {
                    this.$holder.registerProblem((PsiElement)target, "Unused equals expression", ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[0]);
                }
            }

            public void visitBinaryExpression(@NotNull KtBinaryExpression expression2) {
                block2: {
                    block3: {
                        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                        super.visitBinaryExpression(expression2);
                        if (!Intrinsics.areEqual((Object)expression2.getOperationToken(), (Object)((Object)KtTokens.EQEQ))) break block2;
                        if (expression2.getParent() instanceof KtBlockExpression) break block3;
                        PsiElement psiElement2 = expression2.getParent();
                        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"expression.parent");
                        if (!(psiElement2.getParent() instanceof KtIfExpression)) break block2;
                    }
                    KtExpression ktExpression = expression2;
                    KtOperationReferenceExpression ktOperationReferenceExpression = expression2.getOperationReference();
                    Intrinsics.checkExpressionValueIsNotNull((Object)ktOperationReferenceExpression, (String)"expression.operationReference");
                    this.reportIfNotUsedAsExpression(ktExpression, ktOperationReferenceExpression);
                }
            }

            public void visitCallExpression(@NotNull KtCallExpression expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                super.visitCallExpression(expression2);
                KtExpression ktExpression = expression2.getCalleeExpression();
                if (!(ktExpression instanceof KtSimpleNameExpression)) {
                    ktExpression = null;
                }
                KtSimpleNameExpression ktSimpleNameExpression = (KtSimpleNameExpression)ktExpression;
                if (ktSimpleNameExpression == null) {
                    return;
                }
                KtSimpleNameExpression calleeExpression2 = ktSimpleNameExpression;
                if (Intrinsics.areEqual((Object)calleeExpression2.getReferencedNameAsName(), (Object)OperatorNameConventions.EQUALS) ^ true) {
                    return;
                }
                if (!ConventionUtilsKt.isAnyEquals(expression2)) {
                    return;
                }
                this.reportIfNotUsedAsExpression(KtPsiUtilKt.getQualifiedExpressionForSelectorOrThis(expression2), calleeExpression2);
            }
            {
                this.$holder = $captured_local_variable$0;
            }
        };
    }
}

