/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\f\u0010\t\u001a\u00020\b*\u00020\nH\u0002J\u0014\u0010\u000b\u001a\u00020\b*\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/UnusedLambdaExpressionBodyInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "returnsFunction", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "used", "Lorg/jetbrains/kotlin/psi/KtExpression;", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "RemoveEqTokenFromFunctionDeclarationFix", "idea"})
public final class UnusedLambdaExpressionBodyInspection
extends AbstractKotlinInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        return VisitorWrappersKt.callExpressionVisitor((Function1<? super KtCallExpression, Unit>)((Function1)new Function1<KtCallExpression, Unit>(this, holder){
            final /* synthetic */ UnusedLambdaExpressionBodyInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;

            public final void invoke(@NotNull KtCallExpression expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                BindingContext context2 = ResolutionUtils.analyze(expression2, BodyResolveMode.PARTIAL_WITH_CFA);
                if (UnusedLambdaExpressionBodyInspection.access$used(this.this$0, expression2, context2)) {
                    return;
                }
                ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(expression2, context2);
                if (resolvedCall2 == null || (resolvedCall2 = resolvedCall2.getResultingDescriptor()) == null) {
                    return;
                }
                ResolvedCall<? extends CallableDescriptor> descriptor2 = resolvedCall2;
                if (!UnusedLambdaExpressionBodyInspection.access$returnsFunction(this.this$0, (CallableDescriptor)((Object)descriptor2))) {
                    return;
                }
                SourceElement sourceElement = descriptor2.getSource();
                Intrinsics.checkExpressionValueIsNotNull((Object)sourceElement, (String)"descriptor.source");
                PsiElement psiElement2 = KotlinSourceElementKt.getPsi(sourceElement);
                if (!(psiElement2 instanceof KtFunction)) {
                    psiElement2 = null;
                }
                KtFunction ktFunction = (KtFunction)psiElement2;
                if (ktFunction == null) {
                    return;
                }
                KtFunction function2 = ktFunction;
                if (function2.hasBlockBody() || !(function2.getBodyExpression() instanceof KtLambdaExpression)) {
                    return;
                }
                this.$holder.registerProblem((PsiElement)expression2, "Unused return value of a function with lambda expression body", new LocalQuickFix[]{(LocalQuickFix)new RemoveEqTokenFromFunctionDeclarationFix(function2)});
            }
            {
                this.this$0 = unusedLambdaExpressionBodyInspection;
                this.$holder = problemsHolder;
                super(1);
            }
        }));
    }

    private final boolean used(@NotNull KtExpression $receiver, BindingContext context2) {
        Boolean bl = (Boolean)context2.get(BindingContext.USED_AS_EXPRESSION, $receiver);
        return bl != null ? bl : true;
    }

    private final boolean returnsFunction(@NotNull CallableDescriptor $receiver) {
        KotlinType kotlinType = $receiver.getReturnType();
        return kotlinType != null ? FunctionTypesKt.isFunctionType(kotlinType) : false;
    }

    public static final /* synthetic */ boolean access$used(UnusedLambdaExpressionBodyInspection $this, @NotNull KtExpression $receiver, @NotNull BindingContext context2) {
        return $this.used($receiver, context2);
    }

    public static final /* synthetic */ boolean access$returnsFunction(UnusedLambdaExpressionBodyInspection $this, @NotNull CallableDescriptor $receiver) {
        return $this.returnsFunction($receiver);
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016J)\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0096\u0002J\f\u0010\u0011\u001a\u00020\u0012*\u00020\u000fH\u0002\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/UnusedLambdaExpressionBodyInspection$RemoveEqTokenFromFunctionDeclarationFix;", "Lcom/intellij/codeInspection/LocalQuickFixOnPsiElement;", "function", "Lorg/jetbrains/kotlin/psi/KtFunction;", "(Lorg/jetbrains/kotlin/psi/KtFunction;)V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "startElement", "Lcom/intellij/psi/PsiElement;", "endElement", "isSpace", "", "idea"})
    public static final class RemoveEqTokenFromFunctionDeclarationFix
    extends LocalQuickFixOnPsiElement {
        @NotNull
        public String getText() {
            return "Remove '=' token from function declaration";
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name");
            return string;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement2, @NotNull PsiElement endElement2) {
            block5: {
                PsiElement psiElement2;
                Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
                Intrinsics.checkParameterIsNotNull((Object)startElement2, (String)"startElement");
                Intrinsics.checkParameterIsNotNull((Object)endElement2, (String)"endElement");
                PsiElement psiElement3 = startElement2;
                if (!(psiElement3 instanceof KtFunction)) {
                    psiElement3 = null;
                }
                KtFunction ktFunction = (KtFunction)psiElement3;
                if (ktFunction == null) {
                    return;
                }
                KtFunction function2 = ktFunction;
                if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)function2)) {
                    return;
                }
                PsiElement psiElement4 = function2.getEqualsToken();
                if (psiElement4 == null) break block5;
                PsiElement $receiver = psiElement2 = psiElement4;
                PsiElement psiElement5 = $receiver.getPrevSibling();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement5, (String)"prevSibling");
                if (this.isSpace(psiElement5)) {
                    PsiElement psiElement6 = $receiver.getNextSibling();
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiElement6, (String)"nextSibling");
                    if (this.isSpace(psiElement6)) {
                        $receiver.getPrevSibling().delete();
                    }
                }
                $receiver.delete();
            }
        }

        private final boolean isSpace(@NotNull PsiElement $receiver) {
            return Intrinsics.areEqual((Object)$receiver.getText(), (Object)" ");
        }

        public RemoveEqTokenFromFunctionDeclarationFix(@NotNull KtFunction function2) {
            Intrinsics.checkParameterIsNotNull((Object)function2, (String)"function");
            super((PsiElement)function2);
        }
    }
}

