/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections.conventionNameCalls;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.inspections.AbstractApplicabilityBasedInspection;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.load.java.descriptors.JavaClassDescriptor;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.BuilderByPattern;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMappingKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.util.ModifierChecksKt;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\"\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u0010\u0010\u0018\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\r\u001a\u00020\u0002H\u0016J \u0010\u001b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u000eH\u0002J\f\u0010\u001e\u001a\u00020\u001a*\u00020\u001fH\u0002R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/idea/inspections/conventionNameCalls/ReplaceGetOrSetInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractApplicabilityBasedInspection;", "Lorg/jetbrains/kotlin/psi/KtDotQualifiedExpression;", "()V", "defaultFixText", "", "getDefaultFixText", "()Ljava/lang/String;", "operatorNames", "", "Lorg/jetbrains/kotlin/name/Name;", "applyTo", "", "element", "Lcom/intellij/psi/PsiElement;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "fixText", "inspectionHighlightType", "Lcom/intellij/codeInspection/ProblemHighlightType;", "inspectionTarget", "Lorg/jetbrains/kotlin/psi/KtExpression;", "inspectionText", "isApplicable", "", "moveCaret", "isSet", "newElement", "isExplicitOperator", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "idea"})
public final class ReplaceGetOrSetInspection
extends AbstractApplicabilityBasedInspection<KtDotQualifiedExpression> {
    private final Set<Name> operatorNames = SetsKt.setOf((Object[])new Name[]{OperatorNameConventions.GET, OperatorNameConventions.SET});

    private final boolean isExplicitOperator(@NotNull FunctionDescriptor $receiver) {
        boolean bl;
        block5: {
            if ($receiver.getOverriddenDescriptors().isEmpty()) {
                bl = !($receiver.getContainingDeclaration() instanceof JavaClassDescriptor) && $receiver.isOperator();
            } else {
                Collection<? extends FunctionDescriptor> collection = $receiver.getOverriddenDescriptors();
                Intrinsics.checkExpressionValueIsNotNull(collection, (String)"overriddenDescriptors");
                Iterable $receiver$iv = collection;
                if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $receiver$iv) {
                        FunctionDescriptor it;
                        FunctionDescriptor functionDescriptor2 = it = (FunctionDescriptor)element$iv;
                        Intrinsics.checkExpressionValueIsNotNull((Object)functionDescriptor2, (String)"it");
                        if (!this.isExplicitOperator(functionDescriptor2)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
        }
        return bl;
    }

    @Override
    public boolean isApplicable(@NotNull KtDotQualifiedExpression element3) {
        boolean bl;
        FunctionDescriptor target;
        BindingContext bindingContext2;
        block15: {
            Name calleeName;
            Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
            KtCallExpression ktCallExpression = UtilsKt.getCallExpression(element3);
            if (ktCallExpression == null) {
                return false;
            }
            KtCallExpression callExpression2 = ktCallExpression;
            KtExpression ktExpression = callExpression2.getCalleeExpression();
            if (!(ktExpression instanceof KtSimpleNameExpression)) {
                ktExpression = null;
            }
            KtSimpleNameExpression ktSimpleNameExpression = (KtSimpleNameExpression)ktExpression;
            Name name2 = calleeName = ktSimpleNameExpression != null ? ktSimpleNameExpression.getReferencedNameAsName() : null;
            if (!CollectionsKt.contains((Iterable)this.operatorNames, (Object)calleeName)) {
                return false;
            }
            bindingContext2 = ResolutionUtils.analyze(callExpression2, BodyResolveMode.PARTIAL_WITH_CFA);
            ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(callExpression2, bindingContext2);
            if (resolvedCall2 == null) {
                return false;
            }
            ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
            if (!ArgumentMappingKt.isReallySuccess(resolvedCall3)) {
                return false;
            }
            CallableDescriptor callableDescriptor = resolvedCall3.getResultingDescriptor();
            if (!(callableDescriptor instanceof FunctionDescriptor)) {
                callableDescriptor = null;
            }
            FunctionDescriptor functionDescriptor2 = (FunctionDescriptor)callableDescriptor;
            if (functionDescriptor2 == null) {
                return false;
            }
            target = functionDescriptor2;
            if (!ModifierChecksKt.isValidOperator(target) || !this.operatorNames.contains(target.getName())) {
                return false;
            }
            if (callExpression2.getTypeArgumentList() != null) {
                return false;
            }
            List<KtValueArgument> arguments2 = callExpression2.getValueArguments();
            if (arguments2.isEmpty()) {
                return false;
            }
            List<KtValueArgument> list2 = arguments2;
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"arguments");
            Iterable $receiver$iv = list2;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    KtValueArgument it = (KtValueArgument)element$iv;
                    if (!it.isNamed()) continue;
                    bl = true;
                    break block15;
                }
                bl = false;
            }
        }
        if (bl) {
            return false;
        }
        if (!UtilsKt.isReceiverExpressionWithValue(element3)) {
            return false;
        }
        return Intrinsics.areEqual((Object)target.getName(), (Object)OperatorNameConventions.SET) ^ true || !BindingContextUtilsKt.isUsedAsExpression(element3, bindingContext2);
    }

    @Override
    @NotNull
    public String inspectionText(@NotNull KtDotQualifiedExpression element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        return "Should be replaced with indexing";
    }

    @Override
    @NotNull
    public ProblemHighlightType inspectionHighlightType(@NotNull KtDotQualifiedExpression element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = UtilsKt.toResolvedCall(element3, BodyResolveMode.PARTIAL);
        if (resolvedCall2 == null) {
            Intrinsics.throwNpe();
        }
        CallableDescriptor callableDescriptor = resolvedCall2.getResultingDescriptor();
        if (callableDescriptor == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.FunctionDescriptor");
        }
        return this.isExplicitOperator((FunctionDescriptor)callableDescriptor) ? ProblemHighlightType.GENERIC_ERROR_OR_WARNING : ProblemHighlightType.INFORMATION;
    }

    @Override
    @NotNull
    public String getDefaultFixText() {
        return "Replace get or set call with indexing operator";
    }

    @Override
    @NotNull
    public String fixText(@NotNull KtDotQualifiedExpression element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        KtCallExpression ktCallExpression = UtilsKt.getCallExpression(element3);
        if (ktCallExpression == null) {
            return this.getDefaultFixText();
        }
        KtCallExpression callExpression2 = ktCallExpression;
        ResolvedCall resolvedCall2 = ResolutionUtils.resolveToCall$default(callExpression2, null, 1, null);
        if (resolvedCall2 == null) {
            return this.getDefaultFixText();
        }
        ResolvedCall resolvedCall3 = resolvedCall2;
        return "Replace '" + resolvedCall3.getResultingDescriptor().getName().asString() + "' call with indexing operator";
    }

    @NotNull
    public KtExpression inspectionTarget(@NotNull KtDotQualifiedExpression element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        KtExpression ktExpression = UtilsKt.getCallExpression(element3);
        if (ktExpression == null || (ktExpression = ktExpression.getCalleeExpression()) == null) {
            ktExpression = element3;
        }
        return ktExpression;
    }

    @Override
    public void applyTo(@NotNull PsiElement element3, @NotNull Project project, @Nullable Editor editor) {
        boolean bl;
        List<KtValueArgument> allArguments;
        KtDotQualifiedExpression ktDotQualifiedExpression;
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        PsiElement psiElement2 = element3;
        if (!(psiElement2 instanceof KtDotQualifiedExpression)) {
            psiElement2 = null;
        }
        if ((ktDotQualifiedExpression = (KtDotQualifiedExpression)psiElement2) == null) {
            PsiElement psiElement3 = element3.getParent();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement3, (String)"element.parent");
            PsiElement psiElement4 = psiElement3.getParent();
            if (!(psiElement4 instanceof KtDotQualifiedExpression)) {
                psiElement4 = null;
            }
            ktDotQualifiedExpression = (KtDotQualifiedExpression)psiElement4;
        }
        if (ktDotQualifiedExpression == null) {
            return;
        }
        KtDotQualifiedExpression expression2 = ktDotQualifiedExpression;
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = UtilsKt.toResolvedCall(expression2, BodyResolveMode.PARTIAL);
        if (resolvedCall2 == null) {
            Intrinsics.throwNpe();
        }
        boolean isSet = Intrinsics.areEqual((Object)resolvedCall2.getResultingDescriptor().getName(), (Object)OperatorNameConventions.SET);
        KtCallExpression ktCallExpression = UtilsKt.getCallExpression(expression2);
        if (ktCallExpression == null) {
            Intrinsics.throwNpe();
        }
        List<KtValueArgument> list2 = allArguments = ktCallExpression.getValueArguments();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"allArguments");
        Collection collection = list2;
        boolean bl2 = bl = !collection.isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        KtExpression newExpression2 = CreateByPatternKt.buildExpression$default(KtPsiFactoryKt.KtPsiFactory$default((PsiElement)expression2, false, 2, null), false, (Function1)new Function1<BuilderByPattern<KtExpression>, Unit>(expression2, isSet, allArguments){
            final /* synthetic */ KtDotQualifiedExpression $expression;
            final /* synthetic */ boolean $isSet;
            final /* synthetic */ List $allArguments;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull BuilderByPattern<KtExpression> $receiver) {
                Collection<KtExpression> collection;
                void $receiver$iv$iv;
                void $receiver$iv;
                List list2;
                Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
                $receiver.appendExpression(this.$expression.getReceiverExpression());
                $receiver.appendFixedText("[");
                if (this.$isSet) {
                    List list3 = this.$allArguments;
                    Intrinsics.checkExpressionValueIsNotNull((Object)list3, (String)"allArguments");
                    list2 = CollectionsKt.dropLast((List)list3, (int)1);
                } else {
                    List list4 = this.$allArguments;
                    list2 = list4;
                    Intrinsics.checkExpressionValueIsNotNull((Object)list4, (String)"allArguments");
                }
                List arguments2 = list2;
                Iterable iterable = arguments2;
                BuilderByPattern<KtExpression> builderByPattern = $receiver;
                void var4_5 = $receiver$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (T item$iv$iv : $receiver$iv$iv) {
                    void it;
                    KtValueArgument ktValueArgument = (KtValueArgument)item$iv$iv;
                    collection = destination$iv$iv;
                    KtExpression ktExpression = it.getArgumentExpression();
                    collection.add(ktExpression);
                }
                collection = (List)destination$iv$iv;
                BuilderByPattern.appendExpressions$default(builderByPattern, collection, null, 2, null);
                $receiver.appendFixedText("]");
                if (this.$isSet) {
                    $receiver.appendFixedText("=");
                    List list5 = this.$allArguments;
                    Intrinsics.checkExpressionValueIsNotNull((Object)list5, (String)"allArguments");
                    $receiver.appendExpression(((KtValueArgument)CollectionsKt.last((List)list5)).getArgumentExpression());
                }
            }
            {
                this.$expression = ktDotQualifiedExpression;
                this.$isSet = bl;
                this.$allArguments = list2;
                super(1);
            }
        }, 1, null);
        PsiElement newElement = expression2.replace((PsiElement)newExpression2);
        if (editor != null) {
            PsiElement psiElement5 = newElement;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement5, (String)"newElement");
            this.moveCaret(editor, isSet, psiElement5);
        }
    }

    private final void moveCaret(Editor editor, boolean isSet, PsiElement newElement) {
        KtArrayAccessExpression ktArrayAccessExpression;
        if (isSet) {
            PsiElement $receiver$iv = newElement;
            PsiElement psiElement2 = PsiTreeUtil.getChildOfType((PsiElement)$receiver$iv, KtArrayAccessExpression.class);
            if (psiElement2 == null) {
                Intrinsics.throwNpe();
            }
            ktArrayAccessExpression = (KtArrayAccessExpression)psiElement2;
        } else {
            PsiElement psiElement3 = newElement;
            if (psiElement3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtArrayAccessExpression");
            }
            ktArrayAccessExpression = (KtArrayAccessExpression)psiElement3;
        }
        KtArrayAccessExpression arrayAccessExpression2 = ktArrayAccessExpression;
        CaretModel caretModel = editor.getCaretModel();
        PsiElement psiElement4 = arrayAccessExpression2.getLeftBracket();
        if (psiElement4 == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement4, (String)"arrayAccessExpression.leftBracket!!");
        caretModel.moveToOffset(PsiUtilsKt.getStartOffset(psiElement4));
    }

    public ReplaceGetOrSetInspection() {
        super(KtDotQualifiedExpression.class);
    }
}

