/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections.gradle;

import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.LibraryDependencyData;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ModuleDependencyData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.tooling.model.idea.IdeaProject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.inspections.gradle.KotlinGradleModelFacade;
import org.jetbrains.kotlin.idea.inspections.gradle.KotlinGradleModelFacadeKt;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00042\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\b\u001a\u00020\tH\u0016J$\u0010\n\u001a\u0004\u0018\u00010\u000b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\u00052\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/gradle/DefaultGradleModelFacade;", "Lorg/jetbrains/kotlin/idea/inspections/gradle/KotlinGradleModelFacade;", "()V", "getDependencyModules", "", "Lcom/intellij/openapi/externalSystem/model/DataNode;", "Lcom/intellij/openapi/externalSystem/model/project/ModuleData;", "ideModule", "gradleIdeaProject", "Lorg/gradle/tooling/model/idea/IdeaProject;", "getResolvedKotlinStdlibVersionByModuleData", "", "moduleData", "libraryIds", "", "idea-gradle"})
public final class DefaultGradleModelFacade
implements KotlinGradleModelFacade {
    @Override
    @Nullable
    public String getResolvedKotlinStdlibVersionByModuleData(@NotNull DataNode<?> moduleData, @NotNull List<String> libraryIds) {
        Intrinsics.checkParameterIsNotNull(moduleData, (String)"moduleData");
        Intrinsics.checkParameterIsNotNull(libraryIds, (String)"libraryIds");
        for (DataNode libraryDependencyData : ExternalSystemApiUtil.findAllRecursively(moduleData, (Key)ProjectKeys.LIBRARY_DEPENDENCY)) {
            for (String libraryId : libraryIds) {
                String libraryNameMarker = "org.jetbrains.kotlin:" + libraryId + ':';
                DataNode dataNode = libraryDependencyData;
                Intrinsics.checkExpressionValueIsNotNull((Object)dataNode, (String)"libraryDependencyData");
                Object object = dataNode.getData();
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"libraryDependencyData.data");
                String string = ((LibraryDependencyData)object).getExternalName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"libraryDependencyData.data.externalName");
                if (!StringsKt.startsWith$default((String)string, (String)libraryNameMarker, (boolean)false, (int)2, null)) continue;
                Object object2 = libraryDependencyData.getData();
                Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"libraryDependencyData.data");
                String string2 = ((LibraryDependencyData)object2).getExternalName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"libraryDependencyData.data.externalName");
                return StringsKt.substringAfter$default((String)string2, (String)libraryNameMarker, null, (int)2, null);
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Collection<DataNode<ModuleData>> getDependencyModules(@NotNull DataNode<ModuleData> ideModule, @NotNull IdeaProject gradleIdeaProject) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(ideModule, (String)"ideModule");
        Intrinsics.checkParameterIsNotNull((Object)gradleIdeaProject, (String)"gradleIdeaProject");
        DataNode dataNode = ideModule.getParent();
        if (dataNode == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.externalSystem.model.DataNode<com.intellij.openapi.externalSystem.model.project.ProjectData>");
        }
        DataNode ideProject = dataNode;
        Collection collection = ExternalSystemApiUtil.getChildren(ideModule, (Key)ProjectKeys.MODULE_DEPENDENCY);
        Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"ExternalSystemApiUtil.ge\u2026ctKeys.MODULE_DEPENDENCY)");
        Iterable iterable = $receiver$iv = (Iterable)collection;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            DataNode dataNode2 = (DataNode)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            void v2 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"it");
            Object object = v2.getData();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"it.data");
            ModuleData moduleData = (ModuleData)((ModuleDependencyData)object).getTarget();
            Intrinsics.checkExpressionValueIsNotNull((Object)moduleData, (String)"it.data.target");
            String string = moduleData.getExternalName();
            collection2.add(string);
        }
        HashSet dependencyModuleNames = CollectionsKt.toHashSet((Iterable)((List)destination$iv$iv));
        return KotlinGradleModelFacadeKt.findModulesByNames(dependencyModuleNames, gradleIdeaProject, (DataNode<ProjectData>)ideProject);
    }
}

