/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.intentions.AddBracesIntention$applyTo$;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingIntention;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.idea.util.CommentSaver;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtContainerNode;
import org.jetbrains.kotlin.psi.KtDoWhileExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtLoopExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.psiUtil.PsiChildRange;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0016\u0010\r\u001a\u0004\u0018\u00010\u000e*\u00020\u00022\u0006\u0010\u000f\u001a\u00020\fH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/AddBracesIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingIntention;", "Lorg/jetbrains/kotlin/psi/KtElement;", "()V", "applyTo", "", "element", "editor", "Lcom/intellij/openapi/editor/Editor;", "isApplicableTo", "", "caretOffset", "", "getTargetExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "caretLocation", "idea"})
public final class AddBracesIntention
extends SelfTargetingIntention<KtElement> {
    @Override
    public boolean isApplicableTo(@NotNull KtElement element3, int caretOffset) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        KtExpression ktExpression = this.getTargetExpression(element3, caretOffset);
        if (ktExpression == null) {
            return false;
        }
        KtExpression expression2 = ktExpression;
        if (expression2 instanceof KtBlockExpression) {
            return false;
        }
        PsiElement parent2 = expression2.getParent();
        PsiElement psiElement2 = parent2;
        if (psiElement2 instanceof KtContainerNode) {
            String string = UtilsKt.description((KtContainerNode)parent2);
            if (string == null) {
                Intrinsics.throwNpe();
            }
            String description2 = string;
            this.setText("Add braces to '" + description2 + "' statement");
            bl = true;
        } else if (psiElement2 instanceof KtWhenEntry) {
            this.setText("Add braces to 'when' entry");
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void applyTo(@NotNull KtElement element3, @Nullable Editor editor) {
        PsiElement it;
        PsiElement semicolon2;
        Object object;
        PsiElement it2;
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        if (editor == null) {
            throw (Throwable)new IllegalArgumentException("This intention requires an editor");
        }
        CaretModel caretModel = editor.getCaretModel();
        Intrinsics.checkExpressionValueIsNotNull((Object)caretModel, (String)"editor.caretModel");
        KtExpression ktExpression = this.getTargetExpression(element3, caretModel.getOffset());
        if (ktExpression == null) {
            Intrinsics.throwNpe();
        }
        KtExpression expression2 = ktExpression;
        KtPsiFactory psiFactory = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)element3, false, 2, null);
        PsiElement psiElement2 = PsiUtilsKt.getNextSiblingIgnoringWhitespaceAndComments$default((PsiElement)element3, false, 1, null);
        if (psiElement2 != null) {
            PsiElement psiElement3;
            it2 = psiElement3 = psiElement2;
            ASTNode aSTNode = it2.getNode();
            Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"it.node");
            object = Intrinsics.areEqual((Object)aSTNode.getElementType(), (Object)((Object)KtTokens.SEMICOLON)) ? psiElement3 : null;
        } else {
            object = semicolon2 = null;
        }
        if (semicolon2 != null) {
            PsiElement afterSemicolon = PsiUtilsKt.getNextSiblingIgnoringWhitespace$default(semicolon2, false, 1, null);
            PsiElement psiElement4 = afterSemicolon;
            if (psiElement4 != null && KotlinRefactoringUtilKt.getLineNumber$default(semicolon2, false, 1, null) == KotlinRefactoringUtilKt.getLineNumber$default(psiElement4, false, 1, null)) {
                semicolon2.replace(psiFactory.createNewLine());
            } else {
                semicolon2.delete();
            }
        }
        PsiElement nextComment2 = element3 instanceof KtDoWhileExpression ? null : (element3 instanceof KtIfExpression && expression2 == ((KtIfExpression)element3).getThen() && ((KtIfExpression)element3).getElse() != null ? null : ((it = (it2 = PsiUtilsKt.getNextSiblingIgnoringWhitespace$default((PsiElement)element3, false, 1, null))) instanceof PsiComment ? it2 : null));
        CommentSaver saver = nextComment2 == null ? new CommentSaver((PsiElement)element3, false, 2, null) : new CommentSaver(new PsiChildRange((PsiElement)element3, nextComment2), false, 2, null);
        Object $receiver$iv = PsiUtilsKt.getAllChildren((PsiElement)element3);
        Sequence sequence2 = SequencesKt.filter((Sequence)$receiver$iv, (Function1)applyTo$$inlined$filterIsInstance$1.INSTANCE);
        if (sequence2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
        }
        $receiver$iv = SequencesKt.toList((Sequence)sequence2);
        Iterator iterator2 = $receiver$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv = iterator2.next();
            PsiComment it3 = (PsiComment)element$iv;
            it3.delete();
        }
        PsiElement psiElement5 = nextComment2;
        if (psiElement5 != null) {
            psiElement5.delete();
        }
        PsiElement result2 = expression2.replace((PsiElement)KtPsiFactory.createSingleStatementBlock$default(psiFactory, expression2, null, null, 6, null));
        if (element3 instanceof KtDoWhileExpression) {
            KtExpression ktExpression2 = ((KtDoWhileExpression)element3).getBody();
            if (ktExpression2 == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression2, (String)"element.body!!");
            PsiElement psiElement6 = ktExpression2.getParent();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement6, (String)"element.body!!.parent");
            PsiElement psiElement7 = psiElement6.getNextSibling();
            if (!(psiElement7 instanceof PsiWhiteSpace)) {
                psiElement7 = null;
            }
            PsiWhiteSpace psiWhiteSpace = (PsiWhiteSpace)psiElement7;
            if (psiWhiteSpace != null) {
                psiWhiteSpace.delete();
            }
        }
        PsiElement psiElement8 = result2;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement8, (String)"result");
        CommentSaver.restore$default(saver, psiElement8, false, 2, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final KtExpression getTargetExpression(@NotNull KtElement $receiver, int caretLocation) {
        KtExpression ktExpression;
        KtElement ktElement = $receiver;
        if (ktElement instanceof KtIfExpression) {
            KtExpression ktExpression2 = ((KtIfExpression)$receiver).getThen();
            if (ktExpression2 == null) return null;
            KtExpression thenExpr = ktExpression2;
            KtExpression elseExpr = ((KtIfExpression)$receiver).getElse();
            if (elseExpr != null) {
                PsiElement psiElement2 = ((KtIfExpression)$receiver).getElseKeyword();
                if (psiElement2 == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"elseKeyword!!");
                if (caretLocation >= PsiUtilsKt.getStartOffset(psiElement2)) {
                    ktExpression = elseExpr;
                    return ktExpression;
                }
            }
            ktExpression = thenExpr;
            return ktExpression;
        }
        if (ktElement instanceof KtLoopExpression) {
            ktExpression = ((KtLoopExpression)$receiver).getBody();
            return ktExpression;
        }
        if (!(ktElement instanceof KtWhenEntry)) return null;
        ktExpression = ((KtWhenEntry)$receiver).getExpression();
        return ktExpression;
    }

    public AddBracesIntention() {
        super(KtElement.class, "Add braces", null, 4, null);
    }
}

