/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.CollectingNameValidator;
import org.jetbrains.kotlin.idea.core.KotlinNameSuggester;
import org.jetbrains.kotlin.idea.core.NewDeclarationNameValidator;
import org.jetbrains.kotlin.idea.intentions.AddMissingDestructuringIntention;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingIntention;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u000e\u0010\r\u001a\u0004\u0018\u00010\u000e*\u00020\u0002H\u0002J2\u0010\u000f\u001a(\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00110\u0011\u0018\u0001 \u0012*\u0012\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00110\u0011\u0018\u00010\u00130\u0010*\u00020\u000eH\u0002\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/AddMissingDestructuringIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingIntention;", "Lorg/jetbrains/kotlin/psi/KtDestructuringDeclaration;", "()V", "applyTo", "", "element", "editor", "Lcom/intellij/openapi/editor/Editor;", "isApplicableTo", "", "caretOffset", "", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "primaryParameters", "", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "kotlin.jvm.PlatformType", "", "idea"})
public final class AddMissingDestructuringIntention
extends SelfTargetingIntention<KtDestructuringDeclaration> {
    @Override
    public boolean isApplicableTo(@NotNull KtDestructuringDeclaration element3, int caretOffset) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        int entriesCount = element3.getEntries().size();
        ClassDescriptor classDescriptor = this.classDescriptor(element3);
        if (classDescriptor == null) {
            return false;
        }
        ClassDescriptor classDescriptor2 = classDescriptor;
        if (!classDescriptor2.isData()) {
            return false;
        }
        List<ValueParameterDescriptor> list2 = this.primaryParameters(classDescriptor2);
        if (list2 == null) {
            return false;
        }
        List<ValueParameterDescriptor> primaryParameters = list2;
        return primaryParameters.size() > entriesCount;
    }

    @Override
    public void applyTo(@NotNull KtDestructuringDeclaration element3, @Nullable Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        List<KtDestructuringDeclarationEntry> entries2 = element3.getEntries();
        Object object = this.classDescriptor(element3);
        if (object == null || (object = this.primaryParameters((ClassDescriptor)object)) == null) {
            return;
        }
        Object primaryParameters = object;
        KtPsiFactory factory2 = KtPsiFactoryKt.KtPsiFactory$default(element3, false, 2, null);
        PsiElement psiElement2 = element3.getParent();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"element.parent");
        PsiElement psiElement3 = psiElement2.getParent();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement3, (String)"element.parent.parent");
        CollectingNameValidator nameValidator2 = new CollectingNameValidator(null, new NewDeclarationNameValidator(psiElement3, null, NewDeclarationNameValidator.Target.VARIABLES, null, 8, null), 1, null);
        StringBuilder stringBuilder = new StringBuilder();
        List<KtDestructuringDeclarationEntry> list2 = entries2;
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"entries");
        StringBuilder stringBuilder2 = stringBuilder.append(CollectionsKt.joinToString$default((Iterable)list2, null, null, (CharSequence)", ", (int)0, null, (Function1)applyTo.newEntries.1.INSTANCE, (int)27, null));
        Object object2 = primaryParameters;
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"primaryParameters");
        String newEntries2 = stringBuilder2.append(CollectionsKt.joinToString$default((Iterable)CollectionsKt.drop((Iterable)((Iterable)object2), (int)entries2.size()), null, null, null, (int)0, null, (Function1)((Function1)new Function1<ValueParameterDescriptor, String>(nameValidator2){
            final /* synthetic */ CollectingNameValidator $nameValidator;

            @NotNull
            public final String invoke(ValueParameterDescriptor it) {
                ValueParameterDescriptor valueParameterDescriptor = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)valueParameterDescriptor, (String)"it");
                String string = valueParameterDescriptor.getName().asString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.name.asString()");
                return KotlinNameSuggester.INSTANCE.suggestNameByName(string, (Function1<? super String, Boolean>)((Function1)this.$nameValidator));
            }
            {
                this.$nameValidator = collectingNameValidator;
                super(1);
            }
        }), (int)31, null)).toString();
        KtExpression ktExpression = element3.getInitializer();
        if (ktExpression == null) {
            return;
        }
        KtExpression initializer2 = ktExpression;
        String string = element3.isVar() ? "var ($0) = $1" : "val ($0) = $1";
        Object[] objectArray = new Object[2];
        objectArray[0] = newEntries2;
        KtExpression ktExpression2 = initializer2;
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression2, (String)"initializer");
        objectArray[1] = ktExpression2;
        KtDestructuringDeclaration newDestructuringDeclaration = CreateByPatternKt.createDestructuringDeclarationByPattern$default(factory2, string, objectArray, false, 4, null);
        element3.replace(newDestructuringDeclaration);
    }

    private final ClassDescriptor classDescriptor(@NotNull KtDestructuringDeclaration $receiver) {
        Object object;
        block6: {
            block5: {
                KtExpression ktExpression;
                KtExpression it;
                object = $receiver.getInitializer();
                if (object == null) break block5;
                KtExpression ktExpression2 = it = (ktExpression = object);
                Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression2, (String)"it");
                object = ResolutionUtils.analyze$default(ktExpression2, null, 1, null).getType(it);
                if (object != null) break block6;
            }
            return null;
        }
        Object type2 = object;
        ClassifierDescriptor classifierDescriptor = ((KotlinType)type2).getConstructor().getDeclarationDescriptor();
        if (!(classifierDescriptor instanceof ClassDescriptor)) {
            classifierDescriptor = null;
        }
        ClassDescriptor classDescriptor = (ClassDescriptor)classifierDescriptor;
        if (classDescriptor == null) {
            return null;
        }
        return classDescriptor;
    }

    private final List<ValueParameterDescriptor> primaryParameters(@NotNull ClassDescriptor $receiver) {
        Object v2;
        block1: {
            Collection<ClassConstructorDescriptor> collection = $receiver.getConstructors();
            Intrinsics.checkExpressionValueIsNotNull(collection, (String)"constructors");
            Iterable $receiver$iv = collection;
            for (Object element$iv : $receiver$iv) {
                ClassConstructorDescriptor it;
                ClassConstructorDescriptor classConstructorDescriptor = it = (ClassConstructorDescriptor)element$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)classConstructorDescriptor, (String)"it");
                if (!classConstructorDescriptor.isPrimary()) continue;
                v2 = element$iv;
                break block1;
            }
            v2 = null;
        }
        ClassConstructorDescriptor classConstructorDescriptor = v2;
        return classConstructorDescriptor != null ? classConstructorDescriptor.getValueParameters() : null;
    }

    public AddMissingDestructuringIntention() {
        super(KtDestructuringDeclaration.class, "Add missing component", null, 4, null);
    }
}

