/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingRangeIntention;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u001a\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u00022\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ConvertClassToSealedClassIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingRangeIntention;", "Lorg/jetbrains/kotlin/psi/KtClass;", "()V", "applicabilityRange", "Lcom/intellij/openapi/util/TextRange;", "element", "applyTo", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "idea"})
public final class ConvertClassToSealedClassIntention
extends SelfTargetingRangeIntention<KtClass> {
    @Override
    @Nullable
    public TextRange applicabilityRange(@NotNull KtClass element3) {
        boolean bl;
        block8: {
            Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
            if (element3.getModifierList() == null) {
                return null;
            }
            if (!element3.hasModifier(KtTokens.OPEN_KEYWORD) && !element3.hasModifier(KtTokens.ABSTRACT_KEYWORD)) {
                return null;
            }
            List constructors2 = CollectionsKt.plus((Collection)CollectionsKt.listOfNotNull((Object)element3.getPrimaryConstructor()), (Iterable)element3.getSecondaryConstructors());
            if (constructors2.isEmpty()) {
                return null;
            }
            Iterable $receiver$iv = constructors2;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $receiver$iv) {
                    KtConstructor it = (KtConstructor)element$iv;
                    if (it.hasModifier(KtTokens.PRIVATE_KEYWORD) && it.getAnnotationEntries().isEmpty()) continue;
                    bl = false;
                    break block8;
                }
                bl = true;
            }
        }
        if (!bl) {
            return null;
        }
        PsiElement psiElement2 = element3.getNameIdentifier();
        if (psiElement2 == null) {
            return null;
        }
        PsiElement nameIdentifier = psiElement2;
        int n = PsiUtilsKt.getStartOffset(element3);
        PsiElement psiElement3 = nameIdentifier;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement3, (String)"nameIdentifier");
        return new TextRange(n, PsiUtilsKt.getEndOffset(psiElement3));
    }

    @Override
    public void applyTo(@NotNull KtClass element3, @Nullable Editor editor) {
        KtModifierList $receiver;
        KtElementImplStub ktElementImplStub;
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        KtModifierList ktModifierList = element3.getModifierList();
        if (ktModifierList != null) {
            $receiver = ktElementImplStub = ktModifierList;
            PsiElement psiElement2 = $receiver.getModifier(KtTokens.OPEN_KEYWORD);
            if (psiElement2 != null) {
                psiElement2.delete();
            }
            PsiElement psiElement3 = $receiver.getModifier(KtTokens.ABSTRACT_KEYWORD);
            if (psiElement3 != null) {
                psiElement3.delete();
            }
        }
        element3.addModifier(KtTokens.SEALED_KEYWORD);
        KtPrimaryConstructor ktPrimaryConstructor = element3.getPrimaryConstructor();
        if (ktPrimaryConstructor != null) {
            $receiver = ktElementImplStub = ktPrimaryConstructor;
            if (element3.getSecondaryConstructors().isEmpty() && ((KtConstructor)((Object)$receiver)).getValueParameters().isEmpty()) {
                $receiver.delete();
            } else {
                PsiElement psiElement4 = $receiver.copy();
                if (psiElement4 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtPrimaryConstructor");
                }
                KtPrimaryConstructor newConstructor = (KtPrimaryConstructor)psiElement4;
                KtModifierList ktModifierList2 = newConstructor.getModifierList();
                if (ktModifierList2 != null && (ktModifierList2 = ktModifierList2.getModifier(KtTokens.PRIVATE_KEYWORD)) != null) {
                    ktModifierList2.delete();
                }
                PsiElement psiElement5 = newConstructor.getConstructorKeyword();
                if (psiElement5 != null) {
                    psiElement5.delete();
                }
                $receiver.replace(newConstructor);
            }
        }
        Iterable $receiver$iv = element3.getSecondaryConstructors();
        for (Object element$iv : $receiver$iv) {
            KtSecondaryConstructor it = (KtSecondaryConstructor)element$iv;
            KtModifierList ktModifierList3 = it.getModifierList();
            if (ktModifierList3 == null || (ktModifierList3 = ktModifierList3.getModifier(KtTokens.PRIVATE_KEYWORD)) == null) continue;
            ktModifierList3.delete();
        }
    }

    public ConvertClassToSealedClassIntention() {
        super(KtClass.class, "Convert to sealed class", null, 4, null);
    }
}

