/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions.branchedTransformations.intentions;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.intentions.ChooseStringExpression;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingRangeIntention;
import org.jetbrains.kotlin.idea.intentions.branchedTransformations.IfThenUtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtPostfixExpression;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtThrowExpression;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u001a\u0010\b\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\u00022\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/branchedTransformations/intentions/DoubleBangToIfThenIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingRangeIntention;", "Lorg/jetbrains/kotlin/psi/KtPostfixExpression;", "Lcom/intellij/codeInsight/intention/LowPriorityAction;", "()V", "applicabilityRange", "Lcom/intellij/openapi/util/TextRange;", "element", "applyTo", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "formatForUseInExceptionArgument", "", "expressionText", "idea"})
public final class DoubleBangToIfThenIntention
extends SelfTargetingRangeIntention<KtPostfixExpression>
implements LowPriorityAction {
    @Override
    @Nullable
    public TextRange applicabilityRange(@NotNull KtPostfixExpression element3) {
        TextRange textRange;
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        if (Intrinsics.areEqual((Object)element3.getOperationToken(), (Object)((Object)KtTokens.EXCLEXCL)) && element3.getBaseExpression() != null) {
            KtSimpleNameExpression ktSimpleNameExpression = element3.getOperationReference();
            Intrinsics.checkExpressionValueIsNotNull((Object)ktSimpleNameExpression, (String)"element.operationReference");
            textRange = ktSimpleNameExpression.getTextRange();
        } else {
            textRange = null;
        }
        return textRange;
    }

    @Override
    public void applyTo(@NotNull KtPostfixExpression element3, @Nullable Editor editor) {
        KtExpression base;
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        if (editor == null) {
            throw (Throwable)new IllegalArgumentException("This intention requires an editor");
        }
        KtExpression ktExpression = element3.getBaseExpression();
        if (ktExpression == null) {
            Intrinsics.throwNpe();
        }
        KtExpression ktExpression2 = base = KtPsiUtil.safeDeparenthesize(ktExpression, true);
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression2, (String)"base");
        String string = ktExpression2.getText();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        String expressionText = this.formatForUseInExceptionArgument(string);
        KtExpression defaultException = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)element3, false, 2, null).createExpression("throw NullPointerException()");
        boolean isStatement = BindingContextUtilsKt.isUsedAsStatement(element3, ResolutionUtils.analyze$default(element3, null, 1, null));
        boolean isStable = IfThenUtilsKt.isStableSimpleExpression$default(base, null, 1, null);
        KtIfExpression ifStatement = isStatement ? IfThenUtilsKt.convertToIfNullExpression(element3, base, defaultException) : IfThenUtilsKt.convertToIfNotNullExpression(element3, base, base, defaultException);
        KtExpression ktExpression3 = isStatement ? ifStatement.getThen() : ifStatement.getElse();
        if (ktExpression3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtThrowExpression");
        }
        KtExpression ktExpression4 = ((KtThrowExpression)ktExpression3).getThrownExpression();
        if (ktExpression4 == null) {
            Intrinsics.throwNpe();
        }
        KtExpression thrownExpression = ktExpression4;
        String message2 = StringUtil.escapeStringCharacters((String)("Expression '" + expressionText + "' must not be null"));
        String nullPtrExceptionText = "NullPointerException(\"" + message2 + "\")";
        String kotlinNullPtrExceptionText = "KotlinNullPointerException()";
        ChooseStringExpression exceptionLookupExpression = new ChooseStringExpression((Collection)CollectionsKt.listOf((Object[])new String[]{nullPtrExceptionText, kotlinNullPtrExceptionText}), null, null, 6, null);
        Project project = element3.getProject();
        TemplateBuilderImpl builder = new TemplateBuilderImpl((PsiElement)thrownExpression);
        builder.replaceElement((PsiElement)thrownExpression, (Expression)exceptionLookupExpression);
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(editor.getDocument());
        CaretModel caretModel = editor.getCaretModel();
        KtExpression ktExpression5 = thrownExpression;
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression5, (String)"thrownExpression");
        ASTNode aSTNode = ktExpression5.getNode();
        if (aSTNode == null) {
            Intrinsics.throwNpe();
        }
        caretModel.moveToOffset(aSTNode.getStartOffset());
        TemplateManager.getInstance((Project)project).startTemplate(editor, builder.buildInlineTemplate(), (TemplateEditingListener)new TemplateEditingAdapter(isStable, isStatement, ifStatement, editor){
            final /* synthetic */ boolean $isStable;
            final /* synthetic */ boolean $isStatement;
            final /* synthetic */ KtIfExpression $ifStatement;
            final /* synthetic */ Editor $editor;

            public void templateFinished(@Nullable Template template2, boolean brokenOff) {
                if (!this.$isStable && !this.$isStatement) {
                    KtExpression ktExpression = this.$ifStatement.getThen();
                    if (ktExpression == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"ifStatement.then!!");
                    IfThenUtilsKt.introduceValueForCondition(this.$ifStatement, ktExpression, this.$editor);
                }
            }
            {
                this.$isStable = $captured_local_variable$0;
                this.$isStatement = $captured_local_variable$1;
                this.$ifStatement = $captured_local_variable$2;
                this.$editor = $captured_local_variable$3;
            }
        });
    }

    private final String formatForUseInExceptionArgument(String expressionText) {
        String string;
        List lines = StringsKt.split$default((CharSequence)expressionText, (char[])new char[]{'\n'}, (boolean)false, (int)0, (int)6, null);
        if (lines.size() > 1) {
            String string2 = (String)CollectionsKt.first((List)lines);
            StringBuilder stringBuilder = new StringBuilder();
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            String string4 = ((Object)StringsKt.trim((CharSequence)string3)).toString();
            string = stringBuilder.append(string4).append(" ...").toString();
        } else {
            String string5;
            String string6 = string5 = expressionText;
            if (string6 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            string = ((Object)StringsKt.trim((CharSequence)string6)).toString();
        }
        return string;
    }

    public DoubleBangToIfThenIntention() {
        super(KtPostfixExpression.class, "Replace '!!' expression with 'if' expression", null, 4, null);
    }
}

