/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions.branchedTransformations.intentions;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.PsiModificationUtilsKt;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingRangeIntention;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBreakExpression;
import org.jetbrains.kotlin.psi.KtContinueExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtThrowExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u0003H\u0016J\u001a\u0010\b\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\u00032\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/branchedTransformations/intentions/UnfoldReturnToIfIntention;", "Lcom/intellij/codeInsight/intention/LowPriorityAction;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingRangeIntention;", "Lorg/jetbrains/kotlin/psi/KtReturnExpression;", "()V", "applicabilityRange", "Lcom/intellij/openapi/util/TextRange;", "element", "applyTo", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "Companion", "idea"})
public final class UnfoldReturnToIfIntention
extends SelfTargetingRangeIntention<KtReturnExpression>
implements LowPriorityAction {
    public static final Companion Companion = new Companion(null);

    @Override
    @Nullable
    public TextRange applicabilityRange(@NotNull KtReturnExpression element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        KtExpression ktExpression = element3.getReturnedExpression();
        if (!(ktExpression instanceof KtIfExpression)) {
            ktExpression = null;
        }
        KtIfExpression ktIfExpression = (KtIfExpression)ktExpression;
        if (ktIfExpression == null) {
            return null;
        }
        KtIfExpression ifExpression2 = ktIfExpression;
        int n = PsiUtilsKt.getStartOffset((PsiElement)element3);
        PsiElement psiElement2 = ifExpression2.getIfKeyword();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"ifExpression.ifKeyword");
        return new TextRange(n, PsiUtilsKt.getEndOffset(psiElement2));
    }

    @Override
    public void applyTo(@NotNull KtReturnExpression element3, @Nullable Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        KtExpression ktExpression = element3.getReturnedExpression();
        if (ktExpression == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtIfExpression");
        }
        KtIfExpression ifExpression2 = (KtIfExpression)ktExpression;
        KtExpression ktExpression2 = ifExpression2.getThen();
        if (ktExpression2 == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression2, (String)"ifExpression.then!!");
        KtExpression thenExpr = KtPsiUtilKt.lastBlockStatementOrThis(ktExpression2);
        KtExpression ktExpression3 = ifExpression2.getElse();
        if (ktExpression3 == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression3, (String)"ifExpression.`else`!!");
        KtExpression elseExpr = KtPsiUtilKt.lastBlockStatementOrThis(ktExpression3);
        KtIfExpression newIfExpression = (KtIfExpression)PsiModificationUtilsKt.copied((PsiElement)ifExpression2);
        KtExpression ktExpression4 = newIfExpression.getThen();
        if (ktExpression4 == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression4, (String)"newIfExpression.then!!");
        KtExpression newThenExpr = KtPsiUtilKt.lastBlockStatementOrThis(ktExpression4);
        KtExpression ktExpression5 = newIfExpression.getElse();
        if (ktExpression5 == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression5, (String)"newIfExpression.`else`!!");
        KtExpression newElseExpr = KtPsiUtilKt.lastBlockStatementOrThis(ktExpression5);
        KtPsiFactory psiFactory = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)element3, false, 2, null);
        BindingContext context2 = ResolutionUtils.analyze$default(element3, null, 1, null);
        newThenExpr.replace((PsiElement)Companion.createReturnExpression(thenExpr, psiFactory, context2));
        newElseExpr.replace((PsiElement)Companion.createReturnExpression(elseExpr, psiFactory, context2));
        element3.replace((PsiElement)newIfExpression);
    }

    public UnfoldReturnToIfIntention() {
        super(KtReturnExpression.class, "Replace return with 'if' expression", null, 4, null);
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/branchedTransformations/intentions/UnfoldReturnToIfIntention$Companion;", "", "()V", "createReturnExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "expr", "psiFactory", "Lorg/jetbrains/kotlin/psi/KtPsiFactory;", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "idea"})
    public static final class Companion {
        /*
         * Enabled aggressive block sorting
         */
        @NotNull
        public final KtExpression createReturnExpression(@NotNull KtExpression expr2, @NotNull KtPsiFactory psiFactory, @NotNull BindingContext context2) {
            Object object;
            Intrinsics.checkParameterIsNotNull((Object)expr2, (String)"expr");
            Intrinsics.checkParameterIsNotNull((Object)psiFactory, (String)"psiFactory");
            Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
            KtExpression ktExpression = expr2;
            String returnText = ktExpression instanceof KtBreakExpression || ktExpression instanceof KtContinueExpression || ktExpression instanceof KtReturnExpression || ktExpression instanceof KtThrowExpression ? "" : ((object = CallUtilKt.getResolvedCall(expr2, context2)) != null && (object = object.getResultingDescriptor()) != null && (object = object.getReturnType()) != null && TypeUtilsKt.isNothing((KotlinType)object) ? "" : "return ");
            return CreateByPatternKt.createExpressionByPattern$default(psiFactory, returnText + "$0", new Object[]{expr2}, false, 4, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

