/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.internal;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.ex.dummy.DummyFileSystem;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.internal.DecompileFailedException;
import org.jetbrains.kotlin.idea.internal.KotlinBytecodeDecompilerTask;
import org.jetbrains.kotlin.idea.internal.KotlinDecompilerAdapterKt;
import org.jetbrains.kotlin.idea.internal.KotlinDecompilerService;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/internal/KotlinBytecodeDecompilerTask;", "Lcom/intellij/openapi/progress/Task$Backgroundable;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "(Lorg/jetbrains/kotlin/psi/KtFile;)V", "getFile", "()Lorg/jetbrains/kotlin/psi/KtFile;", "run", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "idea"})
public final class KotlinBytecodeDecompilerTask
extends Task.Backgroundable {
    @NotNull
    private final KtFile file;

    public void run(@NotNull ProgressIndicator indicator) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
        KotlinDecompilerService kotlinDecompilerService = KotlinDecompilerService.Companion.getInstance();
        if (kotlinDecompilerService == null) {
            return;
        }
        KotlinDecompilerService decompilerService = kotlinDecompilerService;
        indicator.setText("Decompiling " + this.file.getName());
        try {
            string = decompilerService.decompile(this.file);
        }
        catch (DecompileFailedException e) {
            string = null;
        }
        String decompiledText2 = string;
        ApplicationManager.getApplication().invokeLater(new Runnable(this, decompiledText2){
            final /* synthetic */ KotlinBytecodeDecompilerTask this$0;
            final /* synthetic */ String $decompiledText;

            public final void run() {
                ApplicationUtilsKt.runWriteAction((Function0)new Function0<Unit>(this){
                    final /* synthetic */ run.1 this$0;

                    public final void invoke() {
                        block5: {
                            block4: {
                                if (!this.this$0.this$0.getFile().isValid()) break block4;
                                Project project = this.this$0.this$0.getFile().getProject();
                                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"file.project");
                                if (!project.isDisposed()) break block5;
                            }
                            return;
                        }
                        if (this.this$0.$decompiledText == null) {
                            Messages.showErrorDialog((String)("Cannot decompile " + this.this$0.this$0.getFile().getName()), (String)"Decompiler error");
                            return;
                        }
                        VirtualFile root = KotlinDecompilerAdapterKt.getOrCreateDummyRoot();
                        String decompiledFileName = FileUtil.getNameWithoutExtension((String)this.this$0.this$0.getFile().getName()) + ".decompiled.java";
                        VirtualFile result2 = DummyFileSystem.getInstance().createChildFile(null, root, decompiledFileName);
                        VfsUtil.saveText((VirtualFile)result2, (String)this.this$0.$decompiledText);
                        new OpenFileDescriptor(this.this$0.this$0.getFile().getProject(), result2).navigate(true);
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                });
            }
            {
                this.this$0 = kotlinBytecodeDecompilerTask;
                this.$decompiledText = string;
            }
        });
    }

    @NotNull
    public final KtFile getFile() {
        return this.file;
    }

    public KotlinBytecodeDecompilerTask(@NotNull KtFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        super(file.getProject(), "Decompile kotlin bytecode");
        this.file = file;
    }
}

