/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.modules;

import com.intellij.codeInsight.daemon.impl.analysis.JavaModuleGraphUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.impl.light.LightJavaModule;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.modules.ModuleHighlightUtil2;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.jvm.modules.JavaModuleResolver;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\b2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000fH\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0014\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/modules/IdeJavaModuleResolver;", "Lorg/jetbrains/kotlin/resolve/jvm/modules/JavaModuleResolver;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "checkAccessibility", "Lorg/jetbrains/kotlin/resolve/jvm/modules/JavaModuleResolver$AccessError;", "fileFromOurModule", "Lcom/intellij/openapi/vfs/VirtualFile;", "referencedFile", "referencedPackage", "Lorg/jetbrains/kotlin/name/FqName;", "exports", "", "source", "Lcom/intellij/psi/PsiJavaModule;", "packageName", "", "target", "findJavaModule", "file", "idea-core"})
public final class IdeJavaModuleResolver
implements JavaModuleResolver {
    private final Project project;

    private final PsiJavaModule findJavaModule(VirtualFile file) {
        return ModuleHighlightUtil2.getModuleDescriptor(file, this.project);
    }

    @Override
    @Nullable
    public JavaModuleResolver.AccessError checkAccessibility(@Nullable VirtualFile fileFromOurModule, @NotNull VirtualFile referencedFile, @Nullable FqName referencedPackage) {
        PsiJavaModule psiJavaModule;
        Intrinsics.checkParameterIsNotNull((Object)referencedFile, (String)"referencedFile");
        VirtualFile virtualFile = fileFromOurModule;
        if (virtualFile != null) {
            VirtualFile virtualFile2 = virtualFile;
            IdeJavaModuleResolver ideJavaModuleResolver = this;
            VirtualFile p1 = virtualFile2;
            psiJavaModule = ideJavaModuleResolver.findJavaModule(p1);
        } else {
            psiJavaModule = null;
        }
        PsiJavaModule ourModule = psiJavaModule;
        PsiJavaModule theirModule = this.findJavaModule(referencedFile);
        PsiJavaModule psiJavaModule2 = ourModule;
        PsiJavaModule psiJavaModule3 = theirModule;
        if (Intrinsics.areEqual((Object)(psiJavaModule2 != null ? psiJavaModule2.getName() : null), (Object)(psiJavaModule3 != null ? psiJavaModule3.getName() : null))) {
            return null;
        }
        if (theirModule == null) {
            return JavaModuleResolver.AccessError.ModuleDoesNotReadUnnamedModule.INSTANCE;
        }
        if (ourModule != null && !JavaModuleGraphUtil.reads((PsiJavaModule)ourModule, (PsiJavaModule)theirModule)) {
            String string = theirModule.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"theirModule.name");
            return new JavaModuleResolver.AccessError.ModuleDoesNotReadModule(string);
        }
        if (ourModule != null) {
            Object fqName2;
            Object object = referencedPackage;
            if (object == null || (object = ((FqName)object).asString()) == null) {
                return null;
            }
            Object object2 = fqName2 = object;
            Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"fqName");
            if (!this.exports(theirModule, (String)object2, ourModule)) {
                String string = theirModule.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"theirModule.name");
                return new JavaModuleResolver.AccessError.ModuleDoesNotExportPackage(string);
            }
        }
        return null;
    }

    private final boolean exports(PsiJavaModule source, String packageName, PsiJavaModule target) {
        return source instanceof LightJavaModule || JavaModuleGraphUtil.exports((PsiJavaModule)source, (String)packageName, (PsiJavaModule)target);
    }

    public IdeJavaModuleResolver(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
    }
}

