/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u00142\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0014B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016J\n\u0010\b\u001a\u0004\u0018\u00010\tH\u0002J\"\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\"\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeAccessorTypeFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtPropertyAccessor;", "element", "(Lorg/jetbrains/kotlin/psi/KtPropertyAccessor;)V", "getFamilyName", "", "getText", "getType", "Lorg/jetbrains/kotlin/types/KotlinType;", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "isAvailable", "", "Companion", "idea"})
public final class ChangeAccessorTypeFix
extends KotlinQuickFixAction<KtPropertyAccessor> {
    public static final Companion Companion = new Companion(null);

    private final KotlinType getType() {
        Annotated annotated;
        Annotated receiver;
        Annotated annotated2;
        Object t = this.getElement();
        if (t == null) {
            Intrinsics.throwNpe();
        }
        KtProperty ktProperty = ((KtPropertyAccessor)t).getProperty();
        Intrinsics.checkExpressionValueIsNotNull((Object)ktProperty, (String)"element!!.property");
        DeclarationDescriptor declarationDescriptor = ResolutionUtils.resolveToDescriptorIfAny$default(ktProperty, null, 1, null);
        if (!(declarationDescriptor instanceof VariableDescriptor)) {
            declarationDescriptor = null;
        }
        return (annotated2 = (VariableDescriptor)declarationDescriptor) != null && (annotated2 = annotated2.getType()) != null ? (!KotlinTypeKt.isError((KotlinType)(receiver = (annotated = annotated2))) ? annotated : null) : null;
    }

    @Override
    protected boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return this.getType() != null;
    }

    @NotNull
    public String getFamilyName() {
        return "Change accessor type";
    }

    @NotNull
    public String getText() {
        KtPropertyAccessor ktPropertyAccessor = (KtPropertyAccessor)this.getElement();
        if (ktPropertyAccessor == null) {
            return "";
        }
        KtPropertyAccessor element3 = ktPropertyAccessor;
        KotlinType kotlinType = this.getType();
        if (kotlinType == null) {
            return this.getFamilyName();
        }
        KotlinType type2 = kotlinType;
        String renderedType = IdeDescriptorRenderers.SOURCE_CODE_SHORT_NAMES_NO_ANNOTATIONS.renderType(type2);
        String target = element3.isGetter() ? "getter" : "setter parameter";
        return "Change " + target + " type to " + renderedType;
    }

    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file) {
        PsiElement psiElement2;
        KtTypeReference typeReference;
        KtTypeReference ktTypeReference;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        KtPropertyAccessor ktPropertyAccessor = (KtPropertyAccessor)this.getElement();
        if (ktPropertyAccessor == null) {
            return;
        }
        KtPropertyAccessor element3 = ktPropertyAccessor;
        KotlinType kotlinType = this.getType();
        if (kotlinType == null) {
            Intrinsics.throwNpe();
        }
        KotlinType type2 = kotlinType;
        KtTypeReference newTypeReference = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)file, false, 2, null).createType(IdeDescriptorRenderers.SOURCE_CODE.renderType(type2));
        if (element3.isGetter()) {
            ktTypeReference = element3.getReturnTypeReference();
        } else {
            KtParameter ktParameter = element3.getParameter();
            if (ktParameter == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)ktParameter, (String)"element.parameter!!");
            ktTypeReference = ktParameter.getTypeReference();
        }
        KtTypeReference ktTypeReference2 = typeReference = ktTypeReference;
        if (ktTypeReference2 == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktTypeReference2, (String)"typeReference!!");
        PsiElement $receiver$iv = ktTypeReference2;
        PsiElement result$iv = $receiver$iv.replace((PsiElement)newTypeReference);
        if (result$iv instanceof KtTypeReference) {
            psiElement2 = result$iv;
        } else {
            PsiElement psiElement3 = result$iv;
            if (psiElement3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
            }
            KtExpression ktExpression = ((KtParenthesizedExpression)psiElement3).getExpression();
            if (ktExpression == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtTypeReference");
            }
            psiElement2 = (KtTypeReference)((Object)ktExpression);
        }
        KtTypeReference insertedTypeRef = (KtTypeReference)psiElement2;
        ShortenReferences.process$default(ShortenReferences.DEFAULT, insertedTypeRef, null, 2, null);
    }

    public ChangeAccessorTypeFix(@NotNull KtPropertyAccessor element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        super((PsiElement)element3);
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeAccessorTypeFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lorg/jetbrains/kotlin/idea/quickfix/ChangeAccessorTypeFix;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "idea"})
    public static final class Companion
    extends KotlinSingleIntentionActionFactory {
        @Override
        @Nullable
        public ChangeAccessorTypeFix createAction(@NotNull Diagnostic diagnostic) {
            ChangeAccessorTypeFix changeAccessorTypeFix;
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            PsiElement psiElement2 = diagnostic.getPsiElement();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"diagnostic.psiElement");
            PsiElement $receiver$iv = psiElement2;
            KtPropertyAccessor ktPropertyAccessor = (KtPropertyAccessor)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtPropertyAccessor.class, (boolean)false);
            if (ktPropertyAccessor != null) {
                KtPropertyAccessor ktPropertyAccessor2;
                KtPropertyAccessor p1 = ktPropertyAccessor2 = ktPropertyAccessor;
                changeAccessorTypeFix = new ChangeAccessorTypeFix(p1);
            } else {
                changeAccessorTypeFix = null;
            }
            return changeAccessorTypeFix;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

