/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.idea.core.PsiModificationUtilsKt;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.resolve.ExposedVisibilityChecker;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u0000 \u00172\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0005\u0013\u0014\u0015\u0016\u0017B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\u0005H\u0016J\b\u0010\n\u001a\u00020\u0005H\u0016J\"\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeVisibilityFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtModifierListOwner;", "element", "elementName", "", "visibilityModifier", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "(Lorg/jetbrains/kotlin/psi/KtModifierListOwner;Ljava/lang/String;Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;)V", "getFamilyName", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "ChangeToInternalFix", "ChangeToPrivateFix", "ChangeToProtectedFix", "ChangeToPublicFix", "Companion", "idea"})
public class ChangeVisibilityFix
extends KotlinQuickFixAction<KtModifierListOwner> {
    private final String elementName;
    private final KtModifierKeywordToken visibilityModifier;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getText() {
        return "Make '" + this.elementName + "' " + (Object)((Object)this.visibilityModifier);
    }

    @NotNull
    public String getFamilyName() {
        return "Make " + (Object)((Object)this.visibilityModifier);
    }

    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            KtModifierListOwner ktModifierListOwner = (KtModifierListOwner)this.getElement();
            if (ktModifierListOwner == null) break block0;
            PsiModificationUtilsKt.setVisibility(ktModifierListOwner, this.visibilityModifier);
        }
    }

    public ChangeVisibilityFix(@NotNull KtModifierListOwner element3, @NotNull String elementName, @NotNull KtModifierKeywordToken visibilityModifier) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)elementName, (String)"elementName");
        Intrinsics.checkParameterIsNotNull((Object)((Object)visibilityModifier), (String)"visibilityModifier");
        super((PsiElement)element3);
        this.elementName = elementName;
        this.visibilityModifier = visibilityModifier;
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeVisibilityFix$ChangeToPublicFix;", "Lorg/jetbrains/kotlin/idea/quickfix/ChangeVisibilityFix;", "Lcom/intellij/codeInsight/intention/HighPriorityAction;", "element", "Lorg/jetbrains/kotlin/psi/KtModifierListOwner;", "elementName", "", "(Lorg/jetbrains/kotlin/psi/KtModifierListOwner;Ljava/lang/String;)V", "idea"})
    protected static final class ChangeToPublicFix
    extends ChangeVisibilityFix
    implements HighPriorityAction {
        public ChangeToPublicFix(@NotNull KtModifierListOwner element3, @NotNull String elementName) {
            Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
            Intrinsics.checkParameterIsNotNull((Object)elementName, (String)"elementName");
            KtModifierKeywordToken ktModifierKeywordToken = KtTokens.PUBLIC_KEYWORD;
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktModifierKeywordToken), (String)"KtTokens.PUBLIC_KEYWORD");
            super(element3, elementName, ktModifierKeywordToken);
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\"\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeVisibilityFix$ChangeToProtectedFix;", "Lorg/jetbrains/kotlin/idea/quickfix/ChangeVisibilityFix;", "element", "Lorg/jetbrains/kotlin/psi/KtModifierListOwner;", "elementName", "", "(Lorg/jetbrains/kotlin/psi/KtModifierListOwner;Ljava/lang/String;)V", "isAvailable", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "idea"})
    protected static final class ChangeToProtectedFix
    extends ChangeVisibilityFix {
        @Override
        protected boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            KtModifierListOwner ktModifierListOwner = (KtModifierListOwner)this.getElement();
            if (ktModifierListOwner == null) {
                return false;
            }
            KtModifierListOwner element3 = ktModifierListOwner;
            return PsiModificationUtilsKt.canBeProtected(element3);
        }

        public ChangeToProtectedFix(@NotNull KtModifierListOwner element3, @NotNull String elementName) {
            Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
            Intrinsics.checkParameterIsNotNull((Object)elementName, (String)"elementName");
            KtModifierKeywordToken ktModifierKeywordToken = KtTokens.PROTECTED_KEYWORD;
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktModifierKeywordToken), (String)"KtTokens.PROTECTED_KEYWORD");
            super(element3, elementName, ktModifierKeywordToken);
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeVisibilityFix$ChangeToInternalFix;", "Lorg/jetbrains/kotlin/idea/quickfix/ChangeVisibilityFix;", "element", "Lorg/jetbrains/kotlin/psi/KtModifierListOwner;", "elementName", "", "(Lorg/jetbrains/kotlin/psi/KtModifierListOwner;Ljava/lang/String;)V", "idea"})
    protected static final class ChangeToInternalFix
    extends ChangeVisibilityFix {
        public ChangeToInternalFix(@NotNull KtModifierListOwner element3, @NotNull String elementName) {
            Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
            Intrinsics.checkParameterIsNotNull((Object)elementName, (String)"elementName");
            KtModifierKeywordToken ktModifierKeywordToken = KtTokens.INTERNAL_KEYWORD;
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktModifierKeywordToken), (String)"KtTokens.INTERNAL_KEYWORD");
            super(element3, elementName, ktModifierKeywordToken);
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\"\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeVisibilityFix$ChangeToPrivateFix;", "Lorg/jetbrains/kotlin/idea/quickfix/ChangeVisibilityFix;", "Lcom/intellij/codeInsight/intention/HighPriorityAction;", "element", "Lorg/jetbrains/kotlin/psi/KtModifierListOwner;", "elementName", "", "(Lorg/jetbrains/kotlin/psi/KtModifierListOwner;Ljava/lang/String;)V", "isAvailable", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "idea"})
    protected static final class ChangeToPrivateFix
    extends ChangeVisibilityFix
    implements HighPriorityAction {
        @Override
        protected boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            KtModifierListOwner ktModifierListOwner = (KtModifierListOwner)this.getElement();
            if (ktModifierListOwner == null) {
                return false;
            }
            KtModifierListOwner element3 = ktModifierListOwner;
            return PsiModificationUtilsKt.canBePrivate(element3);
        }

        public ChangeToPrivateFix(@NotNull KtModifierListOwner element3, @NotNull String elementName) {
            Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
            Intrinsics.checkParameterIsNotNull((Object)elementName, (String)"elementName");
            KtModifierKeywordToken ktModifierKeywordToken = KtTokens.PRIVATE_KEYWORD;
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktModifierKeywordToken), (String)"KtTokens.PRIVATE_KEYWORD");
            super(element3, elementName, ktModifierKeywordToken);
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeVisibilityFix$Companion;", "", "()V", "create", "Lcom/intellij/codeInsight/intention/IntentionAction;", "declaration", "Lorg/jetbrains/kotlin/psi/KtModifierListOwner;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptorWithVisibility;", "targetVisibility", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "idea"})
    public static final class Companion {
        @Nullable
        public final IntentionAction create(@NotNull KtModifierListOwner declaration2, @NotNull DeclarationDescriptorWithVisibility descriptor2, @NotNull Visibility targetVisibility) {
            IntentionAction intentionAction;
            Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            Intrinsics.checkParameterIsNotNull((Object)targetVisibility, (String)"targetVisibility");
            if (!new ExposedVisibilityChecker(null, 1, null).checkDeclarationWithVisibility(declaration2, descriptor2, targetVisibility)) {
                return null;
            }
            String name2 = descriptor2.getName().asString();
            Visibility visibility = targetVisibility;
            if (Intrinsics.areEqual((Object)visibility, (Object)Visibilities.PRIVATE)) {
                String string = name2;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name");
                intentionAction = new ChangeToPrivateFix(declaration2, string);
            } else if (Intrinsics.areEqual((Object)visibility, (Object)Visibilities.INTERNAL)) {
                String string = name2;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name");
                intentionAction = new ChangeToInternalFix(declaration2, string);
            } else if (Intrinsics.areEqual((Object)visibility, (Object)Visibilities.PROTECTED)) {
                String string = name2;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name");
                intentionAction = new ChangeToProtectedFix(declaration2, string);
            } else if (Intrinsics.areEqual((Object)visibility, (Object)Visibilities.PUBLIC)) {
                String string = name2;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name");
                intentionAction = new ChangeToPublicFix(declaration2, string);
            } else {
                intentionAction = null;
            }
            return intentionAction;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

