/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters1;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.intentions.RemoveEmptyPrimaryConstructorIntention;
import org.jetbrains.kotlin.idea.quickfix.ChangeFunctionSignatureFix;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.quickfix.RemoveUnusedFunctionParameterFix;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.psi.EditCommaSeparatedListHelper;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeParameterList;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwnerStub;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u00162\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0016B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016J\"\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0003\u001a\u00020\u0002H\u0002J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0011H\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/RemoveUnusedFunctionParameterFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtParameter;", "parameter", "(Lorg/jetbrains/kotlin/psi/KtParameter;)V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "redundantTypeParameter", "Lorg/jetbrains/kotlin/psi/KtTypeParameter;", "runRemoveTypeParameter", "typeParameter", "startInWriteAction", "", "Companion", "idea"})
public final class RemoveUnusedFunctionParameterFix
extends KotlinQuickFixAction<KtParameter> {
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getFamilyName() {
        return ChangeFunctionSignatureFix.Companion.getFAMILY_NAME();
    }

    @NotNull
    public String getText() {
        Object object;
        block3: {
            block2: {
                KtParameter ktParameter;
                object = (KtParameter)this.getElement();
                if (object == null) break block2;
                KtParameter it = ktParameter = object;
                object = "Remove parameter '" + it.getName() + '\'';
                if (object != null) break block3;
            }
            object = "";
        }
        return object;
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file) {
        RemoveEmptyPrimaryConstructorIntention removeConstructorIntention;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        KtParameter ktParameter = (KtParameter)this.getElement();
        if (ktParameter == null) {
            return;
        }
        KtParameter parameter = ktParameter;
        PsiElement psiElement2 = parameter.getParent();
        if (!(psiElement2 instanceof KtParameterList)) {
            psiElement2 = null;
        }
        KtParameterList ktParameterList = (KtParameterList)psiElement2;
        if (ktParameterList == null) {
            return;
        }
        KtParameterList parameterList = ktParameterList;
        ValueParameterDescriptor valueParameterDescriptor = ResolutionUtils.resolveToParameterDescriptorIfAny(parameter, BodyResolveMode.FULL);
        if (valueParameterDescriptor == null) {
            return;
        }
        ValueParameterDescriptor parameterDescriptor = valueParameterDescriptor;
        int parameterSize = parameterList.getParameters().size();
        KtTypeParameter redundantTypeParameter2 = this.redundantTypeParameter(parameter);
        PsiElement psiElement3 = parameterList.getParent();
        if (!(psiElement3 instanceof KtPrimaryConstructor)) {
            psiElement3 = null;
        }
        KtPrimaryConstructor primaryConstructor2 = (KtPrimaryConstructor)psiElement3;
        ChangeFunctionSignatureFix.Companion.runRemoveParameter(parameterDescriptor, parameter);
        if (redundantTypeParameter2 != null) {
            this.runRemoveTypeParameter(redundantTypeParameter2);
        }
        if (parameterSize > 1) {
            Editor editor2;
            List<KtParameter> list2 = parameterList.getParameters();
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"parameterList.parameters");
            KtParameter nextParameter = (KtParameter)CollectionsKt.getOrNull(list2, (int)parameterDescriptor.getIndex());
            if (nextParameter != null && (editor2 = editor) != null && (editor2 = editor2.getCaretModel()) != null) {
                editor2.moveToOffset(PsiUtilsKt.getStartOffset(nextParameter));
            }
        }
        if (primaryConstructor2 != null && (removeConstructorIntention = new RemoveEmptyPrimaryConstructorIntention()).isApplicableTo(primaryConstructor2)) {
            Editor editor3 = editor;
            if (editor3 != null && (editor3 = editor3.getCaretModel()) != null) {
                editor3.moveToOffset(PsiUtilsKt.getEndOffset(primaryConstructor2));
            }
            ApplicationUtilsKt.runWriteAction((Function0)new Function0<Unit>(removeConstructorIntention, primaryConstructor2){
                final /* synthetic */ RemoveEmptyPrimaryConstructorIntention $removeConstructorIntention;
                final /* synthetic */ KtPrimaryConstructor $primaryConstructor;

                public final void invoke() {
                    this.$removeConstructorIntention.applyTo(this.$primaryConstructor, (Editor)null);
                }
                {
                    this.$removeConstructorIntention = removeEmptyPrimaryConstructorIntention;
                    this.$primaryConstructor = ktPrimaryConstructor;
                    super(0);
                }
            });
        }
    }

    private final KtTypeParameter redundantTypeParameter(KtParameter parameter) {
        PsiElement psiElement2;
        PsiElement $receiver$iv;
        KtElement ktElement = parameter.getTypeReference();
        if (!((ktElement != null && (ktElement = ((KtTypeReference)ktElement).getTypeElement()) != null && (ktElement = (KtNameReferenceExpression)PsiTreeUtil.getChildOfType((PsiElement)($receiver$iv = (PsiElement)ktElement), KtNameReferenceExpression.class)) != null && (ktElement = ((KtElementImplStub)ktElement).getReference()) != null ? ktElement.resolve() : (psiElement2 = null)) instanceof KtTypeParameter)) {
            psiElement2 = null;
        }
        KtTypeParameter ktTypeParameter = (KtTypeParameter)psiElement2;
        if (ktTypeParameter == null) {
            return null;
        }
        KtTypeParameter typeParameter = ktTypeParameter;
        KtTypeParameterListOwnerStub parameterParent2 = (KtTypeParameterListOwnerStub)PsiUtilsKt.getParentOfTypesAndPredicate(parameter, false, new Class[]{KtNamedFunction.class, KtClass.class}, redundantTypeParameter.parameterParent.1.INSTANCE);
        KtTypeParameterListOwnerStub typeParameterParent2 = (KtTypeParameterListOwnerStub)PsiUtilsKt.getParentOfTypesAndPredicate(typeParameter, false, new Class[]{KtNamedFunction.class, KtClass.class}, redundantTypeParameter.typeParameterParent.1.INSTANCE);
        return Intrinsics.areEqual((Object)parameterParent2, (Object)typeParameterParent2) ? typeParameter : null;
    }

    private final void runRemoveTypeParameter(KtTypeParameter typeParameter) {
        if (ReferencesSearch.search((PsiElement)typeParameter).findFirst() != null) {
            return;
        }
        PsiElement psiElement2 = typeParameter.getParent();
        if (!(psiElement2 instanceof KtTypeParameterList)) {
            psiElement2 = null;
        }
        KtTypeParameterList ktTypeParameterList = (KtTypeParameterList)psiElement2;
        if (ktTypeParameterList == null) {
            return;
        }
        KtTypeParameterList typeParameterList = ktTypeParameterList;
        List<KtTypeParameter> typeParameters = typeParameterList.getParameters();
        ApplicationUtilsKt.runWriteAction((Function0)new Function0<Unit>(typeParameters, typeParameterList, typeParameter){
            final /* synthetic */ List $typeParameters;
            final /* synthetic */ KtTypeParameterList $typeParameterList;
            final /* synthetic */ KtTypeParameter $typeParameter;

            public final void invoke() {
                if (this.$typeParameters.size() == 1) {
                    this.$typeParameterList.delete();
                } else {
                    EditCommaSeparatedListHelper.INSTANCE.removeItem((KtElement)this.$typeParameter);
                }
            }
            {
                this.$typeParameters = list2;
                this.$typeParameterList = ktTypeParameterList;
                this.$typeParameter = ktTypeParameter;
                super(0);
            }
        });
    }

    public RemoveUnusedFunctionParameterFix(@NotNull KtParameter parameter) {
        Intrinsics.checkParameterIsNotNull((Object)parameter, (String)"parameter");
        super((PsiElement)parameter);
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/RemoveUnusedFunctionParameterFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtParameter;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "idea"})
    public static final class Companion
    extends KotlinSingleIntentionActionFactory {
        @Override
        @Nullable
        protected KotlinQuickFixAction<KtParameter> createAction(@NotNull Diagnostic diagnostic) {
            KtParameter parameter;
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            Object d = Errors.UNUSED_PARAMETER.cast(diagnostic);
            Intrinsics.checkExpressionValueIsNotNull(d, (String)"Errors.UNUSED_PARAMETER.cast(diagnostic)");
            KtParameter ktParameter = parameter = (KtParameter)((DiagnosticWithParameters1)d).getPsiElement();
            Intrinsics.checkExpressionValueIsNotNull((Object)ktParameter, (String)"parameter");
            PsiElement psiElement2 = ktParameter.getParent();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"parameter.parent");
            PsiElement parameterOwner = psiElement2.getParent();
            if (parameterOwner instanceof KtFunctionLiteral || parameterOwner instanceof KtNamedFunction && ((KtNamedFunction)parameterOwner).getName() == null) {
                return null;
            }
            return new RemoveUnusedFunctionParameterFix(parameter);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

