/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.quickfix.CleanupFix;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00122\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001\u0012B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\u0006H\u0016J\b\u0010\t\u001a\u00020\u0006H\u0016J\"\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/TypeOfAnnotationMemberFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "Lorg/jetbrains/kotlin/idea/quickfix/CleanupFix;", "typeReference", "fixedType", "", "(Lorg/jetbrains/kotlin/psi/KtTypeReference;Ljava/lang/String;)V", "getFamilyName", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "Companion", "idea"})
public final class TypeOfAnnotationMemberFix
extends KotlinQuickFixAction<KtTypeReference>
implements CleanupFix {
    private final String fixedType;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getText() {
        return "Replace array of boxed with array of primitive";
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        KtTypeReference ktTypeReference = (KtTypeReference)this.getElement();
        if (ktTypeReference == null) {
            return;
        }
        KtTypeReference psiElement2 = ktTypeReference;
        psiElement2.replace(KtPsiFactoryKt.KtPsiFactory$default(psiElement2, false, 2, null).createType(this.fixedType));
    }

    public TypeOfAnnotationMemberFix(@NotNull KtTypeReference typeReference, @NotNull String fixedType) {
        Intrinsics.checkParameterIsNotNull((Object)typeReference, (String)"typeReference");
        Intrinsics.checkParameterIsNotNull((Object)fixedType, (String)"fixedType");
        super((PsiElement)typeReference);
        this.fixedType = fixedType;
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014J\u000e\u0010\u0007\u001a\u0004\u0018\u00010\b*\u00020\bH\u0002J\f\u0010\t\u001a\u00020\n*\u00020\bH\u0002\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/TypeOfAnnotationMemberFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "getArrayItemType", "Lorg/jetbrains/kotlin/types/KotlinType;", "isItemTypeToFix", "", "idea"})
    public static final class Companion
    extends KotlinSingleIntentionActionFactory {
        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            KotlinType type2;
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            PsiElement psiElement2 = diagnostic.getPsiElement();
            if (!(psiElement2 instanceof KtTypeReference)) {
                psiElement2 = null;
            }
            KtTypeReference ktTypeReference = (KtTypeReference)psiElement2;
            if (ktTypeReference == null) {
                return null;
            }
            KtTypeReference typeReference = ktTypeReference;
            KotlinType kotlinType = (KotlinType)ResolutionUtils.analyze(typeReference, BodyResolveMode.PARTIAL).get(BindingContext.TYPE, typeReference);
            if (kotlinType == null) {
                return null;
            }
            KotlinType kotlinType2 = type2 = kotlinType;
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"type");
            KotlinType kotlinType3 = this.getArrayItemType(kotlinType2);
            if (kotlinType3 == null) {
                return null;
            }
            KotlinType itemType = kotlinType3;
            Object object = itemType.getConstructor().getDeclarationDescriptor();
            if (object == null || (object = object.getName()) == null || (object = ((Name)object).asString()) == null) {
                return null;
            }
            Object itemTypeName = object;
            if (!this.isItemTypeToFix(itemType)) {
                return null;
            }
            String fixedArrayTypeText = (String)itemTypeName + "Array";
            return new TypeOfAnnotationMemberFix(typeReference, fixedArrayTypeText);
        }

        private final KotlinType getArrayItemType(@NotNull KotlinType $receiver) {
            if (!KotlinBuiltIns.isArray($receiver)) {
                return null;
            }
            TypeProjection typeProjection = (TypeProjection)CollectionsKt.singleOrNull($receiver.getArguments());
            if (typeProjection == null) {
                return null;
            }
            TypeProjection boxedType = typeProjection;
            if (boxedType.isStarProjection()) {
                return null;
            }
            return boxedType.getType();
        }

        private final boolean isItemTypeToFix(@NotNull KotlinType $receiver) {
            return KotlinBuiltIns.isByte($receiver) || KotlinBuiltIns.isChar($receiver) || KotlinBuiltIns.isShort($receiver) || KotlinBuiltIns.isInt($receiver) || KotlinBuiltIns.isLong($receiver) || KotlinBuiltIns.isFloat($receiver) || KotlinBuiltIns.isDouble($receiver) || KotlinBuiltIns.isBoolean($receiver);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

