/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.intentions.branchedTransformations.IfThenUtilsKt;
import org.jetbrains.kotlin.idea.quickfix.ConvertCollectionFix;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0013B\u001f\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\u0005H\u0016J\b\u0010\n\u001a\u00020\u0005H\u0016J\"\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/WrapWithCollectionLiteralCallFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "element", "functionName", "", "wrapInitialElement", "", "(Lorg/jetbrains/kotlin/psi/KtExpression;Ljava/lang/String;Z)V", "getFamilyName", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "Companion", "idea"})
public final class WrapWithCollectionLiteralCallFix
extends KotlinQuickFixAction<KtExpression> {
    private final String functionName;
    private final boolean wrapInitialElement;
    public static final Companion Companion = new Companion(null);

    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file) {
        block11: {
            Editor editor2;
            KtExpression replaced;
            KtExpression ktExpression;
            PsiElement result$iv;
            PsiElement $receiver$iv;
            PsiElement newElement$iv;
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            KtExpression ktExpression2 = (KtExpression)this.getElement();
            if (ktExpression2 == null) {
                return;
            }
            KtExpression expression2 = ktExpression2;
            KtPsiFactory factory2 = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)expression2, false, 2, null);
            if (this.wrapInitialElement) {
                Object object;
                PsiElement psiElement2 = (PsiElement)expression2;
                newElement$iv = (PsiElement)CreateByPatternKt.createExpressionByPattern$default(factory2, this.functionName + "($0)", new Object[]{expression2}, false, 4, null);
                result$iv = $receiver$iv.replace(newElement$iv);
                if (result$iv instanceof KtExpression) {
                    object = result$iv;
                } else {
                    PsiElement psiElement3 = result$iv;
                    if (psiElement3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                    }
                    object = ((KtParenthesizedExpression)psiElement3).getExpression();
                    if (object == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                    }
                }
                ktExpression = (KtExpression)object;
            } else {
                Object object;
                $receiver$iv = (PsiElement)expression2;
                newElement$iv = (PsiElement)factory2.createExpression(this.functionName + "()");
                result$iv = $receiver$iv.replace(newElement$iv);
                if (result$iv instanceof KtExpression) {
                    object = result$iv;
                } else {
                    PsiElement psiElement4 = result$iv;
                    if (psiElement4 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                    }
                    object = ((KtParenthesizedExpression)psiElement4).getExpression();
                    if (object == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                    }
                }
                ktExpression = replaced = (KtExpression)object;
            }
            if ((editor2 = editor) == null || (editor2 = editor2.getCaretModel()) == null) break block11;
            editor2.moveToOffset(PsiUtilsKt.getEndOffset((PsiElement)replaced));
        }
    }

    @NotNull
    public String getFamilyName() {
        return "Wrap with collection literal call";
    }

    @NotNull
    public String getText() {
        return this.wrapInitialElement ? "Wrap element with '" + this.functionName + "()' call" : "Replace with '" + this.functionName + "()' call";
    }

    private WrapWithCollectionLiteralCallFix(KtExpression element3, String functionName, boolean wrapInitialElement) {
        super((PsiElement)element3);
        this.functionName = functionName;
        this.wrapInitialElement = wrapInitialElement;
    }

    public /* synthetic */ WrapWithCollectionLiteralCallFix(@NotNull KtExpression element3, @NotNull String functionName, boolean wrapInitialElement, DefaultConstructorMarker $constructor_marker) {
        this(element3, functionName, wrapInitialElement);
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/WrapWithCollectionLiteralCallFix$Companion;", "", "()V", "create", "", "Lorg/jetbrains/kotlin/idea/quickfix/WrapWithCollectionLiteralCallFix;", "expectedType", "Lorg/jetbrains/kotlin/types/KotlinType;", "expressionType", "element", "Lorg/jetbrains/kotlin/psi/KtExpression;", "idea"})
    public static final class Companion {
        @NotNull
        public final List<WrapWithCollectionLiteralCallFix> create(@NotNull KotlinType expectedType, @NotNull KotlinType expressionType, @NotNull KtExpression element3) {
            WrapWithCollectionLiteralCallFix wrapWithCollectionLiteralCallFix;
            Collection collection;
            Object it;
            Intrinsics.checkParameterIsNotNull((Object)expectedType, (String)"expectedType");
            Intrinsics.checkParameterIsNotNull((Object)expressionType, (String)"expressionType");
            Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
            ConvertCollectionFix.Companion companion = ConvertCollectionFix.Companion;
            Object $receiver = companion;
            ConvertCollectionFix.CollectionType collectionType = ((ConvertCollectionFix.Companion)$receiver).getCollectionType(expectedType, true);
            if (collectionType == null) {
                return CollectionsKt.emptyList();
            }
            ConvertCollectionFix.CollectionType collectionType2 = collectionType;
            Object object = (TypeProjection)CollectionsKt.singleOrNull(expectedType.getArguments());
            if (object == null || (object = (it = ($receiver = object)).getProjectionKind() != Variance.IN_VARIANCE ? $receiver : null) == null || (object = object.getType()) == null) {
                return CollectionsKt.emptyList();
            }
            Object expectedArgumentType = object;
            List result2 = new ArrayList();
            boolean isNullExpression = IfThenUtilsKt.isNullExpression(element3);
            Object object2 = expectedArgumentType;
            Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"expectedArgumentType");
            if ((TypeUtilsKt.isSubtypeOf(expressionType, (KotlinType)object2) || isNullExpression) && collectionType2.getLiteralFunctionName() != null) {
                collection = result2;
                wrapWithCollectionLiteralCallFix = new WrapWithCollectionLiteralCallFix(element3, collectionType2.getLiteralFunctionName(), true, null);
                collection.add(wrapWithCollectionLiteralCallFix);
            }
            if (isNullExpression && collectionType2.getEmptyCollectionFunction() != null) {
                collection = result2;
                wrapWithCollectionLiteralCallFix = new WrapWithCollectionLiteralCallFix(element3, collectionType2.getEmptyCollectionFunction(), false, null);
                collection.add(wrapWithCollectionLiteralCallFix);
            }
            return result2;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

