/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.lang.ElementsHandler;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import java.util.Collection;
import java.util.HashSet;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0007J+\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0096\u0002J8\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H$J0\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u000e\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00180\u00172\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0096\u0002\u00a2\u0006\u0002\u0010\u0019J\u001d\u0010\u001a\u001a\u00020\u001b2\u000e\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00180\u0017H\u0016\u00a2\u0006\u0002\u0010\u001cJ\u001a\u0010\u001d\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0004J\u001a\u0010\u001e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J\u000e\u0010\u001f\u001a\u0004\u0018\u00010\u0013*\u00020 H\u0002R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/AbstractPullPushMembersHandler;", "Lcom/intellij/refactoring/RefactoringActionHandler;", "Lcom/intellij/refactoring/lang/ElementsHandler;", "refactoringName", "", "helpId", "wrongPositionMessage", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "classOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "member", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "elements", "", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/openapi/project/Project;[Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/actionSystem/DataContext;)V", "isEnabledOnElements", "", "([Lcom/intellij/psi/PsiElement;)Z", "reportWrongContext", "reportWrongPosition", "getContainingClass", "Lorg/jetbrains/kotlin/psi/KtParameter;", "idea"})
public abstract class AbstractPullPushMembersHandler
implements RefactoringActionHandler,
ElementsHandler {
    private final String refactoringName;
    private final String helpId;
    private final String wrongPositionMessage;

    private final void reportWrongPosition(Project project, Editor editor) {
        String message2 = RefactoringBundle.getCannotRefactorMessage((String)this.wrongPositionMessage);
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message2, (String)this.refactoringName, (String)this.helpId);
    }

    private final KtClassOrObject getContainingClass(@NotNull KtParameter $receiver) {
        KtClassOrObject ktClassOrObject;
        if ($receiver.hasValOrVar()) {
            KtDeclarationWithBody ktDeclarationWithBody = $receiver.getOwnerFunction();
            if (!(ktDeclarationWithBody instanceof KtPrimaryConstructor)) {
                ktDeclarationWithBody = null;
            }
            KtPrimaryConstructor ktPrimaryConstructor = (KtPrimaryConstructor)ktDeclarationWithBody;
            ktClassOrObject = ktPrimaryConstructor != null ? KtPsiUtilKt.getContainingClassOrObject(ktPrimaryConstructor) : null;
        } else {
            ktClassOrObject = null;
        }
        return ktClassOrObject;
    }

    protected final void reportWrongContext(@NotNull Project project, @Nullable Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        String message2 = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"is.not.supported.in.the.current.context", (Object[])new Object[]{this.refactoringName}));
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message2, (String)this.refactoringName, (String)this.helpId);
    }

    protected abstract void invoke(@NotNull Project var1, @Nullable Editor var2, @Nullable KtClassOrObject var3, @Nullable KtNamedDeclaration var4, @Nullable DataContext var5);

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, @Nullable DataContext dataContext) {
        Object v2;
        block4: {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            CaretModel caretModel = editor.getCaretModel();
            Intrinsics.checkExpressionValueIsNotNull((Object)caretModel, (String)"editor.caretModel");
            int offset = caretModel.getOffset();
            editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
            PsiElement psiElement2 = file.findElementAt(offset);
            if (psiElement2 == null) {
                return;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"(file.findElementAt(offset) ?: return)");
            Sequence<PsiElement> $receiver$iv = PsiUtilsKt.getParentsWithSelf(psiElement2);
            for (Object element$iv : $receiver$iv) {
                PsiElement it = (PsiElement)element$iv;
                if (!(it instanceof KtClassOrObject || (it instanceof KtNamedFunction || it instanceof KtProperty) && it.getParent() instanceof KtClassBody || it instanceof KtParameter && ((KtParameter)it).hasValOrVar() && ((KtParameter)it).getOwnerFunction() instanceof KtPrimaryConstructor)) continue;
                v2 = element$iv;
                break block4;
            }
            v2 = null;
        }
        PsiElement target = v2;
        if (target == null) {
            this.reportWrongPosition(project, editor);
            return;
        }
        if (!KotlinRefactoringUtilKt.canRefactor(target)) {
            return;
        }
        this.invoke(project, new PsiElement[]{target}, dataContext);
    }

    /*
     * WARNING - void declaration
     */
    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements2, @Nullable DataContext dataContext) {
        void classOrObject;
        Pair pair2;
        Editor editor;
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)elements2, (String)"elements");
        PsiElement psiElement2 = (PsiElement)ArraysKt.singleOrNull((Object[])elements2);
        if (psiElement2 == null) {
            return;
        }
        PsiElement element3 = psiElement2;
        DataContext dataContext2 = dataContext;
        if (dataContext2 != null) {
            DataContext it = object = dataContext2;
            editor = (Editor)CommonDataKeys.EDITOR.getData(it);
        } else {
            editor = null;
        }
        Editor editor2 = editor;
        PsiElement psiElement3 = element3;
        if (psiElement3 instanceof KtNamedFunction || psiElement3 instanceof KtProperty) {
            PsiElement $receiver$iv = element3;
            pair2 = TuplesKt.to((Object)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtClassOrObject.class, (boolean)true), (Object)((KtNamedDeclaration)element3));
        } else if (psiElement3 instanceof KtParameter) {
            pair2 = TuplesKt.to((Object)this.getContainingClass((KtParameter)element3), (Object)element3);
        } else if (psiElement3 instanceof KtClassOrObject) {
            pair2 = TuplesKt.to((Object)element3, null);
        } else {
            this.reportWrongPosition(project, editor2);
            return;
        }
        Pair pair3 = pair2;
        object = (KtClassOrObject)pair3.component1();
        KtNamedDeclaration member = (KtNamedDeclaration)pair3.component2();
        this.invoke(project, editor2, (KtClassOrObject)classOrObject, member, dataContext);
    }

    /*
     * WARNING - void declaration
     */
    public boolean isEnabledOnElements(@NotNull PsiElement[] elements2) {
        void var3_3;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)elements2, (String)"elements");
        PsiElement[] psiElementArray = elements2;
        Collection destination$iv = new HashSet();
        int n = ((void)$receiver$iv).length;
        for (int i = 0; i < n; ++i) {
            KtClassOrObject ktClassOrObject;
            void it;
            void item$iv;
            void var7_7 = item$iv = $receiver$iv[i];
            Collection collection = destination$iv;
            void var8_8 = it;
            if (var8_8 instanceof KtNamedFunction || var8_8 instanceof KtProperty) {
                PsiElement psiElement2 = it.getParent();
                if (!(psiElement2 instanceof KtClassBody)) {
                    psiElement2 = null;
                }
                KtClassBody ktClassBody = (KtClassBody)psiElement2;
                Object object = ktClassBody != null ? ktClassBody.getParent() : null;
                if (!(object instanceof KtClassOrObject)) {
                    object = null;
                }
                ktClassOrObject = (KtClassOrObject)object;
            } else {
                ktClassOrObject = var8_8 instanceof KtParameter ? this.getContainingClass((KtParameter)it) : (var8_8 instanceof KtClassOrObject ? (KtClassOrObject)it : null);
            }
            if (ktClassOrObject == null) {
                return false;
            }
            PsiElement psiElement3 = ktClassOrObject;
            collection.add(psiElement3);
        }
        return ((HashSet)var3_3).size() == 1;
    }

    public AbstractPullPushMembersHandler(@NotNull String refactoringName, @NotNull String helpId, @NotNull String wrongPositionMessage) {
        Intrinsics.checkParameterIsNotNull((Object)refactoringName, (String)"refactoringName");
        Intrinsics.checkParameterIsNotNull((Object)helpId, (String)"helpId");
        Intrinsics.checkParameterIsNotNull((Object)wrongPositionMessage, (String)"wrongPositionMessage");
        this.refactoringName = refactoringName;
        this.helpId = helpId;
        this.wrongPositionMessage = wrongPositionMessage;
    }
}

